/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReplaysResponse extends EventBridgeResponse implements
        ToCopyableBuilder<ListReplaysResponse.Builder, ListReplaysResponse> {
    private static final SdkField<List<Replay>> REPLAYS_FIELD = SdkField
            .<List<Replay>> builder(MarshallingType.LIST)
            .memberName("Replays")
            .getter(getter(ListReplaysResponse::replays))
            .setter(setter(Builder::replays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replays").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Replay> builder(MarshallingType.SDK_POJO)
                                            .constructor(Replay::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListReplaysResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLAYS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Replay> replays;

    private final String nextToken;

    private ListReplaysResponse(BuilderImpl builder) {
        super(builder);
        this.replays = builder.replays;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Replays property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReplays() {
        return replays != null && !(replays instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Replay</code> objects that contain information about the replay.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplays} method.
     * </p>
     * 
     * @return An array of <code>Replay</code> objects that contain information about the replay.
     */
    public final List<Replay> replays() {
        return replays;
    }

    /**
     * <p>
     * The token returned by a previous call to retrieve the next set of results.
     * </p>
     * 
     * @return The token returned by a previous call to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReplays() ? replays() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReplaysResponse)) {
            return false;
        }
        ListReplaysResponse other = (ListReplaysResponse) obj;
        return hasReplays() == other.hasReplays() && Objects.equals(replays(), other.replays())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReplaysResponse").add("Replays", hasReplays() ? replays() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Replays":
            return Optional.ofNullable(clazz.cast(replays()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReplaysResponse, T> g) {
        return obj -> g.apply((ListReplaysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListReplaysResponse> {
        /**
         * <p>
         * An array of <code>Replay</code> objects that contain information about the replay.
         * </p>
         * 
         * @param replays
         *        An array of <code>Replay</code> objects that contain information about the replay.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replays(Collection<Replay> replays);

        /**
         * <p>
         * An array of <code>Replay</code> objects that contain information about the replay.
         * </p>
         * 
         * @param replays
         *        An array of <code>Replay</code> objects that contain information about the replay.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replays(Replay... replays);

        /**
         * <p>
         * An array of <code>Replay</code> objects that contain information about the replay.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Replay>.Builder} avoiding the need
         * to create one manually via {@link List<Replay>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Replay>.Builder#build()} is called immediately and its
         * result is passed to {@link #replays(List<Replay>)}.
         * 
         * @param replays
         *        a consumer that will call methods on {@link List<Replay>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replays(List<Replay>)
         */
        Builder replays(Consumer<Replay.Builder>... replays);

        /**
         * <p>
         * The token returned by a previous call to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EventBridgeResponse.BuilderImpl implements Builder {
        private List<Replay> replays = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReplaysResponse model) {
            super(model);
            replays(model.replays);
            nextToken(model.nextToken);
        }

        public final List<Replay.Builder> getReplays() {
            List<Replay.Builder> result = ReplayListCopier.copyToBuilder(this.replays);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplays(Collection<Replay.BuilderImpl> replays) {
            this.replays = ReplayListCopier.copyFromBuilder(replays);
        }

        @Override
        @Transient
        public final Builder replays(Collection<Replay> replays) {
            this.replays = ReplayListCopier.copy(replays);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replays(Replay... replays) {
            replays(Arrays.asList(replays));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replays(Consumer<Replay.Builder>... replays) {
            replays(Stream.of(replays).map(c -> Replay.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListReplaysResponse build() {
            return new ListReplaysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
