/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPartnerEventSourcesResponse extends EventBridgeResponse implements
        ToCopyableBuilder<ListPartnerEventSourcesResponse.Builder, ListPartnerEventSourcesResponse> {
    private static final SdkField<List<PartnerEventSource>> PARTNER_EVENT_SOURCES_FIELD = SdkField
            .<List<PartnerEventSource>> builder(MarshallingType.LIST)
            .memberName("PartnerEventSources")
            .getter(getter(ListPartnerEventSourcesResponse::partnerEventSources))
            .setter(setter(Builder::partnerEventSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerEventSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PartnerEventSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(PartnerEventSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPartnerEventSourcesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTNER_EVENT_SOURCES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PartnerEventSource> partnerEventSources;

    private final String nextToken;

    private ListPartnerEventSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.partnerEventSources = builder.partnerEventSources;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the PartnerEventSources property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPartnerEventSources() {
        return partnerEventSources != null && !(partnerEventSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of partner event sources returned by the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPartnerEventSources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of partner event sources returned by the operation.
     */
    public final List<PartnerEventSource> partnerEventSources() {
        return partnerEventSources;
    }

    /**
     * <p>
     * A token you can use in a subsequent operation to retrieve the next set of results.
     * </p>
     * 
     * @return A token you can use in a subsequent operation to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPartnerEventSources() ? partnerEventSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartnerEventSourcesResponse)) {
            return false;
        }
        ListPartnerEventSourcesResponse other = (ListPartnerEventSourcesResponse) obj;
        return hasPartnerEventSources() == other.hasPartnerEventSources()
                && Objects.equals(partnerEventSources(), other.partnerEventSources())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPartnerEventSourcesResponse")
                .add("PartnerEventSources", hasPartnerEventSources() ? partnerEventSources() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PartnerEventSources":
            return Optional.ofNullable(clazz.cast(partnerEventSources()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPartnerEventSourcesResponse, T> g) {
        return obj -> g.apply((ListPartnerEventSourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPartnerEventSourcesResponse> {
        /**
         * <p>
         * The list of partner event sources returned by the operation.
         * </p>
         * 
         * @param partnerEventSources
         *        The list of partner event sources returned by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerEventSources(Collection<PartnerEventSource> partnerEventSources);

        /**
         * <p>
         * The list of partner event sources returned by the operation.
         * </p>
         * 
         * @param partnerEventSources
         *        The list of partner event sources returned by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerEventSources(PartnerEventSource... partnerEventSources);

        /**
         * <p>
         * The list of partner event sources returned by the operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PartnerEventSource>.Builder} avoiding the
         * need to create one manually via {@link List<PartnerEventSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PartnerEventSource>.Builder#build()} is called immediately
         * and its result is passed to {@link #partnerEventSources(List<PartnerEventSource>)}.
         * 
         * @param partnerEventSources
         *        a consumer that will call methods on {@link List<PartnerEventSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partnerEventSources(List<PartnerEventSource>)
         */
        Builder partnerEventSources(Consumer<PartnerEventSource.Builder>... partnerEventSources);

        /**
         * <p>
         * A token you can use in a subsequent operation to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token you can use in a subsequent operation to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EventBridgeResponse.BuilderImpl implements Builder {
        private List<PartnerEventSource> partnerEventSources = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartnerEventSourcesResponse model) {
            super(model);
            partnerEventSources(model.partnerEventSources);
            nextToken(model.nextToken);
        }

        public final List<PartnerEventSource.Builder> getPartnerEventSources() {
            List<PartnerEventSource.Builder> result = PartnerEventSourceListCopier.copyToBuilder(this.partnerEventSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartnerEventSources(Collection<PartnerEventSource.BuilderImpl> partnerEventSources) {
            this.partnerEventSources = PartnerEventSourceListCopier.copyFromBuilder(partnerEventSources);
        }

        @Override
        @Transient
        public final Builder partnerEventSources(Collection<PartnerEventSource> partnerEventSources) {
            this.partnerEventSources = PartnerEventSourceListCopier.copy(partnerEventSources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder partnerEventSources(PartnerEventSource... partnerEventSources) {
            partnerEventSources(Arrays.asList(partnerEventSources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder partnerEventSources(Consumer<PartnerEventSource.Builder>... partnerEventSources) {
            partnerEventSources(Stream.of(partnerEventSources).map(c -> PartnerEventSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPartnerEventSourcesResponse build() {
            return new ListPartnerEventSourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
