/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEndpointRequest extends EventBridgeRequest implements
        ToCopyableBuilder<UpdateEndpointRequest.Builder, UpdateEndpointRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateEndpointRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateEndpointRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<RoutingConfig> ROUTING_CONFIG_FIELD = SdkField
            .<RoutingConfig> builder(MarshallingType.SDK_POJO).memberName("RoutingConfig")
            .getter(getter(UpdateEndpointRequest::routingConfig)).setter(setter(Builder::routingConfig))
            .constructor(RoutingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingConfig").build()).build();

    private static final SdkField<ReplicationConfig> REPLICATION_CONFIG_FIELD = SdkField
            .<ReplicationConfig> builder(MarshallingType.SDK_POJO).memberName("ReplicationConfig")
            .getter(getter(UpdateEndpointRequest::replicationConfig)).setter(setter(Builder::replicationConfig))
            .constructor(ReplicationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfig").build()).build();

    private static final SdkField<List<EndpointEventBus>> EVENT_BUSES_FIELD = SdkField
            .<List<EndpointEventBus>> builder(MarshallingType.LIST)
            .memberName("EventBuses")
            .getter(getter(UpdateEndpointRequest::eventBuses))
            .setter(setter(Builder::eventBuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EndpointEventBus> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndpointEventBus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateEndpointRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            ROUTING_CONFIG_FIELD, REPLICATION_CONFIG_FIELD, EVENT_BUSES_FIELD, ROLE_ARN_FIELD));

    private final String name;

    private final String description;

    private final RoutingConfig routingConfig;

    private final ReplicationConfig replicationConfig;

    private final List<EndpointEventBus> eventBuses;

    private final String roleArn;

    private UpdateEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.routingConfig = builder.routingConfig;
        this.replicationConfig = builder.replicationConfig;
        this.eventBuses = builder.eventBuses;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The name of the endpoint you want to update.
     * </p>
     * 
     * @return The name of the endpoint you want to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description for the endpoint.
     * </p>
     * 
     * @return A description for the endpoint.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Configure the routing policy, including the health check and secondary Region..
     * </p>
     * 
     * @return Configure the routing policy, including the health check and secondary Region..
     */
    public final RoutingConfig routingConfig() {
        return routingConfig;
    }

    /**
     * <p>
     * Whether event replication was enabled or disabled by this request.
     * </p>
     * 
     * @return Whether event replication was enabled or disabled by this request.
     */
    public final ReplicationConfig replicationConfig() {
        return replicationConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventBuses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEventBuses() {
        return eventBuses != null && !(eventBuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Define event buses used for replication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventBuses} method.
     * </p>
     * 
     * @return Define event buses used for replication.
     */
    public final List<EndpointEventBus> eventBuses() {
        return eventBuses;
    }

    /**
     * <p>
     * The ARN of the role used by event replication for this request.
     * </p>
     * 
     * @return The ARN of the role used by event replication for this request.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(routingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventBuses() ? eventBuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointRequest)) {
            return false;
        }
        UpdateEndpointRequest other = (UpdateEndpointRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(routingConfig(), other.routingConfig())
                && Objects.equals(replicationConfig(), other.replicationConfig()) && hasEventBuses() == other.hasEventBuses()
                && Objects.equals(eventBuses(), other.eventBuses()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEndpointRequest").add("Name", name()).add("Description", description())
                .add("RoutingConfig", routingConfig()).add("ReplicationConfig", replicationConfig())
                .add("EventBuses", hasEventBuses() ? eventBuses() : null).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RoutingConfig":
            return Optional.ofNullable(clazz.cast(routingConfig()));
        case "ReplicationConfig":
            return Optional.ofNullable(clazz.cast(replicationConfig()));
        case "EventBuses":
            return Optional.ofNullable(clazz.cast(eventBuses()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEndpointRequest, T> g) {
        return obj -> g.apply((UpdateEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEndpointRequest> {
        /**
         * <p>
         * The name of the endpoint you want to update.
         * </p>
         * 
         * @param name
         *        The name of the endpoint you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description for the endpoint.
         * </p>
         * 
         * @param description
         *        A description for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Configure the routing policy, including the health check and secondary Region..
         * </p>
         * 
         * @param routingConfig
         *        Configure the routing policy, including the health check and secondary Region..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingConfig(RoutingConfig routingConfig);

        /**
         * <p>
         * Configure the routing policy, including the health check and secondary Region..
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutingConfig.Builder} avoiding the need
         * to create one manually via {@link RoutingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link RoutingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #routingConfig(RoutingConfig)}.
         * 
         * @param routingConfig
         *        a consumer that will call methods on {@link RoutingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingConfig(RoutingConfig)
         */
        default Builder routingConfig(Consumer<RoutingConfig.Builder> routingConfig) {
            return routingConfig(RoutingConfig.builder().applyMutation(routingConfig).build());
        }

        /**
         * <p>
         * Whether event replication was enabled or disabled by this request.
         * </p>
         * 
         * @param replicationConfig
         *        Whether event replication was enabled or disabled by this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfig(ReplicationConfig replicationConfig);

        /**
         * <p>
         * Whether event replication was enabled or disabled by this request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReplicationConfig.Builder} avoiding the
         * need to create one manually via {@link ReplicationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReplicationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #replicationConfig(ReplicationConfig)}.
         * 
         * @param replicationConfig
         *        a consumer that will call methods on {@link ReplicationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationConfig(ReplicationConfig)
         */
        default Builder replicationConfig(Consumer<ReplicationConfig.Builder> replicationConfig) {
            return replicationConfig(ReplicationConfig.builder().applyMutation(replicationConfig).build());
        }

        /**
         * <p>
         * Define event buses used for replication.
         * </p>
         * 
         * @param eventBuses
         *        Define event buses used for replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBuses(Collection<EndpointEventBus> eventBuses);

        /**
         * <p>
         * Define event buses used for replication.
         * </p>
         * 
         * @param eventBuses
         *        Define event buses used for replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBuses(EndpointEventBus... eventBuses);

        /**
         * <p>
         * Define event buses used for replication.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<EndpointEventBus>.Builder} avoiding
         * the need to create one manually via {@link List<EndpointEventBus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EndpointEventBus>.Builder#build()} is called immediately and
         * its result is passed to {@link #eventBuses(List<EndpointEventBus>)}.
         * 
         * @param eventBuses
         *        a consumer that will call methods on {@link List<EndpointEventBus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventBuses(List<EndpointEventBus>)
         */
        Builder eventBuses(Consumer<EndpointEventBus.Builder>... eventBuses);

        /**
         * <p>
         * The ARN of the role used by event replication for this request.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role used by event replication for this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EventBridgeRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private RoutingConfig routingConfig;

        private ReplicationConfig replicationConfig;

        private List<EndpointEventBus> eventBuses = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            routingConfig(model.routingConfig);
            replicationConfig(model.replicationConfig);
            eventBuses(model.eventBuses);
            roleArn(model.roleArn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final RoutingConfig.Builder getRoutingConfig() {
            return routingConfig != null ? routingConfig.toBuilder() : null;
        }

        public final void setRoutingConfig(RoutingConfig.BuilderImpl routingConfig) {
            this.routingConfig = routingConfig != null ? routingConfig.build() : null;
        }

        @Override
        public final Builder routingConfig(RoutingConfig routingConfig) {
            this.routingConfig = routingConfig;
            return this;
        }

        public final ReplicationConfig.Builder getReplicationConfig() {
            return replicationConfig != null ? replicationConfig.toBuilder() : null;
        }

        public final void setReplicationConfig(ReplicationConfig.BuilderImpl replicationConfig) {
            this.replicationConfig = replicationConfig != null ? replicationConfig.build() : null;
        }

        @Override
        public final Builder replicationConfig(ReplicationConfig replicationConfig) {
            this.replicationConfig = replicationConfig;
            return this;
        }

        public final List<EndpointEventBus.Builder> getEventBuses() {
            List<EndpointEventBus.Builder> result = EndpointEventBusListCopier.copyToBuilder(this.eventBuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventBuses(Collection<EndpointEventBus.BuilderImpl> eventBuses) {
            this.eventBuses = EndpointEventBusListCopier.copyFromBuilder(eventBuses);
        }

        @Override
        public final Builder eventBuses(Collection<EndpointEventBus> eventBuses) {
            this.eventBuses = EndpointEventBusListCopier.copy(eventBuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBuses(EndpointEventBus... eventBuses) {
            eventBuses(Arrays.asList(eventBuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBuses(Consumer<EndpointEventBus.Builder>... eventBuses) {
            eventBuses(Stream.of(eventBuses).map(c -> EndpointEventBus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEndpointRequest build() {
            return new UpdateEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
