/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveTargetsResponse extends EventBridgeResponse implements
        ToCopyableBuilder<RemoveTargetsResponse.Builder, RemoveTargetsResponse> {
    private static final SdkField<Integer> FAILED_ENTRY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FailedEntryCount").getter(getter(RemoveTargetsResponse::failedEntryCount))
            .setter(setter(Builder::failedEntryCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedEntryCount").build()).build();

    private static final SdkField<List<RemoveTargetsResultEntry>> FAILED_ENTRIES_FIELD = SdkField
            .<List<RemoveTargetsResultEntry>> builder(MarshallingType.LIST)
            .memberName("FailedEntries")
            .getter(getter(RemoveTargetsResponse::failedEntries))
            .setter(setter(Builder::failedEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemoveTargetsResultEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemoveTargetsResultEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_ENTRY_COUNT_FIELD,
            FAILED_ENTRIES_FIELD));

    private final Integer failedEntryCount;

    private final List<RemoveTargetsResultEntry> failedEntries;

    private RemoveTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.failedEntryCount = builder.failedEntryCount;
        this.failedEntries = builder.failedEntries;
    }

    /**
     * <p>
     * The number of failed entries.
     * </p>
     * 
     * @return The number of failed entries.
     */
    public final Integer failedEntryCount() {
        return failedEntryCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedEntries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedEntries() {
        return failedEntries != null && !(failedEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The failed target entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedEntries} method.
     * </p>
     * 
     * @return The failed target entries.
     */
    public final List<RemoveTargetsResultEntry> failedEntries() {
        return failedEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(failedEntryCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedEntries() ? failedEntries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTargetsResponse)) {
            return false;
        }
        RemoveTargetsResponse other = (RemoveTargetsResponse) obj;
        return Objects.equals(failedEntryCount(), other.failedEntryCount()) && hasFailedEntries() == other.hasFailedEntries()
                && Objects.equals(failedEntries(), other.failedEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoveTargetsResponse").add("FailedEntryCount", failedEntryCount())
                .add("FailedEntries", hasFailedEntries() ? failedEntries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedEntryCount":
            return Optional.ofNullable(clazz.cast(failedEntryCount()));
        case "FailedEntries":
            return Optional.ofNullable(clazz.cast(failedEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveTargetsResponse, T> g) {
        return obj -> g.apply((RemoveTargetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeResponse.Builder, SdkPojo, CopyableBuilder<Builder, RemoveTargetsResponse> {
        /**
         * <p>
         * The number of failed entries.
         * </p>
         * 
         * @param failedEntryCount
         *        The number of failed entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEntryCount(Integer failedEntryCount);

        /**
         * <p>
         * The failed target entries.
         * </p>
         * 
         * @param failedEntries
         *        The failed target entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEntries(Collection<RemoveTargetsResultEntry> failedEntries);

        /**
         * <p>
         * The failed target entries.
         * </p>
         * 
         * @param failedEntries
         *        The failed target entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEntries(RemoveTargetsResultEntry... failedEntries);

        /**
         * <p>
         * The failed target entries.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<RemoveTargetsResultEntry>.Builder}
         * avoiding the need to create one manually via {@link List<RemoveTargetsResultEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RemoveTargetsResultEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #failedEntries(List<RemoveTargetsResultEntry>)}.
         * 
         * @param failedEntries
         *        a consumer that will call methods on {@link List<RemoveTargetsResultEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedEntries(List<RemoveTargetsResultEntry>)
         */
        Builder failedEntries(Consumer<RemoveTargetsResultEntry.Builder>... failedEntries);
    }

    static final class BuilderImpl extends EventBridgeResponse.BuilderImpl implements Builder {
        private Integer failedEntryCount;

        private List<RemoveTargetsResultEntry> failedEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTargetsResponse model) {
            super(model);
            failedEntryCount(model.failedEntryCount);
            failedEntries(model.failedEntries);
        }

        public final Integer getFailedEntryCount() {
            return failedEntryCount;
        }

        public final void setFailedEntryCount(Integer failedEntryCount) {
            this.failedEntryCount = failedEntryCount;
        }

        @Override
        public final Builder failedEntryCount(Integer failedEntryCount) {
            this.failedEntryCount = failedEntryCount;
            return this;
        }

        public final List<RemoveTargetsResultEntry.Builder> getFailedEntries() {
            List<RemoveTargetsResultEntry.Builder> result = RemoveTargetsResultEntryListCopier.copyToBuilder(this.failedEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedEntries(Collection<RemoveTargetsResultEntry.BuilderImpl> failedEntries) {
            this.failedEntries = RemoveTargetsResultEntryListCopier.copyFromBuilder(failedEntries);
        }

        @Override
        public final Builder failedEntries(Collection<RemoveTargetsResultEntry> failedEntries) {
            this.failedEntries = RemoveTargetsResultEntryListCopier.copy(failedEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEntries(RemoveTargetsResultEntry... failedEntries) {
            failedEntries(Arrays.asList(failedEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEntries(Consumer<RemoveTargetsResultEntry.Builder>... failedEntries) {
            failedEntries(Stream.of(failedEntries).map(c -> RemoveTargetsResultEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RemoveTargetsResponse build() {
            return new RemoveTargetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
