/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the client response parameters for the connection when OAuth is specified as the authorization type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionOAuthClientResponseParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionOAuthClientResponseParameters.Builder, ConnectionOAuthClientResponseParameters> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientID").getter(getter(ConnectionOAuthClientResponseParameters::clientID))
            .setter(setter(Builder::clientID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientID;

    private ConnectionOAuthClientResponseParameters(BuilderImpl builder) {
        this.clientID = builder.clientID;
    }

    /**
     * <p>
     * The client ID associated with the response to the connection request.
     * </p>
     * 
     * @return The client ID associated with the response to the connection request.
     */
    public final String clientID() {
        return clientID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionOAuthClientResponseParameters)) {
            return false;
        }
        ConnectionOAuthClientResponseParameters other = (ConnectionOAuthClientResponseParameters) obj;
        return Objects.equals(clientID(), other.clientID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionOAuthClientResponseParameters").add("ClientID", clientID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientID":
            return Optional.ofNullable(clazz.cast(clientID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionOAuthClientResponseParameters, T> g) {
        return obj -> g.apply((ConnectionOAuthClientResponseParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionOAuthClientResponseParameters> {
        /**
         * <p>
         * The client ID associated with the response to the connection request.
         * </p>
         * 
         * @param clientID
         *        The client ID associated with the response to the connection request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientID(String clientID);
    }

    static final class BuilderImpl implements Builder {
        private String clientID;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionOAuthClientResponseParameters model) {
            clientID(model.clientID);
        }

        public final String getClientID() {
            return clientID;
        }

        public final void setClientID(String clientID) {
            this.clientID = clientID;
        }

        @Override
        @Transient
        public final Builder clientID(String clientID) {
            this.clientID = clientID;
            return this;
        }

        @Override
        public ConnectionOAuthClientResponseParameters build() {
            return new ConnectionOAuthClientResponseParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
