/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4aHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.eventbridge.auth.scheme.EventBridgeAuthSchemeParams;
import software.amazon.awssdk.services.eventbridge.auth.scheme.EventBridgeAuthSchemeProvider;
import software.amazon.awssdk.services.eventbridge.auth.scheme.internal.ModeledEventBridgeAuthSchemeProvider;
import software.amazon.awssdk.services.eventbridge.endpoints.EventBridgeEndpointParams;
import software.amazon.awssdk.services.eventbridge.endpoints.EventBridgeEndpointProvider;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultEventBridgeAuthSchemeProvider
implements EventBridgeAuthSchemeProvider {
    private static final DefaultEventBridgeAuthSchemeProvider DEFAULT = new DefaultEventBridgeAuthSchemeProvider();
    private static final EventBridgeAuthSchemeProvider MODELED_RESOLVER = ModeledEventBridgeAuthSchemeProvider.create();
    private static final EventBridgeEndpointProvider DELEGATE = EventBridgeEndpointProvider.defaultProvider();

    private DefaultEventBridgeAuthSchemeProvider() {
    }

    public static EventBridgeAuthSchemeProvider create() {
        return DEFAULT;
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(EventBridgeAuthSchemeParams params) {
        EventBridgeEndpointParams endpointParameters = EventBridgeEndpointParams.builder().region(params.region()).endpointId(params.endpointId()).build();
        Endpoint endpoint = (Endpoint)CompletableFutureUtils.joinLikeSync(DELEGATE.resolveEndpoint(endpointParameters));
        List authSchemes = (List)endpoint.attribute(AwsEndpointAttribute.AUTH_SCHEMES);
        if (authSchemes == null) {
            return MODELED_RESOLVER.resolveAuthScheme(params);
        }
        ArrayList<Object> options = new ArrayList<Object>();
        block8: for (EndpointAuthScheme authScheme : authSchemes) {
            String name;
            switch (name = authScheme.name()) {
                case "sigv4": {
                    SigV4AuthScheme sigv4AuthScheme = (SigV4AuthScheme)Validate.isInstanceOf(SigV4AuthScheme.class, (Object)authScheme, (String)"Expecting auth scheme of class SigV4AuthScheme, got instead object of class %s", (Object[])new Object[]{authScheme.getClass().getName()});
                    options.add(AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)sigv4AuthScheme.signingName()).putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)sigv4AuthScheme.signingRegion()).putSignerProperty(AwsV4HttpSigner.DOUBLE_URL_ENCODE, (Object)(!sigv4AuthScheme.disableDoubleEncoding() ? 1 : 0)).build());
                    continue block8;
                }
                case "sigv4a": {
                    SigV4aAuthScheme sigv4aAuthScheme = (SigV4aAuthScheme)Validate.isInstanceOf(SigV4aAuthScheme.class, (Object)authScheme, (String)"Expecting auth scheme of class SigV4AuthScheme, got instead object of class %s", (Object[])new Object[]{authScheme.getClass().getName()});
                    RegionSet regionSet = RegionSet.create((Collection)sigv4aAuthScheme.signingRegionSet());
                    options.add(AuthSchemeOption.builder().schemeId("aws.auth#sigv4a").putSignerProperty(AwsV4aHttpSigner.SERVICE_SIGNING_NAME, (Object)sigv4aAuthScheme.signingName()).putSignerProperty(AwsV4aHttpSigner.REGION_SET, (Object)regionSet).putSignerProperty(AwsV4aHttpSigner.DOUBLE_URL_ENCODE, (Object)(!sigv4aAuthScheme.disableDoubleEncoding() ? 1 : 0)).build());
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unknown auth scheme: " + name);
        }
        return Collections.unmodifiableList(options);
    }
}

