/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.eventbridge.model.ActivateEventSourceRequest;
import software.amazon.awssdk.services.eventbridge.model.ActivateEventSourceResponse;
import software.amazon.awssdk.services.eventbridge.model.CancelReplayRequest;
import software.amazon.awssdk.services.eventbridge.model.CancelReplayResponse;
import software.amazon.awssdk.services.eventbridge.model.CreateApiDestinationRequest;
import software.amazon.awssdk.services.eventbridge.model.CreateApiDestinationResponse;
import software.amazon.awssdk.services.eventbridge.model.CreateArchiveRequest;
import software.amazon.awssdk.services.eventbridge.model.CreateArchiveResponse;
import software.amazon.awssdk.services.eventbridge.model.CreateConnectionRequest;
import software.amazon.awssdk.services.eventbridge.model.CreateConnectionResponse;
import software.amazon.awssdk.services.eventbridge.model.CreateEndpointRequest;
import software.amazon.awssdk.services.eventbridge.model.CreateEndpointResponse;
import software.amazon.awssdk.services.eventbridge.model.CreateEventBusRequest;
import software.amazon.awssdk.services.eventbridge.model.CreateEventBusResponse;
import software.amazon.awssdk.services.eventbridge.model.CreatePartnerEventSourceRequest;
import software.amazon.awssdk.services.eventbridge.model.CreatePartnerEventSourceResponse;
import software.amazon.awssdk.services.eventbridge.model.DeactivateEventSourceRequest;
import software.amazon.awssdk.services.eventbridge.model.DeactivateEventSourceResponse;
import software.amazon.awssdk.services.eventbridge.model.DeauthorizeConnectionRequest;
import software.amazon.awssdk.services.eventbridge.model.DeauthorizeConnectionResponse;
import software.amazon.awssdk.services.eventbridge.model.DeleteApiDestinationRequest;
import software.amazon.awssdk.services.eventbridge.model.DeleteApiDestinationResponse;
import software.amazon.awssdk.services.eventbridge.model.DeleteArchiveRequest;
import software.amazon.awssdk.services.eventbridge.model.DeleteArchiveResponse;
import software.amazon.awssdk.services.eventbridge.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.eventbridge.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.eventbridge.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.eventbridge.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.eventbridge.model.DeleteEventBusRequest;
import software.amazon.awssdk.services.eventbridge.model.DeleteEventBusResponse;
import software.amazon.awssdk.services.eventbridge.model.DeletePartnerEventSourceRequest;
import software.amazon.awssdk.services.eventbridge.model.DeletePartnerEventSourceResponse;
import software.amazon.awssdk.services.eventbridge.model.DeleteRuleRequest;
import software.amazon.awssdk.services.eventbridge.model.DeleteRuleResponse;
import software.amazon.awssdk.services.eventbridge.model.DescribeApiDestinationRequest;
import software.amazon.awssdk.services.eventbridge.model.DescribeApiDestinationResponse;
import software.amazon.awssdk.services.eventbridge.model.DescribeArchiveRequest;
import software.amazon.awssdk.services.eventbridge.model.DescribeArchiveResponse;
import software.amazon.awssdk.services.eventbridge.model.DescribeConnectionRequest;
import software.amazon.awssdk.services.eventbridge.model.DescribeConnectionResponse;
import software.amazon.awssdk.services.eventbridge.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.eventbridge.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.eventbridge.model.DescribeEventBusRequest;
import software.amazon.awssdk.services.eventbridge.model.DescribeEventBusResponse;
import software.amazon.awssdk.services.eventbridge.model.DescribeEventSourceRequest;
import software.amazon.awssdk.services.eventbridge.model.DescribeEventSourceResponse;
import software.amazon.awssdk.services.eventbridge.model.DescribePartnerEventSourceRequest;
import software.amazon.awssdk.services.eventbridge.model.DescribePartnerEventSourceResponse;
import software.amazon.awssdk.services.eventbridge.model.DescribeReplayRequest;
import software.amazon.awssdk.services.eventbridge.model.DescribeReplayResponse;
import software.amazon.awssdk.services.eventbridge.model.DescribeRuleRequest;
import software.amazon.awssdk.services.eventbridge.model.DescribeRuleResponse;
import software.amazon.awssdk.services.eventbridge.model.DisableRuleRequest;
import software.amazon.awssdk.services.eventbridge.model.DisableRuleResponse;
import software.amazon.awssdk.services.eventbridge.model.EnableRuleRequest;
import software.amazon.awssdk.services.eventbridge.model.EnableRuleResponse;
import software.amazon.awssdk.services.eventbridge.model.ListApiDestinationsRequest;
import software.amazon.awssdk.services.eventbridge.model.ListApiDestinationsResponse;
import software.amazon.awssdk.services.eventbridge.model.ListArchivesRequest;
import software.amazon.awssdk.services.eventbridge.model.ListArchivesResponse;
import software.amazon.awssdk.services.eventbridge.model.ListConnectionsRequest;
import software.amazon.awssdk.services.eventbridge.model.ListConnectionsResponse;
import software.amazon.awssdk.services.eventbridge.model.ListEndpointsRequest;
import software.amazon.awssdk.services.eventbridge.model.ListEndpointsResponse;
import software.amazon.awssdk.services.eventbridge.model.ListEventBusesRequest;
import software.amazon.awssdk.services.eventbridge.model.ListEventBusesResponse;
import software.amazon.awssdk.services.eventbridge.model.ListEventSourcesRequest;
import software.amazon.awssdk.services.eventbridge.model.ListEventSourcesResponse;
import software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourceAccountsRequest;
import software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourceAccountsResponse;
import software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourcesRequest;
import software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourcesResponse;
import software.amazon.awssdk.services.eventbridge.model.ListReplaysRequest;
import software.amazon.awssdk.services.eventbridge.model.ListReplaysResponse;
import software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetRequest;
import software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetResponse;
import software.amazon.awssdk.services.eventbridge.model.ListRulesRequest;
import software.amazon.awssdk.services.eventbridge.model.ListRulesResponse;
import software.amazon.awssdk.services.eventbridge.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.eventbridge.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleRequest;
import software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleResponse;
import software.amazon.awssdk.services.eventbridge.model.PutEventsRequest;
import software.amazon.awssdk.services.eventbridge.model.PutEventsResponse;
import software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsRequest;
import software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsResponse;
import software.amazon.awssdk.services.eventbridge.model.PutPermissionRequest;
import software.amazon.awssdk.services.eventbridge.model.PutPermissionResponse;
import software.amazon.awssdk.services.eventbridge.model.PutRuleRequest;
import software.amazon.awssdk.services.eventbridge.model.PutRuleResponse;
import software.amazon.awssdk.services.eventbridge.model.PutTargetsRequest;
import software.amazon.awssdk.services.eventbridge.model.PutTargetsResponse;
import software.amazon.awssdk.services.eventbridge.model.RemovePermissionRequest;
import software.amazon.awssdk.services.eventbridge.model.RemovePermissionResponse;
import software.amazon.awssdk.services.eventbridge.model.RemoveTargetsRequest;
import software.amazon.awssdk.services.eventbridge.model.RemoveTargetsResponse;
import software.amazon.awssdk.services.eventbridge.model.StartReplayRequest;
import software.amazon.awssdk.services.eventbridge.model.StartReplayResponse;
import software.amazon.awssdk.services.eventbridge.model.TagResourceRequest;
import software.amazon.awssdk.services.eventbridge.model.TagResourceResponse;
import software.amazon.awssdk.services.eventbridge.model.TestEventPatternRequest;
import software.amazon.awssdk.services.eventbridge.model.TestEventPatternResponse;
import software.amazon.awssdk.services.eventbridge.model.UntagResourceRequest;
import software.amazon.awssdk.services.eventbridge.model.UntagResourceResponse;
import software.amazon.awssdk.services.eventbridge.model.UpdateApiDestinationRequest;
import software.amazon.awssdk.services.eventbridge.model.UpdateApiDestinationResponse;
import software.amazon.awssdk.services.eventbridge.model.UpdateArchiveRequest;
import software.amazon.awssdk.services.eventbridge.model.UpdateArchiveResponse;
import software.amazon.awssdk.services.eventbridge.model.UpdateConnectionRequest;
import software.amazon.awssdk.services.eventbridge.model.UpdateConnectionResponse;
import software.amazon.awssdk.services.eventbridge.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.eventbridge.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.eventbridge.model.UpdateEventBusRequest;
import software.amazon.awssdk.services.eventbridge.model.UpdateEventBusResponse;

/**
 * Service client for accessing Amazon EventBridge asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon EventBridge helps you to respond to state changes in your Amazon Web Services resources. When your resources
 * change state, they automatically send events to an event stream. You can create rules that match selected events in
 * the stream and route them to targets to take action. You can also use rules to take action on a predetermined
 * schedule. For example, you can configure rules to:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Automatically invoke an Lambda function to update DNS entries when an event notifies you that Amazon EC2 instance
 * enters the running state.
 * </p>
 * </li>
 * <li>
 * <p>
 * Direct specific API records from CloudTrail to an Amazon Kinesis data stream for detailed analysis of potential
 * security or availability risks.
 * </p>
 * </li>
 * <li>
 * <p>
 * Periodically invoke a built-in target to create a snapshot of an Amazon EBS volume.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information about the features of Amazon EventBridge, see the <a
 * href="https://docs.aws.amazon.com/eventbridge/latest/userguide">Amazon EventBridge User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface EventBridgeAsyncClient extends AwsClient {
    String SERVICE_NAME = "events";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "events";

    /**
     * <p>
     * Activates a partner event source that has been deactivated. Once activated, your matching event bus will start
     * receiving events from the event source.
     * </p>
     *
     * @param activateEventSourceRequest
     * @return A Java Future containing the result of the ActivateEventSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>InvalidStateException The specified state is not a valid state for an event source.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ActivateEventSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ActivateEventSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ActivateEventSourceResponse> activateEventSource(
            ActivateEventSourceRequest activateEventSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates a partner event source that has been deactivated. Once activated, your matching event bus will start
     * receiving events from the event source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateEventSourceRequest.Builder} avoiding the
     * need to create one manually via {@link ActivateEventSourceRequest#builder()}
     * </p>
     *
     * @param activateEventSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.ActivateEventSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ActivateEventSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>InvalidStateException The specified state is not a valid state for an event source.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ActivateEventSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ActivateEventSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ActivateEventSourceResponse> activateEventSource(
            Consumer<ActivateEventSourceRequest.Builder> activateEventSourceRequest) {
        return activateEventSource(ActivateEventSourceRequest.builder().applyMutation(activateEventSourceRequest).build());
    }

    /**
     * <p>
     * Cancels the specified replay.
     * </p>
     *
     * @param cancelReplayRequest
     * @return A Java Future containing the result of the CancelReplay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>IllegalStatusException An error occurred because a replay can be canceled only when the state is
     *         Running or Starting.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.CancelReplay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CancelReplay" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelReplayResponse> cancelReplay(CancelReplayRequest cancelReplayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified replay.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelReplayRequest.Builder} avoiding the need to
     * create one manually via {@link CancelReplayRequest#builder()}
     * </p>
     *
     * @param cancelReplayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.CancelReplayRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelReplay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>IllegalStatusException An error occurred because a replay can be canceled only when the state is
     *         Running or Starting.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.CancelReplay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CancelReplay" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelReplayResponse> cancelReplay(Consumer<CancelReplayRequest.Builder> cancelReplayRequest) {
        return cancelReplay(CancelReplayRequest.builder().applyMutation(cancelReplayRequest).build());
    }

    /**
     * <p>
     * Creates an API destination, which is an HTTP invocation endpoint configured as a target for events.
     * </p>
     * <p>
     * API destinations do not support private destinations, such as interface VPC endpoints.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-api-destinations.html">API destinations</a> in
     * the <i>EventBridge User Guide</i>.
     * </p>
     *
     * @param createApiDestinationRequest
     * @return A Java Future containing the result of the CreateApiDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource you are trying to create already exists.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.CreateApiDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateApiDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApiDestinationResponse> createApiDestination(
            CreateApiDestinationRequest createApiDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an API destination, which is an HTTP invocation endpoint configured as a target for events.
     * </p>
     * <p>
     * API destinations do not support private destinations, such as interface VPC endpoints.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-api-destinations.html">API destinations</a> in
     * the <i>EventBridge User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApiDestinationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateApiDestinationRequest#builder()}
     * </p>
     *
     * @param createApiDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.CreateApiDestinationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateApiDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource you are trying to create already exists.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.CreateApiDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateApiDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApiDestinationResponse> createApiDestination(
            Consumer<CreateApiDestinationRequest.Builder> createApiDestinationRequest) {
        return createApiDestination(CreateApiDestinationRequest.builder().applyMutation(createApiDestinationRequest).build());
    }

    /**
     * <p>
     * Creates an archive of events with the specified settings. When you create an archive, incoming events might not
     * immediately start being sent to the archive. Allow a short period of time for changes to take effect. If you do
     * not specify a pattern to filter events sent to the archive, all events are sent to the archive except replayed
     * events. Replayed events are not sent to an archive.
     * </p>
     * <note>
     * <p>
     * Archives and schema discovery are not supported for event buses encrypted using a customer managed key.
     * EventBridge returns an error if:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You call
     * <code> <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateArchive.html">CreateArchive</a> </code>
     * on an event bus set to use a customer managed key for encryption.
     * </p>
     * </li>
     * <li>
     * <p>
     * You call
     * <code> <a href="https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers.html#CreateDiscoverer">CreateDiscoverer</a> </code>
     * on an event bus set to use a customer managed key for encryption.
     * </p>
     * </li>
     * <li>
     * <p>
     * You call
     * <code> <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_UpdatedEventBus.html">UpdatedEventBus</a> </code>
     * to set a customer managed key on an event bus with an archives or schema discovery enabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To enable archives or schema discovery on an event bus, choose to use an Amazon Web Services owned key. For more
     * information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption.html">Data
     * encryption in EventBridge</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * </note>
     *
     * @param createArchiveRequest
     * @return A Java Future containing the result of the CreateArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ResourceAlreadyExistsException The resource you are trying to create already exists.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>InvalidEventPatternException The event pattern is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.CreateArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateArchiveResponse> createArchive(CreateArchiveRequest createArchiveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an archive of events with the specified settings. When you create an archive, incoming events might not
     * immediately start being sent to the archive. Allow a short period of time for changes to take effect. If you do
     * not specify a pattern to filter events sent to the archive, all events are sent to the archive except replayed
     * events. Replayed events are not sent to an archive.
     * </p>
     * <note>
     * <p>
     * Archives and schema discovery are not supported for event buses encrypted using a customer managed key.
     * EventBridge returns an error if:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You call
     * <code> <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateArchive.html">CreateArchive</a> </code>
     * on an event bus set to use a customer managed key for encryption.
     * </p>
     * </li>
     * <li>
     * <p>
     * You call
     * <code> <a href="https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers.html#CreateDiscoverer">CreateDiscoverer</a> </code>
     * on an event bus set to use a customer managed key for encryption.
     * </p>
     * </li>
     * <li>
     * <p>
     * You call
     * <code> <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_UpdatedEventBus.html">UpdatedEventBus</a> </code>
     * to set a customer managed key on an event bus with an archives or schema discovery enabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To enable archives or schema discovery on an event bus, choose to use an Amazon Web Services owned key. For more
     * information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption.html">Data
     * encryption in EventBridge</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateArchiveRequest.Builder} avoiding the need to
     * create one manually via {@link CreateArchiveRequest#builder()}
     * </p>
     *
     * @param createArchiveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.CreateArchiveRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ResourceAlreadyExistsException The resource you are trying to create already exists.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>InvalidEventPatternException The event pattern is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.CreateArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateArchiveResponse> createArchive(Consumer<CreateArchiveRequest.Builder> createArchiveRequest) {
        return createArchive(CreateArchiveRequest.builder().applyMutation(createArchiveRequest).build());
    }

    /**
     * <p>
     * Creates a connection. A connection defines the authorization type and credentials to use for authorization with
     * an API destination HTTP endpoint.
     * </p>
     *
     * @param createConnectionRequest
     * @return A Java Future containing the result of the CreateConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource you are trying to create already exists.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateConnection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateConnectionResponse> createConnection(CreateConnectionRequest createConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a connection. A connection defines the authorization type and credentials to use for authorization with
     * an API destination HTTP endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConnectionRequest#builder()}
     * </p>
     *
     * @param createConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.CreateConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource you are trying to create already exists.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateConnection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateConnectionResponse> createConnection(
            Consumer<CreateConnectionRequest.Builder> createConnectionRequest) {
        return createConnection(CreateConnectionRequest.builder().applyMutation(createConnectionRequest).build());
    }

    /**
     * <p>
     * Creates a global endpoint. Global endpoints improve your application's availability by making it regional-fault
     * tolerant. To do this, you define a primary and secondary Region with event buses in each Region. You also create
     * a Amazon Route 53 health check that will tell EventBridge to route events to the secondary Region when an
     * "unhealthy" state is encountered and events will be routed back to the primary Region when the health check
     * reports a "healthy" state.
     * </p>
     *
     * @param createEndpointRequest
     * @return A Java Future containing the result of the CreateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource you are trying to create already exists.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEndpointResponse> createEndpoint(CreateEndpointRequest createEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a global endpoint. Global endpoints improve your application's availability by making it regional-fault
     * tolerant. To do this, you define a primary and secondary Region with event buses in each Region. You also create
     * a Amazon Route 53 health check that will tell EventBridge to route events to the secondary Region when an
     * "unhealthy" state is encountered and events will be routed back to the primary Region when the health check
     * reports a "healthy" state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link CreateEndpointRequest#builder()}
     * </p>
     *
     * @param createEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.CreateEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource you are trying to create already exists.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEndpointResponse> createEndpoint(Consumer<CreateEndpointRequest.Builder> createEndpointRequest) {
        return createEndpoint(CreateEndpointRequest.builder().applyMutation(createEndpointRequest).build());
    }

    /**
     * <p>
     * Creates a new event bus within your account. This can be a custom event bus which you can use to receive events
     * from your custom applications and services, or it can be a partner event bus which can be matched to a partner
     * event source.
     * </p>
     *
     * @param createEventBusRequest
     * @return A Java Future containing the result of the CreateEventBus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource you are trying to create already exists.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InvalidStateException The specified state is not a valid state for an event source.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.CreateEventBus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateEventBus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEventBusResponse> createEventBus(CreateEventBusRequest createEventBusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new event bus within your account. This can be a custom event bus which you can use to receive events
     * from your custom applications and services, or it can be a partner event bus which can be matched to a partner
     * event source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventBusRequest.Builder} avoiding the need to
     * create one manually via {@link CreateEventBusRequest#builder()}
     * </p>
     *
     * @param createEventBusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.CreateEventBusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEventBus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource you are trying to create already exists.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InvalidStateException The specified state is not a valid state for an event source.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.CreateEventBus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateEventBus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEventBusResponse> createEventBus(Consumer<CreateEventBusRequest.Builder> createEventBusRequest) {
        return createEventBus(CreateEventBusRequest.builder().applyMutation(createEventBusRequest).build());
    }

    /**
     * <p>
     * Called by an SaaS partner to create a partner event source. This operation is not used by Amazon Web Services
     * customers.
     * </p>
     * <p>
     * Each partner event source can be used by one Amazon Web Services account to create a matching partner event bus
     * in that Amazon Web Services account. A SaaS partner must create one partner event source for each Amazon Web
     * Services account that wants to receive those event types.
     * </p>
     * <p>
     * A partner event source creates events based on resources within the SaaS partner's service or application.
     * </p>
     * <p>
     * An Amazon Web Services account that creates a partner event bus that matches the partner event source can use
     * that event bus to receive events from the partner, and then process them using Amazon Web Services Events rules
     * and targets.
     * </p>
     * <p>
     * Partner event source names follow this format:
     * </p>
     * <p>
     * <code> <i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i> </code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>partner_name</i> is determined during partner registration, and identifies the partner to Amazon Web Services
     * customers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>event_namespace</i> is determined by the partner, and is a way for the partner to categorize their events.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>event_name</i> is determined by the partner, and should uniquely identify an event-generating resource within
     * the partner system.
     * </p>
     * <p>
     * The <i>event_name</i> must be unique across all Amazon Web Services customers. This is because the event source
     * is a shared resource between the partner and customer accounts, and each partner event source unique in the
     * partner account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The combination of <i>event_namespace</i> and <i>event_name</i> should help Amazon Web Services customers decide
     * whether to create an event bus to receive these events.
     * </p>
     *
     * @param createPartnerEventSourceRequest
     * @return A Java Future containing the result of the CreatePartnerEventSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource you are trying to create already exists.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.CreatePartnerEventSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreatePartnerEventSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePartnerEventSourceResponse> createPartnerEventSource(
            CreatePartnerEventSourceRequest createPartnerEventSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Called by an SaaS partner to create a partner event source. This operation is not used by Amazon Web Services
     * customers.
     * </p>
     * <p>
     * Each partner event source can be used by one Amazon Web Services account to create a matching partner event bus
     * in that Amazon Web Services account. A SaaS partner must create one partner event source for each Amazon Web
     * Services account that wants to receive those event types.
     * </p>
     * <p>
     * A partner event source creates events based on resources within the SaaS partner's service or application.
     * </p>
     * <p>
     * An Amazon Web Services account that creates a partner event bus that matches the partner event source can use
     * that event bus to receive events from the partner, and then process them using Amazon Web Services Events rules
     * and targets.
     * </p>
     * <p>
     * Partner event source names follow this format:
     * </p>
     * <p>
     * <code> <i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i> </code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>partner_name</i> is determined during partner registration, and identifies the partner to Amazon Web Services
     * customers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>event_namespace</i> is determined by the partner, and is a way for the partner to categorize their events.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>event_name</i> is determined by the partner, and should uniquely identify an event-generating resource within
     * the partner system.
     * </p>
     * <p>
     * The <i>event_name</i> must be unique across all Amazon Web Services customers. This is because the event source
     * is a shared resource between the partner and customer accounts, and each partner event source unique in the
     * partner account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The combination of <i>event_namespace</i> and <i>event_name</i> should help Amazon Web Services customers decide
     * whether to create an event bus to receive these events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePartnerEventSourceRequest.Builder} avoiding
     * the need to create one manually via {@link CreatePartnerEventSourceRequest#builder()}
     * </p>
     *
     * @param createPartnerEventSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.CreatePartnerEventSourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreatePartnerEventSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource you are trying to create already exists.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.CreatePartnerEventSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreatePartnerEventSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePartnerEventSourceResponse> createPartnerEventSource(
            Consumer<CreatePartnerEventSourceRequest.Builder> createPartnerEventSourceRequest) {
        return createPartnerEventSource(CreatePartnerEventSourceRequest.builder().applyMutation(createPartnerEventSourceRequest)
                .build());
    }

    /**
     * <p>
     * You can use this operation to temporarily stop receiving events from the specified partner event source. The
     * matching event bus is not deleted.
     * </p>
     * <p>
     * When you deactivate a partner event source, the source goes into PENDING state. If it remains in PENDING state
     * for more than two weeks, it is deleted.
     * </p>
     * <p>
     * To activate a deactivated partner event source, use <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ActivateEventSource.html"
     * >ActivateEventSource</a>.
     * </p>
     *
     * @param deactivateEventSourceRequest
     * @return A Java Future containing the result of the DeactivateEventSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>InvalidStateException The specified state is not a valid state for an event source.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DeactivateEventSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeactivateEventSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeactivateEventSourceResponse> deactivateEventSource(
            DeactivateEventSourceRequest deactivateEventSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can use this operation to temporarily stop receiving events from the specified partner event source. The
     * matching event bus is not deleted.
     * </p>
     * <p>
     * When you deactivate a partner event source, the source goes into PENDING state. If it remains in PENDING state
     * for more than two weeks, it is deleted.
     * </p>
     * <p>
     * To activate a deactivated partner event source, use <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ActivateEventSource.html"
     * >ActivateEventSource</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeactivateEventSourceRequest.Builder} avoiding the
     * need to create one manually via {@link DeactivateEventSourceRequest#builder()}
     * </p>
     *
     * @param deactivateEventSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DeactivateEventSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeactivateEventSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>InvalidStateException The specified state is not a valid state for an event source.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DeactivateEventSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeactivateEventSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeactivateEventSourceResponse> deactivateEventSource(
            Consumer<DeactivateEventSourceRequest.Builder> deactivateEventSourceRequest) {
        return deactivateEventSource(DeactivateEventSourceRequest.builder().applyMutation(deactivateEventSourceRequest).build());
    }

    /**
     * <p>
     * Removes all authorization parameters from the connection. This lets you remove the secret from the connection so
     * you can reuse it without having to create a new connection.
     * </p>
     *
     * @param deauthorizeConnectionRequest
     * @return A Java Future containing the result of the DeauthorizeConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DeauthorizeConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeauthorizeConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeauthorizeConnectionResponse> deauthorizeConnection(
            DeauthorizeConnectionRequest deauthorizeConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes all authorization parameters from the connection. This lets you remove the secret from the connection so
     * you can reuse it without having to create a new connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeauthorizeConnectionRequest.Builder} avoiding the
     * need to create one manually via {@link DeauthorizeConnectionRequest#builder()}
     * </p>
     *
     * @param deauthorizeConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DeauthorizeConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeauthorizeConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DeauthorizeConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeauthorizeConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeauthorizeConnectionResponse> deauthorizeConnection(
            Consumer<DeauthorizeConnectionRequest.Builder> deauthorizeConnectionRequest) {
        return deauthorizeConnection(DeauthorizeConnectionRequest.builder().applyMutation(deauthorizeConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified API destination.
     * </p>
     *
     * @param deleteApiDestinationRequest
     * @return A Java Future containing the result of the DeleteApiDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DeleteApiDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteApiDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApiDestinationResponse> deleteApiDestination(
            DeleteApiDestinationRequest deleteApiDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified API destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApiDestinationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteApiDestinationRequest#builder()}
     * </p>
     *
     * @param deleteApiDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DeleteApiDestinationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteApiDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DeleteApiDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteApiDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApiDestinationResponse> deleteApiDestination(
            Consumer<DeleteApiDestinationRequest.Builder> deleteApiDestinationRequest) {
        return deleteApiDestination(DeleteApiDestinationRequest.builder().applyMutation(deleteApiDestinationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified archive.
     * </p>
     *
     * @param deleteArchiveRequest
     * @return A Java Future containing the result of the DeleteArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DeleteArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteArchiveResponse> deleteArchive(DeleteArchiveRequest deleteArchiveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified archive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteArchiveRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteArchiveRequest#builder()}
     * </p>
     *
     * @param deleteArchiveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DeleteArchiveRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DeleteArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteArchiveResponse> deleteArchive(Consumer<DeleteArchiveRequest.Builder> deleteArchiveRequest) {
        return deleteArchive(DeleteArchiveRequest.builder().applyMutation(deleteArchiveRequest).build());
    }

    /**
     * <p>
     * Deletes a connection.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return A Java Future containing the result of the DeleteConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteConnection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest deleteConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectionRequest#builder()}
     * </p>
     *
     * @param deleteConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DeleteConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteConnection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConnectionResponse> deleteConnection(
            Consumer<DeleteConnectionRequest.Builder> deleteConnectionRequest) {
        return deleteConnection(DeleteConnectionRequest.builder().applyMutation(deleteConnectionRequest).build());
    }

    /**
     * <p>
     * Delete an existing global endpoint. For more information about global endpoints, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html">Making applications
     * Regional-fault tolerant with global endpoints and event replication</a> in the <i> <i>Amazon EventBridge User
     * Guide</i> </i>.
     * </p>
     *
     * @param deleteEndpointRequest
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an existing global endpoint. For more information about global endpoints, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html">Making applications
     * Regional-fault tolerant with global endpoints and event replication</a> in the <i> <i>Amazon EventBridge User
     * Guide</i> </i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEndpointRequest#builder()}
     * </p>
     *
     * @param deleteEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DeleteEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEndpointResponse> deleteEndpoint(Consumer<DeleteEndpointRequest.Builder> deleteEndpointRequest) {
        return deleteEndpoint(DeleteEndpointRequest.builder().applyMutation(deleteEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes the specified custom event bus or partner event bus. All rules associated with this event bus need to be
     * deleted. You can't delete your account's default event bus.
     * </p>
     *
     * @param deleteEventBusRequest
     * @return A Java Future containing the result of the DeleteEventBus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DeleteEventBus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteEventBus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEventBusResponse> deleteEventBus(DeleteEventBusRequest deleteEventBusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified custom event bus or partner event bus. All rules associated with this event bus need to be
     * deleted. You can't delete your account's default event bus.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventBusRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEventBusRequest#builder()}
     * </p>
     *
     * @param deleteEventBusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DeleteEventBusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEventBus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DeleteEventBus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteEventBus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEventBusResponse> deleteEventBus(Consumer<DeleteEventBusRequest.Builder> deleteEventBusRequest) {
        return deleteEventBus(DeleteEventBusRequest.builder().applyMutation(deleteEventBusRequest).build());
    }

    /**
     * <p>
     * This operation is used by SaaS partners to delete a partner event source. This operation is not used by Amazon
     * Web Services customers.
     * </p>
     * <p>
     * When you delete an event source, the status of the corresponding partner event bus in the Amazon Web Services
     * customer account becomes DELETED.
     * </p>
     * <p/>
     *
     * @param deletePartnerEventSourceRequest
     * @return A Java Future containing the result of the DeletePartnerEventSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li> <li>
     *         ConcurrentModificationException There is concurrent modification on a rule, target, archive, or replay.
     *         </li> <li>OperationDisabledException The operation you are attempting is not available in this region.
     *         </li> <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li> <li>SdkClientException If any client side error occurs
     *         such as an IO related failure, failure to get credentials, etc.</li> <li>EventBridgeException Base class
     *         for all service exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DeletePartnerEventSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeletePartnerEventSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePartnerEventSourceResponse> deletePartnerEventSource(
            DeletePartnerEventSourceRequest deletePartnerEventSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation is used by SaaS partners to delete a partner event source. This operation is not used by Amazon
     * Web Services customers.
     * </p>
     * <p>
     * When you delete an event source, the status of the corresponding partner event bus in the Amazon Web Services
     * customer account becomes DELETED.
     * </p>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePartnerEventSourceRequest.Builder} avoiding
     * the need to create one manually via {@link DeletePartnerEventSourceRequest#builder()}
     * </p>
     *
     * @param deletePartnerEventSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DeletePartnerEventSourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeletePartnerEventSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DeletePartnerEventSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeletePartnerEventSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePartnerEventSourceResponse> deletePartnerEventSource(
            Consumer<DeletePartnerEventSourceRequest.Builder> deletePartnerEventSourceRequest) {
        return deletePartnerEventSource(DeletePartnerEventSourceRequest.builder().applyMutation(deletePartnerEventSourceRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified rule.
     * </p>
     * <p>
     * Before you can delete the rule, you must remove all targets, using <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemoveTargets.html">RemoveTargets</a>.
     * </p>
     * <p>
     * When you delete a rule, incoming events might continue to match to the deleted rule. Allow a short period of time
     * for changes to take effect.
     * </p>
     * <p>
     * If you call delete rule multiple times for the same rule, all calls will succeed. When you call delete rule for a
     * non-existent custom eventbus, <code>ResourceNotFoundException</code> is returned.
     * </p>
     * <p>
     * Managed rules are rules created and managed by another Amazon Web Services service on your behalf. These rules
     * are created by those other Amazon Web Services services to support functionality in those services. You can
     * delete these rules using the <code>Force</code> option, but you should do so only if you are sure the other
     * service is not still using that rule.
     * </p>
     *
     * @param deleteRuleRequest
     * @return A Java Future containing the result of the DeleteRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ManagedRuleException This rule was created by an Amazon Web Services service on behalf of your
     *         account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or
     *         <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the
     *         rule or remove targets from the rule. You cannot modify these managed rules by using
     *         <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>,
     *         <code>TagResource</code>, or <code>UntagResource</code>.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRuleResponse> deleteRule(DeleteRuleRequest deleteRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified rule.
     * </p>
     * <p>
     * Before you can delete the rule, you must remove all targets, using <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemoveTargets.html">RemoveTargets</a>.
     * </p>
     * <p>
     * When you delete a rule, incoming events might continue to match to the deleted rule. Allow a short period of time
     * for changes to take effect.
     * </p>
     * <p>
     * If you call delete rule multiple times for the same rule, all calls will succeed. When you call delete rule for a
     * non-existent custom eventbus, <code>ResourceNotFoundException</code> is returned.
     * </p>
     * <p>
     * Managed rules are rules created and managed by another Amazon Web Services service on your behalf. These rules
     * are created by those other Amazon Web Services services to support functionality in those services. You can
     * delete these rules using the <code>Force</code> option, but you should do so only if you are sure the other
     * service is not still using that rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRuleRequest#builder()}
     * </p>
     *
     * @param deleteRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DeleteRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ManagedRuleException This rule was created by an Amazon Web Services service on behalf of your
     *         account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or
     *         <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the
     *         rule or remove targets from the rule. You cannot modify these managed rules by using
     *         <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>,
     *         <code>TagResource</code>, or <code>UntagResource</code>.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRuleResponse> deleteRule(Consumer<DeleteRuleRequest.Builder> deleteRuleRequest) {
        return deleteRule(DeleteRuleRequest.builder().applyMutation(deleteRuleRequest).build());
    }

    /**
     * <p>
     * Retrieves details about an API destination.
     * </p>
     *
     * @param describeApiDestinationRequest
     * @return A Java Future containing the result of the DescribeApiDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DescribeApiDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeApiDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApiDestinationResponse> describeApiDestination(
            DescribeApiDestinationRequest describeApiDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about an API destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApiDestinationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeApiDestinationRequest#builder()}
     * </p>
     *
     * @param describeApiDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DescribeApiDestinationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeApiDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DescribeApiDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeApiDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApiDestinationResponse> describeApiDestination(
            Consumer<DescribeApiDestinationRequest.Builder> describeApiDestinationRequest) {
        return describeApiDestination(DescribeApiDestinationRequest.builder().applyMutation(describeApiDestinationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves details about an archive.
     * </p>
     *
     * @param describeArchiveRequest
     * @return A Java Future containing the result of the DescribeArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource you are trying to create already exists.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DescribeArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeArchive" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeArchiveResponse> describeArchive(DescribeArchiveRequest describeArchiveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about an archive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeArchiveRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeArchiveRequest#builder()}
     * </p>
     *
     * @param describeArchiveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DescribeArchiveRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource you are trying to create already exists.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DescribeArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeArchive" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeArchiveResponse> describeArchive(
            Consumer<DescribeArchiveRequest.Builder> describeArchiveRequest) {
        return describeArchive(DescribeArchiveRequest.builder().applyMutation(describeArchiveRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a connection.
     * </p>
     *
     * @param describeConnectionRequest
     * @return A Java Future containing the result of the DescribeConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DescribeConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConnectionResponse> describeConnection(DescribeConnectionRequest describeConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConnectionRequest#builder()}
     * </p>
     *
     * @param describeConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DescribeConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DescribeConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConnectionResponse> describeConnection(
            Consumer<DescribeConnectionRequest.Builder> describeConnectionRequest) {
        return describeConnection(DescribeConnectionRequest.builder().applyMutation(describeConnectionRequest).build());
    }

    /**
     * <p>
     * Get the information about an existing global endpoint. For more information about global endpoints, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html">Making applications
     * Regional-fault tolerant with global endpoints and event replication</a> in the <i> <i>Amazon EventBridge User
     * Guide</i> </i>.
     * </p>
     *
     * @param describeEndpointRequest
     * @return A Java Future containing the result of the DescribeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DescribeEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointResponse> describeEndpoint(DescribeEndpointRequest describeEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the information about an existing global endpoint. For more information about global endpoints, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html">Making applications
     * Regional-fault tolerant with global endpoints and event replication</a> in the <i> <i>Amazon EventBridge User
     * Guide</i> </i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointRequest#builder()}
     * </p>
     *
     * @param describeEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DescribeEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DescribeEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointResponse> describeEndpoint(
            Consumer<DescribeEndpointRequest.Builder> describeEndpointRequest) {
        return describeEndpoint(DescribeEndpointRequest.builder().applyMutation(describeEndpointRequest).build());
    }

    /**
     * <p>
     * Displays details about an event bus in your account. This can include the external Amazon Web Services accounts
     * that are permitted to write events to your default event bus, and the associated policy. For custom event buses
     * and partner event buses, it displays the name, ARN, policy, state, and creation time.
     * </p>
     * <p>
     * To enable your account to receive events from other accounts on its default event bus, use <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission</a>.
     * </p>
     * <p>
     * For more information about partner event buses, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus</a>.
     * </p>
     *
     * @param describeEventBusRequest
     * @return A Java Future containing the result of the DescribeEventBus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DescribeEventBus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeEventBus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEventBusResponse> describeEventBus(DescribeEventBusRequest describeEventBusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays details about an event bus in your account. This can include the external Amazon Web Services accounts
     * that are permitted to write events to your default event bus, and the associated policy. For custom event buses
     * and partner event buses, it displays the name, ARN, policy, state, and creation time.
     * </p>
     * <p>
     * To enable your account to receive events from other accounts on its default event bus, use <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission</a>.
     * </p>
     * <p>
     * For more information about partner event buses, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventBusRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEventBusRequest#builder()}
     * </p>
     *
     * @param describeEventBusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DescribeEventBusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEventBus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DescribeEventBus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeEventBus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEventBusResponse> describeEventBus(
            Consumer<DescribeEventBusRequest.Builder> describeEventBusRequest) {
        return describeEventBus(DescribeEventBusRequest.builder().applyMutation(describeEventBusRequest).build());
    }

    /**
     * <p>
     * This operation lists details about a partner event source that is shared with your account.
     * </p>
     *
     * @param describeEventSourceRequest
     * @return A Java Future containing the result of the DescribeEventSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DescribeEventSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeEventSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSourceResponse> describeEventSource(
            DescribeEventSourceRequest describeEventSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation lists details about a partner event source that is shared with your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSourceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEventSourceRequest#builder()}
     * </p>
     *
     * @param describeEventSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DescribeEventSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEventSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DescribeEventSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeEventSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSourceResponse> describeEventSource(
            Consumer<DescribeEventSourceRequest.Builder> describeEventSourceRequest) {
        return describeEventSource(DescribeEventSourceRequest.builder().applyMutation(describeEventSourceRequest).build());
    }

    /**
     * <p>
     * An SaaS partner can use this operation to list details about a partner event source that they have created.
     * Amazon Web Services customers do not use this operation. Instead, Amazon Web Services customers can use <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventSource.html"
     * >DescribeEventSource</a> to see details about a partner event source that is shared with them.
     * </p>
     *
     * @param describePartnerEventSourceRequest
     * @return A Java Future containing the result of the DescribePartnerEventSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DescribePartnerEventSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribePartnerEventSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePartnerEventSourceResponse> describePartnerEventSource(
            DescribePartnerEventSourceRequest describePartnerEventSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An SaaS partner can use this operation to list details about a partner event source that they have created.
     * Amazon Web Services customers do not use this operation. Instead, Amazon Web Services customers can use <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventSource.html"
     * >DescribeEventSource</a> to see details about a partner event source that is shared with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePartnerEventSourceRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePartnerEventSourceRequest#builder()}
     * </p>
     *
     * @param describePartnerEventSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DescribePartnerEventSourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribePartnerEventSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DescribePartnerEventSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribePartnerEventSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePartnerEventSourceResponse> describePartnerEventSource(
            Consumer<DescribePartnerEventSourceRequest.Builder> describePartnerEventSourceRequest) {
        return describePartnerEventSource(DescribePartnerEventSourceRequest.builder()
                .applyMutation(describePartnerEventSourceRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a replay. Use <code>DescribeReplay</code> to determine the progress of a running replay.
     * A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If
     * you use <code>StartReplay</code> and specify an <code>EventStartTime</code> and an <code>EventEndTime</code> that
     * covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then
     * the events from the second minute are replayed. You can use <code>DescribeReplay</code> to determine the progress
     * of a replay. The value returned for <code>EventLastReplayedTime</code> indicates the time within the specified
     * time range associated with the last event replayed.
     * </p>
     *
     * @param describeReplayRequest
     * @return A Java Future containing the result of the DescribeReplay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DescribeReplay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeReplay" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeReplayResponse> describeReplay(DescribeReplayRequest describeReplayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a replay. Use <code>DescribeReplay</code> to determine the progress of a running replay.
     * A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If
     * you use <code>StartReplay</code> and specify an <code>EventStartTime</code> and an <code>EventEndTime</code> that
     * covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then
     * the events from the second minute are replayed. You can use <code>DescribeReplay</code> to determine the progress
     * of a replay. The value returned for <code>EventLastReplayedTime</code> indicates the time within the specified
     * time range associated with the last event replayed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplayRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeReplayRequest#builder()}
     * </p>
     *
     * @param describeReplayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DescribeReplayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeReplay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DescribeReplay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeReplay" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeReplayResponse> describeReplay(Consumer<DescribeReplayRequest.Builder> describeReplayRequest) {
        return describeReplay(DescribeReplayRequest.builder().applyMutation(describeReplayRequest).build());
    }

    /**
     * <p>
     * Describes the specified rule.
     * </p>
     * <p>
     * DescribeRule does not list the targets of a rule. To see the targets associated with a rule, use <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html"
     * >ListTargetsByRule</a>.
     * </p>
     *
     * @param describeRuleRequest
     * @return A Java Future containing the result of the DescribeRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DescribeRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRuleResponse> describeRule(DescribeRuleRequest describeRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified rule.
     * </p>
     * <p>
     * DescribeRule does not list the targets of a rule. To see the targets associated with a rule, use <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html"
     * >ListTargetsByRule</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeRuleRequest#builder()}
     * </p>
     *
     * @param describeRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DescribeRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DescribeRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRuleResponse> describeRule(Consumer<DescribeRuleRequest.Builder> describeRuleRequest) {
        return describeRule(DescribeRuleRequest.builder().applyMutation(describeRuleRequest).build());
    }

    /**
     * <p>
     * Disables the specified rule. A disabled rule won't match any events, and won't self-trigger if it has a schedule
     * expression.
     * </p>
     * <p>
     * When you disable a rule, incoming events might continue to match to the disabled rule. Allow a short period of
     * time for changes to take effect.
     * </p>
     *
     * @param disableRuleRequest
     * @return A Java Future containing the result of the DisableRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ManagedRuleException This rule was created by an Amazon Web Services service on behalf of your
     *         account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or
     *         <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the
     *         rule or remove targets from the rule. You cannot modify these managed rules by using
     *         <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>,
     *         <code>TagResource</code>, or <code>UntagResource</code>.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DisableRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DisableRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisableRuleResponse> disableRule(DisableRuleRequest disableRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the specified rule. A disabled rule won't match any events, and won't self-trigger if it has a schedule
     * expression.
     * </p>
     * <p>
     * When you disable a rule, incoming events might continue to match to the disabled rule. Allow a short period of
     * time for changes to take effect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DisableRuleRequest#builder()}
     * </p>
     *
     * @param disableRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.DisableRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisableRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ManagedRuleException This rule was created by an Amazon Web Services service on behalf of your
     *         account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or
     *         <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the
     *         rule or remove targets from the rule. You cannot modify these managed rules by using
     *         <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>,
     *         <code>TagResource</code>, or <code>UntagResource</code>.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.DisableRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DisableRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisableRuleResponse> disableRule(Consumer<DisableRuleRequest.Builder> disableRuleRequest) {
        return disableRule(DisableRuleRequest.builder().applyMutation(disableRuleRequest).build());
    }

    /**
     * <p>
     * Enables the specified rule. If the rule does not exist, the operation fails.
     * </p>
     * <p>
     * When you enable a rule, incoming events might not immediately start matching to a newly enabled rule. Allow a
     * short period of time for changes to take effect.
     * </p>
     *
     * @param enableRuleRequest
     * @return A Java Future containing the result of the EnableRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ManagedRuleException This rule was created by an Amazon Web Services service on behalf of your
     *         account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or
     *         <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the
     *         rule or remove targets from the rule. You cannot modify these managed rules by using
     *         <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>,
     *         <code>TagResource</code>, or <code>UntagResource</code>.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.EnableRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/EnableRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnableRuleResponse> enableRule(EnableRuleRequest enableRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the specified rule. If the rule does not exist, the operation fails.
     * </p>
     * <p>
     * When you enable a rule, incoming events might not immediately start matching to a newly enabled rule. Allow a
     * short period of time for changes to take effect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableRuleRequest.Builder} avoiding the need to
     * create one manually via {@link EnableRuleRequest#builder()}
     * </p>
     *
     * @param enableRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.EnableRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the EnableRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ManagedRuleException This rule was created by an Amazon Web Services service on behalf of your
     *         account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or
     *         <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the
     *         rule or remove targets from the rule. You cannot modify these managed rules by using
     *         <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>,
     *         <code>TagResource</code>, or <code>UntagResource</code>.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.EnableRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/EnableRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnableRuleResponse> enableRule(Consumer<EnableRuleRequest.Builder> enableRuleRequest) {
        return enableRule(EnableRuleRequest.builder().applyMutation(enableRuleRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of API destination in the account in the current Region.
     * </p>
     *
     * @param listApiDestinationsRequest
     * @return A Java Future containing the result of the ListApiDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListApiDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListApiDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApiDestinationsResponse> listApiDestinations(
            ListApiDestinationsRequest listApiDestinationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of API destination in the account in the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApiDestinationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListApiDestinationsRequest#builder()}
     * </p>
     *
     * @param listApiDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.ListApiDestinationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListApiDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListApiDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListApiDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApiDestinationsResponse> listApiDestinations(
            Consumer<ListApiDestinationsRequest.Builder> listApiDestinationsRequest) {
        return listApiDestinations(ListApiDestinationsRequest.builder().applyMutation(listApiDestinationsRequest).build());
    }

    /**
     * <p>
     * Lists your archives. You can either list all the archives or you can provide a prefix to match to the archive
     * names. Filter parameters are exclusive.
     * </p>
     *
     * @param listArchivesRequest
     * @return A Java Future containing the result of the ListArchives operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListArchives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListArchives" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListArchivesResponse> listArchives(ListArchivesRequest listArchivesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your archives. You can either list all the archives or you can provide a prefix to match to the archive
     * names. Filter parameters are exclusive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArchivesRequest.Builder} avoiding the need to
     * create one manually via {@link ListArchivesRequest#builder()}
     * </p>
     *
     * @param listArchivesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.ListArchivesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListArchives operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListArchives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListArchives" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListArchivesResponse> listArchives(Consumer<ListArchivesRequest.Builder> listArchivesRequest) {
        return listArchives(ListArchivesRequest.builder().applyMutation(listArchivesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of connections from the account.
     * </p>
     *
     * @param listConnectionsRequest
     * @return A Java Future containing the result of the ListConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListConnections" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListConnectionsResponse> listConnections(ListConnectionsRequest listConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of connections from the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListConnectionsRequest#builder()}
     * </p>
     *
     * @param listConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.ListConnectionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListConnections" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListConnectionsResponse> listConnections(
            Consumer<ListConnectionsRequest.Builder> listConnectionsRequest) {
        return listConnections(ListConnectionsRequest.builder().applyMutation(listConnectionsRequest).build());
    }

    /**
     * <p>
     * List the global endpoints associated with this account. For more information about global endpoints, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html">Making applications
     * Regional-fault tolerant with global endpoints and event replication</a> in the <i> <i>Amazon EventBridge User
     * Guide</i> </i>.
     * </p>
     *
     * @param listEndpointsRequest
     * @return A Java Future containing the result of the ListEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEndpointsResponse> listEndpoints(ListEndpointsRequest listEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the global endpoints associated with this account. For more information about global endpoints, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html">Making applications
     * Regional-fault tolerant with global endpoints and event replication</a> in the <i> <i>Amazon EventBridge User
     * Guide</i> </i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointsRequest.Builder} avoiding the need to
     * create one manually via {@link ListEndpointsRequest#builder()}
     * </p>
     *
     * @param listEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.ListEndpointsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEndpointsResponse> listEndpoints(Consumer<ListEndpointsRequest.Builder> listEndpointsRequest) {
        return listEndpoints(ListEndpointsRequest.builder().applyMutation(listEndpointsRequest).build());
    }

    /**
     * <p>
     * Lists all the event buses in your account, including the default event bus, custom event buses, and partner event
     * buses.
     * </p>
     *
     * @param listEventBusesRequest
     * @return A Java Future containing the result of the ListEventBuses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListEventBuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListEventBuses" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEventBusesResponse> listEventBuses(ListEventBusesRequest listEventBusesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the event buses in your account, including the default event bus, custom event buses, and partner event
     * buses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventBusesRequest.Builder} avoiding the need to
     * create one manually via {@link ListEventBusesRequest#builder()}
     * </p>
     *
     * @param listEventBusesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.ListEventBusesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEventBuses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListEventBuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListEventBuses" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEventBusesResponse> listEventBuses(Consumer<ListEventBusesRequest.Builder> listEventBusesRequest) {
        return listEventBuses(ListEventBusesRequest.builder().applyMutation(listEventBusesRequest).build());
    }

    /**
     * <p>
     * You can use this to see all the partner event sources that have been shared with your Amazon Web Services
     * account. For more information about partner event sources, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus</a>.
     * </p>
     *
     * @param listEventSourcesRequest
     * @return A Java Future containing the result of the ListEventSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListEventSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListEventSources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEventSourcesResponse> listEventSources(ListEventSourcesRequest listEventSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can use this to see all the partner event sources that have been shared with your Amazon Web Services
     * account. For more information about partner event sources, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListEventSourcesRequest#builder()}
     * </p>
     *
     * @param listEventSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.ListEventSourcesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEventSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListEventSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListEventSources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEventSourcesResponse> listEventSources(
            Consumer<ListEventSourcesRequest.Builder> listEventSourcesRequest) {
        return listEventSources(ListEventSourcesRequest.builder().applyMutation(listEventSourcesRequest).build());
    }

    /**
     * <p>
     * An SaaS partner can use this operation to display the Amazon Web Services account ID that a particular partner
     * event source name is associated with. This operation is not used by Amazon Web Services customers.
     * </p>
     *
     * @param listPartnerEventSourceAccountsRequest
     * @return A Java Future containing the result of the ListPartnerEventSourceAccounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListPartnerEventSourceAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListPartnerEventSourceAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPartnerEventSourceAccountsResponse> listPartnerEventSourceAccounts(
            ListPartnerEventSourceAccountsRequest listPartnerEventSourceAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An SaaS partner can use this operation to display the Amazon Web Services account ID that a particular partner
     * event source name is associated with. This operation is not used by Amazon Web Services customers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPartnerEventSourceAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListPartnerEventSourceAccountsRequest#builder()}
     * </p>
     *
     * @param listPartnerEventSourceAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourceAccountsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListPartnerEventSourceAccounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListPartnerEventSourceAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListPartnerEventSourceAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPartnerEventSourceAccountsResponse> listPartnerEventSourceAccounts(
            Consumer<ListPartnerEventSourceAccountsRequest.Builder> listPartnerEventSourceAccountsRequest) {
        return listPartnerEventSourceAccounts(ListPartnerEventSourceAccountsRequest.builder()
                .applyMutation(listPartnerEventSourceAccountsRequest).build());
    }

    /**
     * <p>
     * An SaaS partner can use this operation to list all the partner event source names that they have created. This
     * operation is not used by Amazon Web Services customers.
     * </p>
     *
     * @param listPartnerEventSourcesRequest
     * @return A Java Future containing the result of the ListPartnerEventSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListPartnerEventSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListPartnerEventSources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPartnerEventSourcesResponse> listPartnerEventSources(
            ListPartnerEventSourcesRequest listPartnerEventSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An SaaS partner can use this operation to list all the partner event source names that they have created. This
     * operation is not used by Amazon Web Services customers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPartnerEventSourcesRequest.Builder} avoiding
     * the need to create one manually via {@link ListPartnerEventSourcesRequest#builder()}
     * </p>
     *
     * @param listPartnerEventSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.ListPartnerEventSourcesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListPartnerEventSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListPartnerEventSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListPartnerEventSources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPartnerEventSourcesResponse> listPartnerEventSources(
            Consumer<ListPartnerEventSourcesRequest.Builder> listPartnerEventSourcesRequest) {
        return listPartnerEventSources(ListPartnerEventSourcesRequest.builder().applyMutation(listPartnerEventSourcesRequest)
                .build());
    }

    /**
     * <p>
     * Lists your replays. You can either list all the replays or you can provide a prefix to match to the replay names.
     * Filter parameters are exclusive.
     * </p>
     *
     * @param listReplaysRequest
     * @return A Java Future containing the result of the ListReplays operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListReplays
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListReplays" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReplaysResponse> listReplays(ListReplaysRequest listReplaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your replays. You can either list all the replays or you can provide a prefix to match to the replay names.
     * Filter parameters are exclusive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReplaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListReplaysRequest#builder()}
     * </p>
     *
     * @param listReplaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.ListReplaysRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListReplays operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListReplays
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListReplays" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReplaysResponse> listReplays(Consumer<ListReplaysRequest.Builder> listReplaysRequest) {
        return listReplays(ListReplaysRequest.builder().applyMutation(listReplaysRequest).build());
    }

    /**
     * <p>
     * Lists the rules for the specified target. You can see which of the rules in Amazon EventBridge can invoke a
     * specific target in your account.
     * </p>
     * <p>
     * The maximum number of results per page for requests is 100.
     * </p>
     *
     * @param listRuleNamesByTargetRequest
     * @return A Java Future containing the result of the ListRuleNamesByTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListRuleNamesByTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListRuleNamesByTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRuleNamesByTargetResponse> listRuleNamesByTarget(
            ListRuleNamesByTargetRequest listRuleNamesByTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the rules for the specified target. You can see which of the rules in Amazon EventBridge can invoke a
     * specific target in your account.
     * </p>
     * <p>
     * The maximum number of results per page for requests is 100.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleNamesByTargetRequest.Builder} avoiding the
     * need to create one manually via {@link ListRuleNamesByTargetRequest#builder()}
     * </p>
     *
     * @param listRuleNamesByTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRuleNamesByTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListRuleNamesByTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListRuleNamesByTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRuleNamesByTargetResponse> listRuleNamesByTarget(
            Consumer<ListRuleNamesByTargetRequest.Builder> listRuleNamesByTargetRequest) {
        return listRuleNamesByTarget(ListRuleNamesByTargetRequest.builder().applyMutation(listRuleNamesByTargetRequest).build());
    }

    /**
     * <p>
     * Lists your Amazon EventBridge rules. You can either list all the rules or you can provide a prefix to match to
     * the rule names.
     * </p>
     * <p>
     * The maximum number of results per page for requests is 100.
     * </p>
     * <p>
     * ListRules does not list the targets of a rule. To see the targets associated with a rule, use <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html"
     * >ListTargetsByRule</a>.
     * </p>
     *
     * @param listRulesRequest
     * @return A Java Future containing the result of the ListRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRulesResponse> listRules(ListRulesRequest listRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your Amazon EventBridge rules. You can either list all the rules or you can provide a prefix to match to
     * the rule names.
     * </p>
     * <p>
     * The maximum number of results per page for requests is 100.
     * </p>
     * <p>
     * ListRules does not list the targets of a rule. To see the targets associated with a rule, use <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html"
     * >ListTargetsByRule</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRulesRequest#builder()}
     * </p>
     *
     * @param listRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.ListRulesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRulesResponse> listRules(Consumer<ListRulesRequest.Builder> listRulesRequest) {
        return listRules(ListRulesRequest.builder().applyMutation(listRulesRequest).build());
    }

    /**
     * <p>
     * Displays the tags associated with an EventBridge resource. In EventBridge, rules and event buses can be tagged.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the tags associated with an EventBridge resource. In EventBridge, rules and event buses can be tagged.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the targets assigned to the specified rule.
     * </p>
     * <p>
     * The maximum number of results per page for requests is 100.
     * </p>
     *
     * @param listTargetsByRuleRequest
     * @return A Java Future containing the result of the ListTargetsByRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListTargetsByRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListTargetsByRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTargetsByRuleResponse> listTargetsByRule(ListTargetsByRuleRequest listTargetsByRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the targets assigned to the specified rule.
     * </p>
     * <p>
     * The maximum number of results per page for requests is 100.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetsByRuleRequest.Builder} avoiding the need
     * to create one manually via {@link ListTargetsByRuleRequest#builder()}
     * </p>
     *
     * @param listTargetsByRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTargetsByRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.ListTargetsByRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListTargetsByRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTargetsByRuleResponse> listTargetsByRule(
            Consumer<ListTargetsByRuleRequest.Builder> listTargetsByRuleRequest) {
        return listTargetsByRule(ListTargetsByRuleRequest.builder().applyMutation(listTargetsByRuleRequest).build());
    }

    /**
     * <p>
     * Sends custom events to Amazon EventBridge so that they can be matched to rules.
     * </p>
     * <p>
     * The maximum size for a PutEvents event entry is 256 KB. Entry size is calculated including the event and any
     * necessary characters and keys of the JSON representation of the event. To learn more, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-putevent-size.html">Calculating PutEvents event
     * entry size</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>
     * </p>
     * <p>
     * PutEvents accepts the data in JSON format. For the JSON number (integer) data type, the constraints are: a
     * minimum value of -9,223,372,036,854,775,808 and a maximum value of 9,223,372,036,854,775,807.
     * </p>
     * <note>
     * <p>
     * PutEvents will only process nested JSON up to 1100 levels deep.
     * </p>
     * </note>
     *
     * @param putEventsRequest
     * @return A Java Future containing the result of the PutEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.PutEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutEventsResponse> putEvents(PutEventsRequest putEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends custom events to Amazon EventBridge so that they can be matched to rules.
     * </p>
     * <p>
     * The maximum size for a PutEvents event entry is 256 KB. Entry size is calculated including the event and any
     * necessary characters and keys of the JSON representation of the event. To learn more, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-putevent-size.html">Calculating PutEvents event
     * entry size</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>
     * </p>
     * <p>
     * PutEvents accepts the data in JSON format. For the JSON number (integer) data type, the constraints are: a
     * minimum value of -9,223,372,036,854,775,808 and a maximum value of 9,223,372,036,854,775,807.
     * </p>
     * <note>
     * <p>
     * PutEvents will only process nested JSON up to 1100 levels deep.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEventsRequest.Builder} avoiding the need to
     * create one manually via {@link PutEventsRequest#builder()}
     * </p>
     *
     * @param putEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.PutEventsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.PutEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutEventsResponse> putEvents(Consumer<PutEventsRequest.Builder> putEventsRequest) {
        return putEvents(PutEventsRequest.builder().applyMutation(putEventsRequest).build());
    }

    /**
     * <p>
     * This is used by SaaS partners to write events to a customer's partner event bus. Amazon Web Services customers do
     * not use this operation.
     * </p>
     * <p>
     * For information on calculating event batch size, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-putevent-size.html">Calculating EventBridge
     * PutEvents event entry size</a> in the <i>EventBridge User Guide</i>.
     * </p>
     *
     * @param putPartnerEventsRequest
     * @return A Java Future containing the result of the PutPartnerEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.PutPartnerEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutPartnerEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutPartnerEventsResponse> putPartnerEvents(PutPartnerEventsRequest putPartnerEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is used by SaaS partners to write events to a customer's partner event bus. Amazon Web Services customers do
     * not use this operation.
     * </p>
     * <p>
     * For information on calculating event batch size, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-putevent-size.html">Calculating EventBridge
     * PutEvents event entry size</a> in the <i>EventBridge User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPartnerEventsRequest.Builder} avoiding the need
     * to create one manually via {@link PutPartnerEventsRequest#builder()}
     * </p>
     *
     * @param putPartnerEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutPartnerEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.PutPartnerEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutPartnerEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutPartnerEventsResponse> putPartnerEvents(
            Consumer<PutPartnerEventsRequest.Builder> putPartnerEventsRequest) {
        return putPartnerEvents(PutPartnerEventsRequest.builder().applyMutation(putPartnerEventsRequest).build());
    }

    /**
     * <p>
     * Running <code>PutPermission</code> permits the specified Amazon Web Services account or Amazon Web Services
     * organization to put events to the specified <i>event bus</i>. Amazon EventBridge (CloudWatch Events) rules in
     * your account are triggered by these events arriving to an event bus in your account.
     * </p>
     * <p>
     * For another account to send events to your account, that external account must have an EventBridge rule with your
     * account's event bus as a target.
     * </p>
     * <p>
     * To enable multiple Amazon Web Services accounts to put events to your event bus, run <code>PutPermission</code>
     * once for each of these accounts. Or, if all the accounts are members of the same Amazon Web Services
     * organization, you can run <code>PutPermission</code> once specifying <code>Principal</code> as "*" and specifying
     * the Amazon Web Services organization ID in <code>Condition</code>, to grant permissions to all accounts in that
     * organization.
     * </p>
     * <p>
     * If you grant permissions using an organization, then accounts in that organization must specify a
     * <code>RoleArn</code> with proper permissions when they use <code>PutTarget</code> to add your account's event bus
     * as a target. For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html"
     * >Sending and Receiving Events Between Amazon Web Services Accounts</a> in the <i>Amazon EventBridge User
     * Guide</i>.
     * </p>
     * <p>
     * The permission policy on the event bus cannot exceed 10 KB in size.
     * </p>
     *
     * @param putPermissionRequest
     * @return A Java Future containing the result of the PutPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>PolicyLengthExceededException The event bus policy is too long. For more information, see the limits.
     *         </li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.PutPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutPermissionResponse> putPermission(PutPermissionRequest putPermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Running <code>PutPermission</code> permits the specified Amazon Web Services account or Amazon Web Services
     * organization to put events to the specified <i>event bus</i>. Amazon EventBridge (CloudWatch Events) rules in
     * your account are triggered by these events arriving to an event bus in your account.
     * </p>
     * <p>
     * For another account to send events to your account, that external account must have an EventBridge rule with your
     * account's event bus as a target.
     * </p>
     * <p>
     * To enable multiple Amazon Web Services accounts to put events to your event bus, run <code>PutPermission</code>
     * once for each of these accounts. Or, if all the accounts are members of the same Amazon Web Services
     * organization, you can run <code>PutPermission</code> once specifying <code>Principal</code> as "*" and specifying
     * the Amazon Web Services organization ID in <code>Condition</code>, to grant permissions to all accounts in that
     * organization.
     * </p>
     * <p>
     * If you grant permissions using an organization, then accounts in that organization must specify a
     * <code>RoleArn</code> with proper permissions when they use <code>PutTarget</code> to add your account's event bus
     * as a target. For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html"
     * >Sending and Receiving Events Between Amazon Web Services Accounts</a> in the <i>Amazon EventBridge User
     * Guide</i>.
     * </p>
     * <p>
     * The permission policy on the event bus cannot exceed 10 KB in size.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPermissionRequest.Builder} avoiding the need to
     * create one manually via {@link PutPermissionRequest#builder()}
     * </p>
     *
     * @param putPermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.PutPermissionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>PolicyLengthExceededException The event bus policy is too long. For more information, see the limits.
     *         </li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.PutPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutPermissionResponse> putPermission(Consumer<PutPermissionRequest.Builder> putPermissionRequest) {
        return putPermission(PutPermissionRequest.builder().applyMutation(putPermissionRequest).build());
    }

    /**
     * <p>
     * Creates or updates the specified rule. Rules are enabled by default, or based on value of the state. You can
     * disable a rule using <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DisableRule.html">DisableRule</a>.
     * </p>
     * <p>
     * A single rule watches for events from a single event bus. Events generated by Amazon Web Services services go to
     * your account's default event bus. Events generated by SaaS partner services or applications go to the matching
     * partner event bus. If you have custom applications or services, you can specify whether their events go to your
     * default event bus or a custom event bus that you have created. For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus</a>.
     * </p>
     * <p>
     * If you are updating an existing rule, the rule is replaced with what you specify in this <code>PutRule</code>
     * command. If you omit arguments in <code>PutRule</code>, the old values for those arguments are not kept. Instead,
     * they are replaced with null values.
     * </p>
     * <p>
     * When you create or update a rule, incoming events might not immediately start matching to new or updated rules.
     * Allow a short period of time for changes to take effect.
     * </p>
     * <p>
     * A rule must contain at least an EventPattern or ScheduleExpression. Rules with EventPatterns are triggered when a
     * matching event is observed. Rules with ScheduleExpressions self-trigger based on the given schedule. A rule can
     * have both an EventPattern and a ScheduleExpression, in which case the rule triggers on matching events as well as
     * on a schedule.
     * </p>
     * <p>
     * When you initially create a rule, you can optionally assign one or more tags to the rule. Tags can help you
     * organize and categorize your resources. You can also use them to scope user permissions, by granting a user
     * permission to access or change only rules with certain tag values. To use the <code>PutRule</code> operation and
     * assign tags, you must have both the <code>events:PutRule</code> and <code>events:TagResource</code> permissions.
     * </p>
     * <p>
     * If you are updating an existing rule, any tags you specify in the <code>PutRule</code> operation are ignored. To
     * update the tags of an existing rule, use <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_TagResource.html">TagResource</a> and <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_UntagResource.html">UntagResource</a>.
     * </p>
     * <p>
     * Most services in Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs). However,
     * EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN characters when
     * creating event patterns so that they match the ARN syntax in the event you want to match.
     * </p>
     * <p>
     * In EventBridge, it is possible to create rules that lead to infinite loops, where a rule is fired repeatedly. For
     * example, a rule might detect that ACLs have changed on an S3 bucket, and trigger software to change them to the
     * desired state. If the rule is not written carefully, the subsequent change to the ACLs fires the rule again,
     * creating an infinite loop.
     * </p>
     * <p>
     * To prevent this, write the rules so that the triggered actions do not re-fire the same rule. For example, your
     * rule could fire only if ACLs are found to be in a bad state, instead of after any change.
     * </p>
     * <p>
     * An infinite loop can quickly cause higher than expected charges. We recommend that you use budgeting, which
     * alerts you when charges exceed your specified limit. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html">Managing Your
     * Costs with Budgets</a>.
     * </p>
     *
     * @param putRuleRequest
     * @return A Java Future containing the result of the PutRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidEventPatternException The event pattern is not valid.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ManagedRuleException This rule was created by an Amazon Web Services service on behalf of your
     *         account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or
     *         <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the
     *         rule or remove targets from the rule. You cannot modify these managed rules by using
     *         <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>,
     *         <code>TagResource</code>, or <code>UntagResource</code>.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.PutRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutRuleResponse> putRule(PutRuleRequest putRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the specified rule. Rules are enabled by default, or based on value of the state. You can
     * disable a rule using <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DisableRule.html">DisableRule</a>.
     * </p>
     * <p>
     * A single rule watches for events from a single event bus. Events generated by Amazon Web Services services go to
     * your account's default event bus. Events generated by SaaS partner services or applications go to the matching
     * partner event bus. If you have custom applications or services, you can specify whether their events go to your
     * default event bus or a custom event bus that you have created. For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus</a>.
     * </p>
     * <p>
     * If you are updating an existing rule, the rule is replaced with what you specify in this <code>PutRule</code>
     * command. If you omit arguments in <code>PutRule</code>, the old values for those arguments are not kept. Instead,
     * they are replaced with null values.
     * </p>
     * <p>
     * When you create or update a rule, incoming events might not immediately start matching to new or updated rules.
     * Allow a short period of time for changes to take effect.
     * </p>
     * <p>
     * A rule must contain at least an EventPattern or ScheduleExpression. Rules with EventPatterns are triggered when a
     * matching event is observed. Rules with ScheduleExpressions self-trigger based on the given schedule. A rule can
     * have both an EventPattern and a ScheduleExpression, in which case the rule triggers on matching events as well as
     * on a schedule.
     * </p>
     * <p>
     * When you initially create a rule, you can optionally assign one or more tags to the rule. Tags can help you
     * organize and categorize your resources. You can also use them to scope user permissions, by granting a user
     * permission to access or change only rules with certain tag values. To use the <code>PutRule</code> operation and
     * assign tags, you must have both the <code>events:PutRule</code> and <code>events:TagResource</code> permissions.
     * </p>
     * <p>
     * If you are updating an existing rule, any tags you specify in the <code>PutRule</code> operation are ignored. To
     * update the tags of an existing rule, use <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_TagResource.html">TagResource</a> and <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_UntagResource.html">UntagResource</a>.
     * </p>
     * <p>
     * Most services in Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs). However,
     * EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN characters when
     * creating event patterns so that they match the ARN syntax in the event you want to match.
     * </p>
     * <p>
     * In EventBridge, it is possible to create rules that lead to infinite loops, where a rule is fired repeatedly. For
     * example, a rule might detect that ACLs have changed on an S3 bucket, and trigger software to change them to the
     * desired state. If the rule is not written carefully, the subsequent change to the ACLs fires the rule again,
     * creating an infinite loop.
     * </p>
     * <p>
     * To prevent this, write the rules so that the triggered actions do not re-fire the same rule. For example, your
     * rule could fire only if ACLs are found to be in a bad state, instead of after any change.
     * </p>
     * <p>
     * An infinite loop can quickly cause higher than expected charges. We recommend that you use budgeting, which
     * alerts you when charges exceed your specified limit. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html">Managing Your
     * Costs with Budgets</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRuleRequest.Builder} avoiding the need to create
     * one manually via {@link PutRuleRequest#builder()}
     * </p>
     *
     * @param putRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.PutRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidEventPatternException The event pattern is not valid.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ManagedRuleException This rule was created by an Amazon Web Services service on behalf of your
     *         account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or
     *         <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the
     *         rule or remove targets from the rule. You cannot modify these managed rules by using
     *         <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>,
     *         <code>TagResource</code>, or <code>UntagResource</code>.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.PutRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutRuleResponse> putRule(Consumer<PutRuleRequest.Builder> putRuleRequest) {
        return putRule(PutRuleRequest.builder().applyMutation(putRuleRequest).build());
    }

    /**
     * <p>
     * Adds the specified targets to the specified rule, or updates the targets if they are already associated with the
     * rule.
     * </p>
     * <p>
     * Targets are the resources that are invoked when a rule is triggered.
     * </p>
     * <p>
     * The maximum number of entries per request is 10.
     * </p>
     * <note>
     * <p>
     * Each rule can have up to five (5) targets associated with it at one time.
     * </p>
     * </note>
     * <p>
     * For a list of services you can configure as targets for events, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-targets.html">EventBridge targets</a> in the
     * <i> <i>Amazon EventBridge User Guide</i> </i>.
     * </p>
     * <p>
     * Creating rules with built-in targets is supported only in the Amazon Web Services Management Console. The
     * built-in targets are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Amazon EBS CreateSnapshot API call</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Amazon EC2 RebootInstances API call</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Amazon EC2 StopInstances API call</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Amazon EC2 TerminateInstances API call</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For some target types, <code>PutTargets</code> provides target-specific parameters. If the target is a Kinesis
     * data stream, you can optionally specify which shard the event goes to by using the <code>KinesisParameters</code>
     * argument. To invoke a command on multiple EC2 instances with one rule, you can use the
     * <code>RunCommandParameters</code> field.
     * </p>
     * <p>
     * To be able to make API calls against the resources that you own, Amazon EventBridge needs the appropriate
     * permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Lambda and Amazon SNS resources, EventBridge relies on resource-based policies.
     * </p>
     * </li>
     * <li>
     * <p>
     * For EC2 instances, Kinesis Data Streams, Step Functions state machines and API Gateway APIs, EventBridge relies
     * on IAM roles that you specify in the <code>RoleARN</code> argument in <code>PutTargets</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/auth-and-access-control-eventbridge.html"
     * >Authentication and Access Control</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>.
     * </p>
     * <p>
     * If another Amazon Web Services account is in the same region and has granted you permission (using
     * <code>PutPermission</code>), you can send events to that account. Set that account's event bus as a target of the
     * rules in your account. To send the matched events to the other account, specify that account's event bus as the
     * <code>Arn</code> value when you run <code>PutTargets</code>. If your account sends events to another account,
     * your account is charged for each sent event. Each event sent to another account is charged as a custom event. The
     * account receiving the event is not charged. For more information, see <a
     * href="http://aws.amazon.com/eventbridge/pricing/">Amazon EventBridge Pricing</a>.
     * </p>
     * <note>
     * <p>
     * <code>Input</code>, <code>InputPath</code>, and <code>InputTransformer</code> are not available with
     * <code>PutTarget</code> if the target is an event bus of a different Amazon Web Services account.
     * </p>
     * </note>
     * <p>
     * If you are setting the event bus of another account as the target, and that account granted permission to your
     * account through an organization instead of directly by the account ID, then you must specify a
     * <code>RoleArn</code> with proper permissions in the <code>Target</code> structure. For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">
     * Sending and Receiving Events Between Amazon Web Services Accounts</a> in the <i>Amazon EventBridge User
     * Guide</i>.
     * </p>
     * <note>
     * <p>
     * If you have an IAM role on a cross-account event bus target, a <code>PutTargets</code> call without a role on the
     * same target (same <code>Id</code> and <code>Arn</code>) will not remove the role.
     * </p>
     * </note>
     * <p>
     * For more information about enabling cross-account events, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission</a>.
     * </p>
     * <p>
     * <b>Input</b>, <b>InputPath</b>, and <b>InputTransformer</b> are mutually exclusive and optional parameters of a
     * target. When a rule is triggered due to a matched event:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If none of the following arguments are specified for a target, then the entire event is passed to the target in
     * JSON format (unless the target is Amazon EC2 Run Command or Amazon ECS task, in which case nothing from the event
     * is passed to the target).
     * </p>
     * </li>
     * <li>
     * <p>
     * If <b>Input</b> is specified in the form of valid JSON, then the matched event is overridden with this constant.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <b>InputPath</b> is specified in the form of JSONPath (for example, <code>&#36.detail</code>), then only the
     * part of the event specified in the path is passed to the target (for example, only the detail part of the event
     * is passed).
     * </p>
     * </li>
     * <li>
     * <p>
     * If <b>InputTransformer</b> is specified, then one or more specified JSONPaths are extracted from the event and
     * used as values in a template that you specify as the input to the target.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you specify <code>InputPath</code> or <code>InputTransformer</code>, you must use JSON dot notation, not
     * bracket notation.
     * </p>
     * <p>
     * When you add targets to a rule and the associated rule triggers soon after, new or updated targets might not be
     * immediately invoked. Allow a short period of time for changes to take effect.
     * </p>
     * <p>
     * This action can partially fail if too many requests are made at the same time. If that happens,
     * <code>FailedEntryCount</code> is non-zero in the response and each entry in <code>FailedEntries</code> provides
     * the ID of the failed target and the error code.
     * </p>
     *
     * @param putTargetsRequest
     * @return A Java Future containing the result of the PutTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>ManagedRuleException This rule was created by an Amazon Web Services service on behalf of your
     *         account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or
     *         <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the
     *         rule or remove targets from the rule. You cannot modify these managed rules by using
     *         <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>,
     *         <code>TagResource</code>, or <code>UntagResource</code>.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.PutTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutTargets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutTargetsResponse> putTargets(PutTargetsRequest putTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified targets to the specified rule, or updates the targets if they are already associated with the
     * rule.
     * </p>
     * <p>
     * Targets are the resources that are invoked when a rule is triggered.
     * </p>
     * <p>
     * The maximum number of entries per request is 10.
     * </p>
     * <note>
     * <p>
     * Each rule can have up to five (5) targets associated with it at one time.
     * </p>
     * </note>
     * <p>
     * For a list of services you can configure as targets for events, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-targets.html">EventBridge targets</a> in the
     * <i> <i>Amazon EventBridge User Guide</i> </i>.
     * </p>
     * <p>
     * Creating rules with built-in targets is supported only in the Amazon Web Services Management Console. The
     * built-in targets are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Amazon EBS CreateSnapshot API call</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Amazon EC2 RebootInstances API call</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Amazon EC2 StopInstances API call</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Amazon EC2 TerminateInstances API call</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For some target types, <code>PutTargets</code> provides target-specific parameters. If the target is a Kinesis
     * data stream, you can optionally specify which shard the event goes to by using the <code>KinesisParameters</code>
     * argument. To invoke a command on multiple EC2 instances with one rule, you can use the
     * <code>RunCommandParameters</code> field.
     * </p>
     * <p>
     * To be able to make API calls against the resources that you own, Amazon EventBridge needs the appropriate
     * permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Lambda and Amazon SNS resources, EventBridge relies on resource-based policies.
     * </p>
     * </li>
     * <li>
     * <p>
     * For EC2 instances, Kinesis Data Streams, Step Functions state machines and API Gateway APIs, EventBridge relies
     * on IAM roles that you specify in the <code>RoleARN</code> argument in <code>PutTargets</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/auth-and-access-control-eventbridge.html"
     * >Authentication and Access Control</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>.
     * </p>
     * <p>
     * If another Amazon Web Services account is in the same region and has granted you permission (using
     * <code>PutPermission</code>), you can send events to that account. Set that account's event bus as a target of the
     * rules in your account. To send the matched events to the other account, specify that account's event bus as the
     * <code>Arn</code> value when you run <code>PutTargets</code>. If your account sends events to another account,
     * your account is charged for each sent event. Each event sent to another account is charged as a custom event. The
     * account receiving the event is not charged. For more information, see <a
     * href="http://aws.amazon.com/eventbridge/pricing/">Amazon EventBridge Pricing</a>.
     * </p>
     * <note>
     * <p>
     * <code>Input</code>, <code>InputPath</code>, and <code>InputTransformer</code> are not available with
     * <code>PutTarget</code> if the target is an event bus of a different Amazon Web Services account.
     * </p>
     * </note>
     * <p>
     * If you are setting the event bus of another account as the target, and that account granted permission to your
     * account through an organization instead of directly by the account ID, then you must specify a
     * <code>RoleArn</code> with proper permissions in the <code>Target</code> structure. For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">
     * Sending and Receiving Events Between Amazon Web Services Accounts</a> in the <i>Amazon EventBridge User
     * Guide</i>.
     * </p>
     * <note>
     * <p>
     * If you have an IAM role on a cross-account event bus target, a <code>PutTargets</code> call without a role on the
     * same target (same <code>Id</code> and <code>Arn</code>) will not remove the role.
     * </p>
     * </note>
     * <p>
     * For more information about enabling cross-account events, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission</a>.
     * </p>
     * <p>
     * <b>Input</b>, <b>InputPath</b>, and <b>InputTransformer</b> are mutually exclusive and optional parameters of a
     * target. When a rule is triggered due to a matched event:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If none of the following arguments are specified for a target, then the entire event is passed to the target in
     * JSON format (unless the target is Amazon EC2 Run Command or Amazon ECS task, in which case nothing from the event
     * is passed to the target).
     * </p>
     * </li>
     * <li>
     * <p>
     * If <b>Input</b> is specified in the form of valid JSON, then the matched event is overridden with this constant.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <b>InputPath</b> is specified in the form of JSONPath (for example, <code>&#36.detail</code>), then only the
     * part of the event specified in the path is passed to the target (for example, only the detail part of the event
     * is passed).
     * </p>
     * </li>
     * <li>
     * <p>
     * If <b>InputTransformer</b> is specified, then one or more specified JSONPaths are extracted from the event and
     * used as values in a template that you specify as the input to the target.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you specify <code>InputPath</code> or <code>InputTransformer</code>, you must use JSON dot notation, not
     * bracket notation.
     * </p>
     * <p>
     * When you add targets to a rule and the associated rule triggers soon after, new or updated targets might not be
     * immediately invoked. Allow a short period of time for changes to take effect.
     * </p>
     * <p>
     * This action can partially fail if too many requests are made at the same time. If that happens,
     * <code>FailedEntryCount</code> is non-zero in the response and each entry in <code>FailedEntries</code> provides
     * the ID of the failed target and the error code.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutTargetsRequest.Builder} avoiding the need to
     * create one manually via {@link PutTargetsRequest#builder()}
     * </p>
     *
     * @param putTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.PutTargetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>ManagedRuleException This rule was created by an Amazon Web Services service on behalf of your
     *         account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or
     *         <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the
     *         rule or remove targets from the rule. You cannot modify these managed rules by using
     *         <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>,
     *         <code>TagResource</code>, or <code>UntagResource</code>.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.PutTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutTargets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutTargetsResponse> putTargets(Consumer<PutTargetsRequest.Builder> putTargetsRequest) {
        return putTargets(PutTargetsRequest.builder().applyMutation(putTargetsRequest).build());
    }

    /**
     * <p>
     * Revokes the permission of another Amazon Web Services account to be able to put events to the specified event
     * bus. Specify the account to revoke by the <code>StatementId</code> value that you associated with the account
     * when you granted it permission with <code>PutPermission</code>. You can find the <code>StatementId</code> by
     * using <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventBus.html">DescribeEventBus
     * </a>.
     * </p>
     *
     * @param removePermissionRequest
     * @return A Java Future containing the result of the RemovePermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.RemovePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/RemovePermission" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RemovePermissionResponse> removePermission(RemovePermissionRequest removePermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes the permission of another Amazon Web Services account to be able to put events to the specified event
     * bus. Specify the account to revoke by the <code>StatementId</code> value that you associated with the account
     * when you granted it permission with <code>PutPermission</code>. You can find the <code>StatementId</code> by
     * using <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventBus.html">DescribeEventBus
     * </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemovePermissionRequest.Builder} avoiding the need
     * to create one manually via {@link RemovePermissionRequest#builder()}
     * </p>
     *
     * @param removePermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.RemovePermissionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemovePermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.RemovePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/RemovePermission" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RemovePermissionResponse> removePermission(
            Consumer<RemovePermissionRequest.Builder> removePermissionRequest) {
        return removePermission(RemovePermissionRequest.builder().applyMutation(removePermissionRequest).build());
    }

    /**
     * <p>
     * Removes the specified targets from the specified rule. When the rule is triggered, those targets are no longer be
     * invoked.
     * </p>
     * <note>
     * <p>
     * A successful execution of <code>RemoveTargets</code> doesn't guarantee all targets are removed from the rule, it
     * means that the target(s) listed in the request are removed.
     * </p>
     * </note>
     * <p>
     * When you remove a target, when the associated rule triggers, removed targets might continue to be invoked. Allow
     * a short period of time for changes to take effect.
     * </p>
     * <p>
     * This action can partially fail if too many requests are made at the same time. If that happens,
     * <code>FailedEntryCount</code> is non-zero in the response and each entry in <code>FailedEntries</code> provides
     * the ID of the failed target and the error code.
     * </p>
     * <p>
     * The maximum number of entries per request is 10.
     * </p>
     *
     * @param removeTargetsRequest
     * @return A Java Future containing the result of the RemoveTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ManagedRuleException This rule was created by an Amazon Web Services service on behalf of your
     *         account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or
     *         <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the
     *         rule or remove targets from the rule. You cannot modify these managed rules by using
     *         <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>,
     *         <code>TagResource</code>, or <code>UntagResource</code>.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.RemoveTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/RemoveTargets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveTargetsResponse> removeTargets(RemoveTargetsRequest removeTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified targets from the specified rule. When the rule is triggered, those targets are no longer be
     * invoked.
     * </p>
     * <note>
     * <p>
     * A successful execution of <code>RemoveTargets</code> doesn't guarantee all targets are removed from the rule, it
     * means that the target(s) listed in the request are removed.
     * </p>
     * </note>
     * <p>
     * When you remove a target, when the associated rule triggers, removed targets might continue to be invoked. Allow
     * a short period of time for changes to take effect.
     * </p>
     * <p>
     * This action can partially fail if too many requests are made at the same time. If that happens,
     * <code>FailedEntryCount</code> is non-zero in the response and each entry in <code>FailedEntries</code> provides
     * the ID of the failed target and the error code.
     * </p>
     * <p>
     * The maximum number of entries per request is 10.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTargetsRequest.Builder} avoiding the need to
     * create one manually via {@link RemoveTargetsRequest#builder()}
     * </p>
     *
     * @param removeTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.RemoveTargetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ManagedRuleException This rule was created by an Amazon Web Services service on behalf of your
     *         account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or
     *         <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the
     *         rule or remove targets from the rule. You cannot modify these managed rules by using
     *         <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>,
     *         <code>TagResource</code>, or <code>UntagResource</code>.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.RemoveTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/RemoveTargets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveTargetsResponse> removeTargets(Consumer<RemoveTargetsRequest.Builder> removeTargetsRequest) {
        return removeTargets(RemoveTargetsRequest.builder().applyMutation(removeTargetsRequest).build());
    }

    /**
     * <p>
     * Starts the specified replay. Events are not necessarily replayed in the exact same order that they were added to
     * the archive. A replay processes events to replay based on the time in the event, and replays them using 1 minute
     * intervals. If you specify an <code>EventStartTime</code> and an <code>EventEndTime</code> that covers a 20 minute
     * time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the
     * second minute are replayed. You can use <code>DescribeReplay</code> to determine the progress of a replay. The
     * value returned for <code>EventLastReplayedTime</code> indicates the time within the specified time range
     * associated with the last event replayed.
     * </p>
     *
     * @param startReplayRequest
     * @return A Java Future containing the result of the StartReplay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ResourceAlreadyExistsException The resource you are trying to create already exists.</li>
     *         <li>InvalidEventPatternException The event pattern is not valid.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.StartReplay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/StartReplay" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartReplayResponse> startReplay(StartReplayRequest startReplayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the specified replay. Events are not necessarily replayed in the exact same order that they were added to
     * the archive. A replay processes events to replay based on the time in the event, and replays them using 1 minute
     * intervals. If you specify an <code>EventStartTime</code> and an <code>EventEndTime</code> that covers a 20 minute
     * time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the
     * second minute are replayed. You can use <code>DescribeReplay</code> to determine the progress of a replay. The
     * value returned for <code>EventLastReplayedTime</code> indicates the time within the specified time range
     * associated with the last event replayed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReplayRequest.Builder} avoiding the need to
     * create one manually via {@link StartReplayRequest#builder()}
     * </p>
     *
     * @param startReplayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.StartReplayRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartReplay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ResourceAlreadyExistsException The resource you are trying to create already exists.</li>
     *         <li>InvalidEventPatternException The event pattern is not valid.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.StartReplay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/StartReplay" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartReplayResponse> startReplay(Consumer<StartReplayRequest.Builder> startReplayRequest) {
        return startReplay(StartReplayRequest.builder().applyMutation(startReplayRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified EventBridge resource. Tags can help you organize and
     * categorize your resources. You can also use them to scope user permissions by granting a user permission to
     * access or change only resources with certain tag values. In EventBridge, rules and event buses can be tagged.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
     * characters.
     * </p>
     * <p>
     * You can use the <code>TagResource</code> action with a resource that already has tags. If you specify a new tag
     * key, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is
     * already associated with the resource, the new tag value that you specify replaces the previous value for that
     * tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ManagedRuleException This rule was created by an Amazon Web Services service on behalf of your
     *         account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or
     *         <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the
     *         rule or remove targets from the rule. You cannot modify these managed rules by using
     *         <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>,
     *         <code>TagResource</code>, or <code>UntagResource</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified EventBridge resource. Tags can help you organize and
     * categorize your resources. You can also use them to scope user permissions by granting a user permission to
     * access or change only resources with certain tag values. In EventBridge, rules and event buses can be tagged.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
     * characters.
     * </p>
     * <p>
     * You can use the <code>TagResource</code> action with a resource that already has tags. If you specify a new tag
     * key, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is
     * already associated with the resource, the new tag value that you specify replaces the previous value for that
     * tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ManagedRuleException This rule was created by an Amazon Web Services service on behalf of your
     *         account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or
     *         <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the
     *         rule or remove targets from the rule. You cannot modify these managed rules by using
     *         <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>,
     *         <code>TagResource</code>, or <code>UntagResource</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Tests whether the specified event pattern matches the provided event.
     * </p>
     * <p>
     * Most services in Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs). However,
     * EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN characters when
     * creating event patterns so that they match the ARN syntax in the event you want to match.
     * </p>
     *
     * @param testEventPatternRequest
     * @return A Java Future containing the result of the TestEventPattern operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidEventPatternException The event pattern is not valid.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.TestEventPattern
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/TestEventPattern" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TestEventPatternResponse> testEventPattern(TestEventPatternRequest testEventPatternRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests whether the specified event pattern matches the provided event.
     * </p>
     * <p>
     * Most services in Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs). However,
     * EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN characters when
     * creating event patterns so that they match the ARN syntax in the event you want to match.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestEventPatternRequest.Builder} avoiding the need
     * to create one manually via {@link TestEventPatternRequest#builder()}
     * </p>
     *
     * @param testEventPatternRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.TestEventPatternRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TestEventPattern operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidEventPatternException The event pattern is not valid.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.TestEventPattern
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/TestEventPattern" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TestEventPatternResponse> testEventPattern(
            Consumer<TestEventPatternRequest.Builder> testEventPatternRequest) {
        return testEventPattern(TestEventPatternRequest.builder().applyMutation(testEventPatternRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified EventBridge resource. In Amazon EventBridge (CloudWatch Events),
     * rules and event buses can be tagged.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ManagedRuleException This rule was created by an Amazon Web Services service on behalf of your
     *         account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or
     *         <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the
     *         rule or remove targets from the rule. You cannot modify these managed rules by using
     *         <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>,
     *         <code>TagResource</code>, or <code>UntagResource</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified EventBridge resource. In Amazon EventBridge (CloudWatch Events),
     * rules and event buses can be tagged.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ManagedRuleException This rule was created by an Amazon Web Services service on behalf of your
     *         account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or
     *         <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the
     *         rule or remove targets from the rule. You cannot modify these managed rules by using
     *         <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>,
     *         <code>TagResource</code>, or <code>UntagResource</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an API destination.
     * </p>
     *
     * @param updateApiDestinationRequest
     * @return A Java Future containing the result of the UpdateApiDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.UpdateApiDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UpdateApiDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApiDestinationResponse> updateApiDestination(
            UpdateApiDestinationRequest updateApiDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an API destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApiDestinationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateApiDestinationRequest#builder()}
     * </p>
     *
     * @param updateApiDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.UpdateApiDestinationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateApiDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.UpdateApiDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UpdateApiDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApiDestinationResponse> updateApiDestination(
            Consumer<UpdateApiDestinationRequest.Builder> updateApiDestinationRequest) {
        return updateApiDestination(UpdateApiDestinationRequest.builder().applyMutation(updateApiDestinationRequest).build());
    }

    /**
     * <p>
     * Updates the specified archive.
     * </p>
     *
     * @param updateArchiveRequest
     * @return A Java Future containing the result of the UpdateArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>InvalidEventPatternException The event pattern is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.UpdateArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UpdateArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateArchiveResponse> updateArchive(UpdateArchiveRequest updateArchiveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified archive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateArchiveRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateArchiveRequest#builder()}
     * </p>
     *
     * @param updateArchiveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.UpdateArchiveRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>InvalidEventPatternException The event pattern is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.UpdateArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UpdateArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateArchiveResponse> updateArchive(Consumer<UpdateArchiveRequest.Builder> updateArchiveRequest) {
        return updateArchive(UpdateArchiveRequest.builder().applyMutation(updateArchiveRequest).build());
    }

    /**
     * <p>
     * Updates settings for a connection.
     * </p>
     *
     * @param updateConnectionRequest
     * @return A Java Future containing the result of the UpdateConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.UpdateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UpdateConnection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateConnectionResponse> updateConnection(UpdateConnectionRequest updateConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates settings for a connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateConnectionRequest#builder()}
     * </p>
     *
     * @param updateConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.UpdateConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>LimitExceededException The request failed because it attempted to create resource beyond the allowed
     *         service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.UpdateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UpdateConnection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateConnectionResponse> updateConnection(
            Consumer<UpdateConnectionRequest.Builder> updateConnectionRequest) {
        return updateConnection(UpdateConnectionRequest.builder().applyMutation(updateConnectionRequest).build());
    }

    /**
     * <p>
     * Update an existing endpoint. For more information about global endpoints, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html">Making applications
     * Regional-fault tolerant with global endpoints and event replication</a> in the <i> <i>Amazon EventBridge User
     * Guide</i> </i>.
     * </p>
     *
     * @param updateEndpointRequest
     * @return A Java Future containing the result of the UpdateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.UpdateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UpdateEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateEndpointResponse> updateEndpoint(UpdateEndpointRequest updateEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an existing endpoint. For more information about global endpoints, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html">Making applications
     * Regional-fault tolerant with global endpoints and event replication</a> in the <i> <i>Amazon EventBridge User
     * Guide</i> </i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateEndpointRequest#builder()}
     * </p>
     *
     * @param updateEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.UpdateEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.UpdateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UpdateEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateEndpointResponse> updateEndpoint(Consumer<UpdateEndpointRequest.Builder> updateEndpointRequest) {
        return updateEndpoint(UpdateEndpointRequest.builder().applyMutation(updateEndpointRequest).build());
    }

    /**
     * <p>
     * Updates the specified event bus.
     * </p>
     *
     * @param updateEventBusRequest
     * @return A Java Future containing the result of the UpdateEventBus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.UpdateEventBus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UpdateEventBus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateEventBusResponse> updateEventBus(UpdateEventBusRequest updateEventBusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified event bus.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventBusRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateEventBusRequest#builder()}
     * </p>
     *
     * @param updateEventBusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eventbridge.model.UpdateEventBusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEventBus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An entity that you specified does not exist.</li>
     *         <li>InternalException This exception occurs due to unexpected causes.</li>
     *         <li>ConcurrentModificationException There is concurrent modification on a rule, target, archive, or
     *         replay.</li>
     *         <li>OperationDisabledException The operation you are attempting is not available in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EventBridgeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EventBridgeAsyncClient.UpdateEventBus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UpdateEventBus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateEventBusResponse> updateEventBus(Consumer<UpdateEventBusRequest.Builder> updateEventBusRequest) {
        return updateEventBus(UpdateEventBusRequest.builder().applyMutation(updateEventBusRequest).build());
    }

    @Override
    default EventBridgeServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link EventBridgeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static EventBridgeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link EventBridgeAsyncClient}.
     */
    static EventBridgeAsyncClientBuilder builder() {
        return new DefaultEventBridgeAsyncClientBuilder();
    }
}
