/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.auth.scheme.internal;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.eventbridge.auth.scheme.EventBridgeAuthSchemeParams;
import software.amazon.awssdk.services.eventbridge.endpoints.EventBridgeEndpointProvider;
import software.amazon.awssdk.utils.Validate;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public final class DefaultEventBridgeAuthSchemeParams implements EventBridgeAuthSchemeParams, EventBridgeEndpointResolverAware {
    private final String operation;

    private final Region region;

    private final String endpointId;

    private final EventBridgeEndpointProvider endpointProvider;

    private DefaultEventBridgeAuthSchemeParams(Builder builder) {
        this.operation = Validate.paramNotNull(builder.operation, "operation");
        this.region = builder.region;
        this.endpointId = builder.endpointId;
        this.endpointProvider = builder.endpointProvider;
    }

    public static EventBridgeAuthSchemeParams.Builder builder() {
        return new Builder();
    }

    @Override
    public String operation() {
        return operation;
    }

    @Override
    public Region region() {
        return region;
    }

    @Override
    public String endpointId() {
        return endpointId;
    }

    @Override
    public EventBridgeEndpointProvider endpointProvider() {
        return endpointProvider;
    }

    @Override
    public EventBridgeAuthSchemeParams.Builder toBuilder() {
        return new Builder(this);
    }

    private static final class Builder implements EventBridgeAuthSchemeParams.Builder, EventBridgeEndpointResolverAware.Builder {
        private String operation;

        private Region region;

        private String endpointId;

        private EventBridgeEndpointProvider endpointProvider;

        Builder() {
        }

        Builder(DefaultEventBridgeAuthSchemeParams params) {
            this.operation = params.operation;
            this.region = params.region;
            this.endpointId = params.endpointId;
            this.endpointProvider = params.endpointProvider;
        }

        @Override
        public Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        @Override
        public Builder endpointProvider(EventBridgeEndpointProvider endpointProvider) {
            this.endpointProvider = endpointProvider;
            return this;
        }

        @Override
        public EventBridgeAuthSchemeParams build() {
            return new DefaultEventBridgeAuthSchemeParams(this);
        }
    }
}
