/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEndpointResponse extends EventBridgeResponse implements
        ToCopyableBuilder<CreateEndpointResponse.Builder, CreateEndpointResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateEndpointResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateEndpointResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<RoutingConfig> ROUTING_CONFIG_FIELD = SdkField
            .<RoutingConfig> builder(MarshallingType.SDK_POJO).memberName("RoutingConfig")
            .getter(getter(CreateEndpointResponse::routingConfig)).setter(setter(Builder::routingConfig))
            .constructor(RoutingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingConfig").build()).build();

    private static final SdkField<ReplicationConfig> REPLICATION_CONFIG_FIELD = SdkField
            .<ReplicationConfig> builder(MarshallingType.SDK_POJO).memberName("ReplicationConfig")
            .getter(getter(CreateEndpointResponse::replicationConfig)).setter(setter(Builder::replicationConfig))
            .constructor(ReplicationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfig").build()).build();

    private static final SdkField<List<EndpointEventBus>> EVENT_BUSES_FIELD = SdkField
            .<List<EndpointEventBus>> builder(MarshallingType.LIST)
            .memberName("EventBuses")
            .getter(getter(CreateEndpointResponse::eventBuses))
            .setter(setter(Builder::eventBuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EndpointEventBus> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndpointEventBus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateEndpointResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(CreateEndpointResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            ROUTING_CONFIG_FIELD, REPLICATION_CONFIG_FIELD, EVENT_BUSES_FIELD, ROLE_ARN_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Name", NAME_FIELD);
                    put("Arn", ARN_FIELD);
                    put("RoutingConfig", ROUTING_CONFIG_FIELD);
                    put("ReplicationConfig", REPLICATION_CONFIG_FIELD);
                    put("EventBuses", EVENT_BUSES_FIELD);
                    put("RoleArn", ROLE_ARN_FIELD);
                    put("State", STATE_FIELD);
                }
            });

    private final String name;

    private final String arn;

    private final RoutingConfig routingConfig;

    private final ReplicationConfig replicationConfig;

    private final List<EndpointEventBus> eventBuses;

    private final String roleArn;

    private final String state;

    private CreateEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.arn = builder.arn;
        this.routingConfig = builder.routingConfig;
        this.replicationConfig = builder.replicationConfig;
        this.eventBuses = builder.eventBuses;
        this.roleArn = builder.roleArn;
        this.state = builder.state;
    }

    /**
     * <p>
     * The name of the endpoint that was created by this request.
     * </p>
     * 
     * @return The name of the endpoint that was created by this request.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the endpoint that was created by this request.
     * </p>
     * 
     * @return The ARN of the endpoint that was created by this request.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The routing configuration defined by this request.
     * </p>
     * 
     * @return The routing configuration defined by this request.
     */
    public final RoutingConfig routingConfig() {
        return routingConfig;
    }

    /**
     * <p>
     * Whether event replication was enabled or disabled by this request.
     * </p>
     * 
     * @return Whether event replication was enabled or disabled by this request.
     */
    public final ReplicationConfig replicationConfig() {
        return replicationConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventBuses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEventBuses() {
        return eventBuses != null && !(eventBuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The event buses used by this request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventBuses} method.
     * </p>
     * 
     * @return The event buses used by this request.
     */
    public final List<EndpointEventBus> eventBuses() {
        return eventBuses;
    }

    /**
     * <p>
     * The ARN of the role used by event replication for this request.
     * </p>
     * 
     * @return The ARN of the role used by event replication for this request.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The state of the endpoint that was created by this request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EndpointState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the endpoint that was created by this request.
     * @see EndpointState
     */
    public final EndpointState state() {
        return EndpointState.fromValue(state);
    }

    /**
     * <p>
     * The state of the endpoint that was created by this request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EndpointState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the endpoint that was created by this request.
     * @see EndpointState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(routingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventBuses() ? eventBuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEndpointResponse)) {
            return false;
        }
        CreateEndpointResponse other = (CreateEndpointResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(routingConfig(), other.routingConfig())
                && Objects.equals(replicationConfig(), other.replicationConfig()) && hasEventBuses() == other.hasEventBuses()
                && Objects.equals(eventBuses(), other.eventBuses()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEndpointResponse").add("Name", name()).add("Arn", arn())
                .add("RoutingConfig", routingConfig()).add("ReplicationConfig", replicationConfig())
                .add("EventBuses", hasEventBuses() ? eventBuses() : null).add("RoleArn", roleArn()).add("State", stateAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "RoutingConfig":
            return Optional.ofNullable(clazz.cast(routingConfig()));
        case "ReplicationConfig":
            return Optional.ofNullable(clazz.cast(replicationConfig()));
        case "EventBuses":
            return Optional.ofNullable(clazz.cast(eventBuses()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateEndpointResponse, T> g) {
        return obj -> g.apply((CreateEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateEndpointResponse> {
        /**
         * <p>
         * The name of the endpoint that was created by this request.
         * </p>
         * 
         * @param name
         *        The name of the endpoint that was created by this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the endpoint that was created by this request.
         * </p>
         * 
         * @param arn
         *        The ARN of the endpoint that was created by this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The routing configuration defined by this request.
         * </p>
         * 
         * @param routingConfig
         *        The routing configuration defined by this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingConfig(RoutingConfig routingConfig);

        /**
         * <p>
         * The routing configuration defined by this request.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutingConfig.Builder} avoiding the need
         * to create one manually via {@link RoutingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #routingConfig(RoutingConfig)}.
         * 
         * @param routingConfig
         *        a consumer that will call methods on {@link RoutingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingConfig(RoutingConfig)
         */
        default Builder routingConfig(Consumer<RoutingConfig.Builder> routingConfig) {
            return routingConfig(RoutingConfig.builder().applyMutation(routingConfig).build());
        }

        /**
         * <p>
         * Whether event replication was enabled or disabled by this request.
         * </p>
         * 
         * @param replicationConfig
         *        Whether event replication was enabled or disabled by this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfig(ReplicationConfig replicationConfig);

        /**
         * <p>
         * Whether event replication was enabled or disabled by this request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReplicationConfig.Builder} avoiding the
         * need to create one manually via {@link ReplicationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplicationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #replicationConfig(ReplicationConfig)}.
         * 
         * @param replicationConfig
         *        a consumer that will call methods on {@link ReplicationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationConfig(ReplicationConfig)
         */
        default Builder replicationConfig(Consumer<ReplicationConfig.Builder> replicationConfig) {
            return replicationConfig(ReplicationConfig.builder().applyMutation(replicationConfig).build());
        }

        /**
         * <p>
         * The event buses used by this request.
         * </p>
         * 
         * @param eventBuses
         *        The event buses used by this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBuses(Collection<EndpointEventBus> eventBuses);

        /**
         * <p>
         * The event buses used by this request.
         * </p>
         * 
         * @param eventBuses
         *        The event buses used by this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBuses(EndpointEventBus... eventBuses);

        /**
         * <p>
         * The event buses used by this request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eventbridge.model.EndpointEventBus.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.eventbridge.model.EndpointEventBus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eventbridge.model.EndpointEventBus.Builder#build()} is called
         * immediately and its result is passed to {@link #eventBuses(List<EndpointEventBus>)}.
         * 
         * @param eventBuses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eventbridge.model.EndpointEventBus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventBuses(java.util.Collection<EndpointEventBus>)
         */
        Builder eventBuses(Consumer<EndpointEventBus.Builder>... eventBuses);

        /**
         * <p>
         * The ARN of the role used by event replication for this request.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role used by event replication for this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The state of the endpoint that was created by this request.
         * </p>
         * 
         * @param state
         *        The state of the endpoint that was created by this request.
         * @see EndpointState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the endpoint that was created by this request.
         * </p>
         * 
         * @param state
         *        The state of the endpoint that was created by this request.
         * @see EndpointState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointState
         */
        Builder state(EndpointState state);
    }

    static final class BuilderImpl extends EventBridgeResponse.BuilderImpl implements Builder {
        private String name;

        private String arn;

        private RoutingConfig routingConfig;

        private ReplicationConfig replicationConfig;

        private List<EndpointEventBus> eventBuses = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEndpointResponse model) {
            super(model);
            name(model.name);
            arn(model.arn);
            routingConfig(model.routingConfig);
            replicationConfig(model.replicationConfig);
            eventBuses(model.eventBuses);
            roleArn(model.roleArn);
            state(model.state);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final RoutingConfig.Builder getRoutingConfig() {
            return routingConfig != null ? routingConfig.toBuilder() : null;
        }

        public final void setRoutingConfig(RoutingConfig.BuilderImpl routingConfig) {
            this.routingConfig = routingConfig != null ? routingConfig.build() : null;
        }

        @Override
        public final Builder routingConfig(RoutingConfig routingConfig) {
            this.routingConfig = routingConfig;
            return this;
        }

        public final ReplicationConfig.Builder getReplicationConfig() {
            return replicationConfig != null ? replicationConfig.toBuilder() : null;
        }

        public final void setReplicationConfig(ReplicationConfig.BuilderImpl replicationConfig) {
            this.replicationConfig = replicationConfig != null ? replicationConfig.build() : null;
        }

        @Override
        public final Builder replicationConfig(ReplicationConfig replicationConfig) {
            this.replicationConfig = replicationConfig;
            return this;
        }

        public final List<EndpointEventBus.Builder> getEventBuses() {
            List<EndpointEventBus.Builder> result = EndpointEventBusListCopier.copyToBuilder(this.eventBuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventBuses(Collection<EndpointEventBus.BuilderImpl> eventBuses) {
            this.eventBuses = EndpointEventBusListCopier.copyFromBuilder(eventBuses);
        }

        @Override
        public final Builder eventBuses(Collection<EndpointEventBus> eventBuses) {
            this.eventBuses = EndpointEventBusListCopier.copy(eventBuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBuses(EndpointEventBus... eventBuses) {
            eventBuses(Arrays.asList(eventBuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBuses(Consumer<EndpointEventBus.Builder>... eventBuses) {
            eventBuses(Stream.of(eventBuses).map(c -> EndpointEventBus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EndpointState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public CreateEndpointResponse build() {
            return new CreateEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
