/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEventBusResponse extends EventBridgeResponse implements
        ToCopyableBuilder<CreateEventBusResponse.Builder, CreateEventBusResponse> {
    private static final SdkField<String> EVENT_BUS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventBusArn").getter(getter(CreateEventBusResponse::eventBusArn)).setter(setter(Builder::eventBusArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBusArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateEventBusResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyIdentifier").getter(getter(CreateEventBusResponse::kmsKeyIdentifier))
            .setter(setter(Builder::kmsKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyIdentifier").build()).build();

    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField
            .<DeadLetterConfig> builder(MarshallingType.SDK_POJO).memberName("DeadLetterConfig")
            .getter(getter(CreateEventBusResponse::deadLetterConfig)).setter(setter(Builder::deadLetterConfig))
            .constructor(DeadLetterConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_BUS_ARN_FIELD,
            DESCRIPTION_FIELD, KMS_KEY_IDENTIFIER_FIELD, DEAD_LETTER_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("EventBusArn", EVENT_BUS_ARN_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("KmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
                    put("DeadLetterConfig", DEAD_LETTER_CONFIG_FIELD);
                }
            });

    private final String eventBusArn;

    private final String description;

    private final String kmsKeyIdentifier;

    private final DeadLetterConfig deadLetterConfig;

    private CreateEventBusResponse(BuilderImpl builder) {
        super(builder);
        this.eventBusArn = builder.eventBusArn;
        this.description = builder.description;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.deadLetterConfig = builder.deadLetterConfig;
    }

    /**
     * <p>
     * The ARN of the new event bus.
     * </p>
     * 
     * @return The ARN of the new event bus.
     */
    public final String eventBusArn() {
        return eventBusArn;
    }

    /**
     * <p>
     * The event bus description.
     * </p>
     * 
     * @return The event bus description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the KMS customer managed key for EventBridge to use to encrypt events on this event bus, if one
     * has been specified.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption.html">Data encryption in
     * EventBridge</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * 
     * @return The identifier of the KMS customer managed key for EventBridge to use to encrypt events on this event
     *         bus, if one has been specified.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption.html">Data encryption in
     *         EventBridge</a> in the <i>Amazon EventBridge User Guide</i>.
     */
    public final String kmsKeyIdentifier() {
        return kmsKeyIdentifier;
    }

    /**
     * Returns the value of the DeadLetterConfig property for this object.
     * 
     * @return The value of the DeadLetterConfig property for this object.
     */
    public final DeadLetterConfig deadLetterConfig() {
        return deadLetterConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventBusArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(deadLetterConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventBusResponse)) {
            return false;
        }
        CreateEventBusResponse other = (CreateEventBusResponse) obj;
        return Objects.equals(eventBusArn(), other.eventBusArn()) && Objects.equals(description(), other.description())
                && Objects.equals(kmsKeyIdentifier(), other.kmsKeyIdentifier())
                && Objects.equals(deadLetterConfig(), other.deadLetterConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEventBusResponse").add("EventBusArn", eventBusArn()).add("Description", description())
                .add("KmsKeyIdentifier", kmsKeyIdentifier()).add("DeadLetterConfig", deadLetterConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventBusArn":
            return Optional.ofNullable(clazz.cast(eventBusArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "KmsKeyIdentifier":
            return Optional.ofNullable(clazz.cast(kmsKeyIdentifier()));
        case "DeadLetterConfig":
            return Optional.ofNullable(clazz.cast(deadLetterConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateEventBusResponse, T> g) {
        return obj -> g.apply((CreateEventBusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateEventBusResponse> {
        /**
         * <p>
         * The ARN of the new event bus.
         * </p>
         * 
         * @param eventBusArn
         *        The ARN of the new event bus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBusArn(String eventBusArn);

        /**
         * <p>
         * The event bus description.
         * </p>
         * 
         * @param description
         *        The event bus description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the KMS customer managed key for EventBridge to use to encrypt events on this event bus, if
         * one has been specified.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption.html">Data encryption in
         * EventBridge</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * 
         * @param kmsKeyIdentifier
         *        The identifier of the KMS customer managed key for EventBridge to use to encrypt events on this event
         *        bus, if one has been specified.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption.html">Data encryption in
         *        EventBridge</a> in the <i>Amazon EventBridge User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyIdentifier(String kmsKeyIdentifier);

        /**
         * Sets the value of the DeadLetterConfig property for this object.
         *
         * @param deadLetterConfig
         *        The new value for the DeadLetterConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deadLetterConfig(DeadLetterConfig deadLetterConfig);

        /**
         * Sets the value of the DeadLetterConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DeadLetterConfig.Builder} avoiding the
         * need to create one manually via {@link DeadLetterConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeadLetterConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deadLetterConfig(DeadLetterConfig)}.
         * 
         * @param deadLetterConfig
         *        a consumer that will call methods on {@link DeadLetterConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deadLetterConfig(DeadLetterConfig)
         */
        default Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return deadLetterConfig(DeadLetterConfig.builder().applyMutation(deadLetterConfig).build());
        }
    }

    static final class BuilderImpl extends EventBridgeResponse.BuilderImpl implements Builder {
        private String eventBusArn;

        private String description;

        private String kmsKeyIdentifier;

        private DeadLetterConfig deadLetterConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventBusResponse model) {
            super(model);
            eventBusArn(model.eventBusArn);
            description(model.description);
            kmsKeyIdentifier(model.kmsKeyIdentifier);
            deadLetterConfig(model.deadLetterConfig);
        }

        public final String getEventBusArn() {
            return eventBusArn;
        }

        public final void setEventBusArn(String eventBusArn) {
            this.eventBusArn = eventBusArn;
        }

        @Override
        public final Builder eventBusArn(String eventBusArn) {
            this.eventBusArn = eventBusArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return deadLetterConfig != null ? deadLetterConfig.toBuilder() : null;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        @Override
        public CreateEventBusResponse build() {
            return new CreateEventBusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
