/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If the connection uses a private OAuth endpoint, the parameters for EventBridge to use when authenticating against
 * the endpoint.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-target-connection-auth.html">Authorization methods
 * for connections</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConnectionConnectivityParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribeConnectionConnectivityParameters.Builder, DescribeConnectionConnectivityParameters> {
    private static final SdkField<DescribeConnectionResourceParameters> RESOURCE_PARAMETERS_FIELD = SdkField
            .<DescribeConnectionResourceParameters> builder(MarshallingType.SDK_POJO).memberName("ResourceParameters")
            .getter(getter(DescribeConnectionConnectivityParameters::resourceParameters))
            .setter(setter(Builder::resourceParameters)).constructor(DescribeConnectionResourceParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ResourceParameters", RESOURCE_PARAMETERS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final DescribeConnectionResourceParameters resourceParameters;

    private DescribeConnectionConnectivityParameters(BuilderImpl builder) {
        this.resourceParameters = builder.resourceParameters;
    }

    /**
     * <p>
     * The parameters for EventBridge to use when invoking the resource endpoint.
     * </p>
     * 
     * @return The parameters for EventBridge to use when invoking the resource endpoint.
     */
    public final DescribeConnectionResourceParameters resourceParameters() {
        return resourceParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectionConnectivityParameters)) {
            return false;
        }
        DescribeConnectionConnectivityParameters other = (DescribeConnectionConnectivityParameters) obj;
        return Objects.equals(resourceParameters(), other.resourceParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConnectionConnectivityParameters").add("ResourceParameters", resourceParameters())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceParameters":
            return Optional.ofNullable(clazz.cast(resourceParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectionConnectivityParameters, T> g) {
        return obj -> g.apply((DescribeConnectionConnectivityParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribeConnectionConnectivityParameters> {
        /**
         * <p>
         * The parameters for EventBridge to use when invoking the resource endpoint.
         * </p>
         * 
         * @param resourceParameters
         *        The parameters for EventBridge to use when invoking the resource endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceParameters(DescribeConnectionResourceParameters resourceParameters);

        /**
         * <p>
         * The parameters for EventBridge to use when invoking the resource endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DescribeConnectionResourceParameters.Builder} avoiding the need to create one manually via
         * {@link DescribeConnectionResourceParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DescribeConnectionResourceParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceParameters(DescribeConnectionResourceParameters)}.
         * 
         * @param resourceParameters
         *        a consumer that will call methods on {@link DescribeConnectionResourceParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceParameters(DescribeConnectionResourceParameters)
         */
        default Builder resourceParameters(Consumer<DescribeConnectionResourceParameters.Builder> resourceParameters) {
            return resourceParameters(DescribeConnectionResourceParameters.builder().applyMutation(resourceParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DescribeConnectionResourceParameters resourceParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectionConnectivityParameters model) {
            resourceParameters(model.resourceParameters);
        }

        public final DescribeConnectionResourceParameters.Builder getResourceParameters() {
            return resourceParameters != null ? resourceParameters.toBuilder() : null;
        }

        public final void setResourceParameters(DescribeConnectionResourceParameters.BuilderImpl resourceParameters) {
            this.resourceParameters = resourceParameters != null ? resourceParameters.build() : null;
        }

        @Override
        public final Builder resourceParameters(DescribeConnectionResourceParameters resourceParameters) {
            this.resourceParameters = resourceParameters;
            return this;
        }

        @Override
        public DescribeConnectionConnectivityParameters build() {
            return new DescribeConnectionConnectivityParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
