/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReplayResponse extends EventBridgeResponse implements
        ToCopyableBuilder<DescribeReplayResponse.Builder, DescribeReplayResponse> {
    private static final SdkField<String> REPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplayName").getter(getter(DescribeReplayResponse::replayName)).setter(setter(Builder::replayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayName").build()).build();

    private static final SdkField<String> REPLAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplayArn").getter(getter(DescribeReplayResponse::replayArn)).setter(setter(Builder::replayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeReplayResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DescribeReplayResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReason").getter(getter(DescribeReplayResponse::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final SdkField<String> EVENT_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSourceArn").getter(getter(DescribeReplayResponse::eventSourceArn))
            .setter(setter(Builder::eventSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceArn").build()).build();

    private static final SdkField<ReplayDestination> DESTINATION_FIELD = SdkField
            .<ReplayDestination> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(DescribeReplayResponse::destination)).setter(setter(Builder::destination))
            .constructor(ReplayDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<Instant> EVENT_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EventStartTime").getter(getter(DescribeReplayResponse::eventStartTime))
            .setter(setter(Builder::eventStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventStartTime").build()).build();

    private static final SdkField<Instant> EVENT_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EventEndTime").getter(getter(DescribeReplayResponse::eventEndTime))
            .setter(setter(Builder::eventEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventEndTime").build()).build();

    private static final SdkField<Instant> EVENT_LAST_REPLAYED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EventLastReplayedTime").getter(getter(DescribeReplayResponse::eventLastReplayedTime))
            .setter(setter(Builder::eventLastReplayedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventLastReplayedTime").build())
            .build();

    private static final SdkField<Instant> REPLAY_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReplayStartTime").getter(getter(DescribeReplayResponse::replayStartTime))
            .setter(setter(Builder::replayStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayStartTime").build()).build();

    private static final SdkField<Instant> REPLAY_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReplayEndTime").getter(getter(DescribeReplayResponse::replayEndTime))
            .setter(setter(Builder::replayEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayEndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLAY_NAME_FIELD,
            REPLAY_ARN_FIELD, DESCRIPTION_FIELD, STATE_FIELD, STATE_REASON_FIELD, EVENT_SOURCE_ARN_FIELD, DESTINATION_FIELD,
            EVENT_START_TIME_FIELD, EVENT_END_TIME_FIELD, EVENT_LAST_REPLAYED_TIME_FIELD, REPLAY_START_TIME_FIELD,
            REPLAY_END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ReplayName", REPLAY_NAME_FIELD);
                    put("ReplayArn", REPLAY_ARN_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("State", STATE_FIELD);
                    put("StateReason", STATE_REASON_FIELD);
                    put("EventSourceArn", EVENT_SOURCE_ARN_FIELD);
                    put("Destination", DESTINATION_FIELD);
                    put("EventStartTime", EVENT_START_TIME_FIELD);
                    put("EventEndTime", EVENT_END_TIME_FIELD);
                    put("EventLastReplayedTime", EVENT_LAST_REPLAYED_TIME_FIELD);
                    put("ReplayStartTime", REPLAY_START_TIME_FIELD);
                    put("ReplayEndTime", REPLAY_END_TIME_FIELD);
                }
            });

    private final String replayName;

    private final String replayArn;

    private final String description;

    private final String state;

    private final String stateReason;

    private final String eventSourceArn;

    private final ReplayDestination destination;

    private final Instant eventStartTime;

    private final Instant eventEndTime;

    private final Instant eventLastReplayedTime;

    private final Instant replayStartTime;

    private final Instant replayEndTime;

    private DescribeReplayResponse(BuilderImpl builder) {
        super(builder);
        this.replayName = builder.replayName;
        this.replayArn = builder.replayArn;
        this.description = builder.description;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.eventSourceArn = builder.eventSourceArn;
        this.destination = builder.destination;
        this.eventStartTime = builder.eventStartTime;
        this.eventEndTime = builder.eventEndTime;
        this.eventLastReplayedTime = builder.eventLastReplayedTime;
        this.replayStartTime = builder.replayStartTime;
        this.replayEndTime = builder.replayEndTime;
    }

    /**
     * <p>
     * The name of the replay.
     * </p>
     * 
     * @return The name of the replay.
     */
    public final String replayName() {
        return replayName;
    }

    /**
     * <p>
     * The ARN of the replay.
     * </p>
     * 
     * @return The ARN of the replay.
     */
    public final String replayArn() {
        return replayArn;
    }

    /**
     * <p>
     * The description of the replay.
     * </p>
     * 
     * @return The description of the replay.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The current state of the replay.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReplayState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the replay.
     * @see ReplayState
     */
    public final ReplayState state() {
        return ReplayState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the replay.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReplayState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the replay.
     * @see ReplayState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The reason that the replay is in the current state.
     * </p>
     * 
     * @return The reason that the replay is in the current state.
     */
    public final String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * The ARN of the archive events were replayed from.
     * </p>
     * 
     * @return The ARN of the archive events were replayed from.
     */
    public final String eventSourceArn() {
        return eventSourceArn;
    }

    /**
     * <p>
     * A <code>ReplayDestination</code> object that contains details about the replay.
     * </p>
     * 
     * @return A <code>ReplayDestination</code> object that contains details about the replay.
     */
    public final ReplayDestination destination() {
        return destination;
    }

    /**
     * <p>
     * The time stamp of the first event that was last replayed from the archive.
     * </p>
     * 
     * @return The time stamp of the first event that was last replayed from the archive.
     */
    public final Instant eventStartTime() {
        return eventStartTime;
    }

    /**
     * <p>
     * The time stamp for the last event that was replayed from the archive.
     * </p>
     * 
     * @return The time stamp for the last event that was replayed from the archive.
     */
    public final Instant eventEndTime() {
        return eventEndTime;
    }

    /**
     * <p>
     * The time that the event was last replayed.
     * </p>
     * 
     * @return The time that the event was last replayed.
     */
    public final Instant eventLastReplayedTime() {
        return eventLastReplayedTime;
    }

    /**
     * <p>
     * A time stamp for the time that the replay started.
     * </p>
     * 
     * @return A time stamp for the time that the replay started.
     */
    public final Instant replayStartTime() {
        return replayStartTime;
    }

    /**
     * <p>
     * A time stamp for the time that the replay stopped.
     * </p>
     * 
     * @return A time stamp for the time that the replay stopped.
     */
    public final Instant replayEndTime() {
        return replayEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replayName());
        hashCode = 31 * hashCode + Objects.hashCode(replayArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(eventSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(eventStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(eventEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(eventLastReplayedTime());
        hashCode = 31 * hashCode + Objects.hashCode(replayStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(replayEndTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplayResponse)) {
            return false;
        }
        DescribeReplayResponse other = (DescribeReplayResponse) obj;
        return Objects.equals(replayName(), other.replayName()) && Objects.equals(replayArn(), other.replayArn())
                && Objects.equals(description(), other.description()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateReason(), other.stateReason()) && Objects.equals(eventSourceArn(), other.eventSourceArn())
                && Objects.equals(destination(), other.destination()) && Objects.equals(eventStartTime(), other.eventStartTime())
                && Objects.equals(eventEndTime(), other.eventEndTime())
                && Objects.equals(eventLastReplayedTime(), other.eventLastReplayedTime())
                && Objects.equals(replayStartTime(), other.replayStartTime())
                && Objects.equals(replayEndTime(), other.replayEndTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReplayResponse").add("ReplayName", replayName()).add("ReplayArn", replayArn())
                .add("Description", description()).add("State", stateAsString()).add("StateReason", stateReason())
                .add("EventSourceArn", eventSourceArn()).add("Destination", destination())
                .add("EventStartTime", eventStartTime()).add("EventEndTime", eventEndTime())
                .add("EventLastReplayedTime", eventLastReplayedTime()).add("ReplayStartTime", replayStartTime())
                .add("ReplayEndTime", replayEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplayName":
            return Optional.ofNullable(clazz.cast(replayName()));
        case "ReplayArn":
            return Optional.ofNullable(clazz.cast(replayArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "EventSourceArn":
            return Optional.ofNullable(clazz.cast(eventSourceArn()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "EventStartTime":
            return Optional.ofNullable(clazz.cast(eventStartTime()));
        case "EventEndTime":
            return Optional.ofNullable(clazz.cast(eventEndTime()));
        case "EventLastReplayedTime":
            return Optional.ofNullable(clazz.cast(eventLastReplayedTime()));
        case "ReplayStartTime":
            return Optional.ofNullable(clazz.cast(replayStartTime()));
        case "ReplayEndTime":
            return Optional.ofNullable(clazz.cast(replayEndTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplayResponse, T> g) {
        return obj -> g.apply((DescribeReplayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeReplayResponse> {
        /**
         * <p>
         * The name of the replay.
         * </p>
         * 
         * @param replayName
         *        The name of the replay.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replayName(String replayName);

        /**
         * <p>
         * The ARN of the replay.
         * </p>
         * 
         * @param replayArn
         *        The ARN of the replay.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replayArn(String replayArn);

        /**
         * <p>
         * The description of the replay.
         * </p>
         * 
         * @param description
         *        The description of the replay.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The current state of the replay.
         * </p>
         * 
         * @param state
         *        The current state of the replay.
         * @see ReplayState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplayState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the replay.
         * </p>
         * 
         * @param state
         *        The current state of the replay.
         * @see ReplayState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplayState
         */
        Builder state(ReplayState state);

        /**
         * <p>
         * The reason that the replay is in the current state.
         * </p>
         * 
         * @param stateReason
         *        The reason that the replay is in the current state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The ARN of the archive events were replayed from.
         * </p>
         * 
         * @param eventSourceArn
         *        The ARN of the archive events were replayed from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSourceArn(String eventSourceArn);

        /**
         * <p>
         * A <code>ReplayDestination</code> object that contains details about the replay.
         * </p>
         * 
         * @param destination
         *        A <code>ReplayDestination</code> object that contains details about the replay.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(ReplayDestination destination);

        /**
         * <p>
         * A <code>ReplayDestination</code> object that contains details about the replay.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReplayDestination.Builder} avoiding the
         * need to create one manually via {@link ReplayDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplayDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(ReplayDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link ReplayDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(ReplayDestination)
         */
        default Builder destination(Consumer<ReplayDestination.Builder> destination) {
            return destination(ReplayDestination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * The time stamp of the first event that was last replayed from the archive.
         * </p>
         * 
         * @param eventStartTime
         *        The time stamp of the first event that was last replayed from the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStartTime(Instant eventStartTime);

        /**
         * <p>
         * The time stamp for the last event that was replayed from the archive.
         * </p>
         * 
         * @param eventEndTime
         *        The time stamp for the last event that was replayed from the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventEndTime(Instant eventEndTime);

        /**
         * <p>
         * The time that the event was last replayed.
         * </p>
         * 
         * @param eventLastReplayedTime
         *        The time that the event was last replayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventLastReplayedTime(Instant eventLastReplayedTime);

        /**
         * <p>
         * A time stamp for the time that the replay started.
         * </p>
         * 
         * @param replayStartTime
         *        A time stamp for the time that the replay started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replayStartTime(Instant replayStartTime);

        /**
         * <p>
         * A time stamp for the time that the replay stopped.
         * </p>
         * 
         * @param replayEndTime
         *        A time stamp for the time that the replay stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replayEndTime(Instant replayEndTime);
    }

    static final class BuilderImpl extends EventBridgeResponse.BuilderImpl implements Builder {
        private String replayName;

        private String replayArn;

        private String description;

        private String state;

        private String stateReason;

        private String eventSourceArn;

        private ReplayDestination destination;

        private Instant eventStartTime;

        private Instant eventEndTime;

        private Instant eventLastReplayedTime;

        private Instant replayStartTime;

        private Instant replayEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplayResponse model) {
            super(model);
            replayName(model.replayName);
            replayArn(model.replayArn);
            description(model.description);
            state(model.state);
            stateReason(model.stateReason);
            eventSourceArn(model.eventSourceArn);
            destination(model.destination);
            eventStartTime(model.eventStartTime);
            eventEndTime(model.eventEndTime);
            eventLastReplayedTime(model.eventLastReplayedTime);
            replayStartTime(model.replayStartTime);
            replayEndTime(model.replayEndTime);
        }

        public final String getReplayName() {
            return replayName;
        }

        public final void setReplayName(String replayName) {
            this.replayName = replayName;
        }

        @Override
        public final Builder replayName(String replayName) {
            this.replayName = replayName;
            return this;
        }

        public final String getReplayArn() {
            return replayArn;
        }

        public final void setReplayArn(String replayArn) {
            this.replayArn = replayArn;
        }

        @Override
        public final Builder replayArn(String replayArn) {
            this.replayArn = replayArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReplayState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final String getEventSourceArn() {
            return eventSourceArn;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final ReplayDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(ReplayDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(ReplayDestination destination) {
            this.destination = destination;
            return this;
        }

        public final Instant getEventStartTime() {
            return eventStartTime;
        }

        public final void setEventStartTime(Instant eventStartTime) {
            this.eventStartTime = eventStartTime;
        }

        @Override
        public final Builder eventStartTime(Instant eventStartTime) {
            this.eventStartTime = eventStartTime;
            return this;
        }

        public final Instant getEventEndTime() {
            return eventEndTime;
        }

        public final void setEventEndTime(Instant eventEndTime) {
            this.eventEndTime = eventEndTime;
        }

        @Override
        public final Builder eventEndTime(Instant eventEndTime) {
            this.eventEndTime = eventEndTime;
            return this;
        }

        public final Instant getEventLastReplayedTime() {
            return eventLastReplayedTime;
        }

        public final void setEventLastReplayedTime(Instant eventLastReplayedTime) {
            this.eventLastReplayedTime = eventLastReplayedTime;
        }

        @Override
        public final Builder eventLastReplayedTime(Instant eventLastReplayedTime) {
            this.eventLastReplayedTime = eventLastReplayedTime;
            return this;
        }

        public final Instant getReplayStartTime() {
            return replayStartTime;
        }

        public final void setReplayStartTime(Instant replayStartTime) {
            this.replayStartTime = replayStartTime;
        }

        @Override
        public final Builder replayStartTime(Instant replayStartTime) {
            this.replayStartTime = replayStartTime;
            return this;
        }

        public final Instant getReplayEndTime() {
            return replayEndTime;
        }

        public final void setReplayEndTime(Instant replayEndTime) {
            this.replayEndTime = replayEndTime;
        }

        @Override
        public final Builder replayEndTime(Instant replayEndTime) {
            this.replayEndTime = replayEndTime;
            return this;
        }

        @Override
        public DescribeReplayResponse build() {
            return new DescribeReplayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
