/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The primary Region of the endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Primary implements SdkPojo, Serializable, ToCopyableBuilder<Primary.Builder, Primary> {
    private static final SdkField<String> HEALTH_CHECK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthCheck").getter(getter(Primary::healthCheck)).setter(setter(Builder::healthCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheck").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_CHECK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("HealthCheck", HEALTH_CHECK_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String healthCheck;

    private Primary(BuilderImpl builder) {
        this.healthCheck = builder.healthCheck;
    }

    /**
     * <p>
     * The ARN of the health check used by the endpoint to determine whether failover is triggered.
     * </p>
     * 
     * @return The ARN of the health check used by the endpoint to determine whether failover is triggered.
     */
    public final String healthCheck() {
        return healthCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(healthCheck());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Primary)) {
            return false;
        }
        Primary other = (Primary) obj;
        return Objects.equals(healthCheck(), other.healthCheck());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Primary").add("HealthCheck", healthCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HealthCheck":
            return Optional.ofNullable(clazz.cast(healthCheck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Primary, T> g) {
        return obj -> g.apply((Primary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Primary> {
        /**
         * <p>
         * The ARN of the health check used by the endpoint to determine whether failover is triggered.
         * </p>
         * 
         * @param healthCheck
         *        The ARN of the health check used by the endpoint to determine whether failover is triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheck(String healthCheck);
    }

    static final class BuilderImpl implements Builder {
        private String healthCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(Primary model) {
            healthCheck(model.healthCheck);
        }

        public final String getHealthCheck() {
            return healthCheck;
        }

        public final void setHealthCheck(String healthCheck) {
            this.healthCheck = healthCheck;
        }

        @Override
        public final Builder healthCheck(String healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        @Override
        public Primary build() {
            return new Primary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
