/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The routing configuration of the endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingConfig implements SdkPojo, Serializable, ToCopyableBuilder<RoutingConfig.Builder, RoutingConfig> {
    private static final SdkField<FailoverConfig> FAILOVER_CONFIG_FIELD = SdkField
            .<FailoverConfig> builder(MarshallingType.SDK_POJO).memberName("FailoverConfig")
            .getter(getter(RoutingConfig::failoverConfig)).setter(setter(Builder::failoverConfig))
            .constructor(FailoverConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailoverConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILOVER_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("FailoverConfig", FAILOVER_CONFIG_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final FailoverConfig failoverConfig;

    private RoutingConfig(BuilderImpl builder) {
        this.failoverConfig = builder.failoverConfig;
    }

    /**
     * <p>
     * The failover configuration for an endpoint. This includes what triggers failover and what happens when it's
     * triggered.
     * </p>
     * 
     * @return The failover configuration for an endpoint. This includes what triggers failover and what happens when
     *         it's triggered.
     */
    public final FailoverConfig failoverConfig() {
        return failoverConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failoverConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingConfig)) {
            return false;
        }
        RoutingConfig other = (RoutingConfig) obj;
        return Objects.equals(failoverConfig(), other.failoverConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutingConfig").add("FailoverConfig", failoverConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailoverConfig":
            return Optional.ofNullable(clazz.cast(failoverConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RoutingConfig, T> g) {
        return obj -> g.apply((RoutingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingConfig> {
        /**
         * <p>
         * The failover configuration for an endpoint. This includes what triggers failover and what happens when it's
         * triggered.
         * </p>
         * 
         * @param failoverConfig
         *        The failover configuration for an endpoint. This includes what triggers failover and what happens when
         *        it's triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failoverConfig(FailoverConfig failoverConfig);

        /**
         * <p>
         * The failover configuration for an endpoint. This includes what triggers failover and what happens when it's
         * triggered.
         * </p>
         * This is a convenience method that creates an instance of the {@link FailoverConfig.Builder} avoiding the need
         * to create one manually via {@link FailoverConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FailoverConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #failoverConfig(FailoverConfig)}.
         * 
         * @param failoverConfig
         *        a consumer that will call methods on {@link FailoverConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failoverConfig(FailoverConfig)
         */
        default Builder failoverConfig(Consumer<FailoverConfig.Builder> failoverConfig) {
            return failoverConfig(FailoverConfig.builder().applyMutation(failoverConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FailoverConfig failoverConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingConfig model) {
            failoverConfig(model.failoverConfig);
        }

        public final FailoverConfig.Builder getFailoverConfig() {
            return failoverConfig != null ? failoverConfig.toBuilder() : null;
        }

        public final void setFailoverConfig(FailoverConfig.BuilderImpl failoverConfig) {
            this.failoverConfig = failoverConfig != null ? failoverConfig.build() : null;
        }

        @Override
        public final Builder failoverConfig(FailoverConfig failoverConfig) {
            this.failoverConfig = failoverConfig;
            return this;
        }

        @Override
        public RoutingConfig build() {
            return new RoutingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
