/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The OAuth authorization parameters to use for the connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectionOAuthClientRequestParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateConnectionOAuthClientRequestParameters.Builder, UpdateConnectionOAuthClientRequestParameters> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientID").getter(getter(UpdateConnectionOAuthClientRequestParameters::clientID))
            .setter(setter(Builder::clientID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientID").build()).build();

    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientSecret").getter(getter(UpdateConnectionOAuthClientRequestParameters::clientSecret))
            .setter(setter(Builder::clientSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSecret").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD,
            CLIENT_SECRET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ClientID", CLIENT_ID_FIELD);
                    put("ClientSecret", CLIENT_SECRET_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String clientID;

    private final String clientSecret;

    private UpdateConnectionOAuthClientRequestParameters(BuilderImpl builder) {
        this.clientID = builder.clientID;
        this.clientSecret = builder.clientSecret;
    }

    /**
     * <p>
     * The client ID to use for OAuth authorization.
     * </p>
     * 
     * @return The client ID to use for OAuth authorization.
     */
    public final String clientID() {
        return clientID;
    }

    /**
     * <p>
     * The client secret assciated with the client ID to use for OAuth authorization.
     * </p>
     * 
     * @return The client secret assciated with the client ID to use for OAuth authorization.
     */
    public final String clientSecret() {
        return clientSecret;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientID());
        hashCode = 31 * hashCode + Objects.hashCode(clientSecret());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionOAuthClientRequestParameters)) {
            return false;
        }
        UpdateConnectionOAuthClientRequestParameters other = (UpdateConnectionOAuthClientRequestParameters) obj;
        return Objects.equals(clientID(), other.clientID()) && Objects.equals(clientSecret(), other.clientSecret());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectionOAuthClientRequestParameters").add("ClientID", clientID())
                .add("ClientSecret", clientSecret() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientID":
            return Optional.ofNullable(clazz.cast(clientID()));
        case "ClientSecret":
            return Optional.ofNullable(clazz.cast(clientSecret()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectionOAuthClientRequestParameters, T> g) {
        return obj -> g.apply((UpdateConnectionOAuthClientRequestParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateConnectionOAuthClientRequestParameters> {
        /**
         * <p>
         * The client ID to use for OAuth authorization.
         * </p>
         * 
         * @param clientID
         *        The client ID to use for OAuth authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientID(String clientID);

        /**
         * <p>
         * The client secret assciated with the client ID to use for OAuth authorization.
         * </p>
         * 
         * @param clientSecret
         *        The client secret assciated with the client ID to use for OAuth authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSecret(String clientSecret);
    }

    static final class BuilderImpl implements Builder {
        private String clientID;

        private String clientSecret;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionOAuthClientRequestParameters model) {
            clientID(model.clientID);
            clientSecret(model.clientSecret);
        }

        public final String getClientID() {
            return clientID;
        }

        public final void setClientID(String clientID) {
            this.clientID = clientID;
        }

        @Override
        public final Builder clientID(String clientID) {
            this.clientID = clientID;
            return this;
        }

        public final String getClientSecret() {
            return clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        @Override
        public UpdateConnectionOAuthClientRequestParameters build() {
            return new UpdateConnectionOAuthClientRequestParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
