/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEventBusesResponse extends EventBridgeResponse implements
        ToCopyableBuilder<ListEventBusesResponse.Builder, ListEventBusesResponse> {
    private static final SdkField<List<EventBus>> EVENT_BUSES_FIELD = SdkField
            .<List<EventBus>> builder(MarshallingType.LIST)
            .memberName("EventBuses")
            .getter(getter(ListEventBusesResponse::eventBuses))
            .setter(setter(Builder::eventBuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventBus> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventBus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEventBusesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_BUSES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<EventBus> eventBuses;

    private final String nextToken;

    private ListEventBusesResponse(BuilderImpl builder) {
        super(builder);
        this.eventBuses = builder.eventBuses;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventBuses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEventBuses() {
        return eventBuses != null && !(eventBuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This list of event buses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventBuses} method.
     * </p>
     * 
     * @return This list of event buses.
     */
    public final List<EventBus> eventBuses() {
        return eventBuses;
    }

    /**
     * <p>
     * A token indicating there are more results available. If there are no more results, no token is included in the
     * response.
     * </p>
     * <p>
     * The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page of
     * results, make the call again using the returned token. Keep all other arguments unchanged.
     * </p>
     * <p>
     * Using an expired pagination token results in an <code>HTTP 400 InvalidToken</code> error.
     * </p>
     * 
     * @return A token indicating there are more results available. If there are no more results, no token is included
     *         in the response.</p>
     *         <p>
     *         The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page
     *         of results, make the call again using the returned token. Keep all other arguments unchanged.
     *         </p>
     *         <p>
     *         Using an expired pagination token results in an <code>HTTP 400 InvalidToken</code> error.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEventBuses() ? eventBuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventBusesResponse)) {
            return false;
        }
        ListEventBusesResponse other = (ListEventBusesResponse) obj;
        return hasEventBuses() == other.hasEventBuses() && Objects.equals(eventBuses(), other.eventBuses())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEventBusesResponse").add("EventBuses", hasEventBuses() ? eventBuses() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventBuses":
            return Optional.ofNullable(clazz.cast(eventBuses()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventBuses", EVENT_BUSES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEventBusesResponse, T> g) {
        return obj -> g.apply((ListEventBusesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEventBusesResponse> {
        /**
         * <p>
         * This list of event buses.
         * </p>
         * 
         * @param eventBuses
         *        This list of event buses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBuses(Collection<EventBus> eventBuses);

        /**
         * <p>
         * This list of event buses.
         * </p>
         * 
         * @param eventBuses
         *        This list of event buses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBuses(EventBus... eventBuses);

        /**
         * <p>
         * This list of event buses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eventbridge.model.EventBus.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.eventbridge.model.EventBus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eventbridge.model.EventBus.Builder#build()} is called immediately and
         * its result is passed to {@link #eventBuses(List<EventBus>)}.
         * 
         * @param eventBuses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eventbridge.model.EventBus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventBuses(java.util.Collection<EventBus>)
         */
        Builder eventBuses(Consumer<EventBus.Builder>... eventBuses);

        /**
         * <p>
         * A token indicating there are more results available. If there are no more results, no token is included in
         * the response.
         * </p>
         * <p>
         * The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page of
         * results, make the call again using the returned token. Keep all other arguments unchanged.
         * </p>
         * <p>
         * Using an expired pagination token results in an <code>HTTP 400 InvalidToken</code> error.
         * </p>
         * 
         * @param nextToken
         *        A token indicating there are more results available. If there are no more results, no token is
         *        included in the response.</p>
         *        <p>
         *        The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next
         *        page of results, make the call again using the returned token. Keep all other arguments unchanged.
         *        </p>
         *        <p>
         *        Using an expired pagination token results in an <code>HTTP 400 InvalidToken</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EventBridgeResponse.BuilderImpl implements Builder {
        private List<EventBus> eventBuses = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventBusesResponse model) {
            super(model);
            eventBuses(model.eventBuses);
            nextToken(model.nextToken);
        }

        public final List<EventBus.Builder> getEventBuses() {
            List<EventBus.Builder> result = EventBusListCopier.copyToBuilder(this.eventBuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventBuses(Collection<EventBus.BuilderImpl> eventBuses) {
            this.eventBuses = EventBusListCopier.copyFromBuilder(eventBuses);
        }

        @Override
        public final Builder eventBuses(Collection<EventBus> eventBuses) {
            this.eventBuses = EventBusListCopier.copy(eventBuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBuses(EventBus... eventBuses) {
            eventBuses(Arrays.asList(eventBuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBuses(Consumer<EventBus.Builder>... eventBuses) {
            eventBuses(Stream.of(eventBuses).map(c -> EventBus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEventBusesResponse build() {
            return new ListEventBusesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
