/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Web Services account that a partner event source has been offered to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PartnerEventSourceAccount implements SdkPojo, Serializable,
        ToCopyableBuilder<PartnerEventSourceAccount.Builder, PartnerEventSourceAccount> {
    private static final SdkField<String> ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Account")
            .getter(getter(PartnerEventSourceAccount::account)).setter(setter(Builder::account))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(PartnerEventSourceAccount::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationTime").getter(getter(PartnerEventSourceAccount::expirationTime))
            .setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(PartnerEventSourceAccount::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_FIELD,
            CREATION_TIME_FIELD, EXPIRATION_TIME_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String account;

    private final Instant creationTime;

    private final Instant expirationTime;

    private final String state;

    private PartnerEventSourceAccount(BuilderImpl builder) {
        this.account = builder.account;
        this.creationTime = builder.creationTime;
        this.expirationTime = builder.expirationTime;
        this.state = builder.state;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that the partner event source was offered to.
     * </p>
     * 
     * @return The Amazon Web Services account ID that the partner event source was offered to.
     */
    public final String account() {
        return account;
    }

    /**
     * <p>
     * The date and time the event source was created.
     * </p>
     * 
     * @return The date and time the event source was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the event source will expire, if the Amazon Web Services account doesn't create a matching
     * event bus for it.
     * </p>
     * 
     * @return The date and time that the event source will expire, if the Amazon Web Services account doesn't create a
     *         matching event bus for it.
     */
    public final Instant expirationTime() {
        return expirationTime;
    }

    /**
     * <p>
     * The state of the event source. If it is ACTIVE, you have already created a matching event bus for this event
     * source, and that event bus is active. If it is PENDING, either you haven't yet created a matching event bus, or
     * that event bus is deactivated. If it is DELETED, you have created a matching event bus, but the event source has
     * since been deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EventSourceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the event source. If it is ACTIVE, you have already created a matching event bus for this
     *         event source, and that event bus is active. If it is PENDING, either you haven't yet created a matching
     *         event bus, or that event bus is deactivated. If it is DELETED, you have created a matching event bus, but
     *         the event source has since been deleted.
     * @see EventSourceState
     */
    public final EventSourceState state() {
        return EventSourceState.fromValue(state);
    }

    /**
     * <p>
     * The state of the event source. If it is ACTIVE, you have already created a matching event bus for this event
     * source, and that event bus is active. If it is PENDING, either you haven't yet created a matching event bus, or
     * that event bus is deactivated. If it is DELETED, you have created a matching event bus, but the event source has
     * since been deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EventSourceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the event source. If it is ACTIVE, you have already created a matching event bus for this
     *         event source, and that event bus is active. If it is PENDING, either you haven't yet created a matching
     *         event bus, or that event bus is deactivated. If it is DELETED, you have created a matching event bus, but
     *         the event source has since been deleted.
     * @see EventSourceState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(account());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartnerEventSourceAccount)) {
            return false;
        }
        PartnerEventSourceAccount other = (PartnerEventSourceAccount) obj;
        return Objects.equals(account(), other.account()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(expirationTime(), other.expirationTime())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PartnerEventSourceAccount").add("Account", account()).add("CreationTime", creationTime())
                .add("ExpirationTime", expirationTime()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Account":
            return Optional.ofNullable(clazz.cast(account()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ExpirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Account", ACCOUNT_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ExpirationTime", EXPIRATION_TIME_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PartnerEventSourceAccount, T> g) {
        return obj -> g.apply((PartnerEventSourceAccount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PartnerEventSourceAccount> {
        /**
         * <p>
         * The Amazon Web Services account ID that the partner event source was offered to.
         * </p>
         * 
         * @param account
         *        The Amazon Web Services account ID that the partner event source was offered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(String account);

        /**
         * <p>
         * The date and time the event source was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time the event source was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time that the event source will expire, if the Amazon Web Services account doesn't create a
         * matching event bus for it.
         * </p>
         * 
         * @param expirationTime
         *        The date and time that the event source will expire, if the Amazon Web Services account doesn't create
         *        a matching event bus for it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Instant expirationTime);

        /**
         * <p>
         * The state of the event source. If it is ACTIVE, you have already created a matching event bus for this event
         * source, and that event bus is active. If it is PENDING, either you haven't yet created a matching event bus,
         * or that event bus is deactivated. If it is DELETED, you have created a matching event bus, but the event
         * source has since been deleted.
         * </p>
         * 
         * @param state
         *        The state of the event source. If it is ACTIVE, you have already created a matching event bus for this
         *        event source, and that event bus is active. If it is PENDING, either you haven't yet created a
         *        matching event bus, or that event bus is deactivated. If it is DELETED, you have created a matching
         *        event bus, but the event source has since been deleted.
         * @see EventSourceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourceState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the event source. If it is ACTIVE, you have already created a matching event bus for this event
         * source, and that event bus is active. If it is PENDING, either you haven't yet created a matching event bus,
         * or that event bus is deactivated. If it is DELETED, you have created a matching event bus, but the event
         * source has since been deleted.
         * </p>
         * 
         * @param state
         *        The state of the event source. If it is ACTIVE, you have already created a matching event bus for this
         *        event source, and that event bus is active. If it is PENDING, either you haven't yet created a
         *        matching event bus, or that event bus is deactivated. If it is DELETED, you have created a matching
         *        event bus, but the event source has since been deleted.
         * @see EventSourceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourceState
         */
        Builder state(EventSourceState state);
    }

    static final class BuilderImpl implements Builder {
        private String account;

        private Instant creationTime;

        private Instant expirationTime;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(PartnerEventSourceAccount model) {
            account(model.account);
            creationTime(model.creationTime);
            expirationTime(model.expirationTime);
            state(model.state);
        }

        public final String getAccount() {
            return account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getExpirationTime() {
            return expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EventSourceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public PartnerEventSourceAccount build() {
            return new PartnerEventSourceAccount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
