/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEndpointsRequest extends EventBridgeRequest implements
        ToCopyableBuilder<ListEndpointsRequest.Builder, ListEndpointsRequest> {
    private static final SdkField<String> NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NamePrefix").getter(getter(ListEndpointsRequest::namePrefix)).setter(setter(Builder::namePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamePrefix").build()).build();

    private static final SdkField<String> HOME_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeRegion").getter(getter(ListEndpointsRequest::homeRegion)).setter(setter(Builder::homeRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEndpointsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListEndpointsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_PREFIX_FIELD,
            HOME_REGION_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String namePrefix;

    private final String homeRegion;

    private final String nextToken;

    private final Integer maxResults;

    private ListEndpointsRequest(BuilderImpl builder) {
        super(builder);
        this.namePrefix = builder.namePrefix;
        this.homeRegion = builder.homeRegion;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * A value that will return a subset of the endpoints associated with this account. For example,
     * <code>"NamePrefix": "ABC"</code> will return all endpoints with "ABC" in the name.
     * </p>
     * 
     * @return A value that will return a subset of the endpoints associated with this account. For example,
     *         <code>"NamePrefix": "ABC"</code> will return all endpoints with "ABC" in the name.
     */
    public final String namePrefix() {
        return namePrefix;
    }

    /**
     * <p>
     * The primary Region of the endpoints associated with this account. For example
     * <code>"HomeRegion": "us-east-1"</code>.
     * </p>
     * 
     * @return The primary Region of the endpoints associated with this account. For example
     *         <code>"HomeRegion": "us-east-1"</code>.
     */
    public final String homeRegion() {
        return homeRegion;
    }

    /**
     * <p>
     * The token returned by a previous call, which you can use to retrieve the next set of results.
     * </p>
     * <p>
     * The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page of
     * results, make the call again using the returned token. Keep all other arguments unchanged.
     * </p>
     * <p>
     * Using an expired pagination token results in an <code>HTTP 400 InvalidToken</code> error.
     * </p>
     * 
     * @return The token returned by a previous call, which you can use to retrieve the next set of results.</p>
     *         <p>
     *         The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page
     *         of results, make the call again using the returned token. Keep all other arguments unchanged.
     *         </p>
     *         <p>
     *         Using an expired pagination token results in an <code>HTTP 400 InvalidToken</code> error.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results returned by the call.
     * </p>
     * 
     * @return The maximum number of results returned by the call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEndpointsRequest)) {
            return false;
        }
        ListEndpointsRequest other = (ListEndpointsRequest) obj;
        return Objects.equals(namePrefix(), other.namePrefix()) && Objects.equals(homeRegion(), other.homeRegion())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEndpointsRequest").add("NamePrefix", namePrefix()).add("HomeRegion", homeRegion())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NamePrefix":
            return Optional.ofNullable(clazz.cast(namePrefix()));
        case "HomeRegion":
            return Optional.ofNullable(clazz.cast(homeRegion()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NamePrefix", NAME_PREFIX_FIELD);
        map.put("HomeRegion", HOME_REGION_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEndpointsRequest, T> g) {
        return obj -> g.apply((ListEndpointsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListEndpointsRequest> {
        /**
         * <p>
         * A value that will return a subset of the endpoints associated with this account. For example,
         * <code>"NamePrefix": "ABC"</code> will return all endpoints with "ABC" in the name.
         * </p>
         * 
         * @param namePrefix
         *        A value that will return a subset of the endpoints associated with this account. For example,
         *        <code>"NamePrefix": "ABC"</code> will return all endpoints with "ABC" in the name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namePrefix(String namePrefix);

        /**
         * <p>
         * The primary Region of the endpoints associated with this account. For example
         * <code>"HomeRegion": "us-east-1"</code>.
         * </p>
         * 
         * @param homeRegion
         *        The primary Region of the endpoints associated with this account. For example
         *        <code>"HomeRegion": "us-east-1"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegion(String homeRegion);

        /**
         * <p>
         * The token returned by a previous call, which you can use to retrieve the next set of results.
         * </p>
         * <p>
         * The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page of
         * results, make the call again using the returned token. Keep all other arguments unchanged.
         * </p>
         * <p>
         * Using an expired pagination token results in an <code>HTTP 400 InvalidToken</code> error.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call, which you can use to retrieve the next set of results.</p>
         *        <p>
         *        The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next
         *        page of results, make the call again using the returned token. Keep all other arguments unchanged.
         *        </p>
         *        <p>
         *        Using an expired pagination token results in an <code>HTTP 400 InvalidToken</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results returned by the call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results returned by the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EventBridgeRequest.BuilderImpl implements Builder {
        private String namePrefix;

        private String homeRegion;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEndpointsRequest model) {
            super(model);
            namePrefix(model.namePrefix);
            homeRegion(model.homeRegion);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getNamePrefix() {
            return namePrefix;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final String getHomeRegion() {
            return homeRegion;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEndpointsRequest build() {
            return new ListEndpointsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
