/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The failover configuration for an endpoint. This includes what triggers failover and what happens when it's
 * triggered.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailoverConfig implements SdkPojo, Serializable, ToCopyableBuilder<FailoverConfig.Builder, FailoverConfig> {
    private static final SdkField<Primary> PRIMARY_FIELD = SdkField.<Primary> builder(MarshallingType.SDK_POJO)
            .memberName("Primary").getter(getter(FailoverConfig::primary)).setter(setter(Builder::primary))
            .constructor(Primary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary").build()).build();

    private static final SdkField<Secondary> SECONDARY_FIELD = SdkField.<Secondary> builder(MarshallingType.SDK_POJO)
            .memberName("Secondary").getter(getter(FailoverConfig::secondary)).setter(setter(Builder::secondary))
            .constructor(Secondary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Secondary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PRIMARY_FIELD, SECONDARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Primary primary;

    private final Secondary secondary;

    private FailoverConfig(BuilderImpl builder) {
        this.primary = builder.primary;
        this.secondary = builder.secondary;
    }

    /**
     * <p>
     * The main Region of the endpoint.
     * </p>
     * 
     * @return The main Region of the endpoint.
     */
    public final Primary primary() {
        return primary;
    }

    /**
     * <p>
     * The Region that events are routed to when failover is triggered or event replication is enabled.
     * </p>
     * 
     * @return The Region that events are routed to when failover is triggered or event replication is enabled.
     */
    public final Secondary secondary() {
        return secondary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primary());
        hashCode = 31 * hashCode + Objects.hashCode(secondary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverConfig)) {
            return false;
        }
        FailoverConfig other = (FailoverConfig) obj;
        return Objects.equals(primary(), other.primary()) && Objects.equals(secondary(), other.secondary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailoverConfig").add("Primary", primary()).add("Secondary", secondary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Primary":
            return Optional.ofNullable(clazz.cast(primary()));
        case "Secondary":
            return Optional.ofNullable(clazz.cast(secondary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Primary", PRIMARY_FIELD);
        map.put("Secondary", SECONDARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailoverConfig, T> g) {
        return obj -> g.apply((FailoverConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailoverConfig> {
        /**
         * <p>
         * The main Region of the endpoint.
         * </p>
         * 
         * @param primary
         *        The main Region of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primary(Primary primary);

        /**
         * <p>
         * The main Region of the endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link Primary.Builder} avoiding the need to
         * create one manually via {@link Primary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Primary.Builder#build()} is called immediately and its result is
         * passed to {@link #primary(Primary)}.
         * 
         * @param primary
         *        a consumer that will call methods on {@link Primary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primary(Primary)
         */
        default Builder primary(Consumer<Primary.Builder> primary) {
            return primary(Primary.builder().applyMutation(primary).build());
        }

        /**
         * <p>
         * The Region that events are routed to when failover is triggered or event replication is enabled.
         * </p>
         * 
         * @param secondary
         *        The Region that events are routed to when failover is triggered or event replication is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondary(Secondary secondary);

        /**
         * <p>
         * The Region that events are routed to when failover is triggered or event replication is enabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link Secondary.Builder} avoiding the need to
         * create one manually via {@link Secondary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Secondary.Builder#build()} is called immediately and its result
         * is passed to {@link #secondary(Secondary)}.
         * 
         * @param secondary
         *        a consumer that will call methods on {@link Secondary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondary(Secondary)
         */
        default Builder secondary(Consumer<Secondary.Builder> secondary) {
            return secondary(Secondary.builder().applyMutation(secondary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Primary primary;

        private Secondary secondary;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverConfig model) {
            primary(model.primary);
            secondary(model.secondary);
        }

        public final Primary.Builder getPrimary() {
            return primary != null ? primary.toBuilder() : null;
        }

        public final void setPrimary(Primary.BuilderImpl primary) {
            this.primary = primary != null ? primary.build() : null;
        }

        @Override
        public final Builder primary(Primary primary) {
            this.primary = primary;
            return this;
        }

        public final Secondary.Builder getSecondary() {
            return secondary != null ? secondary.toBuilder() : null;
        }

        public final void setSecondary(Secondary.BuilderImpl secondary) {
            this.secondary = secondary != null ? secondary.build() : null;
        }

        @Override
        public final Builder secondary(Secondary secondary) {
            this.secondary = secondary;
            return this;
        }

        @Override
        public FailoverConfig build() {
            return new FailoverConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
