/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An <code>Archive</code> object that contains details about an archive.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Archive implements SdkPojo, Serializable, ToCopyableBuilder<Archive.Builder, Archive> {
    private static final SdkField<String> ARCHIVE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveName").getter(getter(Archive::archiveName)).setter(setter(Builder::archiveName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveName").build()).build();

    private static final SdkField<String> EVENT_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSourceArn").getter(getter(Archive::eventSourceArn)).setter(setter(Builder::eventSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Archive::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReason").getter(getter(Archive::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final SdkField<Integer> RETENTION_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetentionDays").getter(getter(Archive::retentionDays)).setter(setter(Builder::retentionDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionDays").build()).build();

    private static final SdkField<Long> SIZE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("SizeBytes")
            .getter(getter(Archive::sizeBytes)).setter(setter(Builder::sizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeBytes").build()).build();

    private static final SdkField<Long> EVENT_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EventCount").getter(getter(Archive::eventCount)).setter(setter(Builder::eventCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCount").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Archive::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_NAME_FIELD,
            EVENT_SOURCE_ARN_FIELD, STATE_FIELD, STATE_REASON_FIELD, RETENTION_DAYS_FIELD, SIZE_BYTES_FIELD, EVENT_COUNT_FIELD,
            CREATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String archiveName;

    private final String eventSourceArn;

    private final String state;

    private final String stateReason;

    private final Integer retentionDays;

    private final Long sizeBytes;

    private final Long eventCount;

    private final Instant creationTime;

    private Archive(BuilderImpl builder) {
        this.archiveName = builder.archiveName;
        this.eventSourceArn = builder.eventSourceArn;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.retentionDays = builder.retentionDays;
        this.sizeBytes = builder.sizeBytes;
        this.eventCount = builder.eventCount;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The name of the archive.
     * </p>
     * 
     * @return The name of the archive.
     */
    public final String archiveName() {
        return archiveName;
    }

    /**
     * <p>
     * The ARN of the event bus associated with the archive. Only events from this event bus are sent to the archive.
     * </p>
     * 
     * @return The ARN of the event bus associated with the archive. Only events from this event bus are sent to the
     *         archive.
     */
    public final String eventSourceArn() {
        return eventSourceArn;
    }

    /**
     * <p>
     * The current state of the archive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ArchiveState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the archive.
     * @see ArchiveState
     */
    public final ArchiveState state() {
        return ArchiveState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the archive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ArchiveState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the archive.
     * @see ArchiveState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * A description for the reason that the archive is in the current state.
     * </p>
     * 
     * @return A description for the reason that the archive is in the current state.
     */
    public final String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * The number of days to retain events in the archive before they are deleted.
     * </p>
     * 
     * @return The number of days to retain events in the archive before they are deleted.
     */
    public final Integer retentionDays() {
        return retentionDays;
    }

    /**
     * <p>
     * The size of the archive, in bytes.
     * </p>
     * 
     * @return The size of the archive, in bytes.
     */
    public final Long sizeBytes() {
        return sizeBytes;
    }

    /**
     * <p>
     * The number of events in the archive.
     * </p>
     * 
     * @return The number of events in the archive.
     */
    public final Long eventCount() {
        return eventCount;
    }

    /**
     * <p>
     * The time stamp for the time that the archive was created.
     * </p>
     * 
     * @return The time stamp for the time that the archive was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(archiveName());
        hashCode = 31 * hashCode + Objects.hashCode(eventSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(retentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(sizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(eventCount());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Archive)) {
            return false;
        }
        Archive other = (Archive) obj;
        return Objects.equals(archiveName(), other.archiveName()) && Objects.equals(eventSourceArn(), other.eventSourceArn())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(stateReason(), other.stateReason())
                && Objects.equals(retentionDays(), other.retentionDays()) && Objects.equals(sizeBytes(), other.sizeBytes())
                && Objects.equals(eventCount(), other.eventCount()) && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Archive").add("ArchiveName", archiveName()).add("EventSourceArn", eventSourceArn())
                .add("State", stateAsString()).add("StateReason", stateReason()).add("RetentionDays", retentionDays())
                .add("SizeBytes", sizeBytes()).add("EventCount", eventCount()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchiveName":
            return Optional.ofNullable(clazz.cast(archiveName()));
        case "EventSourceArn":
            return Optional.ofNullable(clazz.cast(eventSourceArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "RetentionDays":
            return Optional.ofNullable(clazz.cast(retentionDays()));
        case "SizeBytes":
            return Optional.ofNullable(clazz.cast(sizeBytes()));
        case "EventCount":
            return Optional.ofNullable(clazz.cast(eventCount()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ArchiveName", ARCHIVE_NAME_FIELD);
        map.put("EventSourceArn", EVENT_SOURCE_ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("RetentionDays", RETENTION_DAYS_FIELD);
        map.put("SizeBytes", SIZE_BYTES_FIELD);
        map.put("EventCount", EVENT_COUNT_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Archive, T> g) {
        return obj -> g.apply((Archive) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Archive> {
        /**
         * <p>
         * The name of the archive.
         * </p>
         * 
         * @param archiveName
         *        The name of the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveName(String archiveName);

        /**
         * <p>
         * The ARN of the event bus associated with the archive. Only events from this event bus are sent to the
         * archive.
         * </p>
         * 
         * @param eventSourceArn
         *        The ARN of the event bus associated with the archive. Only events from this event bus are sent to the
         *        archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSourceArn(String eventSourceArn);

        /**
         * <p>
         * The current state of the archive.
         * </p>
         * 
         * @param state
         *        The current state of the archive.
         * @see ArchiveState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchiveState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the archive.
         * </p>
         * 
         * @param state
         *        The current state of the archive.
         * @see ArchiveState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchiveState
         */
        Builder state(ArchiveState state);

        /**
         * <p>
         * A description for the reason that the archive is in the current state.
         * </p>
         * 
         * @param stateReason
         *        A description for the reason that the archive is in the current state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The number of days to retain events in the archive before they are deleted.
         * </p>
         * 
         * @param retentionDays
         *        The number of days to retain events in the archive before they are deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionDays(Integer retentionDays);

        /**
         * <p>
         * The size of the archive, in bytes.
         * </p>
         * 
         * @param sizeBytes
         *        The size of the archive, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeBytes(Long sizeBytes);

        /**
         * <p>
         * The number of events in the archive.
         * </p>
         * 
         * @param eventCount
         *        The number of events in the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCount(Long eventCount);

        /**
         * <p>
         * The time stamp for the time that the archive was created.
         * </p>
         * 
         * @param creationTime
         *        The time stamp for the time that the archive was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String archiveName;

        private String eventSourceArn;

        private String state;

        private String stateReason;

        private Integer retentionDays;

        private Long sizeBytes;

        private Long eventCount;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Archive model) {
            archiveName(model.archiveName);
            eventSourceArn(model.eventSourceArn);
            state(model.state);
            stateReason(model.stateReason);
            retentionDays(model.retentionDays);
            sizeBytes(model.sizeBytes);
            eventCount(model.eventCount);
            creationTime(model.creationTime);
        }

        public final String getArchiveName() {
            return archiveName;
        }

        public final void setArchiveName(String archiveName) {
            this.archiveName = archiveName;
        }

        @Override
        public final Builder archiveName(String archiveName) {
            this.archiveName = archiveName;
            return this;
        }

        public final String getEventSourceArn() {
            return eventSourceArn;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ArchiveState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final Integer getRetentionDays() {
            return retentionDays;
        }

        public final void setRetentionDays(Integer retentionDays) {
            this.retentionDays = retentionDays;
        }

        @Override
        public final Builder retentionDays(Integer retentionDays) {
            this.retentionDays = retentionDays;
            return this;
        }

        public final Long getSizeBytes() {
            return sizeBytes;
        }

        public final void setSizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
        }

        @Override
        public final Builder sizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return this;
        }

        public final Long getEventCount() {
            return eventCount;
        }

        public final void setEventCount(Long eventCount) {
            this.eventCount = eventCount;
        }

        @Override
        public final Builder eventCount(Long eventCount) {
            this.eventCount = eventCount;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public Archive build() {
            return new Archive(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
