/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the GraphQL operation to be parsed and executed, if the event target is an AppSync API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppSyncParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<AppSyncParameters.Builder, AppSyncParameters> {
    private static final SdkField<String> GRAPH_QL_OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GraphQLOperation").getter(getter(AppSyncParameters::graphQLOperation))
            .setter(setter(Builder::graphQLOperation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphQLOperation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_QL_OPERATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String graphQLOperation;

    private AppSyncParameters(BuilderImpl builder) {
        this.graphQLOperation = builder.graphQLOperation;
    }

    /**
     * <p>
     * The GraphQL operation; that is, the query, mutation, or subscription to be parsed and executed by the GraphQL
     * service.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/appsync/latest/devguide/graphql-architecture.html#graphql-operations"
     * >Operations</a> in the <i>AppSync User Guide</i>.
     * </p>
     * 
     * @return The GraphQL operation; that is, the query, mutation, or subscription to be parsed and executed by the
     *         GraphQL service.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/appsync/latest/devguide/graphql-architecture.html#graphql-operations"
     *         >Operations</a> in the <i>AppSync User Guide</i>.
     */
    public final String graphQLOperation() {
        return graphQLOperation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(graphQLOperation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppSyncParameters)) {
            return false;
        }
        AppSyncParameters other = (AppSyncParameters) obj;
        return Objects.equals(graphQLOperation(), other.graphQLOperation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppSyncParameters")
                .add("GraphQLOperation", graphQLOperation() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GraphQLOperation":
            return Optional.ofNullable(clazz.cast(graphQLOperation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GraphQLOperation", GRAPH_QL_OPERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppSyncParameters, T> g) {
        return obj -> g.apply((AppSyncParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppSyncParameters> {
        /**
         * <p>
         * The GraphQL operation; that is, the query, mutation, or subscription to be parsed and executed by the GraphQL
         * service.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/appsync/latest/devguide/graphql-architecture.html#graphql-operations"
         * >Operations</a> in the <i>AppSync User Guide</i>.
         * </p>
         * 
         * @param graphQLOperation
         *        The GraphQL operation; that is, the query, mutation, or subscription to be parsed and executed by the
         *        GraphQL service.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/appsync/latest/devguide/graphql-architecture.html#graphql-operations"
         *        >Operations</a> in the <i>AppSync User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphQLOperation(String graphQLOperation);
    }

    static final class BuilderImpl implements Builder {
        private String graphQLOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(AppSyncParameters model) {
            graphQLOperation(model.graphQLOperation);
        }

        public final String getGraphQLOperation() {
            return graphQLOperation;
        }

        public final void setGraphQLOperation(String graphQLOperation) {
            this.graphQLOperation = graphQLOperation;
        }

        @Override
        public final Builder graphQLOperation(String graphQLOperation) {
            this.graphQLOperation = graphQLOperation;
            return this;
        }

        @Override
        public AppSyncParameters build() {
            return new AppSyncParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
