/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectionRequest extends EventBridgeRequest implements
        ToCopyableBuilder<CreateConnectionRequest.Builder, CreateConnectionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateConnectionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateConnectionRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> AUTHORIZATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizationType").getter(getter(CreateConnectionRequest::authorizationTypeAsString))
            .setter(setter(Builder::authorizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationType").build()).build();

    private static final SdkField<CreateConnectionAuthRequestParameters> AUTH_PARAMETERS_FIELD = SdkField
            .<CreateConnectionAuthRequestParameters> builder(MarshallingType.SDK_POJO).memberName("AuthParameters")
            .getter(getter(CreateConnectionRequest::authParameters)).setter(setter(Builder::authParameters))
            .constructor(CreateConnectionAuthRequestParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthParameters").build()).build();

    private static final SdkField<ConnectivityResourceParameters> INVOCATION_CONNECTIVITY_PARAMETERS_FIELD = SdkField
            .<ConnectivityResourceParameters> builder(MarshallingType.SDK_POJO)
            .memberName("InvocationConnectivityParameters")
            .getter(getter(CreateConnectionRequest::invocationConnectivityParameters))
            .setter(setter(Builder::invocationConnectivityParameters))
            .constructor(ConnectivityResourceParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationConnectivityParameters")
                    .build()).build();

    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyIdentifier").getter(getter(CreateConnectionRequest::kmsKeyIdentifier))
            .setter(setter(Builder::kmsKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            AUTHORIZATION_TYPE_FIELD, AUTH_PARAMETERS_FIELD, INVOCATION_CONNECTIVITY_PARAMETERS_FIELD, KMS_KEY_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final String authorizationType;

    private final CreateConnectionAuthRequestParameters authParameters;

    private final ConnectivityResourceParameters invocationConnectivityParameters;

    private final String kmsKeyIdentifier;

    private CreateConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.authorizationType = builder.authorizationType;
        this.authParameters = builder.authParameters;
        this.invocationConnectivityParameters = builder.invocationConnectivityParameters;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
    }

    /**
     * <p>
     * The name for the connection to create.
     * </p>
     * 
     * @return The name for the connection to create.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description for the connection to create.
     * </p>
     * 
     * @return A description for the connection to create.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of authorization to use for the connection.
     * </p>
     * <note>
     * <p>
     * OAUTH tokens are refreshed when a 401 or 407 response is returned.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizationType}
     * will return {@link ConnectionAuthorizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authorizationTypeAsString}.
     * </p>
     * 
     * @return The type of authorization to use for the connection.</p> <note>
     *         <p>
     *         OAUTH tokens are refreshed when a 401 or 407 response is returned.
     *         </p>
     * @see ConnectionAuthorizationType
     */
    public final ConnectionAuthorizationType authorizationType() {
        return ConnectionAuthorizationType.fromValue(authorizationType);
    }

    /**
     * <p>
     * The type of authorization to use for the connection.
     * </p>
     * <note>
     * <p>
     * OAUTH tokens are refreshed when a 401 or 407 response is returned.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizationType}
     * will return {@link ConnectionAuthorizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authorizationTypeAsString}.
     * </p>
     * 
     * @return The type of authorization to use for the connection.</p> <note>
     *         <p>
     *         OAUTH tokens are refreshed when a 401 or 407 response is returned.
     *         </p>
     * @see ConnectionAuthorizationType
     */
    public final String authorizationTypeAsString() {
        return authorizationType;
    }

    /**
     * <p>
     * The authorization parameters to use to authorize with the endpoint.
     * </p>
     * <p>
     * You must include only authorization parameters for the <code>AuthorizationType</code> you specify.
     * </p>
     * 
     * @return The authorization parameters to use to authorize with the endpoint. </p>
     *         <p>
     *         You must include only authorization parameters for the <code>AuthorizationType</code> you specify.
     */
    public final CreateConnectionAuthRequestParameters authParameters() {
        return authParameters;
    }

    /**
     * <p>
     * For connections to private APIs, the parameters to use for invoking the API.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html">Connecting to private
     * APIs</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>.
     * </p>
     * 
     * @return For connections to private APIs, the parameters to use for invoking the API.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html">Connecting to
     *         private APIs</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>.
     */
    public final ConnectivityResourceParameters invocationConnectivityParameters() {
        return invocationConnectivityParameters;
    }

    /**
     * <p>
     * The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer managed
     * key to encrypt this connection. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or
     * key alias ARN.
     * </p>
     * <p>
     * If you do not specify a customer managed key identifier, EventBridge uses an Amazon Web Services owned key to
     * encrypt the connection.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html">Identify and view keys</a> in the
     * <i>Key Management Service Developer Guide</i>.
     * </p>
     * 
     * @return The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer
     *         managed key to encrypt this connection. The identifier can be the key Amazon Resource Name (ARN), KeyId,
     *         key alias, or key alias ARN.</p>
     *         <p>
     *         If you do not specify a customer managed key identifier, EventBridge uses an Amazon Web Services owned
     *         key to encrypt the connection.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html">Identify and view keys</a>
     *         in the <i>Key Management Service Developer Guide</i>.
     */
    public final String kmsKeyIdentifier() {
        return kmsKeyIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authParameters());
        hashCode = 31 * hashCode + Objects.hashCode(invocationConnectivityParameters());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionRequest)) {
            return false;
        }
        CreateConnectionRequest other = (CreateConnectionRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(authorizationTypeAsString(), other.authorizationTypeAsString())
                && Objects.equals(authParameters(), other.authParameters())
                && Objects.equals(invocationConnectivityParameters(), other.invocationConnectivityParameters())
                && Objects.equals(kmsKeyIdentifier(), other.kmsKeyIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectionRequest").add("Name", name()).add("Description", description())
                .add("AuthorizationType", authorizationTypeAsString()).add("AuthParameters", authParameters())
                .add("InvocationConnectivityParameters", invocationConnectivityParameters())
                .add("KmsKeyIdentifier", kmsKeyIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AuthorizationType":
            return Optional.ofNullable(clazz.cast(authorizationTypeAsString()));
        case "AuthParameters":
            return Optional.ofNullable(clazz.cast(authParameters()));
        case "InvocationConnectivityParameters":
            return Optional.ofNullable(clazz.cast(invocationConnectivityParameters()));
        case "KmsKeyIdentifier":
            return Optional.ofNullable(clazz.cast(kmsKeyIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AuthorizationType", AUTHORIZATION_TYPE_FIELD);
        map.put("AuthParameters", AUTH_PARAMETERS_FIELD);
        map.put("InvocationConnectivityParameters", INVOCATION_CONNECTIVITY_PARAMETERS_FIELD);
        map.put("KmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectionRequest, T> g) {
        return obj -> g.apply((CreateConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateConnectionRequest> {
        /**
         * <p>
         * The name for the connection to create.
         * </p>
         * 
         * @param name
         *        The name for the connection to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description for the connection to create.
         * </p>
         * 
         * @param description
         *        A description for the connection to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of authorization to use for the connection.
         * </p>
         * <note>
         * <p>
         * OAUTH tokens are refreshed when a 401 or 407 response is returned.
         * </p>
         * </note>
         * 
         * @param authorizationType
         *        The type of authorization to use for the connection.</p> <note>
         *        <p>
         *        OAUTH tokens are refreshed when a 401 or 407 response is returned.
         *        </p>
         * @see ConnectionAuthorizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionAuthorizationType
         */
        Builder authorizationType(String authorizationType);

        /**
         * <p>
         * The type of authorization to use for the connection.
         * </p>
         * <note>
         * <p>
         * OAUTH tokens are refreshed when a 401 or 407 response is returned.
         * </p>
         * </note>
         * 
         * @param authorizationType
         *        The type of authorization to use for the connection.</p> <note>
         *        <p>
         *        OAUTH tokens are refreshed when a 401 or 407 response is returned.
         *        </p>
         * @see ConnectionAuthorizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionAuthorizationType
         */
        Builder authorizationType(ConnectionAuthorizationType authorizationType);

        /**
         * <p>
         * The authorization parameters to use to authorize with the endpoint.
         * </p>
         * <p>
         * You must include only authorization parameters for the <code>AuthorizationType</code> you specify.
         * </p>
         * 
         * @param authParameters
         *        The authorization parameters to use to authorize with the endpoint. </p>
         *        <p>
         *        You must include only authorization parameters for the <code>AuthorizationType</code> you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authParameters(CreateConnectionAuthRequestParameters authParameters);

        /**
         * <p>
         * The authorization parameters to use to authorize with the endpoint.
         * </p>
         * <p>
         * You must include only authorization parameters for the <code>AuthorizationType</code> you specify.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateConnectionAuthRequestParameters.Builder} avoiding the need to create one manually via
         * {@link CreateConnectionAuthRequestParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateConnectionAuthRequestParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #authParameters(CreateConnectionAuthRequestParameters)}.
         * 
         * @param authParameters
         *        a consumer that will call methods on {@link CreateConnectionAuthRequestParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authParameters(CreateConnectionAuthRequestParameters)
         */
        default Builder authParameters(Consumer<CreateConnectionAuthRequestParameters.Builder> authParameters) {
            return authParameters(CreateConnectionAuthRequestParameters.builder().applyMutation(authParameters).build());
        }

        /**
         * <p>
         * For connections to private APIs, the parameters to use for invoking the API.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html">Connecting to private
         * APIs</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>.
         * </p>
         * 
         * @param invocationConnectivityParameters
         *        For connections to private APIs, the parameters to use for invoking the API.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html">Connecting to
         *        private APIs</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationConnectivityParameters(ConnectivityResourceParameters invocationConnectivityParameters);

        /**
         * <p>
         * For connections to private APIs, the parameters to use for invoking the API.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html">Connecting to private
         * APIs</a> in the <i> <i>Amazon EventBridge User Guide</i> </i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectivityResourceParameters.Builder}
         * avoiding the need to create one manually via {@link ConnectivityResourceParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectivityResourceParameters.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #invocationConnectivityParameters(ConnectivityResourceParameters)}.
         * 
         * @param invocationConnectivityParameters
         *        a consumer that will call methods on {@link ConnectivityResourceParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invocationConnectivityParameters(ConnectivityResourceParameters)
         */
        default Builder invocationConnectivityParameters(
                Consumer<ConnectivityResourceParameters.Builder> invocationConnectivityParameters) {
            return invocationConnectivityParameters(ConnectivityResourceParameters.builder()
                    .applyMutation(invocationConnectivityParameters).build());
        }

        /**
         * <p>
         * The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer
         * managed key to encrypt this connection. The identifier can be the key Amazon Resource Name (ARN), KeyId, key
         * alias, or key alias ARN.
         * </p>
         * <p>
         * If you do not specify a customer managed key identifier, EventBridge uses an Amazon Web Services owned key to
         * encrypt the connection.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html">Identify and view keys</a> in
         * the <i>Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param kmsKeyIdentifier
         *        The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer
         *        managed key to encrypt this connection. The identifier can be the key Amazon Resource Name (ARN),
         *        KeyId, key alias, or key alias ARN.</p>
         *        <p>
         *        If you do not specify a customer managed key identifier, EventBridge uses an Amazon Web Services owned
         *        key to encrypt the connection.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html">Identify and view
         *        keys</a> in the <i>Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyIdentifier(String kmsKeyIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EventBridgeRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String authorizationType;

        private CreateConnectionAuthRequestParameters authParameters;

        private ConnectivityResourceParameters invocationConnectivityParameters;

        private String kmsKeyIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            authorizationType(model.authorizationType);
            authParameters(model.authParameters);
            invocationConnectivityParameters(model.invocationConnectivityParameters);
            kmsKeyIdentifier(model.kmsKeyIdentifier);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAuthorizationType() {
            return authorizationType;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        @Override
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        @Override
        public final Builder authorizationType(ConnectionAuthorizationType authorizationType) {
            this.authorizationType(authorizationType == null ? null : authorizationType.toString());
            return this;
        }

        public final CreateConnectionAuthRequestParameters.Builder getAuthParameters() {
            return authParameters != null ? authParameters.toBuilder() : null;
        }

        public final void setAuthParameters(CreateConnectionAuthRequestParameters.BuilderImpl authParameters) {
            this.authParameters = authParameters != null ? authParameters.build() : null;
        }

        @Override
        public final Builder authParameters(CreateConnectionAuthRequestParameters authParameters) {
            this.authParameters = authParameters;
            return this;
        }

        public final ConnectivityResourceParameters.Builder getInvocationConnectivityParameters() {
            return invocationConnectivityParameters != null ? invocationConnectivityParameters.toBuilder() : null;
        }

        public final void setInvocationConnectivityParameters(
                ConnectivityResourceParameters.BuilderImpl invocationConnectivityParameters) {
            this.invocationConnectivityParameters = invocationConnectivityParameters != null ? invocationConnectivityParameters
                    .build() : null;
        }

        @Override
        public final Builder invocationConnectivityParameters(ConnectivityResourceParameters invocationConnectivityParameters) {
            this.invocationConnectivityParameters = invocationConnectivityParameters;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectionRequest build() {
            return new CreateConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
