/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEventBusRequest extends EventBridgeRequest implements
        ToCopyableBuilder<UpdateEventBusRequest.Builder, UpdateEventBusRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateEventBusRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyIdentifier").getter(getter(UpdateEventBusRequest::kmsKeyIdentifier))
            .setter(setter(Builder::kmsKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyIdentifier").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateEventBusRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField
            .<DeadLetterConfig> builder(MarshallingType.SDK_POJO).memberName("DeadLetterConfig")
            .getter(getter(UpdateEventBusRequest::deadLetterConfig)).setter(setter(Builder::deadLetterConfig))
            .constructor(DeadLetterConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            KMS_KEY_IDENTIFIER_FIELD, DESCRIPTION_FIELD, DEAD_LETTER_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String kmsKeyIdentifier;

    private final String description;

    private final DeadLetterConfig deadLetterConfig;

    private UpdateEventBusRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.description = builder.description;
        this.deadLetterConfig = builder.deadLetterConfig;
    }

    /**
     * <p>
     * The name of the event bus.
     * </p>
     * 
     * @return The name of the event bus.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer managed
     * key to encrypt events on this event bus. The identifier can be the key Amazon Resource Name (ARN), KeyId, key
     * alias, or key alias ARN.
     * </p>
     * <p>
     * If you do not specify a customer managed key identifier, EventBridge uses an Amazon Web Services owned key to
     * encrypt events on the event bus.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html">Identify and view keys</a> in the
     * <i>Key Management Service Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * Schema discovery is not supported for event buses encrypted using a customer managed key. EventBridge returns an
     * error if:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You call
     * <code> <a href="https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers.html#CreateDiscoverer">CreateDiscoverer</a> </code>
     * on an event bus set to use a customer managed key for encryption.
     * </p>
     * </li>
     * <li>
     * <p>
     * You call
     * <code> <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_UpdatedEventBus.html">UpdatedEventBus</a> </code>
     * to set a customer managed key on an event bus with schema discovery enabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To enable schema discovery on an event bus, choose to use an Amazon Web Services owned key. For more information,
     * see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption-event-bus-cmkey.html">Encrypting
     * events</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * </note> <important>
     * <p>
     * If you have specified that EventBridge use a customer managed key for encrypting the source event bus, we
     * strongly recommend you also specify a customer managed key for any archives for the event bus as well.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/encryption-archives.html">Encrypting archives</a>
     * in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * </important>
     * 
     * @return The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer
     *         managed key to encrypt events on this event bus. The identifier can be the key Amazon Resource Name
     *         (ARN), KeyId, key alias, or key alias ARN.</p>
     *         <p>
     *         If you do not specify a customer managed key identifier, EventBridge uses an Amazon Web Services owned
     *         key to encrypt events on the event bus.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html">Identify and view keys</a>
     *         in the <i>Key Management Service Developer Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         Schema discovery is not supported for event buses encrypted using a customer managed key. EventBridge
     *         returns an error if:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You call
     *         <code> <a href="https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers.html#CreateDiscoverer">CreateDiscoverer</a> </code>
     *         on an event bus set to use a customer managed key for encryption.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You call
     *         <code> <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_UpdatedEventBus.html">UpdatedEventBus</a> </code>
     *         to set a customer managed key on an event bus with schema discovery enabled.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To enable schema discovery on an event bus, choose to use an Amazon Web Services owned key. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption-event-bus-cmkey.html"
     *         >Encrypting events</a> in the <i>Amazon EventBridge User Guide</i>.
     *         </p>
     *         </note> <important>
     *         <p>
     *         If you have specified that EventBridge use a customer managed key for encrypting the source event bus, we
     *         strongly recommend you also specify a customer managed key for any archives for the event bus as well.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/encryption-archives.html">Encrypting
     *         archives</a> in the <i>Amazon EventBridge User Guide</i>.
     *         </p>
     */
    public final String kmsKeyIdentifier() {
        return kmsKeyIdentifier;
    }

    /**
     * <p>
     * The event bus description.
     * </p>
     * 
     * @return The event bus description.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the DeadLetterConfig property for this object.
     * 
     * @return The value of the DeadLetterConfig property for this object.
     */
    public final DeadLetterConfig deadLetterConfig() {
        return deadLetterConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deadLetterConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventBusRequest)) {
            return false;
        }
        UpdateEventBusRequest other = (UpdateEventBusRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(kmsKeyIdentifier(), other.kmsKeyIdentifier())
                && Objects.equals(description(), other.description())
                && Objects.equals(deadLetterConfig(), other.deadLetterConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEventBusRequest").add("Name", name()).add("KmsKeyIdentifier", kmsKeyIdentifier())
                .add("Description", description()).add("DeadLetterConfig", deadLetterConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "KmsKeyIdentifier":
            return Optional.ofNullable(clazz.cast(kmsKeyIdentifier()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DeadLetterConfig":
            return Optional.ofNullable(clazz.cast(deadLetterConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("KmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DeadLetterConfig", DEAD_LETTER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventBusRequest, T> g) {
        return obj -> g.apply((UpdateEventBusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEventBusRequest> {
        /**
         * <p>
         * The name of the event bus.
         * </p>
         * 
         * @param name
         *        The name of the event bus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer
         * managed key to encrypt events on this event bus. The identifier can be the key Amazon Resource Name (ARN),
         * KeyId, key alias, or key alias ARN.
         * </p>
         * <p>
         * If you do not specify a customer managed key identifier, EventBridge uses an Amazon Web Services owned key to
         * encrypt events on the event bus.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html">Identify and view keys</a> in
         * the <i>Key Management Service Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * Schema discovery is not supported for event buses encrypted using a customer managed key. EventBridge returns
         * an error if:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You call
         * <code> <a href="https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers.html#CreateDiscoverer">CreateDiscoverer</a> </code>
         * on an event bus set to use a customer managed key for encryption.
         * </p>
         * </li>
         * <li>
         * <p>
         * You call
         * <code> <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_UpdatedEventBus.html">UpdatedEventBus</a> </code>
         * to set a customer managed key on an event bus with schema discovery enabled.
         * </p>
         * </li>
         * </ul>
         * <p>
         * To enable schema discovery on an event bus, choose to use an Amazon Web Services owned key. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption-event-bus-cmkey.html">Encrypting
         * events</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * </note> <important>
         * <p>
         * If you have specified that EventBridge use a customer managed key for encrypting the source event bus, we
         * strongly recommend you also specify a customer managed key for any archives for the event bus as well.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/encryption-archives.html">Encrypting
         * archives</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * </important>
         * 
         * @param kmsKeyIdentifier
         *        The identifier of the KMS customer managed key for EventBridge to use, if you choose to use a customer
         *        managed key to encrypt events on this event bus. The identifier can be the key Amazon Resource Name
         *        (ARN), KeyId, key alias, or key alias ARN.</p>
         *        <p>
         *        If you do not specify a customer managed key identifier, EventBridge uses an Amazon Web Services owned
         *        key to encrypt events on the event bus.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html">Identify and view
         *        keys</a> in the <i>Key Management Service Developer Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        Schema discovery is not supported for event buses encrypted using a customer managed key. EventBridge
         *        returns an error if:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You call
         *        <code> <a href="https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers.html#CreateDiscoverer">CreateDiscoverer</a> </code>
         *        on an event bus set to use a customer managed key for encryption.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You call
         *        <code> <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_UpdatedEventBus.html">UpdatedEventBus</a> </code>
         *        to set a customer managed key on an event bus with schema discovery enabled.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To enable schema discovery on an event bus, choose to use an Amazon Web Services owned key. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption-event-bus-cmkey.html"
         *        >Encrypting events</a> in the <i>Amazon EventBridge User Guide</i>.
         *        </p>
         *        </note> <important>
         *        <p>
         *        If you have specified that EventBridge use a customer managed key for encrypting the source event bus,
         *        we strongly recommend you also specify a customer managed key for any archives for the event bus as
         *        well.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/userguide/encryption-archives.html">Encrypting
         *        archives</a> in the <i>Amazon EventBridge User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyIdentifier(String kmsKeyIdentifier);

        /**
         * <p>
         * The event bus description.
         * </p>
         * 
         * @param description
         *        The event bus description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the DeadLetterConfig property for this object.
         *
         * @param deadLetterConfig
         *        The new value for the DeadLetterConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deadLetterConfig(DeadLetterConfig deadLetterConfig);

        /**
         * Sets the value of the DeadLetterConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DeadLetterConfig.Builder} avoiding the
         * need to create one manually via {@link DeadLetterConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeadLetterConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deadLetterConfig(DeadLetterConfig)}.
         * 
         * @param deadLetterConfig
         *        a consumer that will call methods on {@link DeadLetterConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deadLetterConfig(DeadLetterConfig)
         */
        default Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return deadLetterConfig(DeadLetterConfig.builder().applyMutation(deadLetterConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EventBridgeRequest.BuilderImpl implements Builder {
        private String name;

        private String kmsKeyIdentifier;

        private String description;

        private DeadLetterConfig deadLetterConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventBusRequest model) {
            super(model);
            name(model.name);
            kmsKeyIdentifier(model.kmsKeyIdentifier);
            description(model.description);
            deadLetterConfig(model.deadLetterConfig);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return deadLetterConfig != null ? deadLetterConfig.toBuilder() : null;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEventBusRequest build() {
            return new UpdateEventBusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
