/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Any additional query string parameter for the connection. You can include up to 100 additional query string
 * parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionQueryStringParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionQueryStringParameter.Builder, ConnectionQueryStringParameter> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(ConnectionQueryStringParameter::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(ConnectionQueryStringParameter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Boolean> IS_VALUE_SECRET_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsValueSecret").getter(getter(ConnectionQueryStringParameter::isValueSecret))
            .setter(setter(Builder::isValueSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsValueSecret").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD,
            IS_VALUE_SECRET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String value;

    private final Boolean isValueSecret;

    private ConnectionQueryStringParameter(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.isValueSecret = builder.isValueSecret;
    }

    /**
     * <p>
     * The key for a query string parameter.
     * </p>
     * 
     * @return The key for a query string parameter.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The value associated with the key for the query string parameter.
     * </p>
     * 
     * @return The value associated with the key for the query string parameter.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * Specifies whether the value is secret.
     * </p>
     * 
     * @return Specifies whether the value is secret.
     */
    public final Boolean isValueSecret() {
        return isValueSecret;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(isValueSecret());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionQueryStringParameter)) {
            return false;
        }
        ConnectionQueryStringParameter other = (ConnectionQueryStringParameter) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value())
                && Objects.equals(isValueSecret(), other.isValueSecret());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionQueryStringParameter").add("Key", key())
                .add("Value", value() == null ? null : "*** Sensitive Data Redacted ***").add("IsValueSecret", isValueSecret())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "IsValueSecret":
            return Optional.ofNullable(clazz.cast(isValueSecret()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Key", KEY_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("IsValueSecret", IS_VALUE_SECRET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionQueryStringParameter, T> g) {
        return obj -> g.apply((ConnectionQueryStringParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionQueryStringParameter> {
        /**
         * <p>
         * The key for a query string parameter.
         * </p>
         * 
         * @param key
         *        The key for a query string parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The value associated with the key for the query string parameter.
         * </p>
         * 
         * @param value
         *        The value associated with the key for the query string parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * Specifies whether the value is secret.
         * </p>
         * 
         * @param isValueSecret
         *        Specifies whether the value is secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isValueSecret(Boolean isValueSecret);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private Boolean isValueSecret;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionQueryStringParameter model) {
            key(model.key);
            value(model.value);
            isValueSecret(model.isValueSecret);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Boolean getIsValueSecret() {
            return isValueSecret;
        }

        public final void setIsValueSecret(Boolean isValueSecret) {
            this.isValueSecret = isValueSecret;
        }

        @Override
        public final Builder isValueSecret(Boolean isValueSecret) {
            this.isValueSecret = isValueSecret;
            return this;
        }

        @Override
        public ConnectionQueryStringParameter build() {
            return new ConnectionQueryStringParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
