/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartReplayResponse extends EventBridgeResponse implements
        ToCopyableBuilder<StartReplayResponse.Builder, StartReplayResponse> {
    private static final SdkField<String> REPLAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplayArn").getter(getter(StartReplayResponse::replayArn)).setter(setter(Builder::replayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(StartReplayResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReason").getter(getter(StartReplayResponse::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final SdkField<Instant> REPLAY_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReplayStartTime").getter(getter(StartReplayResponse::replayStartTime))
            .setter(setter(Builder::replayStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayStartTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLAY_ARN_FIELD, STATE_FIELD,
            STATE_REASON_FIELD, REPLAY_START_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String replayArn;

    private final String state;

    private final String stateReason;

    private final Instant replayStartTime;

    private StartReplayResponse(BuilderImpl builder) {
        super(builder);
        this.replayArn = builder.replayArn;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.replayStartTime = builder.replayStartTime;
    }

    /**
     * <p>
     * The ARN of the replay.
     * </p>
     * 
     * @return The ARN of the replay.
     */
    public final String replayArn() {
        return replayArn;
    }

    /**
     * <p>
     * The state of the replay.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReplayState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the replay.
     * @see ReplayState
     */
    public final ReplayState state() {
        return ReplayState.fromValue(state);
    }

    /**
     * <p>
     * The state of the replay.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReplayState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the replay.
     * @see ReplayState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The reason that the replay is in the state.
     * </p>
     * 
     * @return The reason that the replay is in the state.
     */
    public final String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * The time at which the replay started.
     * </p>
     * 
     * @return The time at which the replay started.
     */
    public final Instant replayStartTime() {
        return replayStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replayArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(replayStartTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReplayResponse)) {
            return false;
        }
        StartReplayResponse other = (StartReplayResponse) obj;
        return Objects.equals(replayArn(), other.replayArn()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateReason(), other.stateReason())
                && Objects.equals(replayStartTime(), other.replayStartTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartReplayResponse").add("ReplayArn", replayArn()).add("State", stateAsString())
                .add("StateReason", stateReason()).add("ReplayStartTime", replayStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplayArn":
            return Optional.ofNullable(clazz.cast(replayArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "ReplayStartTime":
            return Optional.ofNullable(clazz.cast(replayStartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplayArn", REPLAY_ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("ReplayStartTime", REPLAY_START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartReplayResponse, T> g) {
        return obj -> g.apply((StartReplayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EventBridgeResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartReplayResponse> {
        /**
         * <p>
         * The ARN of the replay.
         * </p>
         * 
         * @param replayArn
         *        The ARN of the replay.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replayArn(String replayArn);

        /**
         * <p>
         * The state of the replay.
         * </p>
         * 
         * @param state
         *        The state of the replay.
         * @see ReplayState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplayState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the replay.
         * </p>
         * 
         * @param state
         *        The state of the replay.
         * @see ReplayState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplayState
         */
        Builder state(ReplayState state);

        /**
         * <p>
         * The reason that the replay is in the state.
         * </p>
         * 
         * @param stateReason
         *        The reason that the replay is in the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The time at which the replay started.
         * </p>
         * 
         * @param replayStartTime
         *        The time at which the replay started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replayStartTime(Instant replayStartTime);
    }

    static final class BuilderImpl extends EventBridgeResponse.BuilderImpl implements Builder {
        private String replayArn;

        private String state;

        private String stateReason;

        private Instant replayStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartReplayResponse model) {
            super(model);
            replayArn(model.replayArn);
            state(model.state);
            stateReason(model.stateReason);
            replayStartTime(model.replayStartTime);
        }

        public final String getReplayArn() {
            return replayArn;
        }

        public final void setReplayArn(String replayArn) {
            this.replayArn = replayArn;
        }

        @Override
        public final Builder replayArn(String replayArn) {
            this.replayArn = replayArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReplayState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final Instant getReplayStartTime() {
            return replayStartTime;
        }

        public final void setReplayStartTime(Instant replayStartTime) {
            this.replayStartTime = replayStartTime;
        }

        @Override
        public final Builder replayStartTime(Instant replayStartTime) {
            this.replayStartTime = replayStartTime;
            return this;
        }

        @Override
        public StartReplayResponse build() {
            return new StartReplayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
