/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutPartnerEventsRequest extends EventBridgeRequest implements
        ToCopyableBuilder<PutPartnerEventsRequest.Builder, PutPartnerEventsRequest> {
    private static final SdkField<List<PutPartnerEventsRequestEntry>> ENTRIES_FIELD = SdkField
            .<List<PutPartnerEventsRequestEntry>> builder(MarshallingType.LIST)
            .getter(getter(PutPartnerEventsRequest::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PutPartnerEventsRequestEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(PutPartnerEventsRequestEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRIES_FIELD));

    private final List<PutPartnerEventsRequestEntry> entries;

    private PutPartnerEventsRequest(BuilderImpl builder) {
        super(builder);
        this.entries = builder.entries;
    }

    /**
     * <p>
     * The list of events to write to the event bus.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of events to write to the event bus.
     */
    public List<PutPartnerEventsRequestEntry> entries() {
        return entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entries());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPartnerEventsRequest)) {
            return false;
        }
        PutPartnerEventsRequest other = (PutPartnerEventsRequest) obj;
        return Objects.equals(entries(), other.entries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutPartnerEventsRequest").add("Entries", entries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entries":
            return Optional.ofNullable(clazz.cast(entries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutPartnerEventsRequest, T> g) {
        return obj -> g.apply((PutPartnerEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutPartnerEventsRequest> {
        /**
         * <p>
         * The list of events to write to the event bus.
         * </p>
         * 
         * @param entries
         *        The list of events to write to the event bus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<PutPartnerEventsRequestEntry> entries);

        /**
         * <p>
         * The list of events to write to the event bus.
         * </p>
         * 
         * @param entries
         *        The list of events to write to the event bus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(PutPartnerEventsRequestEntry... entries);

        /**
         * <p>
         * The list of events to write to the event bus.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PutPartnerEventsRequestEntry>.Builder}
         * avoiding the need to create one manually via {@link List<PutPartnerEventsRequestEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PutPartnerEventsRequestEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #entries(List<PutPartnerEventsRequestEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on {@link List<PutPartnerEventsRequestEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(List<PutPartnerEventsRequestEntry>)
         */
        Builder entries(Consumer<PutPartnerEventsRequestEntry.Builder>... entries);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EventBridgeRequest.BuilderImpl implements Builder {
        private List<PutPartnerEventsRequestEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutPartnerEventsRequest model) {
            super(model);
            entries(model.entries);
        }

        public final Collection<PutPartnerEventsRequestEntry.Builder> getEntries() {
            return entries != null ? entries.stream().map(PutPartnerEventsRequestEntry::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder entries(Collection<PutPartnerEventsRequestEntry> entries) {
            this.entries = PutPartnerEventsRequestEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(PutPartnerEventsRequestEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<PutPartnerEventsRequestEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> PutPartnerEventsRequestEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntries(Collection<PutPartnerEventsRequestEntry.BuilderImpl> entries) {
            this.entries = PutPartnerEventsRequestEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutPartnerEventsRequest build() {
            return new PutPartnerEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
