/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchevents.transform.EcsParametersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The custom parameters to be used when the target is an Amazon ECS cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EcsParameters implements StructuredPojo, ToCopyableBuilder<EcsParameters.Builder, EcsParameters> {
    private final String taskDefinitionArn;

    private final Integer taskCount;

    private EcsParameters(BuilderImpl builder) {
        this.taskDefinitionArn = builder.taskDefinitionArn;
        this.taskCount = builder.taskCount;
    }

    /**
     * <p>
     * The ARN of the task definition to use if the event target is an Amazon ECS cluster.
     * </p>
     * 
     * @return The ARN of the task definition to use if the event target is an Amazon ECS cluster.
     */
    public String taskDefinitionArn() {
        return taskDefinitionArn;
    }

    /**
     * <p>
     * The number of tasks to create based on the <code>TaskDefinition</code>. The default is one.
     * </p>
     * 
     * @return The number of tasks to create based on the <code>TaskDefinition</code>. The default is one.
     */
    public Integer taskCount() {
        return taskCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(taskCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsParameters)) {
            return false;
        }
        EcsParameters other = (EcsParameters) obj;
        return Objects.equals(taskDefinitionArn(), other.taskDefinitionArn()) && Objects.equals(taskCount(), other.taskCount());
    }

    @Override
    public String toString() {
        return ToString.builder("EcsParameters").add("TaskDefinitionArn", taskDefinitionArn()).add("TaskCount", taskCount())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskDefinitionArn":
            return Optional.ofNullable(clazz.cast(taskDefinitionArn()));
        case "TaskCount":
            return Optional.ofNullable(clazz.cast(taskCount()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EcsParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, EcsParameters> {
        /**
         * <p>
         * The ARN of the task definition to use if the event target is an Amazon ECS cluster.
         * </p>
         * 
         * @param taskDefinitionArn
         *        The ARN of the task definition to use if the event target is an Amazon ECS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDefinitionArn(String taskDefinitionArn);

        /**
         * <p>
         * The number of tasks to create based on the <code>TaskDefinition</code>. The default is one.
         * </p>
         * 
         * @param taskCount
         *        The number of tasks to create based on the <code>TaskDefinition</code>. The default is one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskCount(Integer taskCount);
    }

    static final class BuilderImpl implements Builder {
        private String taskDefinitionArn;

        private Integer taskCount;

        private BuilderImpl() {
        }

        private BuilderImpl(EcsParameters model) {
            taskDefinitionArn(model.taskDefinitionArn);
            taskCount(model.taskCount);
        }

        public final String getTaskDefinitionArn() {
            return taskDefinitionArn;
        }

        @Override
        public final Builder taskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
            return this;
        }

        public final void setTaskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
        }

        public final Integer getTaskCount() {
            return taskCount;
        }

        @Override
        public final Builder taskCount(Integer taskCount) {
            this.taskCount = taskCount;
            return this;
        }

        public final void setTaskCount(Integer taskCount) {
            this.taskCount = taskCount;
        }

        @Override
        public EcsParameters build() {
            return new EcsParameters(this);
        }
    }
}
