/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchevents.transform.KinesisParametersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This object enables you to specify a JSON path to extract from the event and use as the partition key for the Amazon
 * Kinesis stream, so that you can control the shard to which the event goes. If you do not include this parameter, the
 * default is to use the <code>eventId</code> as the partition key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisParameters implements StructuredPojo, ToCopyableBuilder<KinesisParameters.Builder, KinesisParameters> {
    private final String partitionKeyPath;

    private KinesisParameters(BuilderImpl builder) {
        this.partitionKeyPath = builder.partitionKeyPath;
    }

    /**
     * <p>
     * The JSON path to be extracted from the event and used as the partition key. For more information, see <a
     * href="http://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key">Amazon Kinesis Streams Key
     * Concepts</a> in the <i>Amazon Kinesis Streams Developer Guide</i>.
     * </p>
     * 
     * @return The JSON path to be extracted from the event and used as the partition key. For more information, see <a
     *         href="http://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key">Amazon Kinesis
     *         Streams Key Concepts</a> in the <i>Amazon Kinesis Streams Developer Guide</i>.
     */
    public String partitionKeyPath() {
        return partitionKeyPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(partitionKeyPath());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisParameters)) {
            return false;
        }
        KinesisParameters other = (KinesisParameters) obj;
        return Objects.equals(partitionKeyPath(), other.partitionKeyPath());
    }

    @Override
    public String toString() {
        return ToString.builder("KinesisParameters").add("PartitionKeyPath", partitionKeyPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PartitionKeyPath":
            return Optional.ofNullable(clazz.cast(partitionKeyPath()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KinesisParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, KinesisParameters> {
        /**
         * <p>
         * The JSON path to be extracted from the event and used as the partition key. For more information, see <a
         * href="http://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key">Amazon Kinesis Streams
         * Key Concepts</a> in the <i>Amazon Kinesis Streams Developer Guide</i>.
         * </p>
         * 
         * @param partitionKeyPath
         *        The JSON path to be extracted from the event and used as the partition key. For more information, see
         *        <a href="http://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key">Amazon Kinesis
         *        Streams Key Concepts</a> in the <i>Amazon Kinesis Streams Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKeyPath(String partitionKeyPath);
    }

    static final class BuilderImpl implements Builder {
        private String partitionKeyPath;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisParameters model) {
            partitionKeyPath(model.partitionKeyPath);
        }

        public final String getPartitionKeyPath() {
            return partitionKeyPath;
        }

        @Override
        public final Builder partitionKeyPath(String partitionKeyPath) {
            this.partitionKeyPath = partitionKeyPath;
            return this;
        }

        public final void setPartitionKeyPath(String partitionKeyPath) {
            this.partitionKeyPath = partitionKeyPath;
        }

        @Override
        public KinesisParameters build() {
            return new KinesisParameters(this);
        }
    }
}
