/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchevents.transform.TargetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Targets are the resources to be invoked when a rule is triggered. Target types include EC2 instances, AWS Lambda
 * functions, Amazon Kinesis streams, Amazon ECS tasks, AWS Step Functions state machines, Run Command, and built-in
 * targets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Target implements StructuredPojo, ToCopyableBuilder<Target.Builder, Target> {
    private final String id;

    private final String arn;

    private final String roleArn;

    private final String input;

    private final String inputPath;

    private final InputTransformer inputTransformer;

    private final KinesisParameters kinesisParameters;

    private final RunCommandParameters runCommandParameters;

    private final EcsParameters ecsParameters;

    private Target(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.roleArn = builder.roleArn;
        this.input = builder.input;
        this.inputPath = builder.inputPath;
        this.inputTransformer = builder.inputTransformer;
        this.kinesisParameters = builder.kinesisParameters;
        this.runCommandParameters = builder.runCommandParameters;
        this.ecsParameters = builder.ecsParameters;
    }

    /**
     * <p>
     * The ID of the target.
     * </p>
     * 
     * @return The ID of the target.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. If one rule
     * triggers multiple targets, you can use a different IAM role for each target.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. If
     *         one rule triggers multiple targets, you can use a different IAM role for each target.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. You
     * must use JSON dot notation, not bracket notation. For more information, see <a
     * href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON) Data Interchange
     * Format</a>.
     * </p>
     * 
     * @return Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the
     *         target. You must use JSON dot notation, not bracket notation. For more information, see <a
     *         href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON) Data Interchange
     *         Format</a>.
     */
    public String input() {
        return input;
    }

    /**
     * <p>
     * The value of the JSONPath that is used for extracting part of the matched event when passing it to the target.
     * You must use JSON dot notation, not bracket notation. For more information about JSON paths, see <a
     * href="http://goessner.net/articles/JsonPath/">JSONPath</a>.
     * </p>
     * 
     * @return The value of the JSONPath that is used for extracting part of the matched event when passing it to the
     *         target. You must use JSON dot notation, not bracket notation. For more information about JSON paths, see
     *         <a href="http://goessner.net/articles/JsonPath/">JSONPath</a>.
     */
    public String inputPath() {
        return inputPath;
    }

    /**
     * <p>
     * Settings to enable you to provide custom input to a target based on certain event data. You can extract one or
     * more key-value pairs from the event and then use that data to send customized input to the target.
     * </p>
     * 
     * @return Settings to enable you to provide custom input to a target based on certain event data. You can extract
     *         one or more key-value pairs from the event and then use that data to send customized input to the target.
     */
    public InputTransformer inputTransformer() {
        return inputTransformer;
    }

    /**
     * <p>
     * The custom parameter you can use to control shard assignment, when the target is an Amazon Kinesis stream. If you
     * do not include this parameter, the default is to use the <code>eventId</code> as the partition key.
     * </p>
     * 
     * @return The custom parameter you can use to control shard assignment, when the target is an Amazon Kinesis
     *         stream. If you do not include this parameter, the default is to use the <code>eventId</code> as the
     *         partition key.
     */
    public KinesisParameters kinesisParameters() {
        return kinesisParameters;
    }

    /**
     * <p>
     * Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
     * </p>
     * 
     * @return Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
     */
    public RunCommandParameters runCommandParameters() {
        return runCommandParameters;
    }

    /**
     * <p>
     * Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS task. For
     * more information about Amazon ECS tasks, see <a
     * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task Definitions </a> in
     * the <i>Amazon EC2 Container Service Developer Guide</i>.
     * </p>
     * 
     * @return Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS
     *         task. For more information about Amazon ECS tasks, see <a
     *         href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task Definitions
     *         </a> in the <i>Amazon EC2 Container Service Developer Guide</i>.
     */
    public EcsParameters ecsParameters() {
        return ecsParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(inputPath());
        hashCode = 31 * hashCode + Objects.hashCode(inputTransformer());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisParameters());
        hashCode = 31 * hashCode + Objects.hashCode(runCommandParameters());
        hashCode = 31 * hashCode + Objects.hashCode(ecsParameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Target)) {
            return false;
        }
        Target other = (Target) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(input(), other.input())
                && Objects.equals(inputPath(), other.inputPath()) && Objects.equals(inputTransformer(), other.inputTransformer())
                && Objects.equals(kinesisParameters(), other.kinesisParameters())
                && Objects.equals(runCommandParameters(), other.runCommandParameters())
                && Objects.equals(ecsParameters(), other.ecsParameters());
    }

    @Override
    public String toString() {
        return ToString.builder("Target").add("Id", id()).add("Arn", arn()).add("RoleArn", roleArn()).add("Input", input())
                .add("InputPath", inputPath()).add("InputTransformer", inputTransformer())
                .add("KinesisParameters", kinesisParameters()).add("RunCommandParameters", runCommandParameters())
                .add("EcsParameters", ecsParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "InputPath":
            return Optional.ofNullable(clazz.cast(inputPath()));
        case "InputTransformer":
            return Optional.ofNullable(clazz.cast(inputTransformer()));
        case "KinesisParameters":
            return Optional.ofNullable(clazz.cast(kinesisParameters()));
        case "RunCommandParameters":
            return Optional.ofNullable(clazz.cast(runCommandParameters()));
        case "EcsParameters":
            return Optional.ofNullable(clazz.cast(ecsParameters()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Target> {
        /**
         * <p>
         * The ID of the target.
         * </p>
         * 
         * @param id
         *        The ID of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. If one
         * rule triggers multiple targets, you can use a different IAM role for each target.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered.
         *        If one rule triggers multiple targets, you can use a different IAM role for each target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target.
         * You must use JSON dot notation, not bracket notation. For more information, see <a
         * href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON) Data Interchange
         * Format</a>.
         * </p>
         * 
         * @param input
         *        Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the
         *        target. You must use JSON dot notation, not bracket notation. For more information, see <a
         *        href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON) Data
         *        Interchange Format</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The value of the JSONPath that is used for extracting part of the matched event when passing it to the
         * target. You must use JSON dot notation, not bracket notation. For more information about JSON paths, see <a
         * href="http://goessner.net/articles/JsonPath/">JSONPath</a>.
         * </p>
         * 
         * @param inputPath
         *        The value of the JSONPath that is used for extracting part of the matched event when passing it to the
         *        target. You must use JSON dot notation, not bracket notation. For more information about JSON paths,
         *        see <a href="http://goessner.net/articles/JsonPath/">JSONPath</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputPath(String inputPath);

        /**
         * <p>
         * Settings to enable you to provide custom input to a target based on certain event data. You can extract one
         * or more key-value pairs from the event and then use that data to send customized input to the target.
         * </p>
         * 
         * @param inputTransformer
         *        Settings to enable you to provide custom input to a target based on certain event data. You can
         *        extract one or more key-value pairs from the event and then use that data to send customized input to
         *        the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputTransformer(InputTransformer inputTransformer);

        /**
         * <p>
         * Settings to enable you to provide custom input to a target based on certain event data. You can extract one
         * or more key-value pairs from the event and then use that data to send customized input to the target.
         * </p>
         * This is a convenience that creates an instance of the {@link InputTransformer.Builder} avoiding the need to
         * create one manually via {@link InputTransformer#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputTransformer.Builder#build()} is called immediately and its
         * result is passed to {@link #inputTransformer(InputTransformer)}.
         * 
         * @param inputTransformer
         *        a consumer that will call methods on {@link InputTransformer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputTransformer(InputTransformer)
         */
        default Builder inputTransformer(Consumer<InputTransformer.Builder> inputTransformer) {
            return inputTransformer(InputTransformer.builder().applyMutation(inputTransformer).build());
        }

        /**
         * <p>
         * The custom parameter you can use to control shard assignment, when the target is an Amazon Kinesis stream. If
         * you do not include this parameter, the default is to use the <code>eventId</code> as the partition key.
         * </p>
         * 
         * @param kinesisParameters
         *        The custom parameter you can use to control shard assignment, when the target is an Amazon Kinesis
         *        stream. If you do not include this parameter, the default is to use the <code>eventId</code> as the
         *        partition key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisParameters(KinesisParameters kinesisParameters);

        /**
         * <p>
         * The custom parameter you can use to control shard assignment, when the target is an Amazon Kinesis stream. If
         * you do not include this parameter, the default is to use the <code>eventId</code> as the partition key.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisParameters.Builder} avoiding the need to
         * create one manually via {@link KinesisParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #kinesisParameters(KinesisParameters)}.
         * 
         * @param kinesisParameters
         *        a consumer that will call methods on {@link KinesisParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisParameters(KinesisParameters)
         */
        default Builder kinesisParameters(Consumer<KinesisParameters.Builder> kinesisParameters) {
            return kinesisParameters(KinesisParameters.builder().applyMutation(kinesisParameters).build());
        }

        /**
         * <p>
         * Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
         * </p>
         * 
         * @param runCommandParameters
         *        Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runCommandParameters(RunCommandParameters runCommandParameters);

        /**
         * <p>
         * Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
         * </p>
         * This is a convenience that creates an instance of the {@link RunCommandParameters.Builder} avoiding the need
         * to create one manually via {@link RunCommandParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link RunCommandParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #runCommandParameters(RunCommandParameters)}.
         * 
         * @param runCommandParameters
         *        a consumer that will call methods on {@link RunCommandParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runCommandParameters(RunCommandParameters)
         */
        default Builder runCommandParameters(Consumer<RunCommandParameters.Builder> runCommandParameters) {
            return runCommandParameters(RunCommandParameters.builder().applyMutation(runCommandParameters).build());
        }

        /**
         * <p>
         * Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS task.
         * For more information about Amazon ECS tasks, see <a
         * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task Definitions </a>
         * in the <i>Amazon EC2 Container Service Developer Guide</i>.
         * </p>
         * 
         * @param ecsParameters
         *        Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon
         *        ECS task. For more information about Amazon ECS tasks, see <a
         *        href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task
         *        Definitions </a> in the <i>Amazon EC2 Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsParameters(EcsParameters ecsParameters);

        /**
         * <p>
         * Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS task.
         * For more information about Amazon ECS tasks, see <a
         * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task Definitions </a>
         * in the <i>Amazon EC2 Container Service Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link EcsParameters.Builder} avoiding the need to
         * create one manually via {@link EcsParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link EcsParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #ecsParameters(EcsParameters)}.
         * 
         * @param ecsParameters
         *        a consumer that will call methods on {@link EcsParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecsParameters(EcsParameters)
         */
        default Builder ecsParameters(Consumer<EcsParameters.Builder> ecsParameters) {
            return ecsParameters(EcsParameters.builder().applyMutation(ecsParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String roleArn;

        private String input;

        private String inputPath;

        private InputTransformer inputTransformer;

        private KinesisParameters kinesisParameters;

        private RunCommandParameters runCommandParameters;

        private EcsParameters ecsParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(Target model) {
            id(model.id);
            arn(model.arn);
            roleArn(model.roleArn);
            input(model.input);
            inputPath(model.inputPath);
            inputTransformer(model.inputTransformer);
            kinesisParameters(model.kinesisParameters);
            runCommandParameters(model.runCommandParameters);
            ecsParameters(model.ecsParameters);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getInputPath() {
            return inputPath;
        }

        @Override
        public final Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public final void setInputPath(String inputPath) {
            this.inputPath = inputPath;
        }

        public final InputTransformer.Builder getInputTransformer() {
            return inputTransformer != null ? inputTransformer.toBuilder() : null;
        }

        @Override
        public final Builder inputTransformer(InputTransformer inputTransformer) {
            this.inputTransformer = inputTransformer;
            return this;
        }

        public final void setInputTransformer(InputTransformer.BuilderImpl inputTransformer) {
            this.inputTransformer = inputTransformer != null ? inputTransformer.build() : null;
        }

        public final KinesisParameters.Builder getKinesisParameters() {
            return kinesisParameters != null ? kinesisParameters.toBuilder() : null;
        }

        @Override
        public final Builder kinesisParameters(KinesisParameters kinesisParameters) {
            this.kinesisParameters = kinesisParameters;
            return this;
        }

        public final void setKinesisParameters(KinesisParameters.BuilderImpl kinesisParameters) {
            this.kinesisParameters = kinesisParameters != null ? kinesisParameters.build() : null;
        }

        public final RunCommandParameters.Builder getRunCommandParameters() {
            return runCommandParameters != null ? runCommandParameters.toBuilder() : null;
        }

        @Override
        public final Builder runCommandParameters(RunCommandParameters runCommandParameters) {
            this.runCommandParameters = runCommandParameters;
            return this;
        }

        public final void setRunCommandParameters(RunCommandParameters.BuilderImpl runCommandParameters) {
            this.runCommandParameters = runCommandParameters != null ? runCommandParameters.build() : null;
        }

        public final EcsParameters.Builder getEcsParameters() {
            return ecsParameters != null ? ecsParameters.toBuilder() : null;
        }

        @Override
        public final Builder ecsParameters(EcsParameters ecsParameters) {
            this.ecsParameters = ecsParameters;
            return this;
        }

        public final void setEcsParameters(EcsParameters.BuilderImpl ecsParameters) {
            this.ecsParameters = ecsParameters != null ? ecsParameters.build() : null;
        }

        @Override
        public Target build() {
            return new Target(this);
        }
    }
}
