/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains information about the start and end times of the launch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchExecution implements SdkPojo, Serializable, ToCopyableBuilder<LaunchExecution.Builder, LaunchExecution> {
    private static final SdkField<Instant> ENDED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedTime").getter(getter(LaunchExecution::endedTime)).setter(setter(Builder::endedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedTime").build()).build();

    private static final SdkField<Instant> STARTED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedTime").getter(getter(LaunchExecution::startedTime)).setter(setter(Builder::startedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDED_TIME_FIELD,
            STARTED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant endedTime;

    private final Instant startedTime;

    private LaunchExecution(BuilderImpl builder) {
        this.endedTime = builder.endedTime;
        this.startedTime = builder.startedTime;
    }

    /**
     * <p>
     * The date and time that the launch ended.
     * </p>
     * 
     * @return The date and time that the launch ended.
     */
    public final Instant endedTime() {
        return endedTime;
    }

    /**
     * <p>
     * The date and time that the launch started.
     * </p>
     * 
     * @return The date and time that the launch started.
     */
    public final Instant startedTime() {
        return startedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endedTime());
        hashCode = 31 * hashCode + Objects.hashCode(startedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchExecution)) {
            return false;
        }
        LaunchExecution other = (LaunchExecution) obj;
        return Objects.equals(endedTime(), other.endedTime()) && Objects.equals(startedTime(), other.startedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchExecution").add("EndedTime", endedTime()).add("StartedTime", startedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endedTime":
            return Optional.ofNullable(clazz.cast(endedTime()));
        case "startedTime":
            return Optional.ofNullable(clazz.cast(startedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchExecution, T> g) {
        return obj -> g.apply((LaunchExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchExecution> {
        /**
         * <p>
         * The date and time that the launch ended.
         * </p>
         * 
         * @param endedTime
         *        The date and time that the launch ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedTime(Instant endedTime);

        /**
         * <p>
         * The date and time that the launch started.
         * </p>
         * 
         * @param startedTime
         *        The date and time that the launch started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedTime(Instant startedTime);
    }

    static final class BuilderImpl implements Builder {
        private Instant endedTime;

        private Instant startedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchExecution model) {
            endedTime(model.endedTime);
            startedTime(model.startedTime);
        }

        public final Instant getEndedTime() {
            return endedTime;
        }

        public final void setEndedTime(Instant endedTime) {
            this.endedTime = endedTime;
        }

        @Override
        @Transient
        public final Builder endedTime(Instant endedTime) {
            this.endedTime = endedTime;
            return this;
        }

        public final Instant getStartedTime() {
            return startedTime;
        }

        public final void setStartedTime(Instant startedTime) {
            this.startedTime = startedTime;
        }

        @Override
        @Transient
        public final Builder startedTime(Instant startedTime) {
            this.startedTime = startedTime;
            return this;
        }

        @Override
        public LaunchExecution build() {
            return new LaunchExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
