/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class PutProjectEventsResultEntryListCopier {
    static List<PutProjectEventsResultEntry> copy(
            Collection<? extends PutProjectEventsResultEntry> putProjectEventsResultEntryListParam) {
        List<PutProjectEventsResultEntry> list;
        if (putProjectEventsResultEntryListParam == null || putProjectEventsResultEntryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PutProjectEventsResultEntry> modifiableList = new ArrayList<>();
            putProjectEventsResultEntryListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<PutProjectEventsResultEntry> copyFromBuilder(
            Collection<? extends PutProjectEventsResultEntry.Builder> putProjectEventsResultEntryListParam) {
        List<PutProjectEventsResultEntry> list;
        if (putProjectEventsResultEntryListParam == null || putProjectEventsResultEntryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PutProjectEventsResultEntry> modifiableList = new ArrayList<>();
            putProjectEventsResultEntryListParam.forEach(entry -> {
                PutProjectEventsResultEntry member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<PutProjectEventsResultEntry.Builder> copyToBuilder(
            Collection<? extends PutProjectEventsResultEntry> putProjectEventsResultEntryListParam) {
        List<PutProjectEventsResultEntry.Builder> list;
        if (putProjectEventsResultEntryListParam == null || putProjectEventsResultEntryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PutProjectEventsResultEntry.Builder> modifiableList = new ArrayList<>();
            putProjectEventsResultEntryListParam.forEach(entry -> {
                PutProjectEventsResultEntry.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
