/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLaunchResponse extends EvidentlyResponse implements
        ToCopyableBuilder<UpdateLaunchResponse.Builder, UpdateLaunchResponse> {
    private static final SdkField<Launch> LAUNCH_FIELD = SdkField.<Launch> builder(MarshallingType.SDK_POJO).memberName("launch")
            .getter(getter(UpdateLaunchResponse::launch)).setter(setter(Builder::launch)).constructor(Launch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_FIELD));

    private final Launch launch;

    private UpdateLaunchResponse(BuilderImpl builder) {
        super(builder);
        this.launch = builder.launch;
    }

    /**
     * <p>
     * A structure that contains the new configuration of the launch that was updated.
     * </p>
     * 
     * @return A structure that contains the new configuration of the launch that was updated.
     */
    public final Launch launch() {
        return launch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(launch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLaunchResponse)) {
            return false;
        }
        UpdateLaunchResponse other = (UpdateLaunchResponse) obj;
        return Objects.equals(launch(), other.launch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLaunchResponse").add("Launch", launch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "launch":
            return Optional.ofNullable(clazz.cast(launch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLaunchResponse, T> g) {
        return obj -> g.apply((UpdateLaunchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EvidentlyResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLaunchResponse> {
        /**
         * <p>
         * A structure that contains the new configuration of the launch that was updated.
         * </p>
         * 
         * @param launch
         *        A structure that contains the new configuration of the launch that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launch(Launch launch);

        /**
         * <p>
         * A structure that contains the new configuration of the launch that was updated.
         * </p>
         * This is a convenience that creates an instance of the {@link Launch.Builder} avoiding the need to create one
         * manually via {@link Launch#builder()}.
         *
         * When the {@link Consumer} completes, {@link Launch.Builder#build()} is called immediately and its result is
         * passed to {@link #launch(Launch)}.
         * 
         * @param launch
         *        a consumer that will call methods on {@link Launch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launch(Launch)
         */
        default Builder launch(Consumer<Launch.Builder> launch) {
            return launch(Launch.builder().applyMutation(launch).build());
        }
    }

    static final class BuilderImpl extends EvidentlyResponse.BuilderImpl implements Builder {
        private Launch launch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLaunchResponse model) {
            super(model);
            launch(model.launch);
        }

        public final Launch.Builder getLaunch() {
            return launch != null ? launch.toBuilder() : null;
        }

        public final void setLaunch(Launch.BuilderImpl launch) {
            this.launch = launch != null ? launch.build() : null;
        }

        @Override
        @Transient
        public final Builder launch(Launch launch) {
            this.launch = launch;
            return this;
        }

        @Override
        public UpdateLaunchResponse build() {
            return new UpdateLaunchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
