/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value assigned to a feature variation. This structure must contain exactly one field. It can be
 * <code>boolValue</code>, <code>doubleValue</code>, <code>longValue</code>, or <code>stringValue</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VariableValue implements SdkPojo, Serializable, ToCopyableBuilder<VariableValue.Builder, VariableValue> {
    private static final SdkField<Boolean> BOOL_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("boolValue").getter(getter(VariableValue::boolValue)).setter(setter(Builder::boolValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boolValue").build()).build();

    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("doubleValue").getter(getter(VariableValue::doubleValue)).setter(setter(Builder::doubleValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()).build();

    private static final SdkField<Long> LONG_VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("longValue")
            .getter(getter(VariableValue::longValue)).setter(setter(Builder::longValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longValue").build()).build();

    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stringValue").getter(getter(VariableValue::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOL_VALUE_FIELD,
            DOUBLE_VALUE_FIELD, LONG_VALUE_FIELD, STRING_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean boolValue;

    private final Double doubleValue;

    private final Long longValue;

    private final String stringValue;

    private VariableValue(BuilderImpl builder) {
        this.boolValue = builder.boolValue;
        this.doubleValue = builder.doubleValue;
        this.longValue = builder.longValue;
        this.stringValue = builder.stringValue;
    }

    /**
     * <p>
     * If this feature uses the Boolean variation type, this field contains the Boolean value of this variation.
     * </p>
     * 
     * @return If this feature uses the Boolean variation type, this field contains the Boolean value of this variation.
     */
    public final Boolean boolValue() {
        return boolValue;
    }

    /**
     * <p>
     * If this feature uses the double integer variation type, this field contains the double integer value of this
     * variation.
     * </p>
     * 
     * @return If this feature uses the double integer variation type, this field contains the double integer value of
     *         this variation.
     */
    public final Double doubleValue() {
        return doubleValue;
    }

    /**
     * <p>
     * If this feature uses the long variation type, this field contains the long value of this variation.
     * </p>
     * 
     * @return If this feature uses the long variation type, this field contains the long value of this variation.
     */
    public final Long longValue() {
        return longValue;
    }

    /**
     * <p>
     * If this feature uses the string variation type, this field contains the string value of this variation.
     * </p>
     * 
     * @return If this feature uses the string variation type, this field contains the string value of this variation.
     */
    public final String stringValue() {
        return stringValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(boolValue());
        hashCode = 31 * hashCode + Objects.hashCode(doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(longValue());
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableValue)) {
            return false;
        }
        VariableValue other = (VariableValue) obj;
        return Objects.equals(boolValue(), other.boolValue()) && Objects.equals(doubleValue(), other.doubleValue())
                && Objects.equals(longValue(), other.longValue()) && Objects.equals(stringValue(), other.stringValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VariableValue").add("BoolValue", boolValue()).add("DoubleValue", doubleValue())
                .add("LongValue", longValue()).add("StringValue", stringValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "boolValue":
            return Optional.ofNullable(clazz.cast(boolValue()));
        case "doubleValue":
            return Optional.ofNullable(clazz.cast(doubleValue()));
        case "longValue":
            return Optional.ofNullable(clazz.cast(longValue()));
        case "stringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VariableValue, T> g) {
        return obj -> g.apply((VariableValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VariableValue> {
        /**
         * <p>
         * If this feature uses the Boolean variation type, this field contains the Boolean value of this variation.
         * </p>
         * 
         * @param boolValue
         *        If this feature uses the Boolean variation type, this field contains the Boolean value of this
         *        variation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boolValue(Boolean boolValue);

        /**
         * <p>
         * If this feature uses the double integer variation type, this field contains the double integer value of this
         * variation.
         * </p>
         * 
         * @param doubleValue
         *        If this feature uses the double integer variation type, this field contains the double integer value
         *        of this variation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValue(Double doubleValue);

        /**
         * <p>
         * If this feature uses the long variation type, this field contains the long value of this variation.
         * </p>
         * 
         * @param longValue
         *        If this feature uses the long variation type, this field contains the long value of this variation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longValue(Long longValue);

        /**
         * <p>
         * If this feature uses the string variation type, this field contains the string value of this variation.
         * </p>
         * 
         * @param stringValue
         *        If this feature uses the string variation type, this field contains the string value of this
         *        variation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);
    }

    static final class BuilderImpl implements Builder {
        private Boolean boolValue;

        private Double doubleValue;

        private Long longValue;

        private String stringValue;

        private BuilderImpl() {
        }

        private BuilderImpl(VariableValue model) {
            boolValue(model.boolValue);
            doubleValue(model.doubleValue);
            longValue(model.longValue);
            stringValue(model.stringValue);
        }

        public final Boolean getBoolValue() {
            return boolValue;
        }

        public final void setBoolValue(Boolean boolValue) {
            this.boolValue = boolValue;
        }

        @Override
        @Transient
        public final Builder boolValue(Boolean boolValue) {
            this.boolValue = boolValue;
            return this;
        }

        public final Double getDoubleValue() {
            return doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
        }

        @Override
        @Transient
        public final Builder doubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
            return this;
        }

        public final Long getLongValue() {
            return longValue;
        }

        public final void setLongValue(Long longValue) {
            this.longValue = longValue;
        }

        @Override
        @Transient
        public final Builder longValue(Long longValue) {
            this.longValue = longValue;
            return this;
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        @Override
        @Transient
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        @Override
        public VariableValue build() {
            return new VariableValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
