/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.evidently.model.AccessDeniedException;
import software.amazon.awssdk.services.evidently.model.BatchEvaluateFeatureRequest;
import software.amazon.awssdk.services.evidently.model.BatchEvaluateFeatureResponse;
import software.amazon.awssdk.services.evidently.model.ConflictException;
import software.amazon.awssdk.services.evidently.model.CreateExperimentRequest;
import software.amazon.awssdk.services.evidently.model.CreateExperimentResponse;
import software.amazon.awssdk.services.evidently.model.CreateFeatureRequest;
import software.amazon.awssdk.services.evidently.model.CreateFeatureResponse;
import software.amazon.awssdk.services.evidently.model.CreateLaunchRequest;
import software.amazon.awssdk.services.evidently.model.CreateLaunchResponse;
import software.amazon.awssdk.services.evidently.model.CreateProjectRequest;
import software.amazon.awssdk.services.evidently.model.CreateProjectResponse;
import software.amazon.awssdk.services.evidently.model.DeleteExperimentRequest;
import software.amazon.awssdk.services.evidently.model.DeleteExperimentResponse;
import software.amazon.awssdk.services.evidently.model.DeleteFeatureRequest;
import software.amazon.awssdk.services.evidently.model.DeleteFeatureResponse;
import software.amazon.awssdk.services.evidently.model.DeleteLaunchRequest;
import software.amazon.awssdk.services.evidently.model.DeleteLaunchResponse;
import software.amazon.awssdk.services.evidently.model.DeleteProjectRequest;
import software.amazon.awssdk.services.evidently.model.DeleteProjectResponse;
import software.amazon.awssdk.services.evidently.model.EvaluateFeatureRequest;
import software.amazon.awssdk.services.evidently.model.EvaluateFeatureResponse;
import software.amazon.awssdk.services.evidently.model.EvidentlyException;
import software.amazon.awssdk.services.evidently.model.GetExperimentRequest;
import software.amazon.awssdk.services.evidently.model.GetExperimentResponse;
import software.amazon.awssdk.services.evidently.model.GetExperimentResultsRequest;
import software.amazon.awssdk.services.evidently.model.GetExperimentResultsResponse;
import software.amazon.awssdk.services.evidently.model.GetFeatureRequest;
import software.amazon.awssdk.services.evidently.model.GetFeatureResponse;
import software.amazon.awssdk.services.evidently.model.GetLaunchRequest;
import software.amazon.awssdk.services.evidently.model.GetLaunchResponse;
import software.amazon.awssdk.services.evidently.model.GetProjectRequest;
import software.amazon.awssdk.services.evidently.model.GetProjectResponse;
import software.amazon.awssdk.services.evidently.model.InternalServerException;
import software.amazon.awssdk.services.evidently.model.ListExperimentsRequest;
import software.amazon.awssdk.services.evidently.model.ListExperimentsResponse;
import software.amazon.awssdk.services.evidently.model.ListFeaturesRequest;
import software.amazon.awssdk.services.evidently.model.ListFeaturesResponse;
import software.amazon.awssdk.services.evidently.model.ListLaunchesRequest;
import software.amazon.awssdk.services.evidently.model.ListLaunchesResponse;
import software.amazon.awssdk.services.evidently.model.ListProjectsRequest;
import software.amazon.awssdk.services.evidently.model.ListProjectsResponse;
import software.amazon.awssdk.services.evidently.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.evidently.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.evidently.model.PutProjectEventsRequest;
import software.amazon.awssdk.services.evidently.model.PutProjectEventsResponse;
import software.amazon.awssdk.services.evidently.model.ResourceNotFoundException;
import software.amazon.awssdk.services.evidently.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.evidently.model.ServiceUnavailableException;
import software.amazon.awssdk.services.evidently.model.StartExperimentRequest;
import software.amazon.awssdk.services.evidently.model.StartExperimentResponse;
import software.amazon.awssdk.services.evidently.model.StartLaunchRequest;
import software.amazon.awssdk.services.evidently.model.StartLaunchResponse;
import software.amazon.awssdk.services.evidently.model.StopExperimentRequest;
import software.amazon.awssdk.services.evidently.model.StopExperimentResponse;
import software.amazon.awssdk.services.evidently.model.StopLaunchRequest;
import software.amazon.awssdk.services.evidently.model.StopLaunchResponse;
import software.amazon.awssdk.services.evidently.model.TagResourceRequest;
import software.amazon.awssdk.services.evidently.model.TagResourceResponse;
import software.amazon.awssdk.services.evidently.model.ThrottlingException;
import software.amazon.awssdk.services.evidently.model.UntagResourceRequest;
import software.amazon.awssdk.services.evidently.model.UntagResourceResponse;
import software.amazon.awssdk.services.evidently.model.UpdateExperimentRequest;
import software.amazon.awssdk.services.evidently.model.UpdateExperimentResponse;
import software.amazon.awssdk.services.evidently.model.UpdateFeatureRequest;
import software.amazon.awssdk.services.evidently.model.UpdateFeatureResponse;
import software.amazon.awssdk.services.evidently.model.UpdateLaunchRequest;
import software.amazon.awssdk.services.evidently.model.UpdateLaunchResponse;
import software.amazon.awssdk.services.evidently.model.UpdateProjectDataDeliveryRequest;
import software.amazon.awssdk.services.evidently.model.UpdateProjectDataDeliveryResponse;
import software.amazon.awssdk.services.evidently.model.UpdateProjectRequest;
import software.amazon.awssdk.services.evidently.model.UpdateProjectResponse;
import software.amazon.awssdk.services.evidently.model.ValidationException;
import software.amazon.awssdk.services.evidently.paginators.ListExperimentsIterable;
import software.amazon.awssdk.services.evidently.paginators.ListFeaturesIterable;
import software.amazon.awssdk.services.evidently.paginators.ListLaunchesIterable;
import software.amazon.awssdk.services.evidently.paginators.ListProjectsIterable;

/**
 * Service client for accessing Amazon CloudWatch Evidently. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * You can use Amazon CloudWatch Evidently to safely validate new features by serving them to a specified percentage of
 * your users while you roll out the feature. You can monitor the performance of the new feature to help you decide when
 * to ramp up traffic to your users. This helps you reduce risk and identify unintended consequences before you fully
 * launch the feature.
 * </p>
 * <p>
 * You can also conduct A/B experiments to make feature design decisions based on evidence and data. An experiment can
 * test as many as five variations at once. Evidently collects experiment data and analyzes it using statistical
 * methods. It also provides clear recommendations about which variations perform better. You can test both user-facing
 * features and backend features.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface EvidentlyClient extends SdkClient {
    String SERVICE_NAME = "evidently";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "evidently";

    /**
     * Create a {@link EvidentlyClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static EvidentlyClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link EvidentlyClient}.
     */
    static EvidentlyClientBuilder builder() {
        return new DefaultEvidentlyClientBuilder();
    }

    /**
     * <p>
     * This operation assigns feature variation to user sessions. For each user session, you pass in an
     * <code>entityID</code> that represents the user. Evidently then checks the evaluation rules and assigns the
     * variation.
     * </p>
     * <p>
     * The first rules that are evaluated are the override rules. If the user's <code>entityID</code> matches an
     * override rule, the user is served the variation specified by that rule.
     * </p>
     * <p>
     * Next, if there is a launch of the feature, the user might be assigned to a variation in the launch. The chance of
     * this depends on the percentage of users that are allocated to that launch. If the user is enrolled in the launch,
     * the variation they are served depends on the allocation of the various feature variations used for the launch.
     * </p>
     * <p>
     * If the user is not assigned to a launch, and there is an ongoing experiment for this feature, the user might be
     * assigned to a variation in the experiment. The chance of this depends on the percentage of users that are
     * allocated to that experiment. If the user is enrolled in the experiment, the variation they are served depends on
     * the allocation of the various feature variations used for the experiment.
     * </p>
     * <p>
     * If the user is not assigned to a launch or experiment, they are served the default variation.
     * </p>
     *
     * @param batchEvaluateFeatureRequest
     * @return Result of the BatchEvaluateFeature operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.BatchEvaluateFeature
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/BatchEvaluateFeature"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchEvaluateFeatureResponse batchEvaluateFeature(BatchEvaluateFeatureRequest batchEvaluateFeatureRequest)
            throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation assigns feature variation to user sessions. For each user session, you pass in an
     * <code>entityID</code> that represents the user. Evidently then checks the evaluation rules and assigns the
     * variation.
     * </p>
     * <p>
     * The first rules that are evaluated are the override rules. If the user's <code>entityID</code> matches an
     * override rule, the user is served the variation specified by that rule.
     * </p>
     * <p>
     * Next, if there is a launch of the feature, the user might be assigned to a variation in the launch. The chance of
     * this depends on the percentage of users that are allocated to that launch. If the user is enrolled in the launch,
     * the variation they are served depends on the allocation of the various feature variations used for the launch.
     * </p>
     * <p>
     * If the user is not assigned to a launch, and there is an ongoing experiment for this feature, the user might be
     * assigned to a variation in the experiment. The chance of this depends on the percentage of users that are
     * allocated to that experiment. If the user is enrolled in the experiment, the variation they are served depends on
     * the allocation of the various feature variations used for the experiment.
     * </p>
     * <p>
     * If the user is not assigned to a launch or experiment, they are served the default variation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchEvaluateFeatureRequest.Builder} avoiding the
     * need to create one manually via {@link BatchEvaluateFeatureRequest#builder()}
     * </p>
     *
     * @param batchEvaluateFeatureRequest
     *        A {@link Consumer} that will call methods on {@link BatchEvaluateFeatureRequest.Builder} to create a
     *        request.
     * @return Result of the BatchEvaluateFeature operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.BatchEvaluateFeature
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/BatchEvaluateFeature"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchEvaluateFeatureResponse batchEvaluateFeature(
            Consumer<BatchEvaluateFeatureRequest.Builder> batchEvaluateFeatureRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            EvidentlyException {
        return batchEvaluateFeature(BatchEvaluateFeatureRequest.builder().applyMutation(batchEvaluateFeatureRequest).build());
    }

    /**
     * <p>
     * Creates an Evidently <i>experiment</i>. Before you create an experiment, you must create the feature to use for
     * the experiment.
     * </p>
     * <p>
     * An experiment helps you make feature design decisions based on evidence and data. An experiment can test as many
     * as five variations at once. Evidently collects experiment data and analyzes it by statistical methods, and
     * provides clear recommendations about which variations perform better.
     * </p>
     * <p>
     * Don't use this operation to update an existing experiment. Instead, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateExperiment.html"
     * >UpdateExperiment</a>.
     * </p>
     *
     * @param createExperimentRequest
     * @return Result of the CreateExperiment operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.CreateExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/CreateExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateExperimentResponse createExperiment(CreateExperimentRequest createExperimentRequest)
            throws ValidationException, ConflictException, ServiceQuotaExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Evidently <i>experiment</i>. Before you create an experiment, you must create the feature to use for
     * the experiment.
     * </p>
     * <p>
     * An experiment helps you make feature design decisions based on evidence and data. An experiment can test as many
     * as five variations at once. Evidently collects experiment data and analyzes it by statistical methods, and
     * provides clear recommendations about which variations perform better.
     * </p>
     * <p>
     * Don't use this operation to update an existing experiment. Instead, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateExperiment.html"
     * >UpdateExperiment</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExperimentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateExperimentRequest#builder()}
     * </p>
     *
     * @param createExperimentRequest
     *        A {@link Consumer} that will call methods on {@link CreateExperimentRequest.Builder} to create a request.
     * @return Result of the CreateExperiment operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.CreateExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/CreateExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateExperimentResponse createExperiment(Consumer<CreateExperimentRequest.Builder> createExperimentRequest)
            throws ValidationException, ConflictException, ServiceQuotaExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        return createExperiment(CreateExperimentRequest.builder().applyMutation(createExperimentRequest).build());
    }

    /**
     * <p>
     * Creates an Evidently <i>feature</i> that you want to launch or test. You can define up to five variations of a
     * feature, and use these variations in your launches and experiments. A feature must be created in a project. For
     * information about creating a project, see <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateProject.html"
     * >CreateProject</a>.
     * </p>
     * <p>
     * Don't use this operation to update an existing feature. Instead, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateFeature.html"
     * >UpdateFeature</a>.
     * </p>
     *
     * @param createFeatureRequest
     * @return Result of the CreateFeature operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.CreateFeature
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/CreateFeature" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFeatureResponse createFeature(CreateFeatureRequest createFeatureRequest) throws ValidationException,
            ConflictException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Evidently <i>feature</i> that you want to launch or test. You can define up to five variations of a
     * feature, and use these variations in your launches and experiments. A feature must be created in a project. For
     * information about creating a project, see <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateProject.html"
     * >CreateProject</a>.
     * </p>
     * <p>
     * Don't use this operation to update an existing feature. Instead, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateFeature.html"
     * >UpdateFeature</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFeatureRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFeatureRequest#builder()}
     * </p>
     *
     * @param createFeatureRequest
     *        A {@link Consumer} that will call methods on {@link CreateFeatureRequest.Builder} to create a request.
     * @return Result of the CreateFeature operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.CreateFeature
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/CreateFeature" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFeatureResponse createFeature(Consumer<CreateFeatureRequest.Builder> createFeatureRequest)
            throws ValidationException, ConflictException, ServiceQuotaExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        return createFeature(CreateFeatureRequest.builder().applyMutation(createFeatureRequest).build());
    }

    /**
     * <p>
     * Creates a <i>launch</i> of a given feature. Before you create a launch, you must create the feature to use for
     * the launch.
     * </p>
     * <p>
     * You can use a launch to safely validate new features by serving them to a specified percentage of your users
     * while you roll out the feature. You can monitor the performance of the new feature to help you decide when to
     * ramp up traffic to more users. This helps you reduce risk and identify unintended consequences before you fully
     * launch the feature.
     * </p>
     * <p>
     * Don't use this operation to update an existing launch. Instead, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateLaunch.html"
     * >UpdateLaunch</a>.
     * </p>
     *
     * @param createLaunchRequest
     * @return Result of the CreateLaunch operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.CreateLaunch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/CreateLaunch" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLaunchResponse createLaunch(CreateLaunchRequest createLaunchRequest) throws ValidationException,
            ConflictException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <i>launch</i> of a given feature. Before you create a launch, you must create the feature to use for
     * the launch.
     * </p>
     * <p>
     * You can use a launch to safely validate new features by serving them to a specified percentage of your users
     * while you roll out the feature. You can monitor the performance of the new feature to help you decide when to
     * ramp up traffic to more users. This helps you reduce risk and identify unintended consequences before you fully
     * launch the feature.
     * </p>
     * <p>
     * Don't use this operation to update an existing launch. Instead, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateLaunch.html"
     * >UpdateLaunch</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLaunchRequest.Builder} avoiding the need to
     * create one manually via {@link CreateLaunchRequest#builder()}
     * </p>
     *
     * @param createLaunchRequest
     *        A {@link Consumer} that will call methods on {@link CreateLaunchRequest.Builder} to create a request.
     * @return Result of the CreateLaunch operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.CreateLaunch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/CreateLaunch" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLaunchResponse createLaunch(Consumer<CreateLaunchRequest.Builder> createLaunchRequest)
            throws ValidationException, ConflictException, ServiceQuotaExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        return createLaunch(CreateLaunchRequest.builder().applyMutation(createLaunchRequest).build());
    }

    /**
     * <p>
     * Creates a project, which is the logical object in Evidently that can contain features, launches, and experiments.
     * Use projects to group similar features together.
     * </p>
     * <p>
     * To update an existing project, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateProject.html"
     * >UpdateProject</a>.
     * </p>
     *
     * @param createProjectRequest
     * @return Result of the CreateProject operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws ValidationException,
            ConflictException, ServiceQuotaExceededException, AccessDeniedException, AwsServiceException, SdkClientException,
            EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a project, which is the logical object in Evidently that can contain features, launches, and experiments.
     * Use projects to group similar features together.
     * </p>
     * <p>
     * To update an existing project, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateProject.html"
     * >UpdateProject</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProjectRequest#builder()}
     * </p>
     *
     * @param createProjectRequest
     *        A {@link Consumer} that will call methods on {@link CreateProjectRequest.Builder} to create a request.
     * @return Result of the CreateProject operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProjectResponse createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest)
            throws ValidationException, ConflictException, ServiceQuotaExceededException, AccessDeniedException,
            AwsServiceException, SdkClientException, EvidentlyException {
        return createProject(CreateProjectRequest.builder().applyMutation(createProjectRequest).build());
    }

    /**
     * <p>
     * Deletes an Evidently experiment. The feature used for the experiment is not deleted.
     * </p>
     * <p>
     * To stop an experiment without deleting it, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StopExperiment.html"
     * >StopExperiment</a>.
     * </p>
     *
     * @param deleteExperimentRequest
     * @return Result of the DeleteExperiment operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceUnavailableException
     *         The service was unavailable. Retry the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.DeleteExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/DeleteExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteExperimentResponse deleteExperiment(DeleteExperimentRequest deleteExperimentRequest)
            throws ValidationException, InternalServerException, ConflictException, ServiceUnavailableException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Evidently experiment. The feature used for the experiment is not deleted.
     * </p>
     * <p>
     * To stop an experiment without deleting it, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StopExperiment.html"
     * >StopExperiment</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteExperimentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteExperimentRequest#builder()}
     * </p>
     *
     * @param deleteExperimentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteExperimentRequest.Builder} to create a request.
     * @return Result of the DeleteExperiment operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceUnavailableException
     *         The service was unavailable. Retry the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.DeleteExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/DeleteExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteExperimentResponse deleteExperiment(Consumer<DeleteExperimentRequest.Builder> deleteExperimentRequest)
            throws ValidationException, InternalServerException, ConflictException, ServiceUnavailableException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        return deleteExperiment(DeleteExperimentRequest.builder().applyMutation(deleteExperimentRequest).build());
    }

    /**
     * <p>
     * Deletes an Evidently feature.
     * </p>
     *
     * @param deleteFeatureRequest
     * @return Result of the DeleteFeature operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.DeleteFeature
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/DeleteFeature" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFeatureResponse deleteFeature(DeleteFeatureRequest deleteFeatureRequest) throws ThrottlingException,
            ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Evidently feature.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFeatureRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFeatureRequest#builder()}
     * </p>
     *
     * @param deleteFeatureRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFeatureRequest.Builder} to create a request.
     * @return Result of the DeleteFeature operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.DeleteFeature
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/DeleteFeature" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFeatureResponse deleteFeature(Consumer<DeleteFeatureRequest.Builder> deleteFeatureRequest)
            throws ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, EvidentlyException {
        return deleteFeature(DeleteFeatureRequest.builder().applyMutation(deleteFeatureRequest).build());
    }

    /**
     * <p>
     * Deletes an Evidently launch. The feature used for the launch is not deleted.
     * </p>
     * <p>
     * To stop a launch without deleting it, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StopLaunch.html">StopLaunch</a>.
     * </p>
     *
     * @param deleteLaunchRequest
     * @return Result of the DeleteLaunch operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.DeleteLaunch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/DeleteLaunch" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLaunchResponse deleteLaunch(DeleteLaunchRequest deleteLaunchRequest) throws ThrottlingException,
            ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Evidently launch. The feature used for the launch is not deleted.
     * </p>
     * <p>
     * To stop a launch without deleting it, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StopLaunch.html">StopLaunch</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLaunchRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLaunchRequest#builder()}
     * </p>
     *
     * @param deleteLaunchRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLaunchRequest.Builder} to create a request.
     * @return Result of the DeleteLaunch operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.DeleteLaunch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/DeleteLaunch" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLaunchResponse deleteLaunch(Consumer<DeleteLaunchRequest.Builder> deleteLaunchRequest)
            throws ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, EvidentlyException {
        return deleteLaunch(DeleteLaunchRequest.builder().applyMutation(deleteLaunchRequest).build());
    }

    /**
     * <p>
     * Deletes an Evidently project. Before you can delete a project, you must delete all the features that the project
     * contains. To delete a feature, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_DeleteFeature.html"
     * >DeleteFeature</a>.
     * </p>
     *
     * @param deleteProjectRequest
     * @return Result of the DeleteProject operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws ThrottlingException,
            ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Evidently project. Before you can delete a project, you must delete all the features that the project
     * contains. To delete a feature, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_DeleteFeature.html"
     * >DeleteFeature</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProjectRequest#builder()}
     * </p>
     *
     * @param deleteProjectRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProjectRequest.Builder} to create a request.
     * @return Result of the DeleteProject operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProjectResponse deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest)
            throws ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, EvidentlyException {
        return deleteProject(DeleteProjectRequest.builder().applyMutation(deleteProjectRequest).build());
    }

    /**
     * <p>
     * This operation assigns a feature variation to one given user session. You pass in an <code>entityID</code> that
     * represents the user. Evidently then checks the evaluation rules and assigns the variation.
     * </p>
     * <p>
     * The first rules that are evaluated are the override rules. If the user's <code>entityID</code> matches an
     * override rule, the user is served the variation specified by that rule.
     * </p>
     * <p>
     * Next, if there is a launch of the feature, the user might be assigned to a variation in the launch. The chance of
     * this depends on the percentage of users that are allocated to that launch. If the user is enrolled in the launch,
     * the variation they are served depends on the allocation of the various feature variations used for the launch.
     * </p>
     * <p>
     * If the user is not assigned to a launch, and there is an ongoing experiment for this feature, the user might be
     * assigned to a variation in the experiment. The chance of this depends on the percentage of users that are
     * allocated to that experiment. If the user is enrolled in the experiment, the variation they are served depends on
     * the allocation of the various feature variations used for the experiment.
     * </p>
     * <p>
     * If the user is not assigned to a launch or experiment, they are served the default variation.
     * </p>
     *
     * @param evaluateFeatureRequest
     * @return Result of the EvaluateFeature operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.EvaluateFeature
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/EvaluateFeature" target="_top">AWS API
     *      Documentation</a>
     */
    default EvaluateFeatureResponse evaluateFeature(EvaluateFeatureRequest evaluateFeatureRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation assigns a feature variation to one given user session. You pass in an <code>entityID</code> that
     * represents the user. Evidently then checks the evaluation rules and assigns the variation.
     * </p>
     * <p>
     * The first rules that are evaluated are the override rules. If the user's <code>entityID</code> matches an
     * override rule, the user is served the variation specified by that rule.
     * </p>
     * <p>
     * Next, if there is a launch of the feature, the user might be assigned to a variation in the launch. The chance of
     * this depends on the percentage of users that are allocated to that launch. If the user is enrolled in the launch,
     * the variation they are served depends on the allocation of the various feature variations used for the launch.
     * </p>
     * <p>
     * If the user is not assigned to a launch, and there is an ongoing experiment for this feature, the user might be
     * assigned to a variation in the experiment. The chance of this depends on the percentage of users that are
     * allocated to that experiment. If the user is enrolled in the experiment, the variation they are served depends on
     * the allocation of the various feature variations used for the experiment.
     * </p>
     * <p>
     * If the user is not assigned to a launch or experiment, they are served the default variation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EvaluateFeatureRequest.Builder} avoiding the need
     * to create one manually via {@link EvaluateFeatureRequest#builder()}
     * </p>
     *
     * @param evaluateFeatureRequest
     *        A {@link Consumer} that will call methods on {@link EvaluateFeatureRequest.Builder} to create a request.
     * @return Result of the EvaluateFeature operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.EvaluateFeature
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/EvaluateFeature" target="_top">AWS API
     *      Documentation</a>
     */
    default EvaluateFeatureResponse evaluateFeature(Consumer<EvaluateFeatureRequest.Builder> evaluateFeatureRequest)
            throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, EvidentlyException {
        return evaluateFeature(EvaluateFeatureRequest.builder().applyMutation(evaluateFeatureRequest).build());
    }

    /**
     * <p>
     * Returns the details about one experiment. You must already know the experiment name. To retrieve a list of
     * experiments in your account, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListExperiments.html"
     * >ListExperiments</a>.
     * </p>
     *
     * @param getExperimentRequest
     * @return Result of the GetExperiment operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.GetExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetExperiment" target="_top">AWS API
     *      Documentation</a>
     */
    default GetExperimentResponse getExperiment(GetExperimentRequest getExperimentRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details about one experiment. You must already know the experiment name. To retrieve a list of
     * experiments in your account, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListExperiments.html"
     * >ListExperiments</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExperimentRequest.Builder} avoiding the need to
     * create one manually via {@link GetExperimentRequest#builder()}
     * </p>
     *
     * @param getExperimentRequest
     *        A {@link Consumer} that will call methods on {@link GetExperimentRequest.Builder} to create a request.
     * @return Result of the GetExperiment operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.GetExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetExperiment" target="_top">AWS API
     *      Documentation</a>
     */
    default GetExperimentResponse getExperiment(Consumer<GetExperimentRequest.Builder> getExperimentRequest)
            throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, EvidentlyException {
        return getExperiment(GetExperimentRequest.builder().applyMutation(getExperimentRequest).build());
    }

    /**
     * <p>
     * Retrieves the results of a running or completed experiment.
     * </p>
     *
     * @param getExperimentResultsRequest
     * @return Result of the GetExperimentResults operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.GetExperimentResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetExperimentResults"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExperimentResultsResponse getExperimentResults(GetExperimentResultsRequest getExperimentResultsRequest)
            throws ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the results of a running or completed experiment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExperimentResultsRequest.Builder} avoiding the
     * need to create one manually via {@link GetExperimentResultsRequest#builder()}
     * </p>
     *
     * @param getExperimentResultsRequest
     *        A {@link Consumer} that will call methods on {@link GetExperimentResultsRequest.Builder} to create a
     *        request.
     * @return Result of the GetExperimentResults operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.GetExperimentResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetExperimentResults"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExperimentResultsResponse getExperimentResults(
            Consumer<GetExperimentResultsRequest.Builder> getExperimentResultsRequest) throws ThrottlingException,
            ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, EvidentlyException {
        return getExperimentResults(GetExperimentResultsRequest.builder().applyMutation(getExperimentResultsRequest).build());
    }

    /**
     * <p>
     * Returns the details about one feature. You must already know the feature name. To retrieve a list of features in
     * your account, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListFeatures.html"
     * >ListFeatures</a>.
     * </p>
     *
     * @param getFeatureRequest
     * @return Result of the GetFeature operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.GetFeature
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetFeature" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFeatureResponse getFeature(GetFeatureRequest getFeatureRequest) throws ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details about one feature. You must already know the feature name. To retrieve a list of features in
     * your account, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListFeatures.html"
     * >ListFeatures</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFeatureRequest.Builder} avoiding the need to
     * create one manually via {@link GetFeatureRequest#builder()}
     * </p>
     *
     * @param getFeatureRequest
     *        A {@link Consumer} that will call methods on {@link GetFeatureRequest.Builder} to create a request.
     * @return Result of the GetFeature operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.GetFeature
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetFeature" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFeatureResponse getFeature(Consumer<GetFeatureRequest.Builder> getFeatureRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            EvidentlyException {
        return getFeature(GetFeatureRequest.builder().applyMutation(getFeatureRequest).build());
    }

    /**
     * <p>
     * Returns the details about one launch. You must already know the launch name. To retrieve a list of launches in
     * your account, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListLaunches.html"
     * >ListLaunches</a>.
     * </p>
     *
     * @param getLaunchRequest
     * @return Result of the GetLaunch operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.GetLaunch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetLaunch" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLaunchResponse getLaunch(GetLaunchRequest getLaunchRequest) throws ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details about one launch. You must already know the launch name. To retrieve a list of launches in
     * your account, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListLaunches.html"
     * >ListLaunches</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLaunchRequest.Builder} avoiding the need to
     * create one manually via {@link GetLaunchRequest#builder()}
     * </p>
     *
     * @param getLaunchRequest
     *        A {@link Consumer} that will call methods on {@link GetLaunchRequest.Builder} to create a request.
     * @return Result of the GetLaunch operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.GetLaunch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetLaunch" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLaunchResponse getLaunch(Consumer<GetLaunchRequest.Builder> getLaunchRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            EvidentlyException {
        return getLaunch(GetLaunchRequest.builder().applyMutation(getLaunchRequest).build());
    }

    /**
     * <p>
     * Returns the details about one launch. You must already know the project name. To retrieve a list of projects in
     * your account, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListProjects.html"
     * >ListProjects</a>.
     * </p>
     *
     * @param getProjectRequest
     * @return Result of the GetProject operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.GetProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetProject" target="_top">AWS API
     *      Documentation</a>
     */
    default GetProjectResponse getProject(GetProjectRequest getProjectRequest) throws ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details about one launch. You must already know the project name. To retrieve a list of projects in
     * your account, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListProjects.html"
     * >ListProjects</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProjectRequest.Builder} avoiding the need to
     * create one manually via {@link GetProjectRequest#builder()}
     * </p>
     *
     * @param getProjectRequest
     *        A {@link Consumer} that will call methods on {@link GetProjectRequest.Builder} to create a request.
     * @return Result of the GetProject operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.GetProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/GetProject" target="_top">AWS API
     *      Documentation</a>
     */
    default GetProjectResponse getProject(Consumer<GetProjectRequest.Builder> getProjectRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            EvidentlyException {
        return getProject(GetProjectRequest.builder().applyMutation(getProjectRequest).build());
    }

    /**
     * <p>
     * Returns configuration details about all the experiments in the specified project.
     * </p>
     *
     * @param listExperimentsRequest
     * @return Result of the ListExperiments operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.ListExperiments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListExperiments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExperimentsResponse listExperiments(ListExperimentsRequest listExperimentsRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns configuration details about all the experiments in the specified project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExperimentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListExperimentsRequest#builder()}
     * </p>
     *
     * @param listExperimentsRequest
     *        A {@link Consumer} that will call methods on {@link ListExperimentsRequest.Builder} to create a request.
     * @return Result of the ListExperiments operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.ListExperiments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListExperiments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExperimentsResponse listExperiments(Consumer<ListExperimentsRequest.Builder> listExperimentsRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, EvidentlyException {
        return listExperiments(ListExperimentsRequest.builder().applyMutation(listExperimentsRequest).build());
    }

    /**
     * <p>
     * Returns configuration details about all the experiments in the specified project.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExperiments(software.amazon.awssdk.services.evidently.model.ListExperimentsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.evidently.paginators.ListExperimentsIterable responses = client.listExperimentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.evidently.paginators.ListExperimentsIterable responses = client
     *             .listExperimentsPaginator(request);
     *     for (software.amazon.awssdk.services.evidently.model.ListExperimentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.evidently.paginators.ListExperimentsIterable responses = client.listExperimentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperiments(software.amazon.awssdk.services.evidently.model.ListExperimentsRequest)} operation.</b>
     * </p>
     *
     * @param listExperimentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.ListExperiments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListExperiments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExperimentsIterable listExperimentsPaginator(ListExperimentsRequest listExperimentsRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns configuration details about all the experiments in the specified project.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExperiments(software.amazon.awssdk.services.evidently.model.ListExperimentsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.evidently.paginators.ListExperimentsIterable responses = client.listExperimentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.evidently.paginators.ListExperimentsIterable responses = client
     *             .listExperimentsPaginator(request);
     *     for (software.amazon.awssdk.services.evidently.model.ListExperimentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.evidently.paginators.ListExperimentsIterable responses = client.listExperimentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExperiments(software.amazon.awssdk.services.evidently.model.ListExperimentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExperimentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListExperimentsRequest#builder()}
     * </p>
     *
     * @param listExperimentsRequest
     *        A {@link Consumer} that will call methods on {@link ListExperimentsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.ListExperiments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListExperiments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExperimentsIterable listExperimentsPaginator(Consumer<ListExperimentsRequest.Builder> listExperimentsRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, EvidentlyException {
        return listExperimentsPaginator(ListExperimentsRequest.builder().applyMutation(listExperimentsRequest).build());
    }

    /**
     * <p>
     * Returns configuration details about all the features in the specified project.
     * </p>
     *
     * @param listFeaturesRequest
     * @return Result of the ListFeatures operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.ListFeatures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListFeatures" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFeaturesResponse listFeatures(ListFeaturesRequest listFeaturesRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns configuration details about all the features in the specified project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFeaturesRequest.Builder} avoiding the need to
     * create one manually via {@link ListFeaturesRequest#builder()}
     * </p>
     *
     * @param listFeaturesRequest
     *        A {@link Consumer} that will call methods on {@link ListFeaturesRequest.Builder} to create a request.
     * @return Result of the ListFeatures operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.ListFeatures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListFeatures" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFeaturesResponse listFeatures(Consumer<ListFeaturesRequest.Builder> listFeaturesRequest)
            throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, EvidentlyException {
        return listFeatures(ListFeaturesRequest.builder().applyMutation(listFeaturesRequest).build());
    }

    /**
     * <p>
     * Returns configuration details about all the features in the specified project.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFeatures(software.amazon.awssdk.services.evidently.model.ListFeaturesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.evidently.paginators.ListFeaturesIterable responses = client.listFeaturesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.evidently.paginators.ListFeaturesIterable responses = client.listFeaturesPaginator(request);
     *     for (software.amazon.awssdk.services.evidently.model.ListFeaturesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.evidently.paginators.ListFeaturesIterable responses = client.listFeaturesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFeatures(software.amazon.awssdk.services.evidently.model.ListFeaturesRequest)} operation.</b>
     * </p>
     *
     * @param listFeaturesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.ListFeatures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListFeatures" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFeaturesIterable listFeaturesPaginator(ListFeaturesRequest listFeaturesRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns configuration details about all the features in the specified project.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFeatures(software.amazon.awssdk.services.evidently.model.ListFeaturesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.evidently.paginators.ListFeaturesIterable responses = client.listFeaturesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.evidently.paginators.ListFeaturesIterable responses = client.listFeaturesPaginator(request);
     *     for (software.amazon.awssdk.services.evidently.model.ListFeaturesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.evidently.paginators.ListFeaturesIterable responses = client.listFeaturesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFeatures(software.amazon.awssdk.services.evidently.model.ListFeaturesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFeaturesRequest.Builder} avoiding the need to
     * create one manually via {@link ListFeaturesRequest#builder()}
     * </p>
     *
     * @param listFeaturesRequest
     *        A {@link Consumer} that will call methods on {@link ListFeaturesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.ListFeatures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListFeatures" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFeaturesIterable listFeaturesPaginator(Consumer<ListFeaturesRequest.Builder> listFeaturesRequest)
            throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, EvidentlyException {
        return listFeaturesPaginator(ListFeaturesRequest.builder().applyMutation(listFeaturesRequest).build());
    }

    /**
     * <p>
     * Returns configuration details about all the launches in the specified project.
     * </p>
     *
     * @param listLaunchesRequest
     * @return Result of the ListLaunches operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.ListLaunches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListLaunches" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLaunchesResponse listLaunches(ListLaunchesRequest listLaunchesRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns configuration details about all the launches in the specified project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLaunchesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLaunchesRequest#builder()}
     * </p>
     *
     * @param listLaunchesRequest
     *        A {@link Consumer} that will call methods on {@link ListLaunchesRequest.Builder} to create a request.
     * @return Result of the ListLaunches operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.ListLaunches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListLaunches" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLaunchesResponse listLaunches(Consumer<ListLaunchesRequest.Builder> listLaunchesRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            EvidentlyException {
        return listLaunches(ListLaunchesRequest.builder().applyMutation(listLaunchesRequest).build());
    }

    /**
     * <p>
     * Returns configuration details about all the launches in the specified project.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLaunches(software.amazon.awssdk.services.evidently.model.ListLaunchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.evidently.paginators.ListLaunchesIterable responses = client.listLaunchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.evidently.paginators.ListLaunchesIterable responses = client.listLaunchesPaginator(request);
     *     for (software.amazon.awssdk.services.evidently.model.ListLaunchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.evidently.paginators.ListLaunchesIterable responses = client.listLaunchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLaunches(software.amazon.awssdk.services.evidently.model.ListLaunchesRequest)} operation.</b>
     * </p>
     *
     * @param listLaunchesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.ListLaunches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListLaunches" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLaunchesIterable listLaunchesPaginator(ListLaunchesRequest listLaunchesRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns configuration details about all the launches in the specified project.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLaunches(software.amazon.awssdk.services.evidently.model.ListLaunchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.evidently.paginators.ListLaunchesIterable responses = client.listLaunchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.evidently.paginators.ListLaunchesIterable responses = client.listLaunchesPaginator(request);
     *     for (software.amazon.awssdk.services.evidently.model.ListLaunchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.evidently.paginators.ListLaunchesIterable responses = client.listLaunchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLaunches(software.amazon.awssdk.services.evidently.model.ListLaunchesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLaunchesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLaunchesRequest#builder()}
     * </p>
     *
     * @param listLaunchesRequest
     *        A {@link Consumer} that will call methods on {@link ListLaunchesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.ListLaunches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListLaunches" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLaunchesIterable listLaunchesPaginator(Consumer<ListLaunchesRequest.Builder> listLaunchesRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            EvidentlyException {
        return listLaunchesPaginator(ListLaunchesRequest.builder().applyMutation(listLaunchesRequest).build());
    }

    /**
     * <p>
     * Returns configuration details about all the projects in the current Region in your account.
     * </p>
     *
     * @param listProjectsRequest
     * @return Result of the ListProjects operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns configuration details about all the projects in the current Region in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectsRequest.Builder} to create a request.
     * @return Result of the ListProjects operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsResponse listProjects(Consumer<ListProjectsRequest.Builder> listProjectsRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            EvidentlyException {
        return listProjects(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Returns configuration details about all the projects in the current Region in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.evidently.model.ListProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.evidently.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.evidently.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.evidently.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.evidently.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.evidently.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @param listProjectsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator(ListProjectsRequest listProjectsRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns configuration details about all the projects in the current Region in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.evidently.model.ListProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.evidently.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.evidently.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.evidently.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.evidently.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.evidently.model.ListProjectsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator(Consumer<ListProjectsRequest.Builder> listProjectsRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            EvidentlyException {
        return listProjectsPaginator(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Displays the tags associated with an Evidently resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the tags associated with an Evidently resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvidentlyException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Sends performance events to Evidently. These events can be used to evaluate a launch or an experiment.
     * </p>
     *
     * @param putProjectEventsRequest
     * @return Result of the PutProjectEvents operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.PutProjectEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/PutProjectEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default PutProjectEventsResponse putProjectEvents(PutProjectEventsRequest putProjectEventsRequest)
            throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends performance events to Evidently. These events can be used to evaluate a launch or an experiment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutProjectEventsRequest.Builder} avoiding the need
     * to create one manually via {@link PutProjectEventsRequest#builder()}
     * </p>
     *
     * @param putProjectEventsRequest
     *        A {@link Consumer} that will call methods on {@link PutProjectEventsRequest.Builder} to create a request.
     * @return Result of the PutProjectEvents operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.PutProjectEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/PutProjectEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default PutProjectEventsResponse putProjectEvents(Consumer<PutProjectEventsRequest.Builder> putProjectEventsRequest)
            throws ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, EvidentlyException {
        return putProjectEvents(PutProjectEventsRequest.builder().applyMutation(putProjectEventsRequest).build());
    }

    /**
     * <p>
     * Starts an existing experiment. To create an experiment, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateExperiment.html"
     * >CreateExperiment</a>.
     * </p>
     *
     * @param startExperimentRequest
     * @return Result of the StartExperiment operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.StartExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/StartExperiment" target="_top">AWS API
     *      Documentation</a>
     */
    default StartExperimentResponse startExperiment(StartExperimentRequest startExperimentRequest) throws ThrottlingException,
            ValidationException, ConflictException, ServiceQuotaExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an existing experiment. To create an experiment, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateExperiment.html"
     * >CreateExperiment</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartExperimentRequest.Builder} avoiding the need
     * to create one manually via {@link StartExperimentRequest#builder()}
     * </p>
     *
     * @param startExperimentRequest
     *        A {@link Consumer} that will call methods on {@link StartExperimentRequest.Builder} to create a request.
     * @return Result of the StartExperiment operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.StartExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/StartExperiment" target="_top">AWS API
     *      Documentation</a>
     */
    default StartExperimentResponse startExperiment(Consumer<StartExperimentRequest.Builder> startExperimentRequest)
            throws ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        return startExperiment(StartExperimentRequest.builder().applyMutation(startExperimentRequest).build());
    }

    /**
     * <p>
     * Starts an existing launch. To create a launch, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateLaunch.html"
     * >CreateLaunch</a>.
     * </p>
     *
     * @param startLaunchRequest
     * @return Result of the StartLaunch operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.StartLaunch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/StartLaunch" target="_top">AWS API
     *      Documentation</a>
     */
    default StartLaunchResponse startLaunch(StartLaunchRequest startLaunchRequest) throws ThrottlingException,
            ValidationException, ConflictException, ServiceQuotaExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an existing launch. To create a launch, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateLaunch.html"
     * >CreateLaunch</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartLaunchRequest.Builder} avoiding the need to
     * create one manually via {@link StartLaunchRequest#builder()}
     * </p>
     *
     * @param startLaunchRequest
     *        A {@link Consumer} that will call methods on {@link StartLaunchRequest.Builder} to create a request.
     * @return Result of the StartLaunch operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.StartLaunch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/StartLaunch" target="_top">AWS API
     *      Documentation</a>
     */
    default StartLaunchResponse startLaunch(Consumer<StartLaunchRequest.Builder> startLaunchRequest) throws ThrottlingException,
            ValidationException, ConflictException, ServiceQuotaExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        return startLaunch(StartLaunchRequest.builder().applyMutation(startLaunchRequest).build());
    }

    /**
     * <p>
     * Stops an experiment that is currently running. If you stop an experiment, you can't resume it or restart it.
     * </p>
     *
     * @param stopExperimentRequest
     * @return Result of the StopExperiment operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.StopExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/StopExperiment" target="_top">AWS API
     *      Documentation</a>
     */
    default StopExperimentResponse stopExperiment(StopExperimentRequest stopExperimentRequest) throws ThrottlingException,
            ValidationException, ConflictException, ServiceQuotaExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an experiment that is currently running. If you stop an experiment, you can't resume it or restart it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopExperimentRequest.Builder} avoiding the need to
     * create one manually via {@link StopExperimentRequest#builder()}
     * </p>
     *
     * @param stopExperimentRequest
     *        A {@link Consumer} that will call methods on {@link StopExperimentRequest.Builder} to create a request.
     * @return Result of the StopExperiment operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.StopExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/StopExperiment" target="_top">AWS API
     *      Documentation</a>
     */
    default StopExperimentResponse stopExperiment(Consumer<StopExperimentRequest.Builder> stopExperimentRequest)
            throws ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        return stopExperiment(StopExperimentRequest.builder().applyMutation(stopExperimentRequest).build());
    }

    /**
     * <p>
     * Stops a launch that is currently running. After you stop a launch, you will not be able to resume it or restart
     * it. Also, it will not be evaluated as a rule for traffic allocation, and the traffic that was allocated to the
     * launch will instead be available to the feature's experiment, if there is one. Otherwise, all traffic will be
     * served the default variation after the launch is stopped.
     * </p>
     *
     * @param stopLaunchRequest
     * @return Result of the StopLaunch operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.StopLaunch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/StopLaunch" target="_top">AWS API
     *      Documentation</a>
     */
    default StopLaunchResponse stopLaunch(StopLaunchRequest stopLaunchRequest) throws ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a launch that is currently running. After you stop a launch, you will not be able to resume it or restart
     * it. Also, it will not be evaluated as a rule for traffic allocation, and the traffic that was allocated to the
     * launch will instead be available to the feature's experiment, if there is one. Otherwise, all traffic will be
     * served the default variation after the launch is stopped.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopLaunchRequest.Builder} avoiding the need to
     * create one manually via {@link StopLaunchRequest#builder()}
     * </p>
     *
     * @param stopLaunchRequest
     *        A {@link Consumer} that will call methods on {@link StopLaunchRequest.Builder} to create a request.
     * @return Result of the StopLaunch operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.StopLaunch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/StopLaunch" target="_top">AWS API
     *      Documentation</a>
     */
    default StopLaunchResponse stopLaunch(Consumer<StopLaunchRequest.Builder> stopLaunchRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            EvidentlyException {
        return stopLaunch(StopLaunchRequest.builder().applyMutation(stopLaunchRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified CloudWatch Evidently resource. Projects, features,
     * launches, and experiments can be tagged.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
     * granting a user permission to access or change only resources with certain tag values.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
     * characters.
     * </p>
     * <p>
     * You can use the <code>TagResource</code> action with a resource that already has tags. If you specify a new tag
     * key for the resource, this tag is appended to the list of tags associated with the alarm. If you specify a tag
     * key that is already associated with the resource, the new tag value that you specify replaces the previous value
     * for that tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a resource.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon
     * Web Services resources</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified CloudWatch Evidently resource. Projects, features,
     * launches, and experiments can be tagged.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
     * granting a user permission to access or change only resources with certain tag values.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
     * characters.
     * </p>
     * <p>
     * You can use the <code>TagResource</code> action with a resource that already has tags. If you specify a new tag
     * key for the resource, this tag is appended to the list of tags associated with the alarm. If you specify a tag
     * key that is already associated with the resource, the new tag value that you specify replaces the previous value
     * for that tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a resource.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon
     * Web Services resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvidentlyException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            EvidentlyException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an Evidently experiment.
     * </p>
     * <p>
     * Don't use this operation to update an experiment's tag. Instead, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>.
     * </p>
     *
     * @param updateExperimentRequest
     * @return Result of the UpdateExperiment operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.UpdateExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateExperimentResponse updateExperiment(UpdateExperimentRequest updateExperimentRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Evidently experiment.
     * </p>
     * <p>
     * Don't use this operation to update an experiment's tag. Instead, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateExperimentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateExperimentRequest#builder()}
     * </p>
     *
     * @param updateExperimentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateExperimentRequest.Builder} to create a request.
     * @return Result of the UpdateExperiment operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.UpdateExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateExperimentResponse updateExperiment(Consumer<UpdateExperimentRequest.Builder> updateExperimentRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, EvidentlyException {
        return updateExperiment(UpdateExperimentRequest.builder().applyMutation(updateExperimentRequest).build());
    }

    /**
     * <p>
     * Updates an existing feature.
     * </p>
     * <p>
     * You can't use this operation to update the tags of an existing feature. Instead, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>.
     * </p>
     *
     * @param updateFeatureRequest
     * @return Result of the UpdateFeature operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.UpdateFeature
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateFeature" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFeatureResponse updateFeature(UpdateFeatureRequest updateFeatureRequest) throws ValidationException,
            ConflictException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing feature.
     * </p>
     * <p>
     * You can't use this operation to update the tags of an existing feature. Instead, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFeatureRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFeatureRequest#builder()}
     * </p>
     *
     * @param updateFeatureRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFeatureRequest.Builder} to create a request.
     * @return Result of the UpdateFeature operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.UpdateFeature
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateFeature" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFeatureResponse updateFeature(Consumer<UpdateFeatureRequest.Builder> updateFeatureRequest)
            throws ValidationException, ConflictException, ServiceQuotaExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, EvidentlyException {
        return updateFeature(UpdateFeatureRequest.builder().applyMutation(updateFeatureRequest).build());
    }

    /**
     * <p>
     * Updates a launch of a given feature.
     * </p>
     * <p>
     * Don't use this operation to update the tags of an existing launch. Instead, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>.
     * </p>
     *
     * @param updateLaunchRequest
     * @return Result of the UpdateLaunch operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.UpdateLaunch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateLaunch" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateLaunchResponse updateLaunch(UpdateLaunchRequest updateLaunchRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a launch of a given feature.
     * </p>
     * <p>
     * Don't use this operation to update the tags of an existing launch. Instead, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLaunchRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateLaunchRequest#builder()}
     * </p>
     *
     * @param updateLaunchRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLaunchRequest.Builder} to create a request.
     * @return Result of the UpdateLaunch operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.UpdateLaunch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateLaunch" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateLaunchResponse updateLaunch(Consumer<UpdateLaunchRequest.Builder> updateLaunchRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, EvidentlyException {
        return updateLaunch(UpdateLaunchRequest.builder().applyMutation(updateLaunchRequest).build());
    }

    /**
     * <p>
     * Updates the description of an existing project.
     * </p>
     * <p>
     * To create a new project, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateProject.html"
     * >CreateProject</a>.
     * </p>
     * <p>
     * Don't use this operation to update the data storage options of a project. Instead, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateProjectDataDelivery.html"
     * >UpdateProjectDataDelivery</a>.
     * </p>
     * <p>
     * Don't use this operation to update the tags of a project. Instead, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>.
     * </p>
     *
     * @param updateProjectRequest
     * @return Result of the UpdateProject operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateProjectResponse updateProject(UpdateProjectRequest updateProjectRequest) throws ValidationException,
            ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the description of an existing project.
     * </p>
     * <p>
     * To create a new project, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateProject.html"
     * >CreateProject</a>.
     * </p>
     * <p>
     * Don't use this operation to update the data storage options of a project. Instead, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateProjectDataDelivery.html"
     * >UpdateProjectDataDelivery</a>.
     * </p>
     * <p>
     * Don't use this operation to update the tags of a project. Instead, use <a
     * href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProjectRequest#builder()}
     * </p>
     *
     * @param updateProjectRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProjectRequest.Builder} to create a request.
     * @return Result of the UpdateProject operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateProjectResponse updateProject(Consumer<UpdateProjectRequest.Builder> updateProjectRequest)
            throws ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, EvidentlyException {
        return updateProject(UpdateProjectRequest.builder().applyMutation(updateProjectRequest).build());
    }

    /**
     * <p>
     * Updates the data storage options for this project. If you store evaluation events, you an keep them and analyze
     * them on your own. If you choose not to store evaluation events, Evidently deletes them after using them to
     * produce metrics and other experiment results that you can view.
     * </p>
     * <p>
     * You can't specify both <code>cloudWatchLogs</code> and <code>s3Destination</code> in the same operation.
     * </p>
     *
     * @param updateProjectDataDeliveryRequest
     * @return Result of the UpdateProjectDataDelivery operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.UpdateProjectDataDelivery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateProjectDataDelivery"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProjectDataDeliveryResponse updateProjectDataDelivery(
            UpdateProjectDataDeliveryRequest updateProjectDataDeliveryRequest) throws ValidationException, ConflictException,
            ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, EvidentlyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the data storage options for this project. If you store evaluation events, you an keep them and analyze
     * them on your own. If you choose not to store evaluation events, Evidently deletes them after using them to
     * produce metrics and other experiment results that you can view.
     * </p>
     * <p>
     * You can't specify both <code>cloudWatchLogs</code> and <code>s3Destination</code> in the same operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProjectDataDeliveryRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateProjectDataDeliveryRequest#builder()}
     * </p>
     *
     * @param updateProjectDataDeliveryRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProjectDataDeliveryRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateProjectDataDelivery operation returned by the service.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EvidentlyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EvidentlyClient.UpdateProjectDataDelivery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/UpdateProjectDataDelivery"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProjectDataDeliveryResponse updateProjectDataDelivery(
            Consumer<UpdateProjectDataDeliveryRequest.Builder> updateProjectDataDeliveryRequest) throws ValidationException,
            ConflictException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, EvidentlyException {
        return updateProjectDataDelivery(UpdateProjectDataDeliveryRequest.builder()
                .applyMutation(updateProjectDataDeliveryRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
