/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLaunchRequest extends EvidentlyRequest implements
        ToCopyableBuilder<GetLaunchRequest.Builder, GetLaunchRequest> {
    private static final SdkField<String> LAUNCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("launch")
            .getter(getter(GetLaunchRequest::launch)).setter(setter(Builder::launch))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("launch").build()).build();

    private static final SdkField<String> PROJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("project")
            .getter(getter(GetLaunchRequest::project)).setter(setter(Builder::project))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_FIELD, PROJECT_FIELD));

    private final String launch;

    private final String project;

    private GetLaunchRequest(BuilderImpl builder) {
        super(builder);
        this.launch = builder.launch;
        this.project = builder.project;
    }

    /**
     * <p>
     * The name of the launch that you want to see the details of.
     * </p>
     * 
     * @return The name of the launch that you want to see the details of.
     */
    public final String launch() {
        return launch;
    }

    /**
     * <p>
     * The name or ARN of the project that contains the launch.
     * </p>
     * 
     * @return The name or ARN of the project that contains the launch.
     */
    public final String project() {
        return project;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(launch());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLaunchRequest)) {
            return false;
        }
        GetLaunchRequest other = (GetLaunchRequest) obj;
        return Objects.equals(launch(), other.launch()) && Objects.equals(project(), other.project());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLaunchRequest").add("Launch", launch()).add("Project", project()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "launch":
            return Optional.ofNullable(clazz.cast(launch()));
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLaunchRequest, T> g) {
        return obj -> g.apply((GetLaunchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EvidentlyRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetLaunchRequest> {
        /**
         * <p>
         * The name of the launch that you want to see the details of.
         * </p>
         * 
         * @param launch
         *        The name of the launch that you want to see the details of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launch(String launch);

        /**
         * <p>
         * The name or ARN of the project that contains the launch.
         * </p>
         * 
         * @param project
         *        The name or ARN of the project that contains the launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(String project);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EvidentlyRequest.BuilderImpl implements Builder {
        private String launch;

        private String project;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLaunchRequest model) {
            super(model);
            launch(model.launch);
            project(model.project);
        }

        public final String getLaunch() {
            return launch;
        }

        public final void setLaunch(String launch) {
            this.launch = launch;
        }

        @Override
        @Transient
        public final Builder launch(String launch) {
            this.launch = launch;
            return this;
        }

        public final String getProject() {
            return project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        @Transient
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLaunchRequest build() {
            return new GetLaunchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
