/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use this structure to tell Evidently whether higher or lower values are desired for a metric that is used in an
 * experiment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricGoalConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricGoalConfig.Builder, MetricGoalConfig> {
    private static final SdkField<String> DESIRED_CHANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desiredChange").getter(getter(MetricGoalConfig::desiredChangeAsString))
            .setter(setter(Builder::desiredChange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredChange").build()).build();

    private static final SdkField<MetricDefinitionConfig> METRIC_DEFINITION_FIELD = SdkField
            .<MetricDefinitionConfig> builder(MarshallingType.SDK_POJO).memberName("metricDefinition")
            .getter(getter(MetricGoalConfig::metricDefinition)).setter(setter(Builder::metricDefinition))
            .constructor(MetricDefinitionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_CHANGE_FIELD,
            METRIC_DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String desiredChange;

    private final MetricDefinitionConfig metricDefinition;

    private MetricGoalConfig(BuilderImpl builder) {
        this.desiredChange = builder.desiredChange;
        this.metricDefinition = builder.metricDefinition;
    }

    /**
     * <p>
     * <code>INCREASE</code> means that a variation with a higher number for this metric is performing better.
     * </p>
     * <p>
     * <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredChange}
     * will return {@link ChangeDirectionEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #desiredChangeAsString}.
     * </p>
     * 
     * @return <code>INCREASE</code> means that a variation with a higher number for this metric is performing
     *         better.</p>
     *         <p>
     *         <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.
     * @see ChangeDirectionEnum
     */
    public final ChangeDirectionEnum desiredChange() {
        return ChangeDirectionEnum.fromValue(desiredChange);
    }

    /**
     * <p>
     * <code>INCREASE</code> means that a variation with a higher number for this metric is performing better.
     * </p>
     * <p>
     * <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredChange}
     * will return {@link ChangeDirectionEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #desiredChangeAsString}.
     * </p>
     * 
     * @return <code>INCREASE</code> means that a variation with a higher number for this metric is performing
     *         better.</p>
     *         <p>
     *         <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.
     * @see ChangeDirectionEnum
     */
    public final String desiredChangeAsString() {
        return desiredChange;
    }

    /**
     * <p>
     * A structure that contains details about the metric.
     * </p>
     * 
     * @return A structure that contains details about the metric.
     */
    public final MetricDefinitionConfig metricDefinition() {
        return metricDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(desiredChangeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricGoalConfig)) {
            return false;
        }
        MetricGoalConfig other = (MetricGoalConfig) obj;
        return Objects.equals(desiredChangeAsString(), other.desiredChangeAsString())
                && Objects.equals(metricDefinition(), other.metricDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricGoalConfig").add("DesiredChange", desiredChangeAsString())
                .add("MetricDefinition", metricDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "desiredChange":
            return Optional.ofNullable(clazz.cast(desiredChangeAsString()));
        case "metricDefinition":
            return Optional.ofNullable(clazz.cast(metricDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricGoalConfig, T> g) {
        return obj -> g.apply((MetricGoalConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricGoalConfig> {
        /**
         * <p>
         * <code>INCREASE</code> means that a variation with a higher number for this metric is performing better.
         * </p>
         * <p>
         * <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.
         * </p>
         * 
         * @param desiredChange
         *        <code>INCREASE</code> means that a variation with a higher number for this metric is performing
         *        better.</p>
         *        <p>
         *        <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.
         * @see ChangeDirectionEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeDirectionEnum
         */
        Builder desiredChange(String desiredChange);

        /**
         * <p>
         * <code>INCREASE</code> means that a variation with a higher number for this metric is performing better.
         * </p>
         * <p>
         * <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.
         * </p>
         * 
         * @param desiredChange
         *        <code>INCREASE</code> means that a variation with a higher number for this metric is performing
         *        better.</p>
         *        <p>
         *        <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.
         * @see ChangeDirectionEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeDirectionEnum
         */
        Builder desiredChange(ChangeDirectionEnum desiredChange);

        /**
         * <p>
         * A structure that contains details about the metric.
         * </p>
         * 
         * @param metricDefinition
         *        A structure that contains details about the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDefinition(MetricDefinitionConfig metricDefinition);

        /**
         * <p>
         * A structure that contains details about the metric.
         * </p>
         * This is a convenience that creates an instance of the {@link MetricDefinitionConfig.Builder} avoiding the
         * need to create one manually via {@link MetricDefinitionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricDefinitionConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #metricDefinition(MetricDefinitionConfig)}.
         * 
         * @param metricDefinition
         *        a consumer that will call methods on {@link MetricDefinitionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricDefinition(MetricDefinitionConfig)
         */
        default Builder metricDefinition(Consumer<MetricDefinitionConfig.Builder> metricDefinition) {
            return metricDefinition(MetricDefinitionConfig.builder().applyMutation(metricDefinition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String desiredChange;

        private MetricDefinitionConfig metricDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricGoalConfig model) {
            desiredChange(model.desiredChange);
            metricDefinition(model.metricDefinition);
        }

        public final String getDesiredChange() {
            return desiredChange;
        }

        public final void setDesiredChange(String desiredChange) {
            this.desiredChange = desiredChange;
        }

        @Override
        @Transient
        public final Builder desiredChange(String desiredChange) {
            this.desiredChange = desiredChange;
            return this;
        }

        @Override
        @Transient
        public final Builder desiredChange(ChangeDirectionEnum desiredChange) {
            this.desiredChange(desiredChange == null ? null : desiredChange.toString());
            return this;
        }

        public final MetricDefinitionConfig.Builder getMetricDefinition() {
            return metricDefinition != null ? metricDefinition.toBuilder() : null;
        }

        public final void setMetricDefinition(MetricDefinitionConfig.BuilderImpl metricDefinition) {
            this.metricDefinition = metricDefinition != null ? metricDefinition.build() : null;
        }

        @Override
        @Transient
        public final Builder metricDefinition(MetricDefinitionConfig metricDefinition) {
            this.metricDefinition = metricDefinition;
            return this;
        }

        @Override
        public MetricGoalConfig build() {
            return new MetricGoalConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
