/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure defines a project, which is the logical object in Evidently that can contain features, launches, and
 * experiments. Use projects to group similar features together.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Project implements SdkPojo, Serializable, ToCopyableBuilder<Project.Builder, Project> {
    private static final SdkField<Long> ACTIVE_EXPERIMENT_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("activeExperimentCount").getter(getter(Project::activeExperimentCount))
            .setter(setter(Builder::activeExperimentCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeExperimentCount").build())
            .build();

    private static final SdkField<Long> ACTIVE_LAUNCH_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("activeLaunchCount").getter(getter(Project::activeLaunchCount))
            .setter(setter(Builder::activeLaunchCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeLaunchCount").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Project::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTime").getter(getter(Project::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final SdkField<ProjectDataDelivery> DATA_DELIVERY_FIELD = SdkField
            .<ProjectDataDelivery> builder(MarshallingType.SDK_POJO).memberName("dataDelivery")
            .getter(getter(Project::dataDelivery)).setter(setter(Builder::dataDelivery))
            .constructor(ProjectDataDelivery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataDelivery").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Project::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Long> EXPERIMENT_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("experimentCount").getter(getter(Project::experimentCount)).setter(setter(Builder::experimentCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentCount").build()).build();

    private static final SdkField<Long> FEATURE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("featureCount").getter(getter(Project::featureCount)).setter(setter(Builder::featureCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureCount").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedTime").getter(getter(Project::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<Long> LAUNCH_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("launchCount").getter(getter(Project::launchCount)).setter(setter(Builder::launchCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchCount").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Project::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Project::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Project::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_EXPERIMENT_COUNT_FIELD,
            ACTIVE_LAUNCH_COUNT_FIELD, ARN_FIELD, CREATED_TIME_FIELD, DATA_DELIVERY_FIELD, DESCRIPTION_FIELD,
            EXPERIMENT_COUNT_FIELD, FEATURE_COUNT_FIELD, LAST_UPDATED_TIME_FIELD, LAUNCH_COUNT_FIELD, NAME_FIELD, STATUS_FIELD,
            TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long activeExperimentCount;

    private final Long activeLaunchCount;

    private final String arn;

    private final Instant createdTime;

    private final ProjectDataDelivery dataDelivery;

    private final String description;

    private final Long experimentCount;

    private final Long featureCount;

    private final Instant lastUpdatedTime;

    private final Long launchCount;

    private final String name;

    private final String status;

    private final Map<String, String> tags;

    private Project(BuilderImpl builder) {
        this.activeExperimentCount = builder.activeExperimentCount;
        this.activeLaunchCount = builder.activeLaunchCount;
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.dataDelivery = builder.dataDelivery;
        this.description = builder.description;
        this.experimentCount = builder.experimentCount;
        this.featureCount = builder.featureCount;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.launchCount = builder.launchCount;
        this.name = builder.name;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The number of ongoing experiments currently in the project.
     * </p>
     * 
     * @return The number of ongoing experiments currently in the project.
     */
    public final Long activeExperimentCount() {
        return activeExperimentCount;
    }

    /**
     * <p>
     * The number of ongoing launches currently in the project.
     * </p>
     * 
     * @return The number of ongoing launches currently in the project.
     */
    public final Long activeLaunchCount() {
        return activeLaunchCount;
    }

    /**
     * <p>
     * The name or ARN of the project.
     * </p>
     * 
     * @return The name or ARN of the project.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time that the project is created.
     * </p>
     * 
     * @return The date and time that the project is created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * A structure that contains information about where Evidently is to store evaluation events for longer term
     * storage.
     * </p>
     * 
     * @return A structure that contains information about where Evidently is to store evaluation events for longer term
     *         storage.
     */
    public final ProjectDataDelivery dataDelivery() {
        return dataDelivery;
    }

    /**
     * <p>
     * The user-entered description of the project.
     * </p>
     * 
     * @return The user-entered description of the project.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The number of experiments currently in the project. This includes all experiments that have been created and not
     * deleted, whether they are ongoing or not.
     * </p>
     * 
     * @return The number of experiments currently in the project. This includes all experiments that have been created
     *         and not deleted, whether they are ongoing or not.
     */
    public final Long experimentCount() {
        return experimentCount;
    }

    /**
     * <p>
     * The number of features currently in the project.
     * </p>
     * 
     * @return The number of features currently in the project.
     */
    public final Long featureCount() {
        return featureCount;
    }

    /**
     * <p>
     * The date and time that the project was most recently updated.
     * </p>
     * 
     * @return The date and time that the project was most recently updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The number of launches currently in the project. This includes all launches that have been created and not
     * deleted, whether they are ongoing or not.
     * </p>
     * 
     * @return The number of launches currently in the project. This includes all launches that have been created and
     *         not deleted, whether they are ongoing or not.
     */
    public final Long launchCount() {
        return launchCount;
    }

    /**
     * <p>
     * The name of the project.
     * </p>
     * 
     * @return The name of the project.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current state of the project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProjectStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the project.
     * @see ProjectStatus
     */
    public final ProjectStatus status() {
        return ProjectStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of the project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProjectStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the project.
     * @see ProjectStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of tag keys and values associated with this project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of tag keys and values associated with this project.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeExperimentCount());
        hashCode = 31 * hashCode + Objects.hashCode(activeLaunchCount());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(dataDelivery());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(experimentCount());
        hashCode = 31 * hashCode + Objects.hashCode(featureCount());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(launchCount());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project) obj;
        return Objects.equals(activeExperimentCount(), other.activeExperimentCount())
                && Objects.equals(activeLaunchCount(), other.activeLaunchCount()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(dataDelivery(), other.dataDelivery())
                && Objects.equals(description(), other.description())
                && Objects.equals(experimentCount(), other.experimentCount())
                && Objects.equals(featureCount(), other.featureCount())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(launchCount(), other.launchCount()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Project").add("ActiveExperimentCount", activeExperimentCount())
                .add("ActiveLaunchCount", activeLaunchCount()).add("Arn", arn()).add("CreatedTime", createdTime())
                .add("DataDelivery", dataDelivery()).add("Description", description()).add("ExperimentCount", experimentCount())
                .add("FeatureCount", featureCount()).add("LastUpdatedTime", lastUpdatedTime()).add("LaunchCount", launchCount())
                .add("Name", name()).add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activeExperimentCount":
            return Optional.ofNullable(clazz.cast(activeExperimentCount()));
        case "activeLaunchCount":
            return Optional.ofNullable(clazz.cast(activeLaunchCount()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "dataDelivery":
            return Optional.ofNullable(clazz.cast(dataDelivery()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "experimentCount":
            return Optional.ofNullable(clazz.cast(experimentCount()));
        case "featureCount":
            return Optional.ofNullable(clazz.cast(featureCount()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "launchCount":
            return Optional.ofNullable(clazz.cast(launchCount()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Project, T> g) {
        return obj -> g.apply((Project) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Project> {
        /**
         * <p>
         * The number of ongoing experiments currently in the project.
         * </p>
         * 
         * @param activeExperimentCount
         *        The number of ongoing experiments currently in the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeExperimentCount(Long activeExperimentCount);

        /**
         * <p>
         * The number of ongoing launches currently in the project.
         * </p>
         * 
         * @param activeLaunchCount
         *        The number of ongoing launches currently in the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeLaunchCount(Long activeLaunchCount);

        /**
         * <p>
         * The name or ARN of the project.
         * </p>
         * 
         * @param arn
         *        The name or ARN of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time that the project is created.
         * </p>
         * 
         * @param createdTime
         *        The date and time that the project is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * A structure that contains information about where Evidently is to store evaluation events for longer term
         * storage.
         * </p>
         * 
         * @param dataDelivery
         *        A structure that contains information about where Evidently is to store evaluation events for longer
         *        term storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataDelivery(ProjectDataDelivery dataDelivery);

        /**
         * <p>
         * A structure that contains information about where Evidently is to store evaluation events for longer term
         * storage.
         * </p>
         * This is a convenience that creates an instance of the {@link ProjectDataDelivery.Builder} avoiding the need
         * to create one manually via {@link ProjectDataDelivery#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectDataDelivery.Builder#build()} is called immediately and
         * its result is passed to {@link #dataDelivery(ProjectDataDelivery)}.
         * 
         * @param dataDelivery
         *        a consumer that will call methods on {@link ProjectDataDelivery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataDelivery(ProjectDataDelivery)
         */
        default Builder dataDelivery(Consumer<ProjectDataDelivery.Builder> dataDelivery) {
            return dataDelivery(ProjectDataDelivery.builder().applyMutation(dataDelivery).build());
        }

        /**
         * <p>
         * The user-entered description of the project.
         * </p>
         * 
         * @param description
         *        The user-entered description of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The number of experiments currently in the project. This includes all experiments that have been created and
         * not deleted, whether they are ongoing or not.
         * </p>
         * 
         * @param experimentCount
         *        The number of experiments currently in the project. This includes all experiments that have been
         *        created and not deleted, whether they are ongoing or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentCount(Long experimentCount);

        /**
         * <p>
         * The number of features currently in the project.
         * </p>
         * 
         * @param featureCount
         *        The number of features currently in the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureCount(Long featureCount);

        /**
         * <p>
         * The date and time that the project was most recently updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The date and time that the project was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The number of launches currently in the project. This includes all launches that have been created and not
         * deleted, whether they are ongoing or not.
         * </p>
         * 
         * @param launchCount
         *        The number of launches currently in the project. This includes all launches that have been created and
         *        not deleted, whether they are ongoing or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchCount(Long launchCount);

        /**
         * <p>
         * The name of the project.
         * </p>
         * 
         * @param name
         *        The name of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current state of the project.
         * </p>
         * 
         * @param status
         *        The current state of the project.
         * @see ProjectStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the project.
         * </p>
         * 
         * @param status
         *        The current state of the project.
         * @see ProjectStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectStatus
         */
        Builder status(ProjectStatus status);

        /**
         * <p>
         * The list of tag keys and values associated with this project.
         * </p>
         * 
         * @param tags
         *        The list of tag keys and values associated with this project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private Long activeExperimentCount;

        private Long activeLaunchCount;

        private String arn;

        private Instant createdTime;

        private ProjectDataDelivery dataDelivery;

        private String description;

        private Long experimentCount;

        private Long featureCount;

        private Instant lastUpdatedTime;

        private Long launchCount;

        private String name;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Project model) {
            activeExperimentCount(model.activeExperimentCount);
            activeLaunchCount(model.activeLaunchCount);
            arn(model.arn);
            createdTime(model.createdTime);
            dataDelivery(model.dataDelivery);
            description(model.description);
            experimentCount(model.experimentCount);
            featureCount(model.featureCount);
            lastUpdatedTime(model.lastUpdatedTime);
            launchCount(model.launchCount);
            name(model.name);
            status(model.status);
            tags(model.tags);
        }

        public final Long getActiveExperimentCount() {
            return activeExperimentCount;
        }

        public final void setActiveExperimentCount(Long activeExperimentCount) {
            this.activeExperimentCount = activeExperimentCount;
        }

        @Override
        @Transient
        public final Builder activeExperimentCount(Long activeExperimentCount) {
            this.activeExperimentCount = activeExperimentCount;
            return this;
        }

        public final Long getActiveLaunchCount() {
            return activeLaunchCount;
        }

        public final void setActiveLaunchCount(Long activeLaunchCount) {
            this.activeLaunchCount = activeLaunchCount;
        }

        @Override
        @Transient
        public final Builder activeLaunchCount(Long activeLaunchCount) {
            this.activeLaunchCount = activeLaunchCount;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final ProjectDataDelivery.Builder getDataDelivery() {
            return dataDelivery != null ? dataDelivery.toBuilder() : null;
        }

        public final void setDataDelivery(ProjectDataDelivery.BuilderImpl dataDelivery) {
            this.dataDelivery = dataDelivery != null ? dataDelivery.build() : null;
        }

        @Override
        @Transient
        public final Builder dataDelivery(ProjectDataDelivery dataDelivery) {
            this.dataDelivery = dataDelivery;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Long getExperimentCount() {
            return experimentCount;
        }

        public final void setExperimentCount(Long experimentCount) {
            this.experimentCount = experimentCount;
        }

        @Override
        @Transient
        public final Builder experimentCount(Long experimentCount) {
            this.experimentCount = experimentCount;
            return this;
        }

        public final Long getFeatureCount() {
            return featureCount;
        }

        public final void setFeatureCount(Long featureCount) {
            this.featureCount = featureCount;
        }

        @Override
        @Transient
        public final Builder featureCount(Long featureCount) {
            this.featureCount = featureCount;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Long getLaunchCount() {
            return launchCount;
        }

        public final void setLaunchCount(Long launchCount) {
            this.launchCount = launchCount;
        }

        @Override
        @Transient
        public final Builder launchCount(Long launchCount) {
            this.launchCount = launchCount;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ProjectStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Project build() {
            return new Project(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
