/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about where Evidently is to store evaluation events for longer term storage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProjectDataDelivery implements SdkPojo, Serializable,
        ToCopyableBuilder<ProjectDataDelivery.Builder, ProjectDataDelivery> {
    private static final SdkField<CloudWatchLogsDestination> CLOUD_WATCH_LOGS_FIELD = SdkField
            .<CloudWatchLogsDestination> builder(MarshallingType.SDK_POJO).memberName("cloudWatchLogs")
            .getter(getter(ProjectDataDelivery::cloudWatchLogs)).setter(setter(Builder::cloudWatchLogs))
            .constructor(CloudWatchLogsDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()).build();

    private static final SdkField<S3Destination> S3_DESTINATION_FIELD = SdkField
            .<S3Destination> builder(MarshallingType.SDK_POJO).memberName("s3Destination")
            .getter(getter(ProjectDataDelivery::s3Destination)).setter(setter(Builder::s3Destination))
            .constructor(S3Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_FIELD,
            S3_DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final CloudWatchLogsDestination cloudWatchLogs;

    private final S3Destination s3Destination;

    private ProjectDataDelivery(BuilderImpl builder) {
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.s3Destination = builder.s3Destination;
    }

    /**
     * <p>
     * If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.
     * </p>
     * 
     * @return If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.
     */
    public final CloudWatchLogsDestination cloudWatchLogs() {
        return cloudWatchLogs;
    }

    /**
     * <p>
     * If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket
     * prefix.
     * </p>
     * 
     * @return If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and
     *         bucket prefix.
     */
    public final S3Destination s3Destination() {
        return s3Destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(s3Destination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectDataDelivery)) {
            return false;
        }
        ProjectDataDelivery other = (ProjectDataDelivery) obj;
        return Objects.equals(cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(s3Destination(), other.s3Destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProjectDataDelivery").add("CloudWatchLogs", cloudWatchLogs())
                .add("S3Destination", s3Destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudWatchLogs":
            return Optional.ofNullable(clazz.cast(cloudWatchLogs()));
        case "s3Destination":
            return Optional.ofNullable(clazz.cast(s3Destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectDataDelivery, T> g) {
        return obj -> g.apply((ProjectDataDelivery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProjectDataDelivery> {
        /**
         * <p>
         * If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.
         * </p>
         * 
         * @param cloudWatchLogs
         *        If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogs(CloudWatchLogsDestination cloudWatchLogs);

        /**
         * <p>
         * If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchLogsDestination.Builder} avoiding the
         * need to create one manually via {@link CloudWatchLogsDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchLogsDestination.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLogs(CloudWatchLogsDestination)}.
         * 
         * @param cloudWatchLogs
         *        a consumer that will call methods on {@link CloudWatchLogsDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogs(CloudWatchLogsDestination)
         */
        default Builder cloudWatchLogs(Consumer<CloudWatchLogsDestination.Builder> cloudWatchLogs) {
            return cloudWatchLogs(CloudWatchLogsDestination.builder().applyMutation(cloudWatchLogs).build());
        }

        /**
         * <p>
         * If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and
         * bucket prefix.
         * </p>
         * 
         * @param s3Destination
         *        If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name
         *        and bucket prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Destination(S3Destination s3Destination);

        /**
         * <p>
         * If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and
         * bucket prefix.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Destination.Builder} avoiding the need to
         * create one manually via {@link S3Destination#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Destination.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Destination(S3Destination)}.
         * 
         * @param s3Destination
         *        a consumer that will call methods on {@link S3Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Destination(S3Destination)
         */
        default Builder s3Destination(Consumer<S3Destination.Builder> s3Destination) {
            return s3Destination(S3Destination.builder().applyMutation(s3Destination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudWatchLogsDestination cloudWatchLogs;

        private S3Destination s3Destination;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectDataDelivery model) {
            cloudWatchLogs(model.cloudWatchLogs);
            s3Destination(model.s3Destination);
        }

        public final CloudWatchLogsDestination.Builder getCloudWatchLogs() {
            return cloudWatchLogs != null ? cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogsDestination.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        @Transient
        public final Builder cloudWatchLogs(CloudWatchLogsDestination cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final S3Destination.Builder getS3Destination() {
            return s3Destination != null ? s3Destination.toBuilder() : null;
        }

        public final void setS3Destination(S3Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        @Transient
        public final Builder s3Destination(S3Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        @Override
        public ProjectDataDelivery build() {
            return new ProjectDataDelivery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
