/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutProjectEventsResponse extends EvidentlyResponse implements
        ToCopyableBuilder<PutProjectEventsResponse.Builder, PutProjectEventsResponse> {
    private static final SdkField<List<PutProjectEventsResultEntry>> EVENT_RESULTS_FIELD = SdkField
            .<List<PutProjectEventsResultEntry>> builder(MarshallingType.LIST)
            .memberName("eventResults")
            .getter(getter(PutProjectEventsResponse::eventResults))
            .setter(setter(Builder::eventResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PutProjectEventsResultEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(PutProjectEventsResultEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> FAILED_EVENT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("failedEventCount").getter(getter(PutProjectEventsResponse::failedEventCount))
            .setter(setter(Builder::failedEventCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedEventCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_RESULTS_FIELD,
            FAILED_EVENT_COUNT_FIELD));

    private final List<PutProjectEventsResultEntry> eventResults;

    private final Integer failedEventCount;

    private PutProjectEventsResponse(BuilderImpl builder) {
        super(builder);
        this.eventResults = builder.eventResults;
        this.failedEventCount = builder.failedEventCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventResults() {
        return eventResults != null && !(eventResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure that contains Evidently's response to the sent events, including an event ID and error codes, if any.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventResults} method.
     * </p>
     * 
     * @return A structure that contains Evidently's response to the sent events, including an event ID and error codes,
     *         if any.
     */
    public final List<PutProjectEventsResultEntry> eventResults() {
        return eventResults;
    }

    /**
     * <p>
     * The number of events in the operation that could not be used by Evidently.
     * </p>
     * 
     * @return The number of events in the operation that could not be used by Evidently.
     */
    public final Integer failedEventCount() {
        return failedEventCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEventResults() ? eventResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(failedEventCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutProjectEventsResponse)) {
            return false;
        }
        PutProjectEventsResponse other = (PutProjectEventsResponse) obj;
        return hasEventResults() == other.hasEventResults() && Objects.equals(eventResults(), other.eventResults())
                && Objects.equals(failedEventCount(), other.failedEventCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutProjectEventsResponse").add("EventResults", hasEventResults() ? eventResults() : null)
                .add("FailedEventCount", failedEventCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventResults":
            return Optional.ofNullable(clazz.cast(eventResults()));
        case "failedEventCount":
            return Optional.ofNullable(clazz.cast(failedEventCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutProjectEventsResponse, T> g) {
        return obj -> g.apply((PutProjectEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EvidentlyResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutProjectEventsResponse> {
        /**
         * <p>
         * A structure that contains Evidently's response to the sent events, including an event ID and error codes, if
         * any.
         * </p>
         * 
         * @param eventResults
         *        A structure that contains Evidently's response to the sent events, including an event ID and error
         *        codes, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventResults(Collection<PutProjectEventsResultEntry> eventResults);

        /**
         * <p>
         * A structure that contains Evidently's response to the sent events, including an event ID and error codes, if
         * any.
         * </p>
         * 
         * @param eventResults
         *        A structure that contains Evidently's response to the sent events, including an event ID and error
         *        codes, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventResults(PutProjectEventsResultEntry... eventResults);

        /**
         * <p>
         * A structure that contains Evidently's response to the sent events, including an event ID and error codes, if
         * any.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PutProjectEventsResultEntry>.Builder}
         * avoiding the need to create one manually via {@link List<PutProjectEventsResultEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PutProjectEventsResultEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #eventResults(List<PutProjectEventsResultEntry>)}.
         * 
         * @param eventResults
         *        a consumer that will call methods on {@link List<PutProjectEventsResultEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventResults(List<PutProjectEventsResultEntry>)
         */
        Builder eventResults(Consumer<PutProjectEventsResultEntry.Builder>... eventResults);

        /**
         * <p>
         * The number of events in the operation that could not be used by Evidently.
         * </p>
         * 
         * @param failedEventCount
         *        The number of events in the operation that could not be used by Evidently.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEventCount(Integer failedEventCount);
    }

    static final class BuilderImpl extends EvidentlyResponse.BuilderImpl implements Builder {
        private List<PutProjectEventsResultEntry> eventResults = DefaultSdkAutoConstructList.getInstance();

        private Integer failedEventCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PutProjectEventsResponse model) {
            super(model);
            eventResults(model.eventResults);
            failedEventCount(model.failedEventCount);
        }

        public final List<PutProjectEventsResultEntry.Builder> getEventResults() {
            List<PutProjectEventsResultEntry.Builder> result = PutProjectEventsResultEntryListCopier
                    .copyToBuilder(this.eventResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventResults(Collection<PutProjectEventsResultEntry.BuilderImpl> eventResults) {
            this.eventResults = PutProjectEventsResultEntryListCopier.copyFromBuilder(eventResults);
        }

        @Override
        @Transient
        public final Builder eventResults(Collection<PutProjectEventsResultEntry> eventResults) {
            this.eventResults = PutProjectEventsResultEntryListCopier.copy(eventResults);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventResults(PutProjectEventsResultEntry... eventResults) {
            eventResults(Arrays.asList(eventResults));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventResults(Consumer<PutProjectEventsResultEntry.Builder>... eventResults) {
            eventResults(Stream.of(eventResults).map(c -> PutProjectEventsResultEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getFailedEventCount() {
            return failedEventCount;
        }

        public final void setFailedEventCount(Integer failedEventCount) {
            this.failedEventCount = failedEventCount;
        }

        @Override
        @Transient
        public final Builder failedEventCount(Integer failedEventCount) {
            this.failedEventCount = failedEventCount;
            return this;
        }

        @Override
        public PutProjectEventsResponse build() {
            return new PutProjectEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
