/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array of structures that define the traffic allocation percentages among the feature variations during each step
 * of a launch. This also defines the start time of each step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledSplitsLaunchDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledSplitsLaunchDefinition.Builder, ScheduledSplitsLaunchDefinition> {
    private static final SdkField<List<ScheduledSplit>> STEPS_FIELD = SdkField
            .<List<ScheduledSplit>> builder(MarshallingType.LIST)
            .memberName("steps")
            .getter(getter(ScheduledSplitsLaunchDefinition::steps))
            .setter(setter(Builder::steps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("steps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduledSplit> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduledSplit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ScheduledSplit> steps;

    private ScheduledSplitsLaunchDefinition(BuilderImpl builder) {
        this.steps = builder.steps;
    }

    /**
     * For responses, this returns true if the service returned a value for the Steps property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSteps() {
        return steps != null && !(steps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that define the traffic allocation percentages among the feature variations during each
     * step of the launch. This also defines the start time of each step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSteps} method.
     * </p>
     * 
     * @return An array of structures that define the traffic allocation percentages among the feature variations during
     *         each step of the launch. This also defines the start time of each step.
     */
    public final List<ScheduledSplit> steps() {
        return steps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSteps() ? steps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledSplitsLaunchDefinition)) {
            return false;
        }
        ScheduledSplitsLaunchDefinition other = (ScheduledSplitsLaunchDefinition) obj;
        return hasSteps() == other.hasSteps() && Objects.equals(steps(), other.steps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledSplitsLaunchDefinition").add("Steps", hasSteps() ? steps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "steps":
            return Optional.ofNullable(clazz.cast(steps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledSplitsLaunchDefinition, T> g) {
        return obj -> g.apply((ScheduledSplitsLaunchDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledSplitsLaunchDefinition> {
        /**
         * <p>
         * An array of structures that define the traffic allocation percentages among the feature variations during
         * each step of the launch. This also defines the start time of each step.
         * </p>
         * 
         * @param steps
         *        An array of structures that define the traffic allocation percentages among the feature variations
         *        during each step of the launch. This also defines the start time of each step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Collection<ScheduledSplit> steps);

        /**
         * <p>
         * An array of structures that define the traffic allocation percentages among the feature variations during
         * each step of the launch. This also defines the start time of each step.
         * </p>
         * 
         * @param steps
         *        An array of structures that define the traffic allocation percentages among the feature variations
         *        during each step of the launch. This also defines the start time of each step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(ScheduledSplit... steps);

        /**
         * <p>
         * An array of structures that define the traffic allocation percentages among the feature variations during
         * each step of the launch. This also defines the start time of each step.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ScheduledSplit>.Builder} avoiding the need
         * to create one manually via {@link List<ScheduledSplit>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScheduledSplit>.Builder#build()} is called immediately and
         * its result is passed to {@link #steps(List<ScheduledSplit>)}.
         * 
         * @param steps
         *        a consumer that will call methods on {@link List<ScheduledSplit>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #steps(List<ScheduledSplit>)
         */
        Builder steps(Consumer<ScheduledSplit.Builder>... steps);
    }

    static final class BuilderImpl implements Builder {
        private List<ScheduledSplit> steps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledSplitsLaunchDefinition model) {
            steps(model.steps);
        }

        public final List<ScheduledSplit.Builder> getSteps() {
            List<ScheduledSplit.Builder> result = ScheduledStepListCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<ScheduledSplit.BuilderImpl> steps) {
            this.steps = ScheduledStepListCopier.copyFromBuilder(steps);
        }

        @Override
        @Transient
        public final Builder steps(Collection<ScheduledSplit> steps) {
            this.steps = ScheduledStepListCopier.copy(steps);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder steps(ScheduledSplit... steps) {
            steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder steps(Consumer<ScheduledSplit.Builder>... steps) {
            steps(Stream.of(steps).map(c -> ScheduledSplit.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ScheduledSplitsLaunchDefinition build() {
            return new ScheduledSplitsLaunchDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
