/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFeatureResponse extends EvidentlyResponse implements
        ToCopyableBuilder<UpdateFeatureResponse.Builder, UpdateFeatureResponse> {
    private static final SdkField<Feature> FEATURE_FIELD = SdkField.<Feature> builder(MarshallingType.SDK_POJO)
            .memberName("feature").getter(getter(UpdateFeatureResponse::feature)).setter(setter(Builder::feature))
            .constructor(Feature::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("feature").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_FIELD));

    private final Feature feature;

    private UpdateFeatureResponse(BuilderImpl builder) {
        super(builder);
        this.feature = builder.feature;
    }

    /**
     * <p>
     * A structure that contains information about the updated feature.
     * </p>
     * 
     * @return A structure that contains information about the updated feature.
     */
    public final Feature feature() {
        return feature;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(feature());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFeatureResponse)) {
            return false;
        }
        UpdateFeatureResponse other = (UpdateFeatureResponse) obj;
        return Objects.equals(feature(), other.feature());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFeatureResponse").add("Feature", feature()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "feature":
            return Optional.ofNullable(clazz.cast(feature()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFeatureResponse, T> g) {
        return obj -> g.apply((UpdateFeatureResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EvidentlyResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFeatureResponse> {
        /**
         * <p>
         * A structure that contains information about the updated feature.
         * </p>
         * 
         * @param feature
         *        A structure that contains information about the updated feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feature(Feature feature);

        /**
         * <p>
         * A structure that contains information about the updated feature.
         * </p>
         * This is a convenience that creates an instance of the {@link Feature.Builder} avoiding the need to create one
         * manually via {@link Feature#builder()}.
         *
         * When the {@link Consumer} completes, {@link Feature.Builder#build()} is called immediately and its result is
         * passed to {@link #feature(Feature)}.
         * 
         * @param feature
         *        a consumer that will call methods on {@link Feature.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #feature(Feature)
         */
        default Builder feature(Consumer<Feature.Builder> feature) {
            return feature(Feature.builder().applyMutation(feature).build());
        }
    }

    static final class BuilderImpl extends EvidentlyResponse.BuilderImpl implements Builder {
        private Feature feature;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFeatureResponse model) {
            super(model);
            feature(model.feature);
        }

        public final Feature.Builder getFeature() {
            return feature != null ? feature.toBuilder() : null;
        }

        public final void setFeature(Feature.BuilderImpl feature) {
            this.feature = feature != null ? feature.build() : null;
        }

        @Override
        @Transient
        public final Builder feature(Feature feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public UpdateFeatureResponse build() {
            return new UpdateFeatureResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
