/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure defines the traffic allocation percentages among the feature variations during one step of a launch,
 * and the start time of that step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledSplit implements SdkPojo, Serializable, ToCopyableBuilder<ScheduledSplit.Builder, ScheduledSplit> {
    private static final SdkField<Map<String, Long>> GROUP_WEIGHTS_FIELD = SdkField
            .<Map<String, Long>> builder(MarshallingType.MAP)
            .memberName("groupWeights")
            .getter(getter(ScheduledSplit::groupWeights))
            .setter(setter(Builder::groupWeights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupWeights").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Long> builder(MarshallingType.LONG)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(ScheduledSplit::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_WEIGHTS_FIELD,
            START_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, Long> groupWeights;

    private final Instant startTime;

    private ScheduledSplit(BuilderImpl builder) {
        this.groupWeights = builder.groupWeights;
        this.startTime = builder.startTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupWeights property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupWeights() {
        return groupWeights != null && !(groupWeights instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The traffic allocation percentages among the feature variations during one step of a launch. This is a set of
     * key-value pairs. The keys are variation names. The values represent the percentage of traffic to allocate to that
     * variation during this step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupWeights} method.
     * </p>
     * 
     * @return The traffic allocation percentages among the feature variations during one step of a launch. This is a
     *         set of key-value pairs. The keys are variation names. The values represent the percentage of traffic to
     *         allocate to that variation during this step.
     */
    public final Map<String, Long> groupWeights() {
        return groupWeights;
    }

    /**
     * <p>
     * The date and time that this step of the launch starts.
     * </p>
     * 
     * @return The date and time that this step of the launch starts.
     */
    public final Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupWeights() ? groupWeights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledSplit)) {
            return false;
        }
        ScheduledSplit other = (ScheduledSplit) obj;
        return hasGroupWeights() == other.hasGroupWeights() && Objects.equals(groupWeights(), other.groupWeights())
                && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledSplit").add("GroupWeights", hasGroupWeights() ? groupWeights() : null)
                .add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groupWeights":
            return Optional.ofNullable(clazz.cast(groupWeights()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledSplit, T> g) {
        return obj -> g.apply((ScheduledSplit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledSplit> {
        /**
         * <p>
         * The traffic allocation percentages among the feature variations during one step of a launch. This is a set of
         * key-value pairs. The keys are variation names. The values represent the percentage of traffic to allocate to
         * that variation during this step.
         * </p>
         * 
         * @param groupWeights
         *        The traffic allocation percentages among the feature variations during one step of a launch. This is a
         *        set of key-value pairs. The keys are variation names. The values represent the percentage of traffic
         *        to allocate to that variation during this step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupWeights(Map<String, Long> groupWeights);

        /**
         * <p>
         * The date and time that this step of the launch starts.
         * </p>
         * 
         * @param startTime
         *        The date and time that this step of the launch starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Long> groupWeights = DefaultSdkAutoConstructMap.getInstance();

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledSplit model) {
            groupWeights(model.groupWeights);
            startTime(model.startTime);
        }

        public final Map<String, Long> getGroupWeights() {
            if (groupWeights instanceof SdkAutoConstructMap) {
                return null;
            }
            return groupWeights;
        }

        public final void setGroupWeights(Map<String, Long> groupWeights) {
            this.groupWeights = GroupToWeightMapCopier.copy(groupWeights);
        }

        @Override
        public final Builder groupWeights(Map<String, Long> groupWeights) {
            this.groupWeights = GroupToWeightMapCopier.copy(groupWeights);
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public ScheduledSplit build() {
            return new ScheduledSplit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
