/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFeatureRequest extends EvidentlyRequest implements
        ToCopyableBuilder<UpdateFeatureRequest.Builder, UpdateFeatureRequest> {
    private static final SdkField<List<VariationConfig>> ADD_OR_UPDATE_VARIATIONS_FIELD = SdkField
            .<List<VariationConfig>> builder(MarshallingType.LIST)
            .memberName("addOrUpdateVariations")
            .getter(getter(UpdateFeatureRequest::addOrUpdateVariations))
            .setter(setter(Builder::addOrUpdateVariations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOrUpdateVariations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VariationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(VariationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_VARIATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultVariation").getter(getter(UpdateFeatureRequest::defaultVariation))
            .setter(setter(Builder::defaultVariation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVariation").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateFeatureRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> ENTITY_OVERRIDES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("entityOverrides")
            .getter(getter(UpdateFeatureRequest::entityOverrides))
            .setter(setter(Builder::entityOverrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityOverrides").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> EVALUATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evaluationStrategy").getter(getter(UpdateFeatureRequest::evaluationStrategyAsString))
            .setter(setter(Builder::evaluationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationStrategy").build())
            .build();

    private static final SdkField<String> FEATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("feature")
            .getter(getter(UpdateFeatureRequest::feature)).setter(setter(Builder::feature))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("feature").build()).build();

    private static final SdkField<String> PROJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("project")
            .getter(getter(UpdateFeatureRequest::project)).setter(setter(Builder::project))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()).build();

    private static final SdkField<List<String>> REMOVE_VARIATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("removeVariations")
            .getter(getter(UpdateFeatureRequest::removeVariations))
            .setter(setter(Builder::removeVariations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeVariations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADD_OR_UPDATE_VARIATIONS_FIELD, DEFAULT_VARIATION_FIELD, DESCRIPTION_FIELD, ENTITY_OVERRIDES_FIELD,
            EVALUATION_STRATEGY_FIELD, FEATURE_FIELD, PROJECT_FIELD, REMOVE_VARIATIONS_FIELD));

    private final List<VariationConfig> addOrUpdateVariations;

    private final String defaultVariation;

    private final String description;

    private final Map<String, String> entityOverrides;

    private final String evaluationStrategy;

    private final String feature;

    private final String project;

    private final List<String> removeVariations;

    private UpdateFeatureRequest(BuilderImpl builder) {
        super(builder);
        this.addOrUpdateVariations = builder.addOrUpdateVariations;
        this.defaultVariation = builder.defaultVariation;
        this.description = builder.description;
        this.entityOverrides = builder.entityOverrides;
        this.evaluationStrategy = builder.evaluationStrategy;
        this.feature = builder.feature;
        this.project = builder.project;
        this.removeVariations = builder.removeVariations;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddOrUpdateVariations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAddOrUpdateVariations() {
        return addOrUpdateVariations != null && !(addOrUpdateVariations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * To update variation configurations for this feature, or add new ones, specify this structure. In this array,
     * include any variations that you want to add or update. If the array includes a variation name that already exists
     * for this feature, it is updated. If it includes a new variation name, it is added as a new variation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddOrUpdateVariations} method.
     * </p>
     * 
     * @return To update variation configurations for this feature, or add new ones, specify this structure. In this
     *         array, include any variations that you want to add or update. If the array includes a variation name that
     *         already exists for this feature, it is updated. If it includes a new variation name, it is added as a new
     *         variation.
     */
    public final List<VariationConfig> addOrUpdateVariations() {
        return addOrUpdateVariations;
    }

    /**
     * <p>
     * The name of the variation to use as the default variation. The default variation is served to users who are not
     * allocated to any ongoing launches or experiments of this feature.
     * </p>
     * 
     * @return The name of the variation to use as the default variation. The default variation is served to users who
     *         are not allocated to any ongoing launches or experiments of this feature.
     */
    public final String defaultVariation() {
        return defaultVariation;
    }

    /**
     * <p>
     * An optional description of the feature.
     * </p>
     * 
     * @return An optional description of the feature.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityOverrides property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntityOverrides() {
        return entityOverrides != null && !(entityOverrides instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specified users that should always be served a specific variation of a feature. Each user is specified by a
     * key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier.
     * For the value, specify the name of the variation that they are to be served.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityOverrides} method.
     * </p>
     * 
     * @return Specified users that should always be served a specific variation of a feature. Each user is specified by
     *         a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other
     *         identifier. For the value, specify the name of the variation that they are to be served.
     */
    public final Map<String, String> entityOverrides() {
        return entityOverrides;
    }

    /**
     * <p>
     * Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or
     * experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #evaluationStrategy} will return {@link FeatureEvaluationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #evaluationStrategyAsString}.
     * </p>
     * 
     * @return Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or
     *         experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.
     * @see FeatureEvaluationStrategy
     */
    public final FeatureEvaluationStrategy evaluationStrategy() {
        return FeatureEvaluationStrategy.fromValue(evaluationStrategy);
    }

    /**
     * <p>
     * Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or
     * experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #evaluationStrategy} will return {@link FeatureEvaluationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #evaluationStrategyAsString}.
     * </p>
     * 
     * @return Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or
     *         experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.
     * @see FeatureEvaluationStrategy
     */
    public final String evaluationStrategyAsString() {
        return evaluationStrategy;
    }

    /**
     * <p>
     * The name of the feature to be updated.
     * </p>
     * 
     * @return The name of the feature to be updated.
     */
    public final String feature() {
        return feature;
    }

    /**
     * <p>
     * The name or ARN of the project that contains the feature to be updated.
     * </p>
     * 
     * @return The name or ARN of the project that contains the feature to be updated.
     */
    public final String project() {
        return project;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveVariations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveVariations() {
        return removeVariations != null && !(removeVariations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Removes a variation from the feature. If the variation you specify doesn't exist, then this makes no change and
     * does not report an error.
     * </p>
     * <p>
     * This operation fails if you try to remove a variation that is part of an ongoing launch or experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveVariations} method.
     * </p>
     * 
     * @return Removes a variation from the feature. If the variation you specify doesn't exist, then this makes no
     *         change and does not report an error.</p>
     *         <p>
     *         This operation fails if you try to remove a variation that is part of an ongoing launch or experiment.
     */
    public final List<String> removeVariations() {
        return removeVariations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAddOrUpdateVariations() ? addOrUpdateVariations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultVariation());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityOverrides() ? entityOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(evaluationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(feature());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveVariations() ? removeVariations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFeatureRequest)) {
            return false;
        }
        UpdateFeatureRequest other = (UpdateFeatureRequest) obj;
        return hasAddOrUpdateVariations() == other.hasAddOrUpdateVariations()
                && Objects.equals(addOrUpdateVariations(), other.addOrUpdateVariations())
                && Objects.equals(defaultVariation(), other.defaultVariation())
                && Objects.equals(description(), other.description()) && hasEntityOverrides() == other.hasEntityOverrides()
                && Objects.equals(entityOverrides(), other.entityOverrides())
                && Objects.equals(evaluationStrategyAsString(), other.evaluationStrategyAsString())
                && Objects.equals(feature(), other.feature()) && Objects.equals(project(), other.project())
                && hasRemoveVariations() == other.hasRemoveVariations()
                && Objects.equals(removeVariations(), other.removeVariations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFeatureRequest")
                .add("AddOrUpdateVariations", hasAddOrUpdateVariations() ? addOrUpdateVariations() : null)
                .add("DefaultVariation", defaultVariation()).add("Description", description())
                .add("EntityOverrides", hasEntityOverrides() ? entityOverrides() : null)
                .add("EvaluationStrategy", evaluationStrategyAsString()).add("Feature", feature()).add("Project", project())
                .add("RemoveVariations", hasRemoveVariations() ? removeVariations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addOrUpdateVariations":
            return Optional.ofNullable(clazz.cast(addOrUpdateVariations()));
        case "defaultVariation":
            return Optional.ofNullable(clazz.cast(defaultVariation()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "entityOverrides":
            return Optional.ofNullable(clazz.cast(entityOverrides()));
        case "evaluationStrategy":
            return Optional.ofNullable(clazz.cast(evaluationStrategyAsString()));
        case "feature":
            return Optional.ofNullable(clazz.cast(feature()));
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        case "removeVariations":
            return Optional.ofNullable(clazz.cast(removeVariations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFeatureRequest, T> g) {
        return obj -> g.apply((UpdateFeatureRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EvidentlyRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFeatureRequest> {
        /**
         * <p>
         * To update variation configurations for this feature, or add new ones, specify this structure. In this array,
         * include any variations that you want to add or update. If the array includes a variation name that already
         * exists for this feature, it is updated. If it includes a new variation name, it is added as a new variation.
         * </p>
         * 
         * @param addOrUpdateVariations
         *        To update variation configurations for this feature, or add new ones, specify this structure. In this
         *        array, include any variations that you want to add or update. If the array includes a variation name
         *        that already exists for this feature, it is updated. If it includes a new variation name, it is added
         *        as a new variation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOrUpdateVariations(Collection<VariationConfig> addOrUpdateVariations);

        /**
         * <p>
         * To update variation configurations for this feature, or add new ones, specify this structure. In this array,
         * include any variations that you want to add or update. If the array includes a variation name that already
         * exists for this feature, it is updated. If it includes a new variation name, it is added as a new variation.
         * </p>
         * 
         * @param addOrUpdateVariations
         *        To update variation configurations for this feature, or add new ones, specify this structure. In this
         *        array, include any variations that you want to add or update. If the array includes a variation name
         *        that already exists for this feature, it is updated. If it includes a new variation name, it is added
         *        as a new variation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOrUpdateVariations(VariationConfig... addOrUpdateVariations);

        /**
         * <p>
         * To update variation configurations for this feature, or add new ones, specify this structure. In this array,
         * include any variations that you want to add or update. If the array includes a variation name that already
         * exists for this feature, it is updated. If it includes a new variation name, it is added as a new variation.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<VariationConfig>.Builder} avoiding
         * the need to create one manually via {@link List<VariationConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VariationConfig>.Builder#build()} is called immediately and
         * its result is passed to {@link #addOrUpdateVariations(List<VariationConfig>)}.
         * 
         * @param addOrUpdateVariations
         *        a consumer that will call methods on {@link List<VariationConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addOrUpdateVariations(List<VariationConfig>)
         */
        Builder addOrUpdateVariations(Consumer<VariationConfig.Builder>... addOrUpdateVariations);

        /**
         * <p>
         * The name of the variation to use as the default variation. The default variation is served to users who are
         * not allocated to any ongoing launches or experiments of this feature.
         * </p>
         * 
         * @param defaultVariation
         *        The name of the variation to use as the default variation. The default variation is served to users
         *        who are not allocated to any ongoing launches or experiments of this feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVariation(String defaultVariation);

        /**
         * <p>
         * An optional description of the feature.
         * </p>
         * 
         * @param description
         *        An optional description of the feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specified users that should always be served a specific variation of a feature. Each user is specified by a
         * key-value pair . For each key, specify a user by entering their user ID, account ID, or some other
         * identifier. For the value, specify the name of the variation that they are to be served.
         * </p>
         * 
         * @param entityOverrides
         *        Specified users that should always be served a specific variation of a feature. Each user is specified
         *        by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some
         *        other identifier. For the value, specify the name of the variation that they are to be served.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityOverrides(Map<String, String> entityOverrides);

        /**
         * <p>
         * Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or
         * experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.
         * </p>
         * 
         * @param evaluationStrategy
         *        Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or
         *        experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users
         *        instead.
         * @see FeatureEvaluationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureEvaluationStrategy
         */
        Builder evaluationStrategy(String evaluationStrategy);

        /**
         * <p>
         * Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or
         * experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.
         * </p>
         * 
         * @param evaluationStrategy
         *        Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or
         *        experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users
         *        instead.
         * @see FeatureEvaluationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureEvaluationStrategy
         */
        Builder evaluationStrategy(FeatureEvaluationStrategy evaluationStrategy);

        /**
         * <p>
         * The name of the feature to be updated.
         * </p>
         * 
         * @param feature
         *        The name of the feature to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feature(String feature);

        /**
         * <p>
         * The name or ARN of the project that contains the feature to be updated.
         * </p>
         * 
         * @param project
         *        The name or ARN of the project that contains the feature to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(String project);

        /**
         * <p>
         * Removes a variation from the feature. If the variation you specify doesn't exist, then this makes no change
         * and does not report an error.
         * </p>
         * <p>
         * This operation fails if you try to remove a variation that is part of an ongoing launch or experiment.
         * </p>
         * 
         * @param removeVariations
         *        Removes a variation from the feature. If the variation you specify doesn't exist, then this makes no
         *        change and does not report an error.</p>
         *        <p>
         *        This operation fails if you try to remove a variation that is part of an ongoing launch or experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeVariations(Collection<String> removeVariations);

        /**
         * <p>
         * Removes a variation from the feature. If the variation you specify doesn't exist, then this makes no change
         * and does not report an error.
         * </p>
         * <p>
         * This operation fails if you try to remove a variation that is part of an ongoing launch or experiment.
         * </p>
         * 
         * @param removeVariations
         *        Removes a variation from the feature. If the variation you specify doesn't exist, then this makes no
         *        change and does not report an error.</p>
         *        <p>
         *        This operation fails if you try to remove a variation that is part of an ongoing launch or experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeVariations(String... removeVariations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EvidentlyRequest.BuilderImpl implements Builder {
        private List<VariationConfig> addOrUpdateVariations = DefaultSdkAutoConstructList.getInstance();

        private String defaultVariation;

        private String description;

        private Map<String, String> entityOverrides = DefaultSdkAutoConstructMap.getInstance();

        private String evaluationStrategy;

        private String feature;

        private String project;

        private List<String> removeVariations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFeatureRequest model) {
            super(model);
            addOrUpdateVariations(model.addOrUpdateVariations);
            defaultVariation(model.defaultVariation);
            description(model.description);
            entityOverrides(model.entityOverrides);
            evaluationStrategy(model.evaluationStrategy);
            feature(model.feature);
            project(model.project);
            removeVariations(model.removeVariations);
        }

        public final List<VariationConfig.Builder> getAddOrUpdateVariations() {
            List<VariationConfig.Builder> result = VariationConfigsListCopier.copyToBuilder(this.addOrUpdateVariations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddOrUpdateVariations(Collection<VariationConfig.BuilderImpl> addOrUpdateVariations) {
            this.addOrUpdateVariations = VariationConfigsListCopier.copyFromBuilder(addOrUpdateVariations);
        }

        @Override
        public final Builder addOrUpdateVariations(Collection<VariationConfig> addOrUpdateVariations) {
            this.addOrUpdateVariations = VariationConfigsListCopier.copy(addOrUpdateVariations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOrUpdateVariations(VariationConfig... addOrUpdateVariations) {
            addOrUpdateVariations(Arrays.asList(addOrUpdateVariations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOrUpdateVariations(Consumer<VariationConfig.Builder>... addOrUpdateVariations) {
            addOrUpdateVariations(Stream.of(addOrUpdateVariations).map(c -> VariationConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDefaultVariation() {
            return defaultVariation;
        }

        public final void setDefaultVariation(String defaultVariation) {
            this.defaultVariation = defaultVariation;
        }

        @Override
        public final Builder defaultVariation(String defaultVariation) {
            this.defaultVariation = defaultVariation;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getEntityOverrides() {
            if (entityOverrides instanceof SdkAutoConstructMap) {
                return null;
            }
            return entityOverrides;
        }

        public final void setEntityOverrides(Map<String, String> entityOverrides) {
            this.entityOverrides = EntityOverrideMapCopier.copy(entityOverrides);
        }

        @Override
        public final Builder entityOverrides(Map<String, String> entityOverrides) {
            this.entityOverrides = EntityOverrideMapCopier.copy(entityOverrides);
            return this;
        }

        public final String getEvaluationStrategy() {
            return evaluationStrategy;
        }

        public final void setEvaluationStrategy(String evaluationStrategy) {
            this.evaluationStrategy = evaluationStrategy;
        }

        @Override
        public final Builder evaluationStrategy(String evaluationStrategy) {
            this.evaluationStrategy = evaluationStrategy;
            return this;
        }

        @Override
        public final Builder evaluationStrategy(FeatureEvaluationStrategy evaluationStrategy) {
            this.evaluationStrategy(evaluationStrategy == null ? null : evaluationStrategy.toString());
            return this;
        }

        public final String getFeature() {
            return feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        public final String getProject() {
            return project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final Collection<String> getRemoveVariations() {
            if (removeVariations instanceof SdkAutoConstructList) {
                return null;
            }
            return removeVariations;
        }

        public final void setRemoveVariations(Collection<String> removeVariations) {
            this.removeVariations = VariationNameListCopier.copy(removeVariations);
        }

        @Override
        public final Builder removeVariations(Collection<String> removeVariations) {
            this.removeVariations = VariationNameListCopier.copy(removeVariations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeVariations(String... removeVariations) {
            removeVariations(Arrays.asList(removeVariations));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFeatureRequest build() {
            return new UpdateFeatureRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
