/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLaunchRequest extends EvidentlyRequest implements
        ToCopyableBuilder<UpdateLaunchRequest.Builder, UpdateLaunchRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateLaunchRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<LaunchGroupConfig>> GROUPS_FIELD = SdkField
            .<List<LaunchGroupConfig>> builder(MarshallingType.LIST)
            .memberName("groups")
            .getter(getter(UpdateLaunchRequest::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LaunchGroupConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchGroupConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LAUNCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("launch")
            .getter(getter(UpdateLaunchRequest::launch)).setter(setter(Builder::launch))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("launch").build()).build();

    private static final SdkField<List<MetricMonitorConfig>> METRIC_MONITORS_FIELD = SdkField
            .<List<MetricMonitorConfig>> builder(MarshallingType.LIST)
            .memberName("metricMonitors")
            .getter(getter(UpdateLaunchRequest::metricMonitors))
            .setter(setter(Builder::metricMonitors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricMonitors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricMonitorConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricMonitorConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("project")
            .getter(getter(UpdateLaunchRequest::project)).setter(setter(Builder::project))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()).build();

    private static final SdkField<String> RANDOMIZATION_SALT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("randomizationSalt").getter(getter(UpdateLaunchRequest::randomizationSalt))
            .setter(setter(Builder::randomizationSalt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("randomizationSalt").build()).build();

    private static final SdkField<ScheduledSplitsLaunchConfig> SCHEDULED_SPLITS_CONFIG_FIELD = SdkField
            .<ScheduledSplitsLaunchConfig> builder(MarshallingType.SDK_POJO).memberName("scheduledSplitsConfig")
            .getter(getter(UpdateLaunchRequest::scheduledSplitsConfig)).setter(setter(Builder::scheduledSplitsConfig))
            .constructor(ScheduledSplitsLaunchConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledSplitsConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            GROUPS_FIELD, LAUNCH_FIELD, METRIC_MONITORS_FIELD, PROJECT_FIELD, RANDOMIZATION_SALT_FIELD,
            SCHEDULED_SPLITS_CONFIG_FIELD));

    private final String description;

    private final List<LaunchGroupConfig> groups;

    private final String launch;

    private final List<MetricMonitorConfig> metricMonitors;

    private final String project;

    private final String randomizationSalt;

    private final ScheduledSplitsLaunchConfig scheduledSplitsConfig;

    private UpdateLaunchRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.groups = builder.groups;
        this.launch = builder.launch;
        this.metricMonitors = builder.metricMonitors;
        this.project = builder.project;
        this.randomizationSalt = builder.randomizationSalt;
        this.scheduledSplitsConfig = builder.scheduledSplitsConfig;
    }

    /**
     * <p>
     * An optional description for the launch.
     * </p>
     * 
     * @return An optional description for the launch.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that contains the feature and variations that are to be used for the launch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return An array of structures that contains the feature and variations that are to be used for the launch.
     */
    public final List<LaunchGroupConfig> groups() {
        return groups;
    }

    /**
     * <p>
     * The name of the launch that is to be updated.
     * </p>
     * 
     * @return The name of the launch that is to be updated.
     */
    public final String launch() {
        return launch;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricMonitors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricMonitors() {
        return metricMonitors != null && !(metricMonitors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that define the metrics that will be used to monitor the launch performance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricMonitors} method.
     * </p>
     * 
     * @return An array of structures that define the metrics that will be used to monitor the launch performance.
     */
    public final List<MetricMonitorConfig> metricMonitors() {
        return metricMonitors;
    }

    /**
     * <p>
     * The name or ARN of the project that contains the launch that you want to update.
     * </p>
     * 
     * @return The name or ARN of the project that contains the launch that you want to update.
     */
    public final String project() {
        return project;
    }

    /**
     * <p>
     * When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which
     * variation the user session is served. This randomization ID is a combination of the entity ID and
     * <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the
     * <code>randomizationSalt</code>.
     * </p>
     * 
     * @return When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine
     *         which variation the user session is served. This randomization ID is a combination of the entity ID and
     *         <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch
     *         name as the <code>randomizationSalt</code>.
     */
    public final String randomizationSalt() {
        return randomizationSalt;
    }

    /**
     * <p>
     * An array of structures that define the traffic allocation percentages among the feature variations during each
     * step of the launch.
     * </p>
     * 
     * @return An array of structures that define the traffic allocation percentages among the feature variations during
     *         each step of the launch.
     */
    public final ScheduledSplitsLaunchConfig scheduledSplitsConfig() {
        return scheduledSplitsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(launch());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricMonitors() ? metricMonitors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(project());
        hashCode = 31 * hashCode + Objects.hashCode(randomizationSalt());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledSplitsConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLaunchRequest)) {
            return false;
        }
        UpdateLaunchRequest other = (UpdateLaunchRequest) obj;
        return Objects.equals(description(), other.description()) && hasGroups() == other.hasGroups()
                && Objects.equals(groups(), other.groups()) && Objects.equals(launch(), other.launch())
                && hasMetricMonitors() == other.hasMetricMonitors() && Objects.equals(metricMonitors(), other.metricMonitors())
                && Objects.equals(project(), other.project()) && Objects.equals(randomizationSalt(), other.randomizationSalt())
                && Objects.equals(scheduledSplitsConfig(), other.scheduledSplitsConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLaunchRequest").add("Description", description())
                .add("Groups", hasGroups() ? groups() : null).add("Launch", launch())
                .add("MetricMonitors", hasMetricMonitors() ? metricMonitors() : null).add("Project", project())
                .add("RandomizationSalt", randomizationSalt()).add("ScheduledSplitsConfig", scheduledSplitsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "launch":
            return Optional.ofNullable(clazz.cast(launch()));
        case "metricMonitors":
            return Optional.ofNullable(clazz.cast(metricMonitors()));
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        case "randomizationSalt":
            return Optional.ofNullable(clazz.cast(randomizationSalt()));
        case "scheduledSplitsConfig":
            return Optional.ofNullable(clazz.cast(scheduledSplitsConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLaunchRequest, T> g) {
        return obj -> g.apply((UpdateLaunchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EvidentlyRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLaunchRequest> {
        /**
         * <p>
         * An optional description for the launch.
         * </p>
         * 
         * @param description
         *        An optional description for the launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An array of structures that contains the feature and variations that are to be used for the launch.
         * </p>
         * 
         * @param groups
         *        An array of structures that contains the feature and variations that are to be used for the launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<LaunchGroupConfig> groups);

        /**
         * <p>
         * An array of structures that contains the feature and variations that are to be used for the launch.
         * </p>
         * 
         * @param groups
         *        An array of structures that contains the feature and variations that are to be used for the launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(LaunchGroupConfig... groups);

        /**
         * <p>
         * An array of structures that contains the feature and variations that are to be used for the launch.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<LaunchGroupConfig>.Builder} avoiding
         * the need to create one manually via {@link List<LaunchGroupConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchGroupConfig>.Builder#build()} is called immediately
         * and its result is passed to {@link #groups(List<LaunchGroupConfig>)}.
         * 
         * @param groups
         *        a consumer that will call methods on {@link List<LaunchGroupConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(List<LaunchGroupConfig>)
         */
        Builder groups(Consumer<LaunchGroupConfig.Builder>... groups);

        /**
         * <p>
         * The name of the launch that is to be updated.
         * </p>
         * 
         * @param launch
         *        The name of the launch that is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launch(String launch);

        /**
         * <p>
         * An array of structures that define the metrics that will be used to monitor the launch performance.
         * </p>
         * 
         * @param metricMonitors
         *        An array of structures that define the metrics that will be used to monitor the launch performance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricMonitors(Collection<MetricMonitorConfig> metricMonitors);

        /**
         * <p>
         * An array of structures that define the metrics that will be used to monitor the launch performance.
         * </p>
         * 
         * @param metricMonitors
         *        An array of structures that define the metrics that will be used to monitor the launch performance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricMonitors(MetricMonitorConfig... metricMonitors);

        /**
         * <p>
         * An array of structures that define the metrics that will be used to monitor the launch performance.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<MetricMonitorConfig>.Builder}
         * avoiding the need to create one manually via {@link List<MetricMonitorConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricMonitorConfig>.Builder#build()} is called immediately
         * and its result is passed to {@link #metricMonitors(List<MetricMonitorConfig>)}.
         * 
         * @param metricMonitors
         *        a consumer that will call methods on {@link List<MetricMonitorConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricMonitors(List<MetricMonitorConfig>)
         */
        Builder metricMonitors(Consumer<MetricMonitorConfig.Builder>... metricMonitors);

        /**
         * <p>
         * The name or ARN of the project that contains the launch that you want to update.
         * </p>
         * 
         * @param project
         *        The name or ARN of the project that contains the launch that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(String project);

        /**
         * <p>
         * When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine
         * which variation the user session is served. This randomization ID is a combination of the entity ID and
         * <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as
         * the <code>randomizationSalt</code>.
         * </p>
         * 
         * @param randomizationSalt
         *        When Evidently assigns a particular user session to a launch, it must use a randomization ID to
         *        determine which variation the user session is served. This randomization ID is a combination of the
         *        entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently
         *        uses the launch name as the <code>randomizationSalt</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder randomizationSalt(String randomizationSalt);

        /**
         * <p>
         * An array of structures that define the traffic allocation percentages among the feature variations during
         * each step of the launch.
         * </p>
         * 
         * @param scheduledSplitsConfig
         *        An array of structures that define the traffic allocation percentages among the feature variations
         *        during each step of the launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledSplitsConfig(ScheduledSplitsLaunchConfig scheduledSplitsConfig);

        /**
         * <p>
         * An array of structures that define the traffic allocation percentages among the feature variations during
         * each step of the launch.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduledSplitsLaunchConfig.Builder}
         * avoiding the need to create one manually via {@link ScheduledSplitsLaunchConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduledSplitsLaunchConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #scheduledSplitsConfig(ScheduledSplitsLaunchConfig)}.
         * 
         * @param scheduledSplitsConfig
         *        a consumer that will call methods on {@link ScheduledSplitsLaunchConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduledSplitsConfig(ScheduledSplitsLaunchConfig)
         */
        default Builder scheduledSplitsConfig(Consumer<ScheduledSplitsLaunchConfig.Builder> scheduledSplitsConfig) {
            return scheduledSplitsConfig(ScheduledSplitsLaunchConfig.builder().applyMutation(scheduledSplitsConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EvidentlyRequest.BuilderImpl implements Builder {
        private String description;

        private List<LaunchGroupConfig> groups = DefaultSdkAutoConstructList.getInstance();

        private String launch;

        private List<MetricMonitorConfig> metricMonitors = DefaultSdkAutoConstructList.getInstance();

        private String project;

        private String randomizationSalt;

        private ScheduledSplitsLaunchConfig scheduledSplitsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLaunchRequest model) {
            super(model);
            description(model.description);
            groups(model.groups);
            launch(model.launch);
            metricMonitors(model.metricMonitors);
            project(model.project);
            randomizationSalt(model.randomizationSalt);
            scheduledSplitsConfig(model.scheduledSplitsConfig);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<LaunchGroupConfig.Builder> getGroups() {
            List<LaunchGroupConfig.Builder> result = LaunchGroupConfigListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<LaunchGroupConfig.BuilderImpl> groups) {
            this.groups = LaunchGroupConfigListCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<LaunchGroupConfig> groups) {
            this.groups = LaunchGroupConfigListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(LaunchGroupConfig... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<LaunchGroupConfig.Builder>... groups) {
            groups(Stream.of(groups).map(c -> LaunchGroupConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLaunch() {
            return launch;
        }

        public final void setLaunch(String launch) {
            this.launch = launch;
        }

        @Override
        public final Builder launch(String launch) {
            this.launch = launch;
            return this;
        }

        public final List<MetricMonitorConfig.Builder> getMetricMonitors() {
            List<MetricMonitorConfig.Builder> result = MetricMonitorConfigListCopier.copyToBuilder(this.metricMonitors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricMonitors(Collection<MetricMonitorConfig.BuilderImpl> metricMonitors) {
            this.metricMonitors = MetricMonitorConfigListCopier.copyFromBuilder(metricMonitors);
        }

        @Override
        public final Builder metricMonitors(Collection<MetricMonitorConfig> metricMonitors) {
            this.metricMonitors = MetricMonitorConfigListCopier.copy(metricMonitors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricMonitors(MetricMonitorConfig... metricMonitors) {
            metricMonitors(Arrays.asList(metricMonitors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricMonitors(Consumer<MetricMonitorConfig.Builder>... metricMonitors) {
            metricMonitors(Stream.of(metricMonitors).map(c -> MetricMonitorConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getProject() {
            return project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final String getRandomizationSalt() {
            return randomizationSalt;
        }

        public final void setRandomizationSalt(String randomizationSalt) {
            this.randomizationSalt = randomizationSalt;
        }

        @Override
        public final Builder randomizationSalt(String randomizationSalt) {
            this.randomizationSalt = randomizationSalt;
            return this;
        }

        public final ScheduledSplitsLaunchConfig.Builder getScheduledSplitsConfig() {
            return scheduledSplitsConfig != null ? scheduledSplitsConfig.toBuilder() : null;
        }

        public final void setScheduledSplitsConfig(ScheduledSplitsLaunchConfig.BuilderImpl scheduledSplitsConfig) {
            this.scheduledSplitsConfig = scheduledSplitsConfig != null ? scheduledSplitsConfig.build() : null;
        }

        @Override
        public final Builder scheduledSplitsConfig(ScheduledSplitsLaunchConfig scheduledSplitsConfig) {
            this.scheduledSplitsConfig = scheduledSplitsConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLaunchRequest build() {
            return new UpdateLaunchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
