/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluateFeatureResponse extends EvidentlyResponse implements
        ToCopyableBuilder<EvaluateFeatureResponse.Builder, EvaluateFeatureResponse> {
    private static final SdkField<String> DETAILS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("details")
            .getter(getter(EvaluateFeatureResponse::details))
            .setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(EvaluateFeatureResponse::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<VariableValue> VALUE_FIELD = SdkField.<VariableValue> builder(MarshallingType.SDK_POJO)
            .memberName("value").getter(getter(EvaluateFeatureResponse::value)).setter(setter(Builder::value))
            .constructor(VariableValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> VARIATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("variation").getter(getter(EvaluateFeatureResponse::variation)).setter(setter(Builder::variation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_FIELD, REASON_FIELD,
            VALUE_FIELD, VARIATION_FIELD));

    private final String details;

    private final String reason;

    private final VariableValue value;

    private final String variation;

    private EvaluateFeatureResponse(BuilderImpl builder) {
        super(builder);
        this.details = builder.details;
        this.reason = builder.reason;
        this.value = builder.value;
        this.variation = builder.variation;
    }

    /**
     * <p>
     * If this user was assigned to a launch or experiment, this field lists the launch or experiment name.
     * </p>
     * 
     * @return If this user was assigned to a launch or experiment, this field lists the launch or experiment name.
     */
    public final String details() {
        return details;
    }

    /**
     * <p>
     * Specifies the reason that the user session was assigned this variation. Possible values include
     * <code>DEFAULT</code>, meaning the user was served the default variation; <code>LAUNCH_RULE_MATCH</code>, if the
     * user session was enrolled in a launch; <code>EXPERIMENT_RULE_MATCH</code>, if the user session was enrolled in an
     * experiment; or <code>ENTITY_OVERRIDES_MATCH</code>, if the user's <code>entityId</code> matches an override rule.
     * </p>
     * 
     * @return Specifies the reason that the user session was assigned this variation. Possible values include
     *         <code>DEFAULT</code>, meaning the user was served the default variation; <code>LAUNCH_RULE_MATCH</code>,
     *         if the user session was enrolled in a launch; <code>EXPERIMENT_RULE_MATCH</code>, if the user session was
     *         enrolled in an experiment; or <code>ENTITY_OVERRIDES_MATCH</code>, if the user's <code>entityId</code>
     *         matches an override rule.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * The value assigned to this variation to differentiate it from the other variations of this feature.
     * </p>
     * 
     * @return The value assigned to this variation to differentiate it from the other variations of this feature.
     */
    public final VariableValue value() {
        return value;
    }

    /**
     * <p>
     * The name of the variation that was served to the user session.
     * </p>
     * 
     * @return The name of the variation that was served to the user session.
     */
    public final String variation() {
        return variation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(variation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateFeatureResponse)) {
            return false;
        }
        EvaluateFeatureResponse other = (EvaluateFeatureResponse) obj;
        return Objects.equals(details(), other.details()) && Objects.equals(reason(), other.reason())
                && Objects.equals(value(), other.value()) && Objects.equals(variation(), other.variation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluateFeatureResponse").add("Details", details()).add("Reason", reason())
                .add("Value", value()).add("Variation", variation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "variation":
            return Optional.ofNullable(clazz.cast(variation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluateFeatureResponse, T> g) {
        return obj -> g.apply((EvaluateFeatureResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EvidentlyResponse.Builder, SdkPojo, CopyableBuilder<Builder, EvaluateFeatureResponse> {
        /**
         * <p>
         * If this user was assigned to a launch or experiment, this field lists the launch or experiment name.
         * </p>
         * 
         * @param details
         *        If this user was assigned to a launch or experiment, this field lists the launch or experiment name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);

        /**
         * <p>
         * Specifies the reason that the user session was assigned this variation. Possible values include
         * <code>DEFAULT</code>, meaning the user was served the default variation; <code>LAUNCH_RULE_MATCH</code>, if
         * the user session was enrolled in a launch; <code>EXPERIMENT_RULE_MATCH</code>, if the user session was
         * enrolled in an experiment; or <code>ENTITY_OVERRIDES_MATCH</code>, if the user's <code>entityId</code>
         * matches an override rule.
         * </p>
         * 
         * @param reason
         *        Specifies the reason that the user session was assigned this variation. Possible values include
         *        <code>DEFAULT</code>, meaning the user was served the default variation;
         *        <code>LAUNCH_RULE_MATCH</code>, if the user session was enrolled in a launch;
         *        <code>EXPERIMENT_RULE_MATCH</code>, if the user session was enrolled in an experiment; or
         *        <code>ENTITY_OVERRIDES_MATCH</code>, if the user's <code>entityId</code> matches an override rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The value assigned to this variation to differentiate it from the other variations of this feature.
         * </p>
         * 
         * @param value
         *        The value assigned to this variation to differentiate it from the other variations of this feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(VariableValue value);

        /**
         * <p>
         * The value assigned to this variation to differentiate it from the other variations of this feature.
         * </p>
         * This is a convenience method that creates an instance of the {@link VariableValue.Builder} avoiding the need
         * to create one manually via {@link VariableValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link VariableValue.Builder#build()} is called immediately and its
         * result is passed to {@link #value(VariableValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link VariableValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(VariableValue)
         */
        default Builder value(Consumer<VariableValue.Builder> value) {
            return value(VariableValue.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * The name of the variation that was served to the user session.
         * </p>
         * 
         * @param variation
         *        The name of the variation that was served to the user session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variation(String variation);
    }

    static final class BuilderImpl extends EvidentlyResponse.BuilderImpl implements Builder {
        private String details;

        private String reason;

        private VariableValue value;

        private String variation;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateFeatureResponse model) {
            super(model);
            details(model.details);
            reason(model.reason);
            value(model.value);
            variation(model.variation);
        }

        public final String getDetails() {
            return details;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final VariableValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(VariableValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(VariableValue value) {
            this.value = value;
            return this;
        }

        public final String getVariation() {
            return variation;
        }

        public final void setVariation(String variation) {
            this.variation = variation;
        }

        @Override
        public final Builder variation(String variation) {
            this.variation = variation;
            return this;
        }

        @Override
        public EvaluateFeatureResponse build() {
            return new EvaluateFeatureResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
