/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing the configuration details of an experiment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Experiment implements SdkPojo, Serializable, ToCopyableBuilder<Experiment.Builder, Experiment> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Experiment::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTime").getter(getter(Experiment::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Experiment::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<ExperimentExecution> EXECUTION_FIELD = SdkField
            .<ExperimentExecution> builder(MarshallingType.SDK_POJO).memberName("execution")
            .getter(getter(Experiment::execution)).setter(setter(Builder::execution)).constructor(ExperimentExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("execution").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedTime").getter(getter(Experiment::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<List<MetricGoal>> METRIC_GOALS_FIELD = SdkField
            .<List<MetricGoal>> builder(MarshallingType.LIST)
            .memberName("metricGoals")
            .getter(getter(Experiment::metricGoals))
            .setter(setter(Builder::metricGoals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricGoals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricGoal> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricGoal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Experiment::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<OnlineAbDefinition> ONLINE_AB_DEFINITION_FIELD = SdkField
            .<OnlineAbDefinition> builder(MarshallingType.SDK_POJO).memberName("onlineAbDefinition")
            .getter(getter(Experiment::onlineAbDefinition)).setter(setter(Builder::onlineAbDefinition))
            .constructor(OnlineAbDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onlineAbDefinition").build())
            .build();

    private static final SdkField<String> PROJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("project")
            .getter(getter(Experiment::project)).setter(setter(Builder::project))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()).build();

    private static final SdkField<String> RANDOMIZATION_SALT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("randomizationSalt").getter(getter(Experiment::randomizationSalt))
            .setter(setter(Builder::randomizationSalt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("randomizationSalt").build()).build();

    private static final SdkField<Long> SAMPLING_RATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("samplingRate").getter(getter(Experiment::samplingRate)).setter(setter(Builder::samplingRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplingRate").build()).build();

    private static final SdkField<ExperimentSchedule> SCHEDULE_FIELD = SdkField
            .<ExperimentSchedule> builder(MarshallingType.SDK_POJO).memberName("schedule").getter(getter(Experiment::schedule))
            .setter(setter(Builder::schedule)).constructor(ExperimentSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Experiment::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(Experiment::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Experiment::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Treatment>> TREATMENTS_FIELD = SdkField
            .<List<Treatment>> builder(MarshallingType.LIST)
            .memberName("treatments")
            .getter(getter(Experiment::treatments))
            .setter(setter(Builder::treatments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treatments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Treatment> builder(MarshallingType.SDK_POJO)
                                            .constructor(Treatment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Experiment::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_TIME_FIELD,
            DESCRIPTION_FIELD, EXECUTION_FIELD, LAST_UPDATED_TIME_FIELD, METRIC_GOALS_FIELD, NAME_FIELD,
            ONLINE_AB_DEFINITION_FIELD, PROJECT_FIELD, RANDOMIZATION_SALT_FIELD, SAMPLING_RATE_FIELD, SCHEDULE_FIELD,
            STATUS_FIELD, STATUS_REASON_FIELD, TAGS_FIELD, TREATMENTS_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdTime;

    private final String description;

    private final ExperimentExecution execution;

    private final Instant lastUpdatedTime;

    private final List<MetricGoal> metricGoals;

    private final String name;

    private final OnlineAbDefinition onlineAbDefinition;

    private final String project;

    private final String randomizationSalt;

    private final Long samplingRate;

    private final ExperimentSchedule schedule;

    private final String status;

    private final String statusReason;

    private final Map<String, String> tags;

    private final List<Treatment> treatments;

    private final String type;

    private Experiment(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.description = builder.description;
        this.execution = builder.execution;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.metricGoals = builder.metricGoals;
        this.name = builder.name;
        this.onlineAbDefinition = builder.onlineAbDefinition;
        this.project = builder.project;
        this.randomizationSalt = builder.randomizationSalt;
        this.samplingRate = builder.samplingRate;
        this.schedule = builder.schedule;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.tags = builder.tags;
        this.treatments = builder.treatments;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ARN of the experiment.
     * </p>
     * 
     * @return The ARN of the experiment.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time that the experiment is first created.
     * </p>
     * 
     * @return The date and time that the experiment is first created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * A description of the experiment.
     * </p>
     * 
     * @return A description of the experiment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A structure that contains the date and time that the experiment started and ended.
     * </p>
     * 
     * @return A structure that contains the date and time that the experiment started and ended.
     */
    public final ExperimentExecution execution() {
        return execution;
    }

    /**
     * <p>
     * The date and time that the experiment was most recently updated.
     * </p>
     * 
     * @return The date and time that the experiment was most recently updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricGoals property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricGoals() {
        return metricGoals != null && !(metricGoals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for
     * each metric is the goal.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricGoals} method.
     * </p>
     * 
     * @return An array of structures that defines the metrics used for the experiment, and whether a higher or lower
     *         value for each metric is the goal.
     */
    public final List<MetricGoal> metricGoals() {
        return metricGoals;
    }

    /**
     * <p>
     * The name of the experiment.
     * </p>
     * 
     * @return The name of the experiment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A structure that contains the configuration of which variation to use as the "control" version. The "control"
     * version is used for comparison with other variations. This structure also specifies how much experiment traffic
     * is allocated to each variation.
     * </p>
     * 
     * @return A structure that contains the configuration of which variation to use as the "control" version. The
     *         "control" version is used for comparison with other variations. This structure also specifies how much
     *         experiment traffic is allocated to each variation.
     */
    public final OnlineAbDefinition onlineAbDefinition() {
        return onlineAbDefinition;
    }

    /**
     * <p>
     * The name or ARN of the project that contains this experiment.
     * </p>
     * 
     * @return The name or ARN of the project that contains this experiment.
     */
    public final String project() {
        return project;
    }

    /**
     * <p>
     * This value is used when Evidently assigns a particular user session to the experiment. It helps create a
     * randomization ID to determine which variation the user session is served. This randomization ID is a combination
     * of the entity ID and <code>randomizationSalt</code>.
     * </p>
     * 
     * @return This value is used when Evidently assigns a particular user session to the experiment. It helps create a
     *         randomization ID to determine which variation the user session is served. This randomization ID is a
     *         combination of the entity ID and <code>randomizationSalt</code>.
     */
    public final String randomizationSalt() {
        return randomizationSalt;
    }

    /**
     * <p>
     * In thousandths of a percent, the amount of the available audience that is allocated to this experiment. The
     * available audience is the total audience minus the audience that you have allocated to overrides or current
     * launches of this feature.
     * </p>
     * <p>
     * This is represented in thousandths of a percent, so a value of 10,000 is 10% of the available audience.
     * </p>
     * 
     * @return In thousandths of a percent, the amount of the available audience that is allocated to this experiment.
     *         The available audience is the total audience minus the audience that you have allocated to overrides or
     *         current launches of this feature.</p>
     *         <p>
     *         This is represented in thousandths of a percent, so a value of 10,000 is 10% of the available audience.
     */
    public final Long samplingRate() {
        return samplingRate;
    }

    /**
     * <p>
     * A structure that contains the time and date that Evidently completed the analysis of the experiment.
     * </p>
     * 
     * @return A structure that contains the time and date that Evidently completed the analysis of the experiment.
     */
    public final ExperimentSchedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The current state of the experiment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExperimentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the experiment.
     * @see ExperimentStatus
     */
    public final ExperimentStatus status() {
        return ExperimentStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of the experiment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExperimentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the experiment.
     * @see ExperimentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If the experiment was stopped, this is the string that was entered by the person who stopped the experiment, to
     * explain why it was stopped.
     * </p>
     * 
     * @return If the experiment was stopped, this is the string that was entered by the person who stopped the
     *         experiment, to explain why it was stopped.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of tag keys and values associated with this experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of tag keys and values associated with this experiment.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Treatments property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTreatments() {
        return treatments != null && !(treatments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that describe the configuration of each feature variation used in the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTreatments} method.
     * </p>
     * 
     * @return An array of structures that describe the configuration of each feature variation used in the experiment.
     */
    public final List<Treatment> treatments() {
        return treatments;
    }

    /**
     * <p>
     * The type of this experiment. Currently, this value must be <code>aws.experiment.onlineab</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ExperimentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of this experiment. Currently, this value must be <code>aws.experiment.onlineab</code>.
     * @see ExperimentType
     */
    public final ExperimentType type() {
        return ExperimentType.fromValue(type);
    }

    /**
     * <p>
     * The type of this experiment. Currently, this value must be <code>aws.experiment.onlineab</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ExperimentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of this experiment. Currently, this value must be <code>aws.experiment.onlineab</code>.
     * @see ExperimentType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(execution());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricGoals() ? metricGoals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(onlineAbDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        hashCode = 31 * hashCode + Objects.hashCode(randomizationSalt());
        hashCode = 31 * hashCode + Objects.hashCode(samplingRate());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTreatments() ? treatments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Experiment)) {
            return false;
        }
        Experiment other = (Experiment) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(description(), other.description()) && Objects.equals(execution(), other.execution())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && hasMetricGoals() == other.hasMetricGoals()
                && Objects.equals(metricGoals(), other.metricGoals()) && Objects.equals(name(), other.name())
                && Objects.equals(onlineAbDefinition(), other.onlineAbDefinition()) && Objects.equals(project(), other.project())
                && Objects.equals(randomizationSalt(), other.randomizationSalt())
                && Objects.equals(samplingRate(), other.samplingRate()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasTreatments() == other.hasTreatments()
                && Objects.equals(treatments(), other.treatments()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Experiment").add("Arn", arn()).add("CreatedTime", createdTime())
                .add("Description", description()).add("Execution", execution()).add("LastUpdatedTime", lastUpdatedTime())
                .add("MetricGoals", hasMetricGoals() ? metricGoals() : null).add("Name", name())
                .add("OnlineAbDefinition", onlineAbDefinition()).add("Project", project())
                .add("RandomizationSalt", randomizationSalt()).add("SamplingRate", samplingRate()).add("Schedule", schedule())
                .add("Status", statusAsString()).add("StatusReason", statusReason()).add("Tags", hasTags() ? tags() : null)
                .add("Treatments", hasTreatments() ? treatments() : null).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "execution":
            return Optional.ofNullable(clazz.cast(execution()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "metricGoals":
            return Optional.ofNullable(clazz.cast(metricGoals()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "onlineAbDefinition":
            return Optional.ofNullable(clazz.cast(onlineAbDefinition()));
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        case "randomizationSalt":
            return Optional.ofNullable(clazz.cast(randomizationSalt()));
        case "samplingRate":
            return Optional.ofNullable(clazz.cast(samplingRate()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "treatments":
            return Optional.ofNullable(clazz.cast(treatments()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Experiment, T> g) {
        return obj -> g.apply((Experiment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Experiment> {
        /**
         * <p>
         * The ARN of the experiment.
         * </p>
         * 
         * @param arn
         *        The ARN of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time that the experiment is first created.
         * </p>
         * 
         * @param createdTime
         *        The date and time that the experiment is first created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * A description of the experiment.
         * </p>
         * 
         * @param description
         *        A description of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A structure that contains the date and time that the experiment started and ended.
         * </p>
         * 
         * @param execution
         *        A structure that contains the date and time that the experiment started and ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder execution(ExperimentExecution execution);

        /**
         * <p>
         * A structure that contains the date and time that the experiment started and ended.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExperimentExecution.Builder} avoiding the
         * need to create one manually via {@link ExperimentExecution#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExperimentExecution.Builder#build()} is called immediately and
         * its result is passed to {@link #execution(ExperimentExecution)}.
         * 
         * @param execution
         *        a consumer that will call methods on {@link ExperimentExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #execution(ExperimentExecution)
         */
        default Builder execution(Consumer<ExperimentExecution.Builder> execution) {
            return execution(ExperimentExecution.builder().applyMutation(execution).build());
        }

        /**
         * <p>
         * The date and time that the experiment was most recently updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The date and time that the experiment was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * An array of structures that defines the metrics used for the experiment, and whether a higher or lower value
         * for each metric is the goal.
         * </p>
         * 
         * @param metricGoals
         *        An array of structures that defines the metrics used for the experiment, and whether a higher or lower
         *        value for each metric is the goal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricGoals(Collection<MetricGoal> metricGoals);

        /**
         * <p>
         * An array of structures that defines the metrics used for the experiment, and whether a higher or lower value
         * for each metric is the goal.
         * </p>
         * 
         * @param metricGoals
         *        An array of structures that defines the metrics used for the experiment, and whether a higher or lower
         *        value for each metric is the goal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricGoals(MetricGoal... metricGoals);

        /**
         * <p>
         * An array of structures that defines the metrics used for the experiment, and whether a higher or lower value
         * for each metric is the goal.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<MetricGoal>.Builder} avoiding the
         * need to create one manually via {@link List<MetricGoal>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricGoal>.Builder#build()} is called immediately and its
         * result is passed to {@link #metricGoals(List<MetricGoal>)}.
         * 
         * @param metricGoals
         *        a consumer that will call methods on {@link List<MetricGoal>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricGoals(List<MetricGoal>)
         */
        Builder metricGoals(Consumer<MetricGoal.Builder>... metricGoals);

        /**
         * <p>
         * The name of the experiment.
         * </p>
         * 
         * @param name
         *        The name of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A structure that contains the configuration of which variation to use as the "control" version. The "control"
         * version is used for comparison with other variations. This structure also specifies how much experiment
         * traffic is allocated to each variation.
         * </p>
         * 
         * @param onlineAbDefinition
         *        A structure that contains the configuration of which variation to use as the "control" version. The
         *        "control" version is used for comparison with other variations. This structure also specifies how much
         *        experiment traffic is allocated to each variation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onlineAbDefinition(OnlineAbDefinition onlineAbDefinition);

        /**
         * <p>
         * A structure that contains the configuration of which variation to use as the "control" version. The "control"
         * version is used for comparison with other variations. This structure also specifies how much experiment
         * traffic is allocated to each variation.
         * </p>
         * This is a convenience method that creates an instance of the {@link OnlineAbDefinition.Builder} avoiding the
         * need to create one manually via {@link OnlineAbDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link OnlineAbDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #onlineAbDefinition(OnlineAbDefinition)}.
         * 
         * @param onlineAbDefinition
         *        a consumer that will call methods on {@link OnlineAbDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onlineAbDefinition(OnlineAbDefinition)
         */
        default Builder onlineAbDefinition(Consumer<OnlineAbDefinition.Builder> onlineAbDefinition) {
            return onlineAbDefinition(OnlineAbDefinition.builder().applyMutation(onlineAbDefinition).build());
        }

        /**
         * <p>
         * The name or ARN of the project that contains this experiment.
         * </p>
         * 
         * @param project
         *        The name or ARN of the project that contains this experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(String project);

        /**
         * <p>
         * This value is used when Evidently assigns a particular user session to the experiment. It helps create a
         * randomization ID to determine which variation the user session is served. This randomization ID is a
         * combination of the entity ID and <code>randomizationSalt</code>.
         * </p>
         * 
         * @param randomizationSalt
         *        This value is used when Evidently assigns a particular user session to the experiment. It helps create
         *        a randomization ID to determine which variation the user session is served. This randomization ID is a
         *        combination of the entity ID and <code>randomizationSalt</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder randomizationSalt(String randomizationSalt);

        /**
         * <p>
         * In thousandths of a percent, the amount of the available audience that is allocated to this experiment. The
         * available audience is the total audience minus the audience that you have allocated to overrides or current
         * launches of this feature.
         * </p>
         * <p>
         * This is represented in thousandths of a percent, so a value of 10,000 is 10% of the available audience.
         * </p>
         * 
         * @param samplingRate
         *        In thousandths of a percent, the amount of the available audience that is allocated to this
         *        experiment. The available audience is the total audience minus the audience that you have allocated to
         *        overrides or current launches of this feature.</p>
         *        <p>
         *        This is represented in thousandths of a percent, so a value of 10,000 is 10% of the available
         *        audience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingRate(Long samplingRate);

        /**
         * <p>
         * A structure that contains the time and date that Evidently completed the analysis of the experiment.
         * </p>
         * 
         * @param schedule
         *        A structure that contains the time and date that Evidently completed the analysis of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(ExperimentSchedule schedule);

        /**
         * <p>
         * A structure that contains the time and date that Evidently completed the analysis of the experiment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExperimentSchedule.Builder} avoiding the
         * need to create one manually via {@link ExperimentSchedule#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExperimentSchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #schedule(ExperimentSchedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link ExperimentSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(ExperimentSchedule)
         */
        default Builder schedule(Consumer<ExperimentSchedule.Builder> schedule) {
            return schedule(ExperimentSchedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The current state of the experiment.
         * </p>
         * 
         * @param status
         *        The current state of the experiment.
         * @see ExperimentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperimentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the experiment.
         * </p>
         * 
         * @param status
         *        The current state of the experiment.
         * @see ExperimentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperimentStatus
         */
        Builder status(ExperimentStatus status);

        /**
         * <p>
         * If the experiment was stopped, this is the string that was entered by the person who stopped the experiment,
         * to explain why it was stopped.
         * </p>
         * 
         * @param statusReason
         *        If the experiment was stopped, this is the string that was entered by the person who stopped the
         *        experiment, to explain why it was stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The list of tag keys and values associated with this experiment.
         * </p>
         * 
         * @param tags
         *        The list of tag keys and values associated with this experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * An array of structures that describe the configuration of each feature variation used in the experiment.
         * </p>
         * 
         * @param treatments
         *        An array of structures that describe the configuration of each feature variation used in the
         *        experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatments(Collection<Treatment> treatments);

        /**
         * <p>
         * An array of structures that describe the configuration of each feature variation used in the experiment.
         * </p>
         * 
         * @param treatments
         *        An array of structures that describe the configuration of each feature variation used in the
         *        experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatments(Treatment... treatments);

        /**
         * <p>
         * An array of structures that describe the configuration of each feature variation used in the experiment.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Treatment>.Builder} avoiding the
         * need to create one manually via {@link List<Treatment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Treatment>.Builder#build()} is called immediately and its
         * result is passed to {@link #treatments(List<Treatment>)}.
         * 
         * @param treatments
         *        a consumer that will call methods on {@link List<Treatment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #treatments(List<Treatment>)
         */
        Builder treatments(Consumer<Treatment.Builder>... treatments);

        /**
         * <p>
         * The type of this experiment. Currently, this value must be <code>aws.experiment.onlineab</code>.
         * </p>
         * 
         * @param type
         *        The type of this experiment. Currently, this value must be <code>aws.experiment.onlineab</code>.
         * @see ExperimentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperimentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of this experiment. Currently, this value must be <code>aws.experiment.onlineab</code>.
         * </p>
         * 
         * @param type
         *        The type of this experiment. Currently, this value must be <code>aws.experiment.onlineab</code>.
         * @see ExperimentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperimentType
         */
        Builder type(ExperimentType type);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdTime;

        private String description;

        private ExperimentExecution execution;

        private Instant lastUpdatedTime;

        private List<MetricGoal> metricGoals = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private OnlineAbDefinition onlineAbDefinition;

        private String project;

        private String randomizationSalt;

        private Long samplingRate;

        private ExperimentSchedule schedule;

        private String status;

        private String statusReason;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<Treatment> treatments = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Experiment model) {
            arn(model.arn);
            createdTime(model.createdTime);
            description(model.description);
            execution(model.execution);
            lastUpdatedTime(model.lastUpdatedTime);
            metricGoals(model.metricGoals);
            name(model.name);
            onlineAbDefinition(model.onlineAbDefinition);
            project(model.project);
            randomizationSalt(model.randomizationSalt);
            samplingRate(model.samplingRate);
            schedule(model.schedule);
            status(model.status);
            statusReason(model.statusReason);
            tags(model.tags);
            treatments(model.treatments);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ExperimentExecution.Builder getExecution() {
            return execution != null ? execution.toBuilder() : null;
        }

        public final void setExecution(ExperimentExecution.BuilderImpl execution) {
            this.execution = execution != null ? execution.build() : null;
        }

        @Override
        public final Builder execution(ExperimentExecution execution) {
            this.execution = execution;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final List<MetricGoal.Builder> getMetricGoals() {
            List<MetricGoal.Builder> result = MetricGoalsListCopier.copyToBuilder(this.metricGoals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricGoals(Collection<MetricGoal.BuilderImpl> metricGoals) {
            this.metricGoals = MetricGoalsListCopier.copyFromBuilder(metricGoals);
        }

        @Override
        public final Builder metricGoals(Collection<MetricGoal> metricGoals) {
            this.metricGoals = MetricGoalsListCopier.copy(metricGoals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGoals(MetricGoal... metricGoals) {
            metricGoals(Arrays.asList(metricGoals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGoals(Consumer<MetricGoal.Builder>... metricGoals) {
            metricGoals(Stream.of(metricGoals).map(c -> MetricGoal.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final OnlineAbDefinition.Builder getOnlineAbDefinition() {
            return onlineAbDefinition != null ? onlineAbDefinition.toBuilder() : null;
        }

        public final void setOnlineAbDefinition(OnlineAbDefinition.BuilderImpl onlineAbDefinition) {
            this.onlineAbDefinition = onlineAbDefinition != null ? onlineAbDefinition.build() : null;
        }

        @Override
        public final Builder onlineAbDefinition(OnlineAbDefinition onlineAbDefinition) {
            this.onlineAbDefinition = onlineAbDefinition;
            return this;
        }

        public final String getProject() {
            return project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final String getRandomizationSalt() {
            return randomizationSalt;
        }

        public final void setRandomizationSalt(String randomizationSalt) {
            this.randomizationSalt = randomizationSalt;
        }

        @Override
        public final Builder randomizationSalt(String randomizationSalt) {
            this.randomizationSalt = randomizationSalt;
            return this;
        }

        public final Long getSamplingRate() {
            return samplingRate;
        }

        public final void setSamplingRate(Long samplingRate) {
            this.samplingRate = samplingRate;
        }

        @Override
        public final Builder samplingRate(Long samplingRate) {
            this.samplingRate = samplingRate;
            return this;
        }

        public final ExperimentSchedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(ExperimentSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(ExperimentSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExperimentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<Treatment.Builder> getTreatments() {
            List<Treatment.Builder> result = TreatmentListCopier.copyToBuilder(this.treatments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTreatments(Collection<Treatment.BuilderImpl> treatments) {
            this.treatments = TreatmentListCopier.copyFromBuilder(treatments);
        }

        @Override
        public final Builder treatments(Collection<Treatment> treatments) {
            this.treatments = TreatmentListCopier.copy(treatments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder treatments(Treatment... treatments) {
            treatments(Arrays.asList(treatments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder treatments(Consumer<Treatment.Builder>... treatments) {
            treatments(Stream.of(treatments).map(c -> Treatment.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ExperimentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Experiment build() {
            return new Experiment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
