/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchEvaluateFeatureRequest extends EvidentlyRequest implements
        ToCopyableBuilder<BatchEvaluateFeatureRequest.Builder, BatchEvaluateFeatureRequest> {
    private static final SdkField<String> PROJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("project")
            .getter(getter(BatchEvaluateFeatureRequest::project)).setter(setter(Builder::project))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()).build();

    private static final SdkField<List<EvaluationRequest>> REQUESTS_FIELD = SdkField
            .<List<EvaluationRequest>> builder(MarshallingType.LIST)
            .memberName("requests")
            .getter(getter(BatchEvaluateFeatureRequest::requests))
            .setter(setter(Builder::requests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(PROJECT_FIELD, REQUESTS_FIELD));

    private final String project;

    private final List<EvaluationRequest> requests;

    private BatchEvaluateFeatureRequest(BuilderImpl builder) {
        super(builder);
        this.project = builder.project;
        this.requests = builder.requests;
    }

    /**
     * <p>
     * The name or ARN of the project that contains the feature being evaluated.
     * </p>
     * 
     * @return The name or ARN of the project that contains the feature being evaluated.
     */
    public final String project() {
        return project;
    }

    /**
     * For responses, this returns true if the service returned a value for the Requests property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRequests() {
        return requests != null && !(requests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures, where each structure assigns a feature variation to one user session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequests} method.
     * </p>
     * 
     * @return An array of structures, where each structure assigns a feature variation to one user session.
     */
    public final List<EvaluationRequest> requests() {
        return requests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(project());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequests() ? requests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchEvaluateFeatureRequest)) {
            return false;
        }
        BatchEvaluateFeatureRequest other = (BatchEvaluateFeatureRequest) obj;
        return Objects.equals(project(), other.project()) && hasRequests() == other.hasRequests()
                && Objects.equals(requests(), other.requests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchEvaluateFeatureRequest").add("Project", project())
                .add("Requests", hasRequests() ? requests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        case "requests":
            return Optional.ofNullable(clazz.cast(requests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchEvaluateFeatureRequest, T> g) {
        return obj -> g.apply((BatchEvaluateFeatureRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EvidentlyRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchEvaluateFeatureRequest> {
        /**
         * <p>
         * The name or ARN of the project that contains the feature being evaluated.
         * </p>
         * 
         * @param project
         *        The name or ARN of the project that contains the feature being evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(String project);

        /**
         * <p>
         * An array of structures, where each structure assigns a feature variation to one user session.
         * </p>
         * 
         * @param requests
         *        An array of structures, where each structure assigns a feature variation to one user session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requests(Collection<EvaluationRequest> requests);

        /**
         * <p>
         * An array of structures, where each structure assigns a feature variation to one user session.
         * </p>
         * 
         * @param requests
         *        An array of structures, where each structure assigns a feature variation to one user session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requests(EvaluationRequest... requests);

        /**
         * <p>
         * An array of structures, where each structure assigns a feature variation to one user session.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<EvaluationRequest>.Builder} avoiding
         * the need to create one manually via {@link List<EvaluationRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EvaluationRequest>.Builder#build()} is called immediately
         * and its result is passed to {@link #requests(List<EvaluationRequest>)}.
         * 
         * @param requests
         *        a consumer that will call methods on {@link List<EvaluationRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requests(List<EvaluationRequest>)
         */
        Builder requests(Consumer<EvaluationRequest.Builder>... requests);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EvidentlyRequest.BuilderImpl implements Builder {
        private String project;

        private List<EvaluationRequest> requests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchEvaluateFeatureRequest model) {
            super(model);
            project(model.project);
            requests(model.requests);
        }

        public final String getProject() {
            return project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final List<EvaluationRequest.Builder> getRequests() {
            List<EvaluationRequest.Builder> result = EvaluationRequestsListCopier.copyToBuilder(this.requests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequests(Collection<EvaluationRequest.BuilderImpl> requests) {
            this.requests = EvaluationRequestsListCopier.copyFromBuilder(requests);
        }

        @Override
        public final Builder requests(Collection<EvaluationRequest> requests) {
            this.requests = EvaluationRequestsListCopier.copy(requests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requests(EvaluationRequest... requests) {
            requests(Arrays.asList(requests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requests(Consumer<EvaluationRequest.Builder>... requests) {
            requests(Stream.of(requests).map(c -> EvaluationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchEvaluateFeatureRequest build() {
            return new BatchEvaluateFeatureRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
