/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchEvaluateFeatureResponse extends EvidentlyResponse implements
        ToCopyableBuilder<BatchEvaluateFeatureResponse.Builder, BatchEvaluateFeatureResponse> {
    private static final SdkField<List<EvaluationResult>> RESULTS_FIELD = SdkField
            .<List<EvaluationResult>> builder(MarshallingType.LIST)
            .memberName("results")
            .getter(getter(BatchEvaluateFeatureResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD));

    private final List<EvaluationResult> results;

    private BatchEvaluateFeatureResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
    }

    /**
     * For responses, this returns true if the service returned a value for the Results property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures, where each structure displays the results of one feature evaluation assignment to one
     * user session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResults} method.
     * </p>
     * 
     * @return An array of structures, where each structure displays the results of one feature evaluation assignment to
     *         one user session.
     */
    public final List<EvaluationResult> results() {
        return results;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResults() ? results() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchEvaluateFeatureResponse)) {
            return false;
        }
        BatchEvaluateFeatureResponse other = (BatchEvaluateFeatureResponse) obj;
        return hasResults() == other.hasResults() && Objects.equals(results(), other.results());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchEvaluateFeatureResponse").add("Results", hasResults() ? results() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "results":
            return Optional.ofNullable(clazz.cast(results()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchEvaluateFeatureResponse, T> g) {
        return obj -> g.apply((BatchEvaluateFeatureResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EvidentlyResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchEvaluateFeatureResponse> {
        /**
         * <p>
         * An array of structures, where each structure displays the results of one feature evaluation assignment to one
         * user session.
         * </p>
         * 
         * @param results
         *        An array of structures, where each structure displays the results of one feature evaluation assignment
         *        to one user session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<EvaluationResult> results);

        /**
         * <p>
         * An array of structures, where each structure displays the results of one feature evaluation assignment to one
         * user session.
         * </p>
         * 
         * @param results
         *        An array of structures, where each structure displays the results of one feature evaluation assignment
         *        to one user session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(EvaluationResult... results);

        /**
         * <p>
         * An array of structures, where each structure displays the results of one feature evaluation assignment to one
         * user session.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<EvaluationResult>.Builder} avoiding
         * the need to create one manually via {@link List<EvaluationResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EvaluationResult>.Builder#build()} is called immediately and
         * its result is passed to {@link #results(List<EvaluationResult>)}.
         * 
         * @param results
         *        a consumer that will call methods on {@link List<EvaluationResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(List<EvaluationResult>)
         */
        Builder results(Consumer<EvaluationResult.Builder>... results);
    }

    static final class BuilderImpl extends EvidentlyResponse.BuilderImpl implements Builder {
        private List<EvaluationResult> results = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchEvaluateFeatureResponse model) {
            super(model);
            results(model.results);
        }

        public final List<EvaluationResult.Builder> getResults() {
            List<EvaluationResult.Builder> result = EvaluationResultsListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<EvaluationResult.BuilderImpl> results) {
            this.results = EvaluationResultsListCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<EvaluationResult> results) {
            this.results = EvaluationResultsListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(EvaluationResult... results) {
            results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<EvaluationResult.Builder>... results) {
            results(Stream.of(results).map(c -> EvaluationResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchEvaluateFeatureResponse build() {
            return new BatchEvaluateFeatureResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
