/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExperimentResultsResponse extends EvidentlyResponse implements
        ToCopyableBuilder<GetExperimentResultsResponse.Builder, GetExperimentResultsResponse> {
    private static final SdkField<String> DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("details")
            .getter(getter(GetExperimentResultsResponse::details)).setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final SdkField<List<ExperimentReport>> REPORTS_FIELD = SdkField
            .<List<ExperimentReport>> builder(MarshallingType.LIST)
            .memberName("reports")
            .getter(getter(GetExperimentResultsResponse::reports))
            .setter(setter(Builder::reports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExperimentReport> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExperimentReport::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ExperimentResultsData>> RESULTS_DATA_FIELD = SdkField
            .<List<ExperimentResultsData>> builder(MarshallingType.LIST)
            .memberName("resultsData")
            .getter(getter(GetExperimentResultsResponse::resultsData))
            .setter(setter(Builder::resultsData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultsData").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExperimentResultsData> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExperimentResultsData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Instant>> TIMESTAMPS_FIELD = SdkField
            .<List<Instant>> builder(MarshallingType.LIST)
            .memberName("timestamps")
            .getter(getter(GetExperimentResultsResponse::timestamps))
            .setter(setter(Builder::timestamps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Instant> builder(MarshallingType.INSTANT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_FIELD, REPORTS_FIELD,
            RESULTS_DATA_FIELD, TIMESTAMPS_FIELD));

    private final String details;

    private final List<ExperimentReport> reports;

    private final List<ExperimentResultsData> resultsData;

    private final List<Instant> timestamps;

    private GetExperimentResultsResponse(BuilderImpl builder) {
        super(builder);
        this.details = builder.details;
        this.reports = builder.reports;
        this.resultsData = builder.resultsData;
        this.timestamps = builder.timestamps;
    }

    /**
     * <p>
     * If the experiment doesn't yet have enough events to provide valid results, this field is returned with the
     * message <code>Not enough events to generate results</code>. If there are enough events to provide valid results,
     * this field is not returned.
     * </p>
     * 
     * @return If the experiment doesn't yet have enough events to provide valid results, this field is returned with
     *         the message <code>Not enough events to generate results</code>. If there are enough events to provide
     *         valid results, this field is not returned.
     */
    public final String details() {
        return details;
    }

    /**
     * For responses, this returns true if the service returned a value for the Reports property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReports() {
        return reports != null && !(reports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that include the reports that you requested.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReports} method.
     * </p>
     * 
     * @return An array of structures that include the reports that you requested.
     */
    public final List<ExperimentReport> reports() {
        return reports;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResultsData property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResultsData() {
        return resultsData != null && !(resultsData instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that include experiment results including metric names and values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResultsData} method.
     * </p>
     * 
     * @return An array of structures that include experiment results including metric names and values.
     */
    public final List<ExperimentResultsData> resultsData() {
        return resultsData;
    }

    /**
     * For responses, this returns true if the service returned a value for the Timestamps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTimestamps() {
        return timestamps != null && !(timestamps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The timestamps of each result returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimestamps} method.
     * </p>
     * 
     * @return The timestamps of each result returned.
     */
    public final List<Instant> timestamps() {
        return timestamps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(hasReports() ? reports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResultsData() ? resultsData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTimestamps() ? timestamps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExperimentResultsResponse)) {
            return false;
        }
        GetExperimentResultsResponse other = (GetExperimentResultsResponse) obj;
        return Objects.equals(details(), other.details()) && hasReports() == other.hasReports()
                && Objects.equals(reports(), other.reports()) && hasResultsData() == other.hasResultsData()
                && Objects.equals(resultsData(), other.resultsData()) && hasTimestamps() == other.hasTimestamps()
                && Objects.equals(timestamps(), other.timestamps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExperimentResultsResponse").add("Details", details())
                .add("Reports", hasReports() ? reports() : null).add("ResultsData", hasResultsData() ? resultsData() : null)
                .add("Timestamps", hasTimestamps() ? timestamps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        case "reports":
            return Optional.ofNullable(clazz.cast(reports()));
        case "resultsData":
            return Optional.ofNullable(clazz.cast(resultsData()));
        case "timestamps":
            return Optional.ofNullable(clazz.cast(timestamps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExperimentResultsResponse, T> g) {
        return obj -> g.apply((GetExperimentResultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EvidentlyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetExperimentResultsResponse> {
        /**
         * <p>
         * If the experiment doesn't yet have enough events to provide valid results, this field is returned with the
         * message <code>Not enough events to generate results</code>. If there are enough events to provide valid
         * results, this field is not returned.
         * </p>
         * 
         * @param details
         *        If the experiment doesn't yet have enough events to provide valid results, this field is returned with
         *        the message <code>Not enough events to generate results</code>. If there are enough events to provide
         *        valid results, this field is not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);

        /**
         * <p>
         * An array of structures that include the reports that you requested.
         * </p>
         * 
         * @param reports
         *        An array of structures that include the reports that you requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reports(Collection<ExperimentReport> reports);

        /**
         * <p>
         * An array of structures that include the reports that you requested.
         * </p>
         * 
         * @param reports
         *        An array of structures that include the reports that you requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reports(ExperimentReport... reports);

        /**
         * <p>
         * An array of structures that include the reports that you requested.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ExperimentReport>.Builder} avoiding
         * the need to create one manually via {@link List<ExperimentReport>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExperimentReport>.Builder#build()} is called immediately and
         * its result is passed to {@link #reports(List<ExperimentReport>)}.
         * 
         * @param reports
         *        a consumer that will call methods on {@link List<ExperimentReport>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reports(List<ExperimentReport>)
         */
        Builder reports(Consumer<ExperimentReport.Builder>... reports);

        /**
         * <p>
         * An array of structures that include experiment results including metric names and values.
         * </p>
         * 
         * @param resultsData
         *        An array of structures that include experiment results including metric names and values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultsData(Collection<ExperimentResultsData> resultsData);

        /**
         * <p>
         * An array of structures that include experiment results including metric names and values.
         * </p>
         * 
         * @param resultsData
         *        An array of structures that include experiment results including metric names and values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultsData(ExperimentResultsData... resultsData);

        /**
         * <p>
         * An array of structures that include experiment results including metric names and values.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ExperimentResultsData>.Builder}
         * avoiding the need to create one manually via {@link List<ExperimentResultsData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExperimentResultsData>.Builder#build()} is called
         * immediately and its result is passed to {@link #resultsData(List<ExperimentResultsData>)}.
         * 
         * @param resultsData
         *        a consumer that will call methods on {@link List<ExperimentResultsData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultsData(List<ExperimentResultsData>)
         */
        Builder resultsData(Consumer<ExperimentResultsData.Builder>... resultsData);

        /**
         * <p>
         * The timestamps of each result returned.
         * </p>
         * 
         * @param timestamps
         *        The timestamps of each result returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamps(Collection<Instant> timestamps);

        /**
         * <p>
         * The timestamps of each result returned.
         * </p>
         * 
         * @param timestamps
         *        The timestamps of each result returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamps(Instant... timestamps);
    }

    static final class BuilderImpl extends EvidentlyResponse.BuilderImpl implements Builder {
        private String details;

        private List<ExperimentReport> reports = DefaultSdkAutoConstructList.getInstance();

        private List<ExperimentResultsData> resultsData = DefaultSdkAutoConstructList.getInstance();

        private List<Instant> timestamps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetExperimentResultsResponse model) {
            super(model);
            details(model.details);
            reports(model.reports);
            resultsData(model.resultsData);
            timestamps(model.timestamps);
        }

        public final String getDetails() {
            return details;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final List<ExperimentReport.Builder> getReports() {
            List<ExperimentReport.Builder> result = ExperimentReportListCopier.copyToBuilder(this.reports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReports(Collection<ExperimentReport.BuilderImpl> reports) {
            this.reports = ExperimentReportListCopier.copyFromBuilder(reports);
        }

        @Override
        public final Builder reports(Collection<ExperimentReport> reports) {
            this.reports = ExperimentReportListCopier.copy(reports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reports(ExperimentReport... reports) {
            reports(Arrays.asList(reports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reports(Consumer<ExperimentReport.Builder>... reports) {
            reports(Stream.of(reports).map(c -> ExperimentReport.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ExperimentResultsData.Builder> getResultsData() {
            List<ExperimentResultsData.Builder> result = ExperimentResultsDataListCopier.copyToBuilder(this.resultsData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultsData(Collection<ExperimentResultsData.BuilderImpl> resultsData) {
            this.resultsData = ExperimentResultsDataListCopier.copyFromBuilder(resultsData);
        }

        @Override
        public final Builder resultsData(Collection<ExperimentResultsData> resultsData) {
            this.resultsData = ExperimentResultsDataListCopier.copy(resultsData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultsData(ExperimentResultsData... resultsData) {
            resultsData(Arrays.asList(resultsData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultsData(Consumer<ExperimentResultsData.Builder>... resultsData) {
            resultsData(Stream.of(resultsData).map(c -> ExperimentResultsData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<Instant> getTimestamps() {
            if (timestamps instanceof SdkAutoConstructList) {
                return null;
            }
            return timestamps;
        }

        public final void setTimestamps(Collection<Instant> timestamps) {
            this.timestamps = TimestampListCopier.copy(timestamps);
        }

        @Override
        public final Builder timestamps(Collection<Instant> timestamps) {
            this.timestamps = TimestampListCopier.copy(timestamps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestamps(Instant... timestamps) {
            timestamps(Arrays.asList(timestamps));
            return this;
        }

        @Override
        public GetExperimentResultsResponse build() {
            return new GetExperimentResultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
