/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines a metric to be used to monitor performance of the variations during a launch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricMonitorConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricMonitorConfig.Builder, MetricMonitorConfig> {
    private static final SdkField<MetricDefinitionConfig> METRIC_DEFINITION_FIELD = SdkField
            .<MetricDefinitionConfig> builder(MarshallingType.SDK_POJO).memberName("metricDefinition")
            .getter(getter(MetricMonitorConfig::metricDefinition)).setter(setter(Builder::metricDefinition))
            .constructor(MetricDefinitionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final MetricDefinitionConfig metricDefinition;

    private MetricMonitorConfig(BuilderImpl builder) {
        this.metricDefinition = builder.metricDefinition;
    }

    /**
     * <p>
     * A structure that defines the metric.
     * </p>
     * 
     * @return A structure that defines the metric.
     */
    public final MetricDefinitionConfig metricDefinition() {
        return metricDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricMonitorConfig)) {
            return false;
        }
        MetricMonitorConfig other = (MetricMonitorConfig) obj;
        return Objects.equals(metricDefinition(), other.metricDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricMonitorConfig").add("MetricDefinition", metricDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricDefinition":
            return Optional.ofNullable(clazz.cast(metricDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricMonitorConfig, T> g) {
        return obj -> g.apply((MetricMonitorConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricMonitorConfig> {
        /**
         * <p>
         * A structure that defines the metric.
         * </p>
         * 
         * @param metricDefinition
         *        A structure that defines the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDefinition(MetricDefinitionConfig metricDefinition);

        /**
         * <p>
         * A structure that defines the metric.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricDefinitionConfig.Builder} avoiding
         * the need to create one manually via {@link MetricDefinitionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricDefinitionConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #metricDefinition(MetricDefinitionConfig)}.
         * 
         * @param metricDefinition
         *        a consumer that will call methods on {@link MetricDefinitionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricDefinition(MetricDefinitionConfig)
         */
        default Builder metricDefinition(Consumer<MetricDefinitionConfig.Builder> metricDefinition) {
            return metricDefinition(MetricDefinitionConfig.builder().applyMutation(metricDefinition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MetricDefinitionConfig metricDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricMonitorConfig model) {
            metricDefinition(model.metricDefinition);
        }

        public final MetricDefinitionConfig.Builder getMetricDefinition() {
            return metricDefinition != null ? metricDefinition.toBuilder() : null;
        }

        public final void setMetricDefinition(MetricDefinitionConfig.BuilderImpl metricDefinition) {
            this.metricDefinition = metricDefinition != null ? metricDefinition.build() : null;
        }

        @Override
        public final Builder metricDefinition(MetricDefinitionConfig metricDefinition) {
            this.metricDefinition = metricDefinition;
            return this;
        }

        @Override
        public MetricMonitorConfig build() {
            return new MetricMonitorConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
